/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.Action;
import org.egov.infra.admin.master.repository.ActionRepository;
import org.egov.infra.web.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ActionService {
    @Autowired
    private ActionRepository actionRepository;

    public Action getActionByName(String name) {
        return this.actionRepository.findByName(name);
    }

    public Action getActionById(Long id) {
        return (Action)this.actionRepository.findOne(id);
    }

    public Action getActionByUrlAndContextRoot(String url, String contextRoot) {
        Action action = null;
        if (url.contains("?")) {
            String queryParams = WebUtils.extractQueryParamsFromUrl(url);
            String urlPart = WebUtils.extractURLWithoutQueryParams(url);
            action = this.actionRepository.findByUrlAndContextRootAndQueryParams(urlPart, contextRoot, queryParams);
            if (action == null) {
                action = this.findNearestMatchingAction(urlPart, this.actionRepository.findByMatchingUrlAndContextRootAndQueryParams(urlPart, contextRoot, queryParams));
            }
        } else {
            action = this.actionRepository.findByUrlAndContextRootAndQueryParamsIsNull(url, contextRoot);
            if (action == null) {
                action = this.findNearestMatchingAction(url, this.actionRepository.findByMatchingUrlAndContextRoot(url, contextRoot));
            }
        }
        return action;
    }

    private Action findNearestMatchingAction(String url, List<Action> actions) {
        return actions.isEmpty() ? null : actions.parallelStream().filter(action -> StringUtils.getLevenshteinDistance((CharSequence)url, (CharSequence)action.getUrl()) < 1).findFirst().orElse(actions.get(0));
    }
}

