/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.repository;

import java.util.List;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.Module;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface AppConfigRepository
extends JpaRepository<AppConfig, Long> {
    public AppConfig findByIdAndModule_Id(Long var1, Long var2);

    public AppConfig findByKeyNameAndModule_Name(String var1, String var2);

    public AppConfig findById(Long var1);

    public List<AppConfig> findByModule_Id(Long var1);

    public AppConfig findBykeyName(String var1);

    public List<AppConfig> findByModule_Name(String var1);

    @Query(value="select distinct(a.module.name) from AppConfig a order by a.module.name")
    public List<String> getAllAppConfigModule();

    @Query(value="select app from AppConfig app where app.id = :keyid and app.module.id = :moduleid")
    public AppConfig findBykeyIdAndModuleId(@Param(value="keyid") Long var1, @Param(value="moduleid") Long var2);

    @Query(value="select app from AppConfig app where app.keyName = :keyName and app.module.name = :moduleName")
    public AppConfig getConfigKeyByName(@Param(value="keyName") String var1, @Param(value="moduleName") String var2);

    @Query(value="select b from AppConfig b where b.module.id=:id")
    public List<AppConfig> findAllByModuleId(@Param(value="id") Long var1);

    @Query(value="select b from Module b where  b.enabled=true AND (b.parentModule IS NULL OR (b.parentModule IN (select c.id from Module c where c.parentModule IS NULL ))) AND  UPPER(b.name) like UPPER(:name) order by b.id")
    public List<Module> findByNameContainingIgnoreCase(@Param(value="name") String var1);

    @Query(value="select b from Module b where  b.enabled=true AND (b.parentModule IS NULL OR (b.parentModule IN (select c.id from Module c where c.parentModule IS NULL )))  order by b.name")
    public List<Module> findAllModules();

    @Query(value="select b from Module b where  b.enabled=true AND b.id=(:id)")
    public Module findByModuleById(@Param(value="id") Long var1);

    @Query(value="select b from AppConfig b where b.module.name=:moduleName")
    public List<AppConfig> getAppConfigKeys(@Param(value="moduleName") String var1);
}

