/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.admin.master.entity.CityPreferences;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.search.domain.Searchable;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Searchable
@Unique(id="id", tableName="eg_city", fields={"domainURL"}, columnName={"domainURL"}, enableDfltMsg=true)
@Table(name="eg_city")
@NamedQuery(name="CITY_BY_URL", query="Select cw FROM City cw WHERE cw.domainURL=:domainURL")
@SequenceGenerator(name="SEQ_EG_CITY", sequenceName="SEQ_EG_CITY", allocationSize=1)
@Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
public class City
extends AbstractAuditable {
    private static final long serialVersionUID = -6267923687226233397L;
    public static final String SEQ_CITY = "SEQ_EG_CITY";
    public static final String QUERY_CITY_BY_URL = "CITY_BY_URL";
    public static final String LOGO_URL = "/downloadfile/logo?fileStoreId=%s&moduleName=%s";
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_CITY", strategy=GenerationType.SEQUENCE)
    private Long id;
    @SafeHtml
    @NotBlank
    @Searchable(group=Searchable.Group.CLAUSES)
    private String name;
    @SafeHtml
    @NotBlank
    private String localName;
    private boolean active;
    @SafeHtml
    @NotBlank
    @Searchable(group=Searchable.Group.CLAUSES)
    private String domainURL;
    @SafeHtml
    @NotBlank
    private String recaptchaPK;
    @SafeHtml
    @NotBlank
    private String recaptchaPub;
    @SafeHtml
    @NotBlank
    @Searchable(group=Searchable.Group.CLAUSES)
    private String code;
    @SafeHtml
    @NotBlank
    @Searchable(group=Searchable.Group.CLAUSES)
    private String districtCode;
    @SafeHtml
    @NotBlank
    @Searchable(group=Searchable.Group.CLAUSES)
    private String districtName;
    @SafeHtml
    @Searchable(group=Searchable.Group.CLAUSES)
    private String regionName;
    @SafeHtml
    @Searchable(group=Searchable.Group.CLAUSES)
    private String grade;
    private Float longitude;
    private Float latitude;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="preferences")
    @NotAudited
    @Fetch(value=FetchMode.JOIN)
    private CityPreferences preferences;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDomainURL() {
        return this.domainURL;
    }

    public void setDomainURL(String domainURL) {
        this.domainURL = domainURL;
    }

    public String getRecaptchaPK() {
        return this.recaptchaPK;
    }

    public void setRecaptchaPK(String recaptchaPK) {
        this.recaptchaPK = recaptchaPK;
    }

    public String getRecaptchaPub() {
        return this.recaptchaPub;
    }

    public void setRecaptchaPub(String recaptchaPub) {
        this.recaptchaPub = recaptchaPub;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public String getDistrictCode() {
        return this.districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public CityPreferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(CityPreferences preferences) {
        this.preferences = preferences;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> cityPrefs = new HashMap<String, Object>();
        cityPrefs.put("cityurl", this.domainURL);
        cityPrefs.put("cityname", this.name);
        if (this.preferences == null) {
            cityPrefs.put("citylogo", "/resources/global/images/logo@2x.png");
            cityPrefs.put("citymunicipalityname", this.name);
        } else {
            cityPrefs.put("citylogo", this.preferences.logoExist() ? String.format(LOGO_URL, this.preferences.getMunicipalityLogo().getFileStoreId(), this.code) : "");
            cityPrefs.put("citymunicipalityname", this.preferences.getMunicipalityName());
            cityPrefs.put("corpAddress", this.preferences.getMunicipalityAddress());
            cityPrefs.put("corpCallCenterNo", this.preferences.getMunicipalityCallCenterNo());
            cityPrefs.put("corpContactNo", this.preferences.getMunicipalityContactNo());
            cityPrefs.put("corpContactEmail", this.preferences.getMunicipalityContactEmail());
            cityPrefs.put("corpTwitterLink", this.preferences.getMunicipalityTwitterLink());
            cityPrefs.put("corpFBLink", this.preferences.getMunicipalityFacebookLink());
            cityPrefs.put("corpGisLink", this.preferences.getMunicipalityGisLocation());
        }
        cityPrefs.put("citynamelocal", this.localName);
        cityPrefs.put("cityCode", this.code);
        cityPrefs.put("siteSecret", this.recaptchaPK);
        cityPrefs.put("siteKey", this.recaptchaPub);
        cityPrefs.put("citylat", this.latitude);
        cityPrefs.put("citylng", this.longitude);
        cityPrefs.put("cityCode", this.code);
        cityPrefs.put("districtName", this.districtName);
        cityPrefs.put("districtCode", this.districtCode);
        cityPrefs.put("cityGrade", this.grade);
        return cityPrefs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domainURL == null ? 0 : this.domainURL.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        City other = (City)obj;
        if (this.domainURL == null ? other.domainURL != null : !this.domainURL.equals(other.domainURL)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

