/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.google.gson.annotations.Expose;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.search.domain.Searchable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.format.annotation.DateTimeFormat;

@Entity
@Table(name="eg_appconfig_values")
@Searchable
@SequenceGenerator(name="SEQ_EG_APPCONFIG_VALUES", sequenceName="SEQ_EG_APPCONFIG_VALUES", allocationSize=1)
public class AppConfigValues
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ_APPCONFIG_VALUE = "SEQ_EG_APPCONFIG_VALUES";
    @Expose
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_APPCONFIG_VALUES", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    @Length(max=4000)
    @Searchable
    @Column(name="value")
    private String value;
    @NotNull
    @DateFormat
    @DateTimeFormat(pattern="dd/MM/yyyy")
    @Column(name="effective_from")
    private Date effectiveFrom;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="key_id")
    private AppConfig key;

    public Date getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public AppConfig getKey() {
        return this.key;
    }

    public void setKey(AppConfig key) {
        this.key = key;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppConfigValues other = (AppConfigValues)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

