/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.egov.search.domain.Searchable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="eg_appconfig")
@SequenceGenerator(name="SEQ_EG_APPCONFIG", sequenceName="SEQ_EG_APPCONFIG", allocationSize=1)
@CompositeUnique(fields={"keyName", "module"}, enableDfltMsg=true, message="Key Name and Module combination already exists")
@Searchable
public class AppConfig
extends AbstractAuditable {
    private static final long serialVersionUID = 8904645810221559541L;
    public static final String SEQ_APPCONFIG = "SEQ_EG_APPCONFIG";
    @Expose
    @DocumentId
    @Id
    @GeneratedValue(generator="SEQ_EG_APPCONFIG", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    @Length(max=250)
    @Column(name="key_name")
    @Searchable
    private String keyName;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="module", nullable=false)
    @Searchable
    private Module module;
    @NotBlank
    @SafeHtml
    @Length(max=250)
    @Searchable
    @Column(name="description")
    private String description;
    @OneToMany(mappedBy="key", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AppConfigValues> appDataValues = new ArrayList<AppConfigValues>(0);

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void addAppDataValues(AppConfigValues appDataValues) {
        this.getAppDataValues().add(appDataValues);
    }

    public List<AppConfigValues> getAppDataValues() {
        return this.appDataValues;
    }

    public void setAppDataValues(List<AppConfigValues> appDataValues) {
        this.appDataValues = appDataValues;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppConfig other = (AppConfig)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName));
    }
}

