/*
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 *
 *         1) All versions of this program, verbatim or modified must carry this
 *            Legal Notice.
 *
 *         2) Any misrepresentation of the origin of the material is prohibited. It
 *            is required that all modified versions of this material be marked in
 *            reasonable ways as different from the original version.
 *
 *         3) This license does not grant any rights to any user of the program
 *            with regards to rights under trademark law for use of the trade names
 *            or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */

package org.egov.infra.security.token.entity;

import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name = "EG_TOKEN")
@SequenceGenerator(name = Token.SEQ_TOKEN, sequenceName = Token.SEQ_TOKEN, allocationSize = 1)
public class Token extends AbstractAuditable {

	private static final long serialVersionUID = 1L;
    public static final String SEQ_TOKEN = "SEQ_EG_TOKEN";

    @DocumentId
    @Id
    @GeneratedValue(generator = SEQ_TOKEN, strategy = GenerationType.SEQUENCE)
    private Long id;
    
    @NotNull
    @Length(max = 128)
	private String tokenNumber;
	
	@Length(max = 100)
	private String tokenIdentity;
	
	@Length(max = 100)
	private String service;
	
	@NotNull
	private Long ttlSecs;
	
	@Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(final Long id) {
        this.id = id;
    }

	/**
	 * @return the tokenNumber
	 */
	public String getTokenNumber() {
		return tokenNumber;
	}

	/**
	 * @param tokenNumber the tokenNumber to set
	 */
	public void setTokenNumber(String tokenNumber) {
		this.tokenNumber = tokenNumber;
	}

	/**
	 * @return the tokenIdentity
	 */
	public String getTokenIdentity() {
		return tokenIdentity;
	}

	/**
	 * @param tokenIdentity the tokenIdentity to set
	 */
	public void setTokenIdentity(String tokenIdentity) {
		this.tokenIdentity = tokenIdentity;
	}

	/**
	 * @return the service
	 */
	public String getService() {
		return service;
	}

	/**
	 * @param service the service to set
	 */
	public void setService(String service) {
		this.service = service;
	}

	/**
	 * @return the ttlSecs
	 */
	public Long getTtlSecs() {
		return ttlSecs;
	}

	/**
	 * @param ttlSecs the ttlSecs to set
	 */
	public void setTtlSecs(Long ttlSecs) {
		this.ttlSecs = ttlSecs;
	}
    

}