/*
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 *
 *         1) All versions of this program, verbatim or modified must carry this
 *            Legal Notice.
 *
 *         2) Any misrepresentation of the origin of the material is prohibited. It
 *            is required that all modified versions of this material be marked in
 *            reasonable ways as different from the original version.
 *
 *         3) This license does not grant any rights to any user of the program
 *            with regards to rights under trademark law for use of the trade names
 *            or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */

package org.egov.infra.messaging.custom.entity;

import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.pims.commons.Position;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.Set;

import static org.egov.infra.messaging.custom.entity.NotificationGroup.SEQ_EG_NOTIFICATION_GROUP;

@Entity
@Table(name = "EG_NOTIFICATION_GROUP")
@SequenceGenerator(name = SEQ_EG_NOTIFICATION_GROUP, sequenceName = SEQ_EG_NOTIFICATION_GROUP, allocationSize = 1)
public class NotificationGroup extends AbstractAuditable {

    private static final long serialVersionUID = -6657657337034880987L;

    public static final String SEQ_EG_NOTIFICATION_GROUP = "SEQ_EG_NOTIFICATION_GROUP";

    @Id
    @GeneratedValue(generator = SEQ_EG_NOTIFICATION_GROUP, strategy = GenerationType.SEQUENCE)
    @DocumentId
    private Long id;

	@Length(min = 1, max = 100)
    @SafeHtml
	private String name;

	@Length(max = 250)
    @SafeHtml
	private String description;

	@NotNull
	private Date effectiveDate;

    private boolean active;

    //Should think about using UserGroup rather than depending on EIS, when add this feature.
    //It should be an many to many relation with notification_users table, contains group id and UserGroup id
    @Transient
	private Set<Position> members;

	@Override
	protected void setId(Long id) {
        this.id = id;
	}

	@Override
	public Long getId() {
		return id;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getEffectiveDate() {
		return this.effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public Set<Position> getMembers() {
		return this.members;
	}

	public void setMembers(Set<Position> members) {
		this.members = members;
	}

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

	@Override
	public String toString() {
		return name;
	}
}
