/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.voucher;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.CVoucherHeader;
import org.egov.egf.utils.FinancialUtils;
import org.egov.egf.voucher.service.JournalVoucherService;
import org.egov.egf.web.controller.voucher.BaseVoucherController;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.utils.FinancialConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/journalvoucher"})
public class CreateJournalVoucherController
extends BaseVoucherController {
    private static final String JOURNALVOUCHER_FORM = "journalvoucher-form";
    private static final String VOUCHER_NUMBER_GENERATION_AUTO = "voucherNumberGenerationAuto";
    private static final String STATE_TYPE = "stateType";
    private static final String APPROVAL_POSITION = "approvalPosition";
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private JournalVoucherService journalVoucherService;
    @Autowired
    private FinancialUtils financialUtils;

    public CreateJournalVoucherController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    protected void setDropDownValues(Model model) {
        super.setDropDownValues(model);
        model.addAttribute("voucherSubTypes", (Object)FinancialUtils.VOUCHER_SUBTYPES);
    }

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="voucherHeader") CVoucherHeader voucherHeader, Model model) {
        voucherHeader.setType("Journal Voucher");
        this.setDropDownValues(model);
        model.addAttribute(STATE_TYPE, (Object)voucherHeader.getClass().getSimpleName());
        this.prepareWorkflow(model, (StateAware)voucherHeader, new WorkflowContainer());
        this.prepareValidActionListByCutOffDate(model);
        voucherHeader.setVoucherDate(new Date());
        model.addAttribute(VOUCHER_NUMBER_GENERATION_AUTO, (Object)this.isVoucherNumberGenerationAuto(voucherHeader));
        return JOURNALVOUCHER_FORM;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="voucherHeader") CVoucherHeader voucherHeader, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam String workFlowAction) throws IOException {
        CVoucherHeader savedVoucherHeader;
        voucherHeader.setType("Journal Voucher");
        voucherHeader.setEffectiveDate(voucherHeader.getVoucherDate());
        this.populateVoucherName(voucherHeader);
        this.populateAccountDetails(voucherHeader);
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute(STATE_TYPE, (Object)voucherHeader.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)voucherHeader, new WorkflowContainer());
            this.prepareValidActionListByCutOffDate(model);
            voucherHeader.setVoucherDate(new Date());
            model.addAttribute(VOUCHER_NUMBER_GENERATION_AUTO, (Object)this.isVoucherNumberGenerationAuto(voucherHeader));
            return JOURNALVOUCHER_FORM;
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        try {
            savedVoucherHeader = this.journalVoucherService.create(voucherHeader, approvalPosition, approvalComment, null, workFlowAction);
        }
        catch (ValidationException e) {
            this.setDropDownValues(model);
            model.addAttribute(STATE_TYPE, (Object)voucherHeader.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)voucherHeader, new WorkflowContainer());
            this.prepareValidActionListByCutOffDate(model);
            voucherHeader.setVoucherDate(new Date());
            model.addAttribute(VOUCHER_NUMBER_GENERATION_AUTO, (Object)this.isVoucherNumberGenerationAuto(voucherHeader));
            resultBinder.reject("", ((ValidationError)e.getErrors().get(0)).getMessage());
            return JOURNALVOUCHER_FORM;
        }
        String approverDetails = this.financialUtils.getApproverDetails(workFlowAction, savedVoucherHeader.getState(), savedVoucherHeader.getId(), approvalPosition);
        return "redirect:/journalvoucher/success?approverDetails= " + approverDetails + "&voucherNumber=" + savedVoucherHeader.getVoucherNumber() + "&workFlowAction=" + workFlowAction;
    }

    @RequestMapping(value={"/success"}, method={RequestMethod.GET})
    public String showSuccessPage(@RequestParam(value="voucherNumber") String voucherNumber, Model model, HttpServletRequest request) {
        String workFlowAction = request.getParameter("workFlowAction");
        String[] keyNameArray = request.getParameter("approverDetails").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0].trim());
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0].trim());
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0].trim());
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            model.addAttribute("approverName", (Object)approverName);
        }
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        CVoucherHeader voucherHeader = this.journalVoucherService.getByVoucherNumber(voucherNumber);
        String message = this.getMessageByStatus(voucherHeader, approverName, nextDesign, workFlowAction);
        model.addAttribute("message", (Object)message);
        return "expensebill-success";
    }

    private String getMessageByStatus(CVoucherHeader voucherHeader, String approverName, String nextDesign, String workFlowAction) {
        String message = FinancialConstants.PREAPPROVEDVOUCHERSTATUS.equals(voucherHeader.getStatus()) ? this.messageSource.getMessage("msg.journal.voucher.create.success", (Object[])new String[]{voucherHeader.getVoucherNumber(), approverName, nextDesign}, null) : (FinancialConstants.CREATEDVOUCHERSTATUS.equals(voucherHeader.getStatus()) ? this.messageSource.getMessage("msg.journal.voucher.approved.success", (Object[])new String[]{voucherHeader.getVoucherNumber()}, null) : ("Cancelled".equals(workFlowAction) ? this.messageSource.getMessage("msg.journal.voucher.cancel", (Object[])new String[]{voucherHeader.getVoucherNumber()}, null) : this.messageSource.getMessage("msg.journal.voucher.reject", (Object[])new String[]{voucherHeader.getVoucherNumber(), approverName, nextDesign}, null)));
        return message;
    }
}

