/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.contract;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.CFiscalPeriod;
import org.egov.commons.CFunction;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.FiscalPeriodHibernateDAO;
import org.egov.commons.service.FunctionService;
import org.egov.commons.service.FundService;
import org.egov.egf.contract.model.AccountDetailContract;
import org.egov.egf.contract.model.AccountDetailKeyContract;
import org.egov.egf.contract.model.AccountDetailTypeContract;
import org.egov.egf.contract.model.ErrorDetail;
import org.egov.egf.contract.model.FinancialYearContract;
import org.egov.egf.contract.model.FiscalPeriodContract;
import org.egov.egf.contract.model.FunctionContract;
import org.egov.egf.contract.model.SubledgerDetailContract;
import org.egov.egf.contract.model.VoucherContract;
import org.egov.egf.contract.model.VoucherContractResponse;
import org.egov.egf.contract.model.VoucherRequest;
import org.egov.egf.contract.model.VoucherResponse;
import org.egov.egf.voucher.service.ContractVoucherService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.services.voucher.GeneralLedgerDetailService;
import org.egov.services.voucher.GeneralLedgerService;
import org.egov.services.voucher.VoucherService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/vouchers"})
public class ContractVoucherController {
    @Autowired
    private CreateVoucher createVoucher;
    @Autowired
    private FundService fundService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private ContractVoucherService contractVoucherService;
    @Autowired
    private FiscalPeriodHibernateDAO fiscalPeriodHibernateDAO;
    @Autowired
    private GeneralLedgerService generalLedgerService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    private GeneralLedgerDetailService generalLedgerDetailService;

    @RequestMapping(value={"/_create"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String createVoucher(@RequestBody VoucherContract voucherRequest, @RequestParam String tenantId, HttpServletResponse response) throws Exception {
        List<ErrorDetail> errorList = new ArrayList(0);
        ErrorDetail re = new ErrorDetail();
        ApplicationThreadLocals.setUserId((Long)2L);
        CVoucherHeader cVoucherHeader = new CVoucherHeader();
        errorList = this.contractVoucherService.validateVoucherReuest(voucherRequest);
        if (!errorList.isEmpty()) {
            response.setStatus(400);
            return this.getJSONResponse(errorList).replace("\"", "");
        }
        HashMap<String, Date> headerDetails = new HashMap<String, Date>();
        ArrayList accountCodeDetails = new ArrayList();
        ArrayList subledgerDetails = new ArrayList();
        for (VoucherRequest request : voucherRequest.getVouchers()) {
            this.prepairHeaderDetail(headerDetails, request);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
            try {
                headerDetails.put("voucherdate", formatter.parse(request.getVoucherDate()));
            }
            catch (ParseException e) {
                response.setStatus(400);
            }
            if (!request.getLedgers().isEmpty()) {
                for (AccountDetailContract accountDetailContract : request.getLedgers()) {
                    this.prepairAccountDetail(accountCodeDetails, accountDetailContract);
                    if (accountDetailContract.getSubledgerDetails().isEmpty()) continue;
                    for (SubledgerDetailContract subledgerDetailContract : accountDetailContract.getSubledgerDetails()) {
                        this.prepairSubledgerDetails(subledgerDetails, accountDetailContract, subledgerDetailContract);
                    }
                }
            }
            try {
                cVoucherHeader = this.createVoucher.createVoucher(headerDetails, accountCodeDetails, subledgerDetails);
            }
            catch (ApplicationRuntimeException e) {
                re.setErrorCode(e.getMessage());
                re.setErrorMessage(e.getMessage());
                errorList.add(re);
                response.setStatus(400);
                return this.getJSONResponse(errorList).replace("\"", "");
            }
            catch (ValidationException e) {
                re.setErrorCode(((ValidationError)e.getErrors().get(0)).getKey());
                re.setErrorMessage(((ValidationError)e.getErrors().get(0)).getMessage());
                errorList.add(re);
                response.setStatus(400);
                return this.getJSONResponse(errorList).replace("\"", "");
            }
            catch (Exception e) {
                re.setErrorCode(e.getMessage());
                re.setErrorMessage(e.getMessage());
                errorList.add(re);
                response.setStatus(400);
                return this.getJSONResponse(errorList).replace("\"", "");
            }
        }
        VoucherContractResponse voucherContractResponse = new VoucherContractResponse();
        ArrayList<VoucherResponse> vouchers = new ArrayList<VoucherResponse>();
        VoucherResponse voucherResponse = this.prepairVoucherResponse(cVoucherHeader);
        ArrayList<AccountDetailContract> accountDetailContracts = new ArrayList<AccountDetailContract>();
        ArrayList<SubledgerDetailContract> subledgerDetailContracts = new ArrayList<SubledgerDetailContract>();
        List cGeneralLedgerDetails = new ArrayList();
        for (CGeneralLedger cGeneralLedger : this.generalLedgerService.findCGeneralLedgerByVoucherHeaderId(cVoucherHeader.getId())) {
            AccountDetailContract accountDetailContract = this.prepairAccountDetailResponse(cGeneralLedger);
            accountDetailContracts.add(accountDetailContract);
            cGeneralLedgerDetails = this.generalLedgerDetailService.findCGeneralLedgerDetailByLedgerId(cGeneralLedger.getId());
            if (cGeneralLedgerDetails.isEmpty()) continue;
            for (CGeneralLedgerDetail cGeneralLedgerDetail : cGeneralLedgerDetails) {
                SubledgerDetailContract subledgerDetailContract1 = this.prepairSubledgerDetailResponse(cGeneralLedgerDetail);
                subledgerDetailContracts.add(subledgerDetailContract1);
            }
            ((AccountDetailContract)accountDetailContracts.get(0)).setSubledgerDetails(subledgerDetailContracts);
        }
        voucherResponse.setLedgers(accountDetailContracts);
        vouchers.add(voucherResponse);
        voucherContractResponse.setVouchers(vouchers);
        response.setStatus(201);
        return this.getJSONResponse((Object)voucherContractResponse).replace("\"", "");
    }

    private AccountDetailContract prepairAccountDetailResponse(CGeneralLedger cGeneralLedger) {
        AccountDetailContract accountDetailContract = new AccountDetailContract();
        accountDetailContract.setId(cGeneralLedger.getId());
        accountDetailContract.setCreditAmount(cGeneralLedger.getCreditAmount());
        accountDetailContract.setDebitAmount(cGeneralLedger.getDebitAmount());
        accountDetailContract.setGlcode(cGeneralLedger.getGlcode());
        if (cGeneralLedger.getFunctionId() != null) {
            FunctionContract functionContract = new FunctionContract();
            CFunction cFunction = this.functionService.findOne(Long.valueOf(cGeneralLedger.getFunctionId().intValue()));
            functionContract.setActive(cFunction.getIsActive());
            functionContract.setCode(cFunction.getCode());
            functionContract.setId(cFunction.getId());
            if (cFunction.getParentId() != null) {
                functionContract.setParentId(cFunction.getParentId().getId());
                functionContract.setIsParent(Boolean.TRUE);
            } else {
                functionContract.setIsParent(Boolean.FALSE);
            }
            functionContract.setLevel(Long.valueOf(cFunction.getLlevel()));
            functionContract.setName(cFunction.getName());
            accountDetailContract.setFunction(functionContract);
        }
        return accountDetailContract;
    }

    private SubledgerDetailContract prepairSubledgerDetailResponse(CGeneralLedgerDetail cGeneralLedgerDetail) {
        SubledgerDetailContract subledgerDetailContract1 = new SubledgerDetailContract();
        subledgerDetailContract1.setId(cGeneralLedgerDetail.getId());
        subledgerDetailContract1.setAmount(Double.valueOf(cGeneralLedgerDetail.getAmount().doubleValue()));
        AccountDetailKeyContract accountDetailKeyContract = new AccountDetailKeyContract();
        AccountDetailTypeContract accountDetailTypeContract = new AccountDetailTypeContract();
        if (cGeneralLedgerDetail.getDetailTypeId() != null) {
            accountDetailTypeContract.setActive(cGeneralLedgerDetail.getDetailTypeId().getIsactive());
        }
        accountDetailTypeContract.setDescription(cGeneralLedgerDetail.getDetailTypeId().getDescription());
        accountDetailTypeContract.setFullyQualifiedName(cGeneralLedgerDetail.getDetailTypeId().getFullQualifiedName());
        accountDetailTypeContract.setId(Long.valueOf(cGeneralLedgerDetail.getDetailTypeId().getId().intValue()));
        accountDetailTypeContract.setName(cGeneralLedgerDetail.getDetailTypeId().getName());
        accountDetailTypeContract.setTableName(cGeneralLedgerDetail.getDetailTypeId().getTablename());
        subledgerDetailContract1.setAccountDetailType(accountDetailTypeContract);
        accountDetailKeyContract.setAccountDetailType(accountDetailTypeContract);
        accountDetailKeyContract.setId(Long.valueOf(cGeneralLedgerDetail.getDetailKeyId().intValue()));
        subledgerDetailContract1.setAccountDetailKey(accountDetailKeyContract);
        return subledgerDetailContract1;
    }

    private void prepairHeaderDetail(HashMap<String, Object> headerDetails, VoucherRequest request) {
        headerDetails.put("vouchername", request.getName());
        headerDetails.put("vouchertype", request.getType());
        headerDetails.put("description", request.getDescription());
        if (request.getDepartment() != null) {
            headerDetails.put("departmentcode", this.departmentService.getDepartmentById(request.getDepartment()).getCode());
        }
        headerDetails.put("moduleid", request.getModuleId());
        headerDetails.put("vouchernumber", request.getVoucherNumber());
        if (request.getFund() != null && request.getFund().getId() != null) {
            headerDetails.put("fundcode", this.fundService.findOne(Integer.valueOf(request.getFund().getId().intValue())).getCode());
        } else if (request.getFund() != null && !request.getFund().getCode().isEmpty()) {
            headerDetails.put("fundcode", request.getFund().getCode());
        } else if (request.getFund() != null && !request.getFund().getName().isEmpty()) {
            headerDetails.put("fundcode", this.fundService.findByName(request.getFund().getName()).getCode());
        }
    }

    private void prepairAccountDetail(List<HashMap<String, Object>> accountCodeDetails, AccountDetailContract accountDetailContract) {
        HashMap<String, Object> accountDetails1 = new HashMap<String, Object>();
        accountDetails1.put("glcode", accountDetailContract.getGlcode());
        accountDetails1.put("debitamount", accountDetailContract.getDebitAmount());
        accountDetails1.put("creditamount", accountDetailContract.getCreditAmount());
        if (accountDetailContract.getFunction() != null && accountDetailContract.getFunction().getId() != null) {
            accountDetails1.put("functioncode", this.functionService.findOne(accountDetailContract.getFunction().getId()).getCode());
        } else if (accountDetailContract.getFunction() != null && accountDetailContract.getFunction().getCode() != null) {
            accountDetails1.put("functioncode", accountDetailContract.getFunction().getCode());
        } else if (accountDetailContract.getFunction() != null && accountDetailContract.getFunction().getName() != null) {
            accountDetails1.put("functioncode", this.functionService.findByName(accountDetailContract.getFunction().getName()).getCode());
        }
        accountCodeDetails.add(accountDetails1);
    }

    private void prepairSubledgerDetails(List<HashMap<String, Object>> subledgerDetails, AccountDetailContract accountDetailContract, SubledgerDetailContract subledgerDetailContract) {
        HashMap<String, Object> subledgerDetails1 = new HashMap<String, Object>();
        subledgerDetails1.put("creditamount", subledgerDetailContract.getAmount());
        subledgerDetails1.put("glcode", accountDetailContract.getGlcode());
        subledgerDetails1.put("detailtypeid", subledgerDetailContract.getAccountDetailType().getId());
        subledgerDetails1.put("detailkeyid", subledgerDetailContract.getAccountDetailKey().getId());
        subledgerDetails.add(subledgerDetails1);
    }

    private VoucherResponse prepairVoucherResponse(CVoucherHeader cVoucherHeader) {
        VoucherResponse voucherResponse = new VoucherResponse();
        voucherResponse.setFund(cVoucherHeader.getFundId());
        voucherResponse.setCgvn(cVoucherHeader.getCgvn());
        voucherResponse.setVoucherNumber(cVoucherHeader.getVoucherNumber());
        voucherResponse.setDescription(cVoucherHeader.getDescription());
        voucherResponse.setVoucherDate(DateUtils.getFormattedDate((Date)cVoucherHeader.getVoucherDate(), (String)"dd-MM-yyyy"));
        voucherResponse.setName(cVoucherHeader.getName());
        voucherResponse.setType(cVoucherHeader.getType());
        voucherResponse.setOriginalVhId(cVoucherHeader.getOriginalvcId());
        voucherResponse.setRefVhId(cVoucherHeader.getRefvhId());
        voucherResponse.setStatus("Approved");
        voucherResponse.setId(cVoucherHeader.getId());
        CFiscalPeriod fiscalPeriod = this.fiscalPeriodHibernateDAO.getFiscalPeriodByDate(cVoucherHeader.getVoucherDate());
        FiscalPeriodContract fiscalPeriodContract = new FiscalPeriodContract();
        FinancialYearContract financialYearContract = new FinancialYearContract();
        financialYearContract.setActive(fiscalPeriod.getcFinancialYear().getIsActive());
        financialYearContract.setEndingDate(fiscalPeriod.getcFinancialYear().getStartingDate());
        financialYearContract.setFinYearRange(fiscalPeriod.getcFinancialYear().getFinYearRange());
        financialYearContract.setId(fiscalPeriod.getcFinancialYear().getId());
        financialYearContract.setIsActiveForPosting(fiscalPeriod.getcFinancialYear().getIsActiveForPosting());
        financialYearContract.setIsClosed(fiscalPeriod.getcFinancialYear().getIsClosed());
        financialYearContract.setTransferClosingBalance(fiscalPeriod.getcFinancialYear().getTransferClosingBalance());
        fiscalPeriodContract.setActive(fiscalPeriod.getIsActive());
        fiscalPeriodContract.setStartingDate(fiscalPeriod.getStartingDate());
        fiscalPeriodContract.setEndingDate(fiscalPeriod.getEndingDate());
        fiscalPeriodContract.setId(fiscalPeriod.getId());
        fiscalPeriodContract.setIsActiveForPosting(fiscalPeriod.getIsActiveForPosting());
        fiscalPeriodContract.setName(fiscalPeriod.getName());
        fiscalPeriodContract.setFinancialYear(financialYearContract);
        voucherResponse.setFiscalPeriod(fiscalPeriodContract);
        return voucherResponse;
    }

    private String getJSONResponse(Object obj) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("dd-MM-yyyy"));
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }
}

