/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.bankbranch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.Bankbranch;
import org.egov.egf.commons.bank.service.CreateBankService;
import org.egov.egf.commons.bankbranch.service.CreateBankBranchService;
import org.egov.egf.web.controller.bankbranch.adaptor.BankBranchJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/bankbranch"})
public class BankBranchController {
    private static final String BANKBRANCH = "bankbranch";
    @Autowired
    private CreateBankBranchService createBankBranchService;
    @Autowired
    private CreateBankService createBankService;
    @Autowired
    private MessageSource messageSource;

    private void setDropDownValues(Model model) {
        model.addAttribute("banks", (Object)this.createBankService.getByIsActiveTrueOrderByName());
        model.addAttribute("bankbranches", (Object)this.createBankBranchService.getByIsActiveTrueOrderByBranchname());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.setDropDownValues(model);
        model.addAttribute(BANKBRANCH, (Object)new Bankbranch());
        return "bankbranch-new";
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Integer id, Model model) {
        Bankbranch bankbranch = this.createBankBranchService.getById(id);
        this.setDropDownValues(model);
        model.addAttribute(BANKBRANCH, (Object)bankbranch);
        return "bankbranch-update";
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public String success(@PathVariable(value="id") Integer id, Model model) {
        Bankbranch bankbranch = this.createBankBranchService.getById(id);
        model.addAttribute(BANKBRANCH, (Object)bankbranch);
        return "bankbranch-success";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Integer id, Model model) {
        Bankbranch bankbranch = this.createBankBranchService.getById(id);
        model.addAttribute(BANKBRANCH, (Object)bankbranch);
        return "bankbranch-view";
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Bankbranch bankbranch = new Bankbranch();
        this.setDropDownValues(model);
        model.addAttribute(BANKBRANCH, (Object)bankbranch);
        return "bankbranch-search";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Bankbranch bankbranch, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            Model model2 = model;
            this.setDropDownValues(model2);
            model.addAttribute(BANKBRANCH, (Object)bankbranch);
            return "bankbranch-new";
        }
        this.createBankBranchService.create(bankbranch);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.bankbranch.success", null, null));
        return "redirect:/bankbranch/success/" + bankbranch.getId();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Bankbranch bankbranch, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute(BANKBRANCH, (Object)bankbranch);
            return "bankbranch-update";
        }
        this.createBankBranchService.update(bankbranch);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.bankbranch.success", null, null));
        return "redirect:/bankbranch/success/" + bankbranch.getId();
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Bankbranch bankbranch) {
        List searchResultList = this.createBankBranchService.search(bankbranch);
        return "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Bankbranch.class, (Object)new BankBranchJsonAdaptor()).create();
        return gson.toJson(object);
    }
}

