/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.bankaccount;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.service.FundService;
import org.egov.commons.utils.BankAccountType;
import org.egov.egf.commons.bank.service.CreateBankService;
import org.egov.egf.commons.bankaccount.service.CreateBankAccountService;
import org.egov.egf.commons.bankbranch.service.CreateBankBranchService;
import org.egov.egf.utils.FinancialUtils;
import org.egov.egf.web.controller.bankaccount.adaptor.BankAccountJsonAdaptor;
import org.egov.model.masters.AccountCodePurpose;
import org.egov.services.voucher.GeneralLedgerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/bankaccount"})
public class BankAccountController {
    private static final String BANKACCOUNT = "bankaccount";
    @Autowired
    private CreateBankAccountService createBankAccountService;
    @Autowired
    private CreateBankBranchService createBankBranchService;
    @Autowired
    private FundService fundService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    @Qualifier(value="generalLedgerService")
    private GeneralLedgerService generalLedgerService;
    @Autowired
    private FinancialUtils financialUtils;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CreateBankService createBankService;

    private void setDropDownValues(Model model) {
        model.addAttribute("banks", (Object)this.createBankService.getByIsActiveTrueOrderByName());
        model.addAttribute("bankbranches", (Object)this.createBankBranchService.getByIsActiveTrueOrderByBranchname());
        model.addAttribute("funds", (Object)this.fundService.getByIsActive(Boolean.valueOf(true)));
        model.addAttribute("usagetypes", (Object)BankAccountType.values());
        model.addAttribute("accounttypes", (Object)this.chartOfAccountsService.getAccountTypes());
        model.addAttribute("autoglcode", (Object)this.createBankAccountService.autoBankAccountGLCodeEnabled());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.setDropDownValues(model);
        model.addAttribute(BANKACCOUNT, (Object)new Bankaccount());
        return "bankaccount-new";
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        Bankaccount bankaccount = this.createBankAccountService.getById(id);
        this.setDropDownValues(model);
        model.addAttribute("autoglcode", (Object)true);
        model.addAttribute(BANKACCOUNT, (Object)bankaccount);
        return "bankaccount-update";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        Bankaccount bankaccount = this.createBankAccountService.getById(id);
        model.addAttribute(BANKACCOUNT, (Object)bankaccount);
        return "bankaccount-view";
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Bankaccount bankaccount = new Bankaccount();
        this.setDropDownValues(model);
        model.addAttribute(BANKACCOUNT, (Object)bankaccount);
        return "bankaccount-search";
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public String success(@PathVariable(value="id") Long id, Model model) {
        Bankaccount bankaccount = this.createBankAccountService.getById(id);
        model.addAttribute(BANKACCOUNT, (Object)bankaccount);
        return "bankaccount-success";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Bankaccount bankaccount, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (!this.createBankAccountService.autoBankAccountGLCodeEnabled().booleanValue()) {
            this.validateGlCode(bankaccount.getChartofaccounts().getGlcode(), errors);
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute(BANKACCOUNT, (Object)bankaccount);
            return "bankaccount-new";
        }
        this.createBankAccountService.create(bankaccount);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.bankaccount.success", null, null));
        return "redirect:/bankaccount/success/" + bankaccount.getId();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Bankaccount bankaccount, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("autoglcode", (Object)true);
            model.addAttribute(BANKACCOUNT, (Object)bankaccount);
            return "bankaccount-update";
        }
        this.createBankAccountService.update(bankaccount);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.bankaccount.success", null, null));
        return "redirect:/bankaccount/success/" + bankaccount.getId();
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Bankaccount bankaccount) {
        List searchResultList = this.createBankAccountService.search(bankaccount);
        return "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Bankaccount.class, (Object)new BankAccountJsonAdaptor()).create();
        return gson.toJson(object);
    }

    private void validateGlCode(String glCode, BindingResult errors) {
        AccountCodePurpose purpose;
        Bankaccount account;
        List glList;
        CChartOfAccounts coa = this.chartOfAccountsService.getByGlCode(glCode);
        if (coa == null) {
            errors.reject("msg.glcode.does.not.exist", (Object[])new String[0], null);
        }
        if (glCode != null && (glList = this.generalLedgerService.getGeneralLedgerByGlCode(glCode)) != null && !glList.isEmpty()) {
            errors.reject("msg.transaction.already.exist.for.given.glcode", (Object[])new String[0], null);
        }
        if (coa != null && (account = this.createBankAccountService.getByGlcode(glCode)) != null) {
            errors.reject("msg.glcode.already.mapped", (Object[])new String[]{account.getAccountnumber()}, null);
        }
        if (coa != null && !coa.getIsActiveForPosting().booleanValue()) {
            errors.reject("msg.glcode.not.active.for.posting", (Object[])new String[0], null);
        }
        if (coa != null && coa.getChartOfAccountDetails() != null && !coa.getChartOfAccountDetails().isEmpty()) {
            errors.reject("msg.glcode.should.not.be.control.code", (Object[])new String[0], null);
        }
        if (coa != null && coa.getType() != null && coa.getType().compareTo(Character.valueOf('A')) != 0) {
            errors.reject("msg.glcode.should.be.of.type.assets", (Object[])new String[0], null);
        }
        if (coa != null && coa.getPurposeId() == null) {
            errors.reject("msg.glcode.is.not.mapped.with.any.purpose", (Object[])new String[0], null);
        }
        if (coa != null && coa.getPurposeId() != null && (purpose = this.financialUtils.getAccountCodePurposeById(coa.getPurposeId())) != null && !purpose.getName().contains("Bank Account Codes")) {
            errors.reject("msg.glcode.should.be.of.purpose.bank.account.codes", (Object[])new String[0], null);
        }
    }
}

