/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.Bank;
import org.egov.commons.Relation;
import org.egov.commons.service.RelationJpaService;
import org.egov.egf.web.adaptor.RelationJsonAdaptor;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.services.masters.BankService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/relation"})
public class RelationController {
    private static final String RELATION_NEW = "relation-new";
    private static final String RELATION_RESULT = "relation-result";
    private static final String RELATION_EDIT = "relation-edit";
    private static final String RELATION_VIEW = "relation-view";
    private static final String RELATION_SEARCH = "relation-search";
    @Autowired
    private RelationJpaService relationJpaService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="bankService")
    private BankService bankService;

    private void prepareNewForm(Model model) {
        model.addAttribute("banks", (Object)this.bankService.findAll());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("relation", (Object)new Relation());
        return RELATION_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Relation relation, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return RELATION_NEW;
        }
        if (relation.getBank() != null && relation.getBank().getId() != null) {
            relation.setBank((Bank)this.bankService.findById((Serializable)relation.getBank().getId(), false));
        } else {
            relation.setBank(null);
        }
        relation.setCreatedby(this.securityUtils.getCurrentUser().getId());
        relation.setCreateddate(new Date());
        relation.setModifiedby(this.securityUtils.getCurrentUser().getId());
        relation.setLastmodifieddate(new Date());
        this.relationJpaService.create(relation);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.relation.success", null, null));
        return "redirect:/relation/result/" + relation.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Integer id, Model model) {
        Relation relation = this.relationJpaService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("relation", (Object)relation);
        return RELATION_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Relation relation, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return RELATION_EDIT;
        }
        relation.setModifiedby(this.securityUtils.getCurrentUser().getId());
        relation.setLastmodifieddate(new Date());
        this.relationJpaService.update(relation);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.relation.success", null, null));
        return "redirect:/relation/result/" + relation.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Integer id, Model model) {
        Relation relation = this.relationJpaService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("relation", (Object)relation);
        return RELATION_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Integer id, Model model) {
        Relation relation = this.relationJpaService.findOne(id);
        model.addAttribute("relation", (Object)relation);
        return RELATION_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Relation relation = new Relation();
        this.prepareNewForm(model);
        model.addAttribute("relation", (Object)relation);
        return RELATION_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Relation relation) {
        List searchResultList = this.relationJpaService.search(relation);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Relation.class, (Object)new RelationJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

