/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.commons.service.CFinancialYearService;
import org.egov.egf.model.ClosedPeriod;
import org.egov.egf.web.adaptor.ClosedPeriodJsonAdaptor;
import org.egov.services.closeperiod.ClosedPeriodService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/closedperiod"})
public class ClosedPeriodController {
    private static final String CLOSEDPERIOD_RESULT = "closedperiod-result";
    private static final String CLOSEDPERIOD_EDIT = "closedperiod-edit";
    private static final String CLOSEDPERIOD_SEARCH = "closedperiod-search";
    private static final String CLOSEDPERIOD = "closedPeriod";
    @Autowired
    private ClosedPeriodService closedPeriodService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CFinancialYearService cFinancialYearService;

    private void prepareNewForm(Model model) {
        model.addAttribute("cFinancialYears", (Object)this.cFinancialYearService.findAll());
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        ClosedPeriod closedPeriod = this.closedPeriodService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute(CLOSEDPERIOD, (Object)closedPeriod);
        return CLOSEDPERIOD_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@ModelAttribute ClosedPeriod closedPeriod, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return CLOSEDPERIOD_EDIT;
        }
        List closePer = this.closedPeriodService.findAll();
        Long cId = closedPeriod.getcFinancialYearId().getId();
        if (!closePer.isEmpty()) {
            for (ClosedPeriod cp : closePer) {
                if (cp.getcFinancialYearId().getId() != closedPeriod.getcFinancialYearId().getId() || closedPeriod.getIsClosed().booleanValue()) continue;
                this.closedPeriodService.delete(cp);
                redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.reopenedperiod.success", null, null));
                return "redirect:/closedperiod/result/" + cId;
            }
        } else if (closePer.isEmpty() && closedPeriod.getIsClosed().booleanValue()) {
            this.closedPeriodService.update(closedPeriod);
            redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.closedPeriod.success", null, null));
            return "redirect:/closedperiod/result/" + closedPeriod.getId();
        }
        if (!closedPeriod.getcFinancialYearId().getIsClosed().booleanValue() && !closedPeriod.getIsClosed().booleanValue()) {
            redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.reopenedperiod.success", null, null));
            return "redirect:/closedperiod/result/" + cId;
        }
        this.closedPeriodService.update(closedPeriod);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.closedPeriod.success", null, null));
        return "redirect:/closedperiod/result/" + closedPeriod.getId();
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        ClosedPeriod closedPeriod = this.closedPeriodService.findOne(id);
        model.addAttribute(CLOSEDPERIOD, (Object)closedPeriod);
        return CLOSEDPERIOD_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        ClosedPeriod closedPeriod = new ClosedPeriod();
        this.prepareNewForm(model);
        model.addAttribute(CLOSEDPERIOD, (Object)closedPeriod);
        return CLOSEDPERIOD_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute ClosedPeriod closedPeriod) {
        List searchResultList = this.closedPeriodService.search(closedPeriod);
        return "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ClosedPeriod.class, (Object)new ClosedPeriodJsonAdaptor()).create();
        return gson.toJson(object);
    }
}

