/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.List;
import org.egov.commons.dao.FunctionDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.egf.web.adaptor.BudgetUploadReportJsonAdaptor;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetUploadReport;
import org.egov.model.service.BudgetUploadReportService;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/budgetuploadreport"})
public class BudgetUploadReportController {
    private static final String BUDGETUPLOADREPORT_SEARCH = "budgetuploadreport-search";
    @Autowired
    private BudgetUploadReportService budgetUploadReportService;
    @Autowired
    @Qualifier(value="budgetService")
    private BudgetService budgetService;
    @Autowired
    private FundHibernateDAO fundDAO;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private FunctionDAO functionDAO;
    @Autowired
    @Qualifier(value="budgetDetailService")
    private BudgetDetailService budgetDetailService;

    private void prepareNewForm(Model model) {
        model.addAttribute("budgets", (Object)this.budgetService.getBudgetsForUploadReport());
        model.addAttribute("funds", (Object)this.fundDAO.findAllActiveIsLeafFunds());
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("functions", (Object)this.functionDAO.getAllActiveFunctions());
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        BudgetUploadReport budgetUploadReport = new BudgetUploadReport();
        this.prepareNewForm(model);
        model.addAttribute("budgetUploadReport", (Object)budgetUploadReport);
        return BUDGETUPLOADREPORT_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(Model model, @ModelAttribute BudgetUploadReport budgetUploadReport) {
        List searchResultList = this.budgetUploadReportService.search(budgetUploadReport);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    @RequestMapping(value={"/ajax/getReferenceBudget"}, method={RequestMethod.GET})
    @ResponseBody
    public String getReferenceBudget(@RequestParam(value="budgetId") Long budgetId) {
        if (budgetId != null) {
            Budget refBudget = this.budgetService.getReferenceBudgetFor((Budget)this.budgetService.findById((Serializable)budgetId, false));
            return refBudget.getName();
        }
        return null;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(BudgetUploadReport.class, (Object)new BudgetUploadReportJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

