/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.egf.web.adaptor.BudgetGroupJsonAdaptor;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.service.BudgetingGroupService;
import org.egov.services.budget.BudgetDetailService;
import org.egov.utils.BudgetAccountType;
import org.egov.utils.BudgetingType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/budgetgroup"})
public class BudgetGroupController {
    private static final String BUDGETGROUP_NEW = "budgetgroup-new";
    private static final String BUDGETGROUP_RESULT = "budgetgroup-result";
    private static final String BUDGETGROUP_EDIT = "budgetgroup-edit";
    private static final String BUDGETGROUP_VIEW = "budgetgroup-view";
    private static final String BUDGETGROUP_SEARCH = "budgetgroup-search";
    @Autowired
    private BudgetingGroupService budgetGroupService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private BudgetDetailService budgetDetailService;

    private void prepareNewForm(Model model) {
        model.addAttribute("majorCodeList", (Object)this.budgetGroupService.getMajorCodeList());
        model.addAttribute("minCodeList", (Object)this.budgetGroupService.getMinCodeList());
        model.addAttribute("budgetAccountTypes", Arrays.asList(BudgetAccountType.values()));
        model.addAttribute("budgetingTypes", Arrays.asList(BudgetingType.values()));
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("budgetGroup", (Object)new BudgetGroup());
        return BUDGETGROUP_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute BudgetGroup budgetGroup, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (budgetGroup.getMajorCode() == null && budgetGroup.getMinCode() == null && budgetGroup.getMaxCode() == null) {
            errors.rejectValue("majorCode", "budgetgroup.select.accountcode");
        }
        if (budgetGroup.getMajorCode() != null && (budgetGroup.getMinCode() != null || budgetGroup.getMaxCode() != null)) {
            errors.rejectValue("majorCode", "budgetgroup.invalid.mapping");
        }
        if (budgetGroup.getMajorCode() == null && (budgetGroup.getMinCode() != null || budgetGroup.getMaxCode() != null)) {
            if (budgetGroup.getMinCode() == null) {
                errors.rejectValue("minCode", "budgetgroup.invalidminorcode.mapping");
            } else if (budgetGroup.getMaxCode() == null) {
                errors.rejectValue("maxCode", "budgetgroup.invalidmajorcode.mapping");
            }
        }
        String validationMessage = this.budgetGroupService.validate(budgetGroup, errors);
        if (errors.hasErrors() || !StringUtils.isEmpty((CharSequence)validationMessage)) {
            this.prepareNewForm(model);
            model.addAttribute("majorCode", (Object)validationMessage);
            return BUDGETGROUP_NEW;
        }
        this.budgetGroupService.create(budgetGroup);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.budgetGroup.success", null, Locale.ENGLISH));
        return "redirect:/budgetgroup/result/" + budgetGroup.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        BudgetGroup budgetGroup = this.budgetGroupService.findOne(id);
        List bd = this.budgetDetailService.getBudgetDetailsByBudgetGroupId(budgetGroup.getId());
        if (!bd.isEmpty()) {
            model.addAttribute("mode", (Object)"edit");
        }
        this.prepareNewForm(model);
        model.addAttribute("budgetGroup", (Object)budgetGroup);
        return BUDGETGROUP_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute BudgetGroup budgetGroup, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        String validationMessage = this.budgetGroupService.validate(budgetGroup, errors);
        if (errors.hasErrors() || !StringUtils.isEmpty((CharSequence)validationMessage)) {
            model.addAttribute("majorCode", (Object)validationMessage);
            this.prepareNewForm(model);
            return BUDGETGROUP_EDIT;
        }
        this.budgetGroupService.update(budgetGroup);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.budgetGroup.update", null, Locale.ENGLISH));
        return "redirect:/budgetgroup/result/" + budgetGroup.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        BudgetGroup budgetGroup = this.budgetGroupService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("budgetGroup", (Object)budgetGroup);
        return BUDGETGROUP_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        BudgetGroup budgetGroup = this.budgetGroupService.findOne(id);
        model.addAttribute("budgetGroup", (Object)budgetGroup);
        return BUDGETGROUP_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        BudgetGroup budgetGroup = new BudgetGroup();
        this.prepareNewForm(model);
        model.addAttribute("budgetGroup", (Object)budgetGroup);
        return BUDGETGROUP_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute BudgetGroup budgetGroup) {
        List searchResultList = this.budgetGroupService.search(budgetGroup);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(BudgetGroup.class, (Object)new BudgetGroupJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

