/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.egov.egf.web.adaptor.BudgetApprovalAdaptor;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetApproval;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.repository.BudgetDefinitionRepository;
import org.egov.model.service.BudgetApprovalService;
import org.egov.model.service.BudgetDefinitionService;
import org.egov.services.budget.BudgetDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/budgetapproval"})
public class BudgetApprovalController {
    private static final String BUDGETAPPROVAL_SEARCH = "budgetapproval-search";
    private static final String BUDGETAPPROVAL_RESULT = "budgetapproval-result";
    @Autowired
    private BudgetApprovalService budgetApprovalService;
    @Autowired
    private BudgetDefinitionService budgetDefinitionService;
    @Autowired
    private BudgetDefinitionRepository budgetDefinitionRepository;
    @Autowired
    private BudgetApprovalAdaptor budgetApprovalAdaptor;
    @Autowired
    private BudgetDetailService budgetDetailService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
        model.addAttribute("financialYearList", (Object)this.budgetApprovalService.financialYearList());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        BudgetDetail budgetDetail = new BudgetDetail();
        this.prepareNewForm(model);
        model.addAttribute("budgetDetail", (Object)budgetDetail);
        return BUDGETAPPROVAL_SEARCH;
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String search(Model model, @ModelAttribute BudgetDetail budgetDetail) {
        Long finYearId = budgetDetail.getBudget().getFinancialYear().getId();
        List searchResultList = this.budgetApprovalService.search(finYearId);
        this.prepareNewForm(model);
        ArrayList<BudgetApproval> budgetApprovalList = new ArrayList<BudgetApproval>();
        for (Budget ba : searchResultList) {
            BudgetApproval budgetApproval = new BudgetApproval();
            budgetApproval.setId(ba.getId());
            budgetApproval.setDepartment(this.budgetDetailService.getDeptNameForBudgetId(ba.getId()));
            budgetApproval.setParent(ba.getParent().getName());
            budgetApproval.setReferenceBudget(this.budgetDetailService.getNextYrBEName(ba));
            budgetApproval.setBeAmount(this.budgetDetailService.getBEAmount(ba));
            budgetApproval.setReAmount(this.budgetDetailService.getREAmount(ba));
            budgetApproval.setCount(this.budgetDetailService.getBudgetDetailCount(ba));
            budgetApprovalList.add(budgetApproval);
        }
        return "{ \"data\":" + this.toSearchResultJson(budgetApprovalList) + "}";
    }

    @RequestMapping(value={"/approve"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String approve(@ModelAttribute BudgetDetail budgetDetail, BindingResult errors, Model model, RedirectAttributes redirectAttrs, @RequestParam List<String> checkedArray) {
        Budget bg;
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String checkListId : checkedArray) {
            if (!checkListId.isEmpty()) {
                idList.add(Long.parseLong(checkListId));
            }
            Budget budget = this.budgetDefinitionService.findOne(Long.valueOf(checkListId));
            budget.setStatus(this.budgetDefinitionService.getBudgetApprovedStatus());
            this.budgetDefinitionService.update(budget);
            bg = this.budgetDefinitionRepository.findByReferenceBudgetId(Long.valueOf(checkListId));
            bg.setStatus(this.budgetDefinitionService.getBudgetApprovedStatus());
            this.budgetDefinitionService.update(bg);
            Budget parentREBudget = this.budgetDefinitionService.getParentBudgetForApprovedChildBudgets(budget);
            if (parentREBudget == null) continue;
            parentREBudget.setStatus(this.budgetDefinitionService.getBudgetApprovedStatus());
            this.budgetDefinitionService.update(parentREBudget);
            Budget referenceParentREBudget = this.budgetDefinitionRepository.findByReferenceBudgetId(parentREBudget.getId());
            referenceParentREBudget.setStatus(this.budgetDefinitionService.getBudgetApprovedStatus());
            this.budgetDefinitionService.update(referenceParentREBudget);
            Budget rootREBudget = this.budgetDefinitionService.getParentBudgetForApprovedChildBudgets(parentREBudget);
            if (rootREBudget == null) continue;
            rootREBudget.setStatus(this.budgetDefinitionService.getBudgetApprovedStatus());
            this.budgetDefinitionService.update(rootREBudget);
            Budget rootBEBudget = this.budgetDefinitionRepository.findByReferenceBudgetId(rootREBudget.getId());
            rootBEBudget.setStatus(this.budgetDefinitionService.getBudgetApprovedStatus());
            this.budgetDefinitionService.update(rootBEBudget);
        }
        List budgetDetailList = this.budgetDetailService.getBudgetDetails(idList);
        for (BudgetDetail budgetDetails : budgetDetailList) {
            budgetDetails.setStatus(this.budgetDetailService.getBudgetDetailStatus("Approved"));
            this.budgetDetailService.update((Object)budgetDetails);
            bg = this.budgetDetailService.getBudgetDetailByReferencceBudget(budgetDetails.getUniqueNo(), budgetDetails.getBudget().getId());
            bg.setStatus(this.budgetDetailService.getBudgetDetailStatus("Approved"));
            this.budgetDetailService.update((Object)bg);
        }
        return this.messageSource.getMessage("msg.budgetdetail.approve", null, Locale.ENGLISH);
    }

    @RequestMapping(value={"/reject"}, method={RequestMethod.POST})
    @ResponseBody
    public String reject(@ModelAttribute BudgetDetail budgetDetail, BindingResult errors, Model model, RedirectAttributes redirectAttrs, @RequestParam List<String> checkedArray, @RequestParam String comments) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String checkedIdList : checkedArray) {
            if (checkedIdList.isEmpty()) continue;
            idList.add(Long.parseLong(checkedIdList));
        }
        List budgetDetailList = this.budgetDetailService.getBudgetDetails(idList);
        for (BudgetDetail budgetDetails : budgetDetailList) {
            budgetDetails = this.budgetDetailService.rejectWorkFlow(budgetDetails, comments);
            budgetDetails.setStatus(this.budgetDetailService.getBudgetDetailStatus("REJECTED"));
            this.budgetDetailService.update((Object)budgetDetails);
            BudgetDetail bg = this.budgetDetailService.getBudgetDetailByReferencceBudget(budgetDetails.getUniqueNo(), budgetDetails.getBudget().getId());
            bg.setStatus(this.budgetDetailService.getBudgetDetailStatus("REJECTED"));
            this.budgetDetailService.update((Object)bg);
        }
        return this.messageSource.getMessage("msg.budgetdetail.reject", null, Locale.ENGLISH);
    }

    @RequestMapping(value={"/success"})
    public String success(@ModelAttribute Budget budget, BindingResult errors, Model model, @RequestParam(value="message") String message) {
        model.addAttribute("message", (Object)message);
        return BUDGETAPPROVAL_RESULT;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(BudgetApproval.class, (Object)this.budgetApprovalAdaptor).create();
        return gson.toJson(object);
    }
}

