/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.model.budget.Budget;

public class BudgetJsonAdaptor
implements JsonSerializer<Budget> {
    public JsonElement serialize(Budget budget, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (budget != null) {
            if (budget.getName() != null) {
                jsonObject.addProperty("name", budget.getName());
            } else {
                jsonObject.addProperty("name", "");
            }
            if (budget.getIsbere() != null) {
                jsonObject.addProperty("isbere", budget.getIsbere());
            } else {
                jsonObject.addProperty("isbere", "");
            }
            if (budget.getFinancialYear() != null) {
                jsonObject.addProperty("financialYear", budget.getFinancialYear().getFinYearRange());
            } else {
                jsonObject.addProperty("financialYear", "");
            }
            if (budget.getParent() != null) {
                jsonObject.addProperty("parent", budget.getParent().getName());
                jsonObject.addProperty("parentId", (Number)budget.getParent().getId());
            } else {
                jsonObject.addProperty("parent", "");
                jsonObject.addProperty("parentId", "");
            }
            if (budget.getReferenceBudget() != null) {
                jsonObject.addProperty("reference", budget.getReferenceBudget().getName());
                jsonObject.addProperty("referenceId", (Number)budget.getReferenceBudget().getId());
            } else {
                jsonObject.addProperty("reference", "");
                jsonObject.addProperty("referenceId", "");
            }
            if (budget.getIsActiveBudget()) {
                jsonObject.addProperty("isActiveBudget", Boolean.toString(true).toUpperCase());
            } else {
                jsonObject.addProperty("isActiveBudget", Boolean.toString(false).toUpperCase());
            }
            if (budget.getIsPrimaryBudget()) {
                jsonObject.addProperty("isPrimaryBudget", Boolean.toString(true).toUpperCase());
            } else {
                jsonObject.addProperty("isPrimaryBudget", Boolean.toString(false).toUpperCase());
            }
            jsonObject.addProperty("id", (Number)budget.getId());
        }
        return jsonObject;
    }
}

