/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import com.exilant.GLEngine.ChartOfAccounts;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.model.voucher.VoucherDetails;
import org.egov.model.voucher.VoucherTypeBean;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.services.voucher.JournalVoucherActionHelper;
import org.egov.services.voucher.PreApprovedActionHelper;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.VoucherHelper;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"editVoucher"}, location="journalVoucherModify-editVoucher.jsp"), @Result(name={"view"}, location="journalVoucherModify-view.jsp"), @Result(name={"message"}, location="journalVoucherModify-message.jsp")})
public class JournalVoucherModifyAction
extends BaseVoucherAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JournalVoucherModifyAction.class);
    private VoucherService voucherService;
    private List<VoucherDetails> billDetailslist;
    private List<VoucherDetails> subLedgerlist;
    private String voucherNumManual;
    private String target;
    private String saveMode;
    private String message = "";
    private VoucherTypeBean voucherTypeBean;
    public static final String EXEPMSG = "Exception occured in voucher service while updating voucher ";
    private Integer departmentId;
    private String wfitemstate;
    private VoucherHelper voucherHelper;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private ChartOfAccounts chartOfAccounts;
    private ChartOfAccounts engine;
    private static final String ACTIONNAME = "actionName";
    private SimpleWorkflowService<CVoucherHeader> voucherWorkflowService;
    private String methodName = "";
    private static final String VHID = "vhid";
    protected EisCommonService eisCommonService;
    private static final String VOUCHERQUERY = " from CVoucherHeader where id=?";
    private String worksVoucherRestrictedDate;
    private FinancialYearDAO financialYearDAO;
    private boolean isOneFunctionCenter;
    private ScriptService scriptService;
    @Autowired
    @Qualifier(value="preApprovedActionHelper")
    private PreApprovedActionHelper preApprovedActionHelper;
    @Autowired
    @Qualifier(value="journalVoucherActionHelper")
    private JournalVoucherActionHelper journalVoucherActionHelper;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void prepare() {
        super.prepare();
        this.addDropdownData("approvaldepartmentList", Collections.EMPTY_LIST);
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
        this.setOneFunctionCenterValue();
    }

    @Action(value="/voucher/journalVoucherModify-beforeModify")
    public String beforeModify() {
        String voucherHeaderId = null;
        List positionsForUser = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalVoucherModifyAction | loadvouchers | Start ");
        }
        voucherHeaderId = this.voucherHeader != null && this.voucherHeader.getId() != null ? this.voucherHeader.getId().toString() : ((String[])this.parameters.get("voucherId"))[0];
        this.isOneFunctionCenter = this.voucherHeader.getIsRestrictedtoOneFunctionCenter();
        if (voucherHeaderId != null) {
            this.voucherHeader = (CVoucherHeader)this.getPersistenceService().find(VOUCHERQUERY, new Object[]{Long.valueOf(voucherHeaderId)});
        }
        Map vhInfoMap = this.voucherService.getVoucherInfo(this.voucherHeader.getId());
        this.voucherHeader = (CVoucherHeader)vhInfoMap.get("voucherHeader");
        try {
            if (this.voucherHeader != null && this.voucherHeader.getState() != null) {
                if (this.voucherHeader.getState().getValue().contains("Rejected")) {
                    positionsForUser = this.eisService.getPositionsForUser(ApplicationThreadLocals.getUserId(), new Date());
                } else if (this.voucherHeader.getState().getValue().contains("Closed")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Valid Owner :return true");
                    }
                } else if (((String[])this.parameters.get("showMode"))[0].equalsIgnoreCase("view")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Valid Owner :return true");
                    }
                } else {
                    throw new ApplicationRuntimeException("Invalid Aceess");
                }
            }
            this.setOneFunctionCenterValue();
        }
        catch (ApplicationRuntimeException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", "Invalid Aceess"));
            throw new ValidationException(errors);
        }
        this.billDetailslist = (List)vhInfoMap.get("glDetailList");
        this.subLedgerlist = (List)vhInfoMap.get("subLedgerDetail");
        this.getBillInfo();
        this.loadSchemeSubscheme();
        this.loadFundSource();
        if (null != this.parameters.get("showMode") && ((String[])this.parameters.get("showMode"))[0].equalsIgnoreCase("view")) {
            return "view";
        }
        return "editVoucher";
    }

    @ValidationErrorPage(value="editVoucher")
    public String saveAndPrint() throws Exception {
        this.saveMode = "saveprint";
        return this.update();
    }

    private void sendForApproval() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"journalVoucherModifyAction | sendForApproval | Start");
        }
        if (this.voucherHeader.getId() == null) {
            this.voucherHeader = (CVoucherHeader)this.voucherService.findById((Serializable)Long.valueOf(Long.parseLong(((String[])this.parameters.get("voucherId"))[0])), false);
        }
        this.populateWorkflowBean();
        this.voucherHeader = this.preApprovedActionHelper.sendForApproval(this.voucherHeader, this.workflowBean);
        if ("Forward".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("pjv.voucher.approved", new String[]{this.voucherService.getEmployeeNameForPositionId(this.voucherHeader.getState().getOwnerPosition())}));
        }
        if ("Cancel".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("billVoucher.file.canceled"));
            if (!"JVGeneral".equalsIgnoreCase(this.voucherHeader.getName())) {
                this.cancelBill(this.voucherHeader.getId());
            }
        }
    }

    private void validateBeforeEdit(CVoucherHeader voucherHeader) {
        try {
            this.financialYearDAO.getFinancialYearByDate(voucherHeader.getVoucherDate());
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    private void addActionMsg(String stateValue, Position pos) {
        if (((String[])this.parameters.get(ACTIONNAME))[0].contains("approve")) {
            if ("END".equals(stateValue)) {
                this.addActionMessage(this.getText("pjv.voucher.final.approval", new String[]{"The File has been approved"}));
            } else {
                this.addActionMessage(this.getText("pjv.voucher.modified", new String[]{this.voucherHeader.getVoucherNumber()}));
                this.addActionMessage(this.getText("pjv.voucher.approved", new String[]{this.voucherService.getEmployeeNameForPositionId(pos)}));
            }
        } else if (((String[])this.parameters.get(ACTIONNAME))[0].contains("ao_reject") || ((String[])this.parameters.get(ACTIONNAME))[0].contains("aa_reject") || "END".equals(stateValue)) {
            this.addActionMessage(this.getText("voucher.cancelled"));
        } else {
            this.addActionMessage(this.getText("pjv.voucher.rejected", new String[]{this.voucherService.getEmployeeNameForPositionId(pos)}));
        }
    }

    @ValidationErrorPage(value="editVoucher")
    @Action(value="/voucher/journalVoucherModify-update")
    public String update() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalVoucherModifyAction | updateVoucher | Start");
        }
        this.target = "";
        this.loadSchemeSubscheme();
        this.validateFields();
        if (this.voucherHeader.getId() == null) {
            this.voucherHeader.setId(Long.valueOf(((String[])this.parameters.get(VHID))[0]));
        }
        this.validateBeforeEdit(this.voucherHeader);
        CVoucherHeader oldVh = this.voucherHeader;
        this.populateWorkflowBean();
        if ("Cancel".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.voucherHeader = (CVoucherHeader)this.voucherService.findById((Serializable)Long.valueOf(Long.parseLong(((String[])this.parameters.get(VHID))[0])), false);
            this.sendForApproval();
            return "message";
        }
        if (null != this.voucherNumManual && StringUtils.isNotEmpty((String)this.voucherNumManual)) {
            this.voucherHeader.setVoucherNumber(this.voucherNumManual);
        }
        this.voucherHeader.setIsRestrictedtoOneFunctionCenter(Boolean.valueOf(this.isOneFunctionCenter));
        this.removeEmptyRowsAccoutDetail(this.billDetailslist);
        this.removeEmptyRowsSubledger(this.subLedgerlist);
        try {
            if (this.validateData(this.billDetailslist, this.subLedgerlist)) {
                throw new ValidationException("InValid data", "InValid data", new String[0]);
            }
            this.voucherHeader = this.journalVoucherActionHelper.editVoucher(this.billDetailslist, this.subLedgerlist, this.voucherHeader, this.voucherTypeBean, this.workflowBean, ((String[])this.parameters.get("totaldbamount"))[0]);
            this.target = "success";
            if (this.subLedgerlist.size() == 0) {
                this.subLedgerlist.add(new VoucherDetails());
                this.resetVoucherHeader();
            } else {
                this.resetVoucherHeader();
            }
            if ("Forward".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("pjv.voucher.approved", new String[]{this.voucherService.getEmployeeNameForPositionId(this.voucherHeader.getState().getOwnerPosition())}));
            }
        }
        catch (ValidationException e) {
            this.resetVoucherHeader();
            this.voucherHeader = oldVh;
            this.setOneFunctionCenterValue();
            if (this.subLedgerlist.size() == 0) {
                this.subLedgerlist.add(new VoucherDetails());
            }
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            this.resetVoucherHeader();
            this.voucherHeader = oldVh;
            this.setOneFunctionCenterValue();
            if (this.subLedgerlist.size() == 0) {
                this.subLedgerlist.add(new VoucherDetails());
            }
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalVoucherModifyAction | updateVoucher | End");
        }
        return "message";
    }

    private void cancelBill(Long vhId) {
        StringBuffer billQuery = new StringBuffer();
        String statusQuery = "(select stat.id from  egw_status  stat where stat.moduletype=:module and stat.description=:description)";
        String cancelQuery = "Update eg_billregister set billstatus=:billstatus , statusid =(select stat.id from  egw_status  stat where stat.moduletype=:module and stat.description=:description) where  id=:billId";
        String moduleType = "";
        String description = "";
        String billstatus = "";
        EgBillregistermis billMis = (EgBillregistermis)this.persistenceService.find("from  EgBillregistermis  mis where voucherHeader.id=?", new Object[]{vhId});
        if (billMis != null && billMis.getEgBillregister().getState() == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"....Cancelling Bill Associated with the Voucher....");
            }
            billQuery.append("select bill.expendituretype,bill.id from CVoucherHeader vh,EgBillregister bill ,EgBillregistermis mis").append(" where vh.id=mis.voucherHeader and bill.id=mis.egBillregister and vh.id=" + vhId);
            Object[] bill = (Object[])this.persistenceService.find(billQuery.toString());
            if ("Salary".equalsIgnoreCase(bill[0].toString())) {
                billstatus = "SALBILL";
                description = "Cancelled";
                moduleType = "SALBILL";
            } else if ("Expense".equalsIgnoreCase(bill[0].toString())) {
                billstatus = "Cancelled";
                description = "Cancelled";
                moduleType = "EXPENSEBILL";
            } else if ("Purchase".equalsIgnoreCase(bill[0].toString())) {
                billstatus = "Cancelled";
                description = "Cancelled";
                moduleType = "PURCHBILL";
            } else if ("Works".equalsIgnoreCase(bill[0].toString())) {
                billstatus = "Cancelled";
                description = "Cancelled";
                moduleType = "WORKSBILL";
            }
            SQLQuery billQry = this.persistenceService.getSession().createSQLQuery("Update eg_billregister set billstatus=:billstatus , statusid =(select stat.id from  egw_status  stat where stat.moduletype=:module and stat.description=:description) where  id=:billId".toString());
            billQry.setString("module", moduleType);
            billQry.setString("description", description);
            billQry.setString("billstatus", billstatus);
            billQry.setLong("billId", ((Long)bill[1]).longValue());
            billQry.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Bill Cancelled Successfully" + bill[1]));
            }
        }
    }

    public Position getPosition() throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getPosition====" + ApplicationThreadLocals.getUserId()));
        }
        Position pos = this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("position===" + pos.getId()));
        }
        return pos;
    }

    @SkipValidation
    public List<WorkflowAction> getValidActions(String purpose) {
        ArrayList<WorkflowAction> validButtons = new ArrayList<WorkflowAction>();
        List list = (List)this.scriptService.executeScript("pjv.validbuttons", ScriptService.createContext((Object[])new Object[]{"eisCommonServiceBean", this.eisCommonService, "userId", ApplicationThreadLocals.getUserId().intValue(), "date", new Date(), "purpose", purpose}));
        for (Object s : list) {
            if ("invalid".equals(s)) break;
            WorkflowAction action = (WorkflowAction)this.getPersistenceService().find(" from WorkflowAction where type='CVoucherHeader' and name=?", new Object[]{s.toString()});
            validButtons.add(action);
        }
        return validButtons;
    }

    private void loadApproverUser(String type) {
        String scriptName = "billvoucher.nextDesg";
        this.departmentId = this.voucherService.getCurrentDepartment().getId().intValue();
        Map map = this.voucherService.getDesgByDeptAndType(type, "billvoucher.nextDesg");
        if (null == map.get("wfitemstate")) {
            if (this.mandatoryFields.contains("department")) {
                this.addDropdownData("approvaldepartmentList", this.voucherHelper.getAllAssgnDeptforUser());
            } else {
                this.addDropdownData("approvaldepartmentList", this.masterDataCache.get("egi-department"));
            }
            this.addDropdownData("designationList", (List)map.get("designationList"));
            this.wfitemstate = "";
        } else {
            this.wfitemstate = map.get("wfitemstate").toString();
        }
    }

    public void getBillInfo() {
        EgBillregister billRegister;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"JournalVoucherModify | getBillInfo | Start");
        }
        if (null != (billRegister = (EgBillregister)this.persistenceService.find("from EgBillregister br where br.egBillregistermis.voucherHeader.id=" + this.voucherHeader.getId()))) {
            this.voucherTypeBean.setPartyBillNum(billRegister.getEgBillregistermis().getPartyBillNumber());
            this.voucherTypeBean.setPartyName(billRegister.getEgBillregistermis().getPayto());
            this.voucherTypeBean.setPartyBillDate(billRegister.getEgBillregistermis().getPartyBillDate());
            this.voucherTypeBean.setBillNum(billRegister.getBillnumber());
            this.voucherTypeBean.setBillDate(billRegister.getBilldate());
            if (null == billRegister.getEgBillregistermis().getEgBillSubType()) {
                this.voucherTypeBean.setVoucherSubType(billRegister.getExpendituretype());
            } else {
                this.voucherTypeBean.setVoucherSubType(billRegister.getEgBillregistermis().getEgBillSubType().getName());
            }
        } else {
            this.voucherTypeBean.setVoucherSubType(this.voucherHeader.getName());
        }
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public List<VoucherDetails> getBillDetailslist() {
        return this.billDetailslist;
    }

    public VoucherTypeBean getVoucherTypeBean() {
        return this.voucherTypeBean;
    }

    public void setVoucherTypeBean(VoucherTypeBean voucherTypeBean) {
        this.voucherTypeBean = voucherTypeBean;
    }

    public void setBillDetailslist(List<VoucherDetails> billDetailslist) {
        this.billDetailslist = billDetailslist;
    }

    public List<VoucherDetails> getSubLedgerlist() {
        return this.subLedgerlist;
    }

    public void setSubLedgerlist(List<VoucherDetails> subLedgerlist) {
        this.subLedgerlist = subLedgerlist;
    }

    public String getVoucherNumManual() {
        return this.voucherNumManual;
    }

    public void setVoucherNumManual(String voucherNumManual) {
        this.voucherNumManual = voucherNumManual;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getSaveMode() {
        return this.saveMode;
    }

    public void setSaveMode(String saveMode) {
        this.saveMode = saveMode;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public VoucherHelper getVoucherHelper() {
        return this.voucherHelper;
    }

    public void setVoucherHelper(VoucherHelper voucherHelper) {
        this.voucherHelper = voucherHelper;
    }

    public SimpleWorkflowService<CVoucherHeader> getVoucherWorkflowService() {
        return this.voucherWorkflowService;
    }

    public void setVoucherWorkflowService(SimpleWorkflowService<CVoucherHeader> voucherWorkflowService) {
        this.voucherWorkflowService = voucherWorkflowService;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public EisCommonService getEisCommonService() {
        return this.eisCommonService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getWorksVoucherRestrictedDate() {
        return this.worksVoucherRestrictedDate;
    }

    public void setWorksVoucherRestrictedDate(String worksVoucherRestrictedDate) {
        this.worksVoucherRestrictedDate = worksVoucherRestrictedDate;
    }

    public boolean isOneFunctionCenter() {
        return this.isOneFunctionCenter;
    }

    public void setOneFunctionCenter(boolean isOneFunctionCenter) {
        this.isOneFunctionCenter = isOneFunctionCenter;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }
}

