/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.revenue;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.egf.revenue.Grant;
import org.egov.egf.web.actions.revenue.BaseRevenueAction;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.ReportHelper;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=CentralFC.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=CentralFC.xls"})})
public class CentralFCAction
extends BaseRevenueAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = -7946924671971486440L;
    private final String jasperpath = "/reports/templates/RevenueReport.jasper";
    private ReportHelper reportHelper;
    private InputStream inputStream;

    public void prepare() {
        super.prepare();
        this.periodList = new ArrayList();
        this.periodList.add("I-Half");
        this.periodList.add("II-Half");
        this.setGrantsType("Central Finance Commission");
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String header = "";
        paramMap.put("ulbName", this.getUlbName());
        paramMap.put("heading", "");
        return paramMap;
    }

    public String exportPdf() throws JRException, IOException {
        ArrayList<Grant> dataSource = new ArrayList<Grant>();
        for (Grant row : this.grantsList) {
            if (row.getDepartment().getId() != null) {
                for (Department dep : this.departmentList) {
                    if (!dep.getId().equals(row.getDepartment().getId())) continue;
                    row.setDepartment(dep);
                }
            }
            for (CFinancialYear fin : this.finYearList) {
                if (!fin.getId().equals(row.getFinancialYear().getId())) continue;
                row.setFinancialYear(fin);
            }
            dataSource.add(row);
        }
        this.setInputStream(this.reportHelper.exportPdf(this.getInputStream(), "/reports/templates/RevenueReport.jasper", this.getParamMap(), dataSource));
        return "PDF";
    }

    public String exportXls() throws JRException, IOException {
        ArrayList<Grant> dataSource = new ArrayList<Grant>();
        for (Grant row : this.grantsList) {
            if (row.getDepartment().getId() != null) {
                for (Department dep : this.departmentList) {
                    if (!dep.getId().equals(row.getDepartment().getId())) continue;
                    row.setDepartment(dep);
                }
            }
            for (CFinancialYear fin : this.finYearList) {
                if (!fin.getId().equals(row.getFinancialYear().getId())) continue;
                row.setFinancialYear(fin);
            }
            dataSource.add(row);
        }
        this.setInputStream(this.reportHelper.exportXls(this.getInputStream(), "/reports/templates/RevenueReport.jasper", this.getParamMap(), dataSource));
        return "XLS";
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

