/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report.loangrant;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.utils.EntityType;
import org.egov.egf.masters.model.LoanGrantBean;
import org.egov.egf.web.actions.masters.loangrant.LoanGrantBaseAction;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.services.report.LoanGrantService;
import org.egov.utils.ReportHelper;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"result"}, location="schemeUtilizationReport-result.jsp"), @Result(name={"new"}, location="schemeUtilizationReport-new.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=SchemeUtilization.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=SchemeUtilization.xls"}), @Result(name={"HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html", "contentDisposition", "no-cache;filename=SchemeUtilization.html"})})
public class SchemeUtilizationReportAction
extends LoanGrantBaseAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 5416901822456802437L;
    static final Logger LOGGER = Logger.getLogger(SchemeUtilizationReportAction.class);
    private LoanGrantService lgService;
    private List<Integer> projectCodeIdList;
    private List<Object> projectCodeResultList;
    private List<LoanGrantBean> fundingPatternBysubScheme;
    private final String jasperpath = "/reports/templates/SchemeUtilization.jasper";
    private InputStream inputStream;
    private ReportService reportService;
    ReportHelper reportHelper;
    private int maxRows;
    private Map<String, BigDecimal> faTotalMap;
    private List<Object> fundingAgencyResultList;

    public void prepare() {
        super.prepare();
    }

    public Object getModel() {
        return super.getModel();
    }

    @Action(value="/report/loangrant/schemeUtilizationReport-newForm")
    public String newForm() {
        return "new";
    }

    @Action(value="/report/loangrant/schemeUtilizationReport-search")
    public String search() {
        if (this.projectCodeIdList != null) {
            this.projectCodeIdList = this.removeNulls(this.projectCodeIdList);
        }
        this.projectCodeResultList = this.lgService.schemeUtilizationBy(this.schemeId, this.subSchemeId, this.fromDate, this.toDate, this.projectCodeIdList, this.fundId);
        if (this.projectCodeResultList.size() == 0) {
            this.addActionMessage("No Records Found");
            throw new ValidationException(Arrays.asList(new ValidationError("No Records Found", "no.records.found")));
        }
        this.fundingPatternBysubScheme = this.lgService.fundingPatternBy(this.subSchemeId, this.schemeId);
        this.maxRows = this.projectCodeResultList.size() > this.fundingPatternBysubScheme.size() ? this.projectCodeResultList.size() : this.fundingPatternBysubScheme.size();
        this.projectCodeResultList.size();
        this.fundingPatternBysubScheme.size();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Passed Params are FundID:" + this.fundId + " schemeId:" + this.schemeId + " subSchemeId" + this.subSchemeId));
        }
        Accountdetailtype pcType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype  where name='PROJECTCODE'");
        String table = pcType.getFullQualifiedName();
        try {
            Class.forName(table);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot load class", (Throwable)e);
        }
        String temp = "";
        String pcQryStr = "from " + table + " where  id=?";
        BigDecimal grandTotal = BigDecimal.ZERO;
        LinkedHashMap<String, BigDecimal> ssTotalMap = new LinkedHashMap<String, BigDecimal>();
        for (Object lp : this.projectCodeResultList) {
            LoanGrantBean lgForPc = (LoanGrantBean)lp;
            grandTotal = grandTotal.add(lgForPc.getAmount());
            if (!temp.equalsIgnoreCase(lgForPc.getSubScheme())) {
                ssTotalMap.put(lgForPc.getSubScheme(), lgForPc.getAmount());
            } else {
                ssTotalMap.put(lgForPc.getSubScheme(), ((BigDecimal)ssTotalMap.get(temp)).add(lgForPc.getAmount()));
            }
            temp = lgForPc.getSubScheme();
            EntityType entity = (EntityType)this.persistenceService.find(pcQryStr, new Object[]{lgForPc.getId()});
            if (entity.getEgwStatus() == null) continue;
            lgForPc.setStatus(entity.getEgwStatus().getDescription());
        }
        temp = "";
        int i = 0;
        ArrayList projectCodeResultList2 = new ArrayList();
        projectCodeResultList2.addAll(this.projectCodeResultList);
        for (Object lpg : projectCodeResultList2) {
            LoanGrantBean lgForPc = (LoanGrantBean)lpg;
            if (!temp.equalsIgnoreCase(lgForPc.getSubScheme())) {
                if (i == 0) {
                    temp = lgForPc.getSubScheme();
                    ++i;
                    continue;
                }
                LoanGrantBean lg = new LoanGrantBean();
                lg.setCode("Total");
                lg.setAmount((BigDecimal)ssTotalMap.get(temp));
                this.projectCodeResultList.add(i, lg);
                ++i;
            }
            ++i;
            temp = lgForPc.getSubScheme();
        }
        LoanGrantBean lg = new LoanGrantBean();
        lg.setCode("Total");
        lg.setAmount((BigDecimal)ssTotalMap.get(temp));
        this.projectCodeResultList.add(lg);
        lg = new LoanGrantBean();
        lg.setCode("GrandTotal");
        lg.setAmount(grandTotal);
        this.projectCodeResultList.add(lg);
        temp = "";
        this.faTotalMap = new LinkedHashMap();
        BigDecimal faGrandTotal = BigDecimal.ZERO;
        for (LoanGrantBean lgForFa : this.fundingPatternBysubScheme) {
            BigDecimal faTotal;
            if (null == this.faTotalMap.get(lgForFa.getName())) {
                if (ssTotalMap.get(lgForFa.getSubScheme()) != null) {
                    faTotal = ((BigDecimal)ssTotalMap.get(lgForFa.getSubScheme())).multiply(lgForFa.getAmount()).divide(BigDecimal.valueOf(100L));
                    faGrandTotal = faGrandTotal.add(faTotal);
                    this.faTotalMap.put(lgForFa.getName(), faTotal);
                }
            } else if (ssTotalMap.get(lgForFa.getSubScheme()) != null) {
                faTotal = ((BigDecimal)ssTotalMap.get(lgForFa.getSubScheme())).multiply(lgForFa.getAmount()).divide(BigDecimal.valueOf(100L));
                faGrandTotal = faGrandTotal.add(faTotal);
                this.faTotalMap.put(lgForFa.getName(), ((BigDecimal)this.faTotalMap.get(lgForFa.getName())).add(faTotal));
            }
            lgForFa.getName();
            temp = lgForFa.getSubScheme();
        }
        this.faTotalMap.put("GrandTotal", faGrandTotal);
        this.fundingAgencyResultList = new ArrayList();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("SSTOTAL" + ssTotalMap));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("FATOTAL" + this.faTotalMap));
        }
        for (String key : this.faTotalMap.keySet()) {
            LoanGrantBean fa = new LoanGrantBean();
            fa.setAgencyName(key);
            fa.setPercentAmount((BigDecimal)this.faTotalMap.get(key));
            this.fundingAgencyResultList.add(fa);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("fundingAgencyResultList" + this.fundingAgencyResultList.size()));
        }
        return "result";
    }

    private List<Integer> removeNulls(List<Integer> projectCodeIdList2) {
        if (this.projectCodeIdList != null) {
            while (this.projectCodeIdList.contains(null)) {
                this.projectCodeIdList.remove(null);
            }
        }
        return this.projectCodeIdList;
    }

    public String exportPdf() {
        try {
            this.search();
            this.inputStream = this.reportHelper.exportPdf(this.inputStream, "/reports/templates/SchemeUtilization.jasper", this.getParamMap(), this.projectCodeResultList);
        }
        catch (JRException e) {
            LOGGER.error((Object)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (ValidationException e) {
            return "new";
        }
        return "PDF";
    }

    public String exportXls() {
        try {
            this.search();
            this.inputStream = this.reportHelper.exportXls(this.inputStream, "/reports/templates/SchemeUtilization.jasper", this.getParamMap(), this.projectCodeResultList);
        }
        catch (JRException e) {
            LOGGER.error((Object)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (ValidationException e) {
            return "new";
        }
        return "XLS";
    }

    public String exportHTML() {
        try {
            this.search();
            this.inputStream = this.reportHelper.exportHtml(this.inputStream, "/reports/templates/SchemeUtilization.jasper", this.getParamMap(), this.projectCodeResultList, "pt");
        }
        catch (ValidationException e) {
            return "new";
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return "HTML";
    }

    private Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (this.schemeId != null) {
            String schemeName = (String)this.persistenceService.find("select name from Scheme where id=?", new Object[]{this.getSchemeId()});
            paramMap.put("reportBy", "Scheme Utilization Report for " + schemeName);
            paramMap.put("schemeName", schemeName);
        }
        if (this.getSubSchemeId() != null) {
            String subSchemeName = (String)this.persistenceService.find("select name from SubScheme where id=?", new Object[]{this.getSubSchemeId()});
            paramMap.put("reportBy", "Scheme Utilization Report for " + subSchemeName);
            paramMap.put("subSchemeName", subSchemeName);
        }
        if (this.fundId != null) {
            String fundName = (String)this.persistenceService.find("select name from Fund where id=?", new Object[]{this.fundId});
            paramMap.put("fundName", fundName);
        }
        paramMap.put("fromDate", this.fromDate);
        paramMap.put("toDate", this.toDate);
        paramMap.put("ulbName", this.getUlbName());
        paramMap.put("fundingAgencyResultList", this.fundingAgencyResultList);
        paramMap.put("SchemeUtilization_fundingAgency", ReportUtil.getTemplateAsStream((String)"SchemeUtilization_fundingAgency.jasper"));
        return paramMap;
    }

    private String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    public void setLgService(LoanGrantService lgService) {
        this.lgService = lgService;
    }

    public List<Integer> getProjectCodeIdList() {
        return this.projectCodeIdList;
    }

    public void setProjectCodeIdList(List<Integer> projectCodeIdList) {
        this.projectCodeIdList = projectCodeIdList;
    }

    public List<Object> getProjectCodeResultList() {
        return this.projectCodeResultList;
    }

    public void setProjectCodeResultList(List<Object> projectCodeResultList) {
        this.projectCodeResultList = projectCodeResultList;
    }

    public List<LoanGrantBean> getFundingPatternBysubScheme() {
        return this.fundingPatternBysubScheme;
    }

    public void setFundingPatternBysubScheme(List<LoanGrantBean> fundingPatternBysubScheme) {
        this.fundingPatternBysubScheme = fundingPatternBysubScheme;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public Map<String, BigDecimal> getFaTotalMap() {
        return this.faTotalMap;
    }

    public void setFaTotalMap(Map<String, BigDecimal> faTotalMap) {
        this.faTotalMap = faTotalMap;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public List<Object> getFundingAgencyResultList() {
        return this.fundingAgencyResultList;
    }

    public void setFundingAgencyResultList(List<Object> fundingAgencyResultList) {
        this.fundingAgencyResultList = fundingAgencyResultList;
    }
}

