/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.egf.model.Statement;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.services.report.IncomeExpenditureScheduleService;
import org.egov.services.report.IncomeExpenditureService;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"report"}, location="incomeExpenditureReport-report.jsp"), @Result(name={"scheduleResults"}, location="incomeExpenditureReport-scheduleResults.jsp"), @Result(name={"allScheduleResults"}, location="incomeExpenditureReport-allScheduleResults.jsp"), @Result(name={"results"}, location="incomeExpenditureReport-results.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=IncomeExpenditureStatement.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=IncomeExpenditureStatement.xls"})})
public class IncomeExpenditureReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 91711010096900620L;
    private static final String INCOME_EXPENSE_PDF = "PDF";
    private static final String INCOME_EXPENSE_XLS = "XLS";
    private static SimpleDateFormat FORMATDDMMYYYY = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    InputStream inputStream;
    ReportHelper reportHelper;
    Statement incomeExpenditureStatement = new Statement();
    IncomeExpenditureService incomeExpenditureService;
    IncomeExpenditureScheduleService incomeExpenditureScheduleService;
    private String majorCode;
    private String minorCode;
    private String scheduleNo;
    private String financialYearId;
    private Date todayDate;
    private String asOnDateRange;
    private String period;
    private Integer fundId;
    private final StringBuffer heading = new StringBuffer();
    private StringBuffer scheduleheading = new StringBuffer();
    private StringBuffer statementheading = new StringBuffer();
    List<CChartOfAccounts> listChartOfAccounts;
    private boolean detailReport = false;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void setIncomeExpenditureService(IncomeExpenditureService incomeExpenditureService) {
        this.incomeExpenditureService = incomeExpenditureService;
    }

    public void setIncomeExpenditureScheduleService(IncomeExpenditureScheduleService incomeExpenditureScheduleService) {
        this.incomeExpenditureScheduleService = incomeExpenditureScheduleService;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Statement getIncomeExpenditureStatement() {
        return this.incomeExpenditureStatement;
    }

    public IncomeExpenditureReportAction() {
        this.addRelatedEntity("department", Department.class);
        this.addRelatedEntity("function", CFunction.class);
        this.addRelatedEntity("functionary", Functionary.class);
        this.addRelatedEntity("financialYear", CFinancialYear.class);
        this.addRelatedEntity("field", Boundary.class);
        this.addRelatedEntity("fund", Fund.class);
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        if (!this.parameters.containsKey("showDropDown")) {
            this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
            this.addDropdownData("functionList", this.masterDataCache.get("egi-function"));
            this.addDropdownData("functionaryList", this.masterDataCache.get("egi-functionary"));
            this.addDropdownData("fundDropDownList", this.masterDataCache.get("egi-fund"));
            this.addDropdownData("fieldList", this.masterDataCache.get("egi-ward"));
            this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true  order by finYearRange desc ", new Object[0]));
        }
    }

    protected void setRelatedEntitesOn() {
        this.setTodayDate(new Date());
        if (this.incomeExpenditureStatement.getFund() != null && this.incomeExpenditureStatement.getFund().getId() != null && this.incomeExpenditureStatement.getFund().getId() != 0) {
            this.incomeExpenditureStatement.setFund((Fund)this.getPersistenceService().find("from Fund where id=?", new Object[]{this.incomeExpenditureStatement.getFund().getId()}));
            this.heading.append(" in " + this.incomeExpenditureStatement.getFund().getName());
        }
        if (this.incomeExpenditureStatement.getDepartment() != null && this.incomeExpenditureStatement.getDepartment().getId() != null && this.incomeExpenditureStatement.getDepartment().getId() != 0L) {
            this.incomeExpenditureStatement.setDepartment((Department)this.getPersistenceService().find("from Department where id=?", new Object[]{this.incomeExpenditureStatement.getDepartment().getId()}));
            this.heading.append(" in " + this.incomeExpenditureStatement.getDepartment().getName() + " Department");
        } else {
            this.incomeExpenditureStatement.setDepartment(null);
        }
        if (this.incomeExpenditureStatement.getFinancialYear() != null && this.incomeExpenditureStatement.getFinancialYear().getId() != null && this.incomeExpenditureStatement.getFinancialYear().getId() != 0L) {
            this.incomeExpenditureStatement.setFinancialYear((CFinancialYear)this.getPersistenceService().find("from CFinancialYear where id=?", new Object[]{this.incomeExpenditureStatement.getFinancialYear().getId()}));
            this.heading.append(" for the Financial Year " + this.incomeExpenditureStatement.getFinancialYear().getFinYearRange());
        }
        if (this.incomeExpenditureStatement.getFunction() != null && this.incomeExpenditureStatement.getFunction().getId() != null && this.incomeExpenditureStatement.getFunction().getId() != 0L) {
            this.incomeExpenditureStatement.setFunction((CFunction)this.getPersistenceService().find("from CFunction where id=?", new Object[]{this.incomeExpenditureStatement.getFunction().getId()}));
            this.heading.append(" in Function Code " + this.incomeExpenditureStatement.getFunction().getName());
        }
        if (this.incomeExpenditureStatement.getField() != null && this.incomeExpenditureStatement.getField().getId() != null && this.incomeExpenditureStatement.getField().getId() != 0L) {
            this.incomeExpenditureStatement.setField((Boundary)this.getPersistenceService().find("from Boundary where id=?", new Object[]{this.incomeExpenditureStatement.getField().getId()}));
            this.heading.append(" in the field value" + this.incomeExpenditureStatement.getField().getName());
        }
        if (this.incomeExpenditureStatement.getFunctionary() != null && this.incomeExpenditureStatement.getFunctionary().getId() != null && this.incomeExpenditureStatement.getFunctionary().getId() != 0) {
            this.incomeExpenditureStatement.setFunctionary((Functionary)this.getPersistenceService().find("from Functionary where id=?", new Object[]{this.incomeExpenditureStatement.getFunctionary().getId()}));
            this.heading.append(" and " + this.incomeExpenditureStatement.getFunctionary().getName() + " Functionary");
        }
    }

    public void setIncomeExpenditureStatement(Statement incomeExpenditureStatement) {
        this.incomeExpenditureStatement = incomeExpenditureStatement;
    }

    public Object getModel() {
        return this.incomeExpenditureStatement;
    }

    @Action(value="/report/incomeExpenditureReport-generateIncomeExpenditureReport")
    public String generateIncomeExpenditureReport() {
        return "report";
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateIncomeExpenditureSubReport")
    public String generateIncomeExpenditureSubReport() {
        this.setDetailReport(false);
        this.populateDataSourceForSchedule();
        return "scheduleResults";
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateScheduleReport")
    public String generateScheduleReport() {
        this.populateDataSourceForAllSchedules();
        return "allScheduleResults";
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateDetailCodeReport")
    public String generateDetailCodeReport() {
        this.setDetailReport(true);
        this.populateSchedulewiseDetailCodeReport();
        return "scheduleResults";
    }

    private void populateSchedulewiseDetailCodeReport() {
        this.setRelatedEntitesOn();
        this.scheduleheading.append("Income And Expenditure Schedule Statement").append(this.heading);
        if (this.incomeExpenditureStatement.getFund() != null && this.incomeExpenditureStatement.getFund().getId() != null && this.incomeExpenditureStatement.getFund().getId() != 0) {
            ArrayList<Fund> fundlist = new ArrayList<Fund>();
            fundlist.add(this.incomeExpenditureStatement.getFund());
            this.incomeExpenditureStatement.setFunds(fundlist);
            this.incomeExpenditureScheduleService.populateDetailcode(this.incomeExpenditureStatement);
        } else {
            this.incomeExpenditureStatement.setFunds(this.incomeExpenditureService.getFunds());
            this.incomeExpenditureScheduleService.populateDetailcode(this.incomeExpenditureStatement);
        }
    }

    private void populateDataSourceForSchedule() {
        this.setDetailReport(false);
        this.setRelatedEntitesOn();
        this.scheduleheading.append("Income And Expenditure Schedule Statement").append(this.heading);
        if (this.incomeExpenditureStatement.getFund() != null && this.incomeExpenditureStatement.getFund().getId() != null && this.incomeExpenditureStatement.getFund().getId() != 0) {
            ArrayList<Fund> fundlist = new ArrayList<Fund>();
            fundlist.add(this.incomeExpenditureStatement.getFund());
            this.incomeExpenditureStatement.setFunds(fundlist);
            this.incomeExpenditureScheduleService.populateDataForLedgerSchedule(this.incomeExpenditureStatement, ((String[])this.parameters.get("majorCode"))[0]);
        } else {
            this.incomeExpenditureStatement.setFunds(this.incomeExpenditureService.getFunds());
            this.incomeExpenditureScheduleService.populateDataForLedgerSchedule(this.incomeExpenditureStatement, ((String[])this.parameters.get("majorCode"))[0]);
        }
    }

    private void populateDataSourceForAllSchedules() {
        this.setRelatedEntitesOn();
        if (this.incomeExpenditureStatement.getFund() != null && this.incomeExpenditureStatement.getFund().getId() != null && this.incomeExpenditureStatement.getFund().getId() != 0) {
            ArrayList<Fund> fundlist = new ArrayList<Fund>();
            fundlist.add(this.incomeExpenditureStatement.getFund());
            this.incomeExpenditureStatement.setFunds(fundlist);
            this.incomeExpenditureScheduleService.populateDataForAllSchedules(this.incomeExpenditureStatement);
        } else {
            this.incomeExpenditureStatement.setFunds(this.incomeExpenditureService.getFunds());
            this.incomeExpenditureScheduleService.populateDataForAllSchedules(this.incomeExpenditureStatement);
        }
    }

    public String printIncomeExpenditureReport() {
        this.populateDataSource();
        return "report";
    }

    @Action(value="/report/incomeExpenditureReport-ajaxPrintIncomeExpenditureReport")
    public String ajaxPrintIncomeExpenditureReport() {
        this.populateDataSource();
        return "results";
    }

    protected void populateDataSource() {
        this.setRelatedEntitesOn();
        this.statementheading.append("Income And Expenditure Statement").append(this.heading);
        if (this.incomeExpenditureStatement.getFund() != null && this.incomeExpenditureStatement.getFund().getId() != null && this.incomeExpenditureStatement.getFund().getId() != 0) {
            ArrayList<Fund> fundlist = new ArrayList<Fund>();
            fundlist.add(this.incomeExpenditureStatement.getFund());
            this.incomeExpenditureStatement.setFunds(fundlist);
            this.incomeExpenditureService.populateIEStatement(this.incomeExpenditureStatement);
        } else {
            this.incomeExpenditureStatement.setFunds(this.incomeExpenditureService.getFunds());
            this.incomeExpenditureService.populateIEStatement(this.incomeExpenditureStatement);
        }
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateIncomeExpenditurePdf")
    public String generateIncomeExpenditurePdf() throws Exception {
        this.populateDataSource();
        String heading = ReportUtil.getCityName() + "\\n" + this.statementheading.toString();
        String subtitle = "Report Run Date-" + FORMATDDMMYYYY.format(this.getTodayDate());
        JasperPrint jasper = this.reportHelper.generateIncomeExpenditureReportJasperPrint(this.incomeExpenditureStatement, heading, this.getPreviousYearToDate(), this.getCurrentYearToDate(), subtitle, true);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return INCOME_EXPENSE_PDF;
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateDetailCodePdf")
    public String generateDetailCodePdf() throws Exception {
        this.populateSchedulewiseDetailCodeReport();
        String heading = ReportUtil.getCityName() + "\\n" + this.statementheading.toString();
        String subtitle = "Report Run Date-" + FORMATDDMMYYYY.format(this.getTodayDate());
        JasperPrint jasper = this.reportHelper.generateIncomeExpenditureReportJasperPrint(this.incomeExpenditureStatement, heading, this.getPreviousYearToDate(), this.getCurrentYearToDate(), subtitle, true);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return INCOME_EXPENSE_PDF;
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateDetailCodeXls")
    public String generateDetailCodeXls() throws Exception {
        this.populateSchedulewiseDetailCodeReport();
        String heading = ReportUtil.getCityName() + "\\n" + this.statementheading.toString();
        String subtitle = "Report Run Date-" + FORMATDDMMYYYY.format(this.getTodayDate()) + "                                               ";
        JasperPrint jasper = this.reportHelper.generateIncomeExpenditureReportJasperPrint(this.incomeExpenditureStatement, heading, this.getPreviousYearToDate(), this.getCurrentYearToDate(), subtitle, true);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return INCOME_EXPENSE_XLS;
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateIncomeExpenditureXls")
    public String generateIncomeExpenditureXls() throws Exception {
        this.populateDataSource();
        String heading = ReportUtil.getCityName() + "\\n" + this.statementheading.toString();
        String subtitle = "Report Run Date-" + FORMATDDMMYYYY.format(this.getTodayDate()) + "                                               ";
        JasperPrint jasper = this.reportHelper.generateIncomeExpenditureReportJasperPrint(this.incomeExpenditureStatement, heading, this.getPreviousYearToDate(), this.getCurrentYearToDate(), subtitle, true);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return INCOME_EXPENSE_XLS;
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateSchedulePdf")
    public String generateSchedulePdf() throws Exception {
        this.populateDataSourceForAllSchedules();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.incomeExpenditureStatement, this.getText("report.ie.heading"), this.heading.toString(), this.getPreviousYearToDate(), this.getCurrentYearToDate(), false);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return INCOME_EXPENSE_PDF;
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateScheduleXls")
    public String generateScheduleXls() throws Exception {
        this.populateDataSourceForAllSchedules();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.incomeExpenditureStatement, this.getText("report.ie.heading"), this.heading.toString(), this.getPreviousYearToDate(), this.getCurrentYearToDate(), false);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return INCOME_EXPENSE_XLS;
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateIncomeExpenditureSchedulePdf")
    public String generateIncomeExpenditureSchedulePdf() throws Exception {
        this.populateDataSourceForSchedule();
        String heading = ReportUtil.getCityName() + "\\n" + this.scheduleheading.toString();
        String subtitle = "Report Run Date-" + FORMATDDMMYYYY.format(this.getTodayDate()) + "                                             ";
        JasperPrint jasper = this.reportHelper.generateIncomeExpenditureReportJasperPrint(this.incomeExpenditureStatement, heading, this.getPreviousYearToDate(), this.getCurrentYearToDate(), subtitle, false);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return INCOME_EXPENSE_PDF;
    }

    @ReadOnly
    @Action(value="/report/incomeExpenditureReport-generateIncomeExpenditureScheduleXls")
    public String generateIncomeExpenditureScheduleXls() throws Exception {
        this.populateDataSourceForSchedule();
        String heading = ReportUtil.getCityName() + "\\n" + this.scheduleheading.toString();
        String subtitle = "Report Run Date-" + FORMATDDMMYYYY.format(this.getTodayDate()) + "\t\t\t\t\t  \t\t\t\t\t\t ";
        JasperPrint jasper = this.reportHelper.generateIncomeExpenditureReportJasperPrint(this.incomeExpenditureStatement, heading, this.getPreviousYearToDate(), this.getCurrentYearToDate(), subtitle, false);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return INCOME_EXPENSE_XLS;
    }

    public String getCurrentYearToDate() {
        return this.incomeExpenditureService.getFormattedDate(this.incomeExpenditureService.getToDate(this.incomeExpenditureStatement));
    }

    public String getPreviousYearToDate() {
        return this.incomeExpenditureService.getFormattedDate(this.incomeExpenditureService.getPreviousYearFor(this.incomeExpenditureService.getToDate(this.incomeExpenditureStatement)));
    }

    public String getCurrentYearFromDate() {
        return this.incomeExpenditureService.getFormattedDate(this.incomeExpenditureService.getFromDate(this.incomeExpenditureStatement));
    }

    public String getPreviousYearFromDate() {
        return this.incomeExpenditureService.getFormattedDate(this.incomeExpenditureService.getPreviousYearFor(this.incomeExpenditureService.getFromDate(this.incomeExpenditureStatement)));
    }

    public Date getTodayDate() {
        return this.todayDate;
    }

    public void setTodayDate(Date todayDate) {
        this.todayDate = todayDate;
    }

    public String getMajorCode() {
        return this.majorCode;
    }

    public void setMajorCode(String majorCode) {
        this.majorCode = majorCode;
    }

    public String getMinorCode() {
        return this.minorCode;
    }

    public void setMinorCode(String minorCode) {
        this.minorCode = minorCode;
    }

    public String getScheduleNo() {
        return this.scheduleNo;
    }

    public void setScheduleNo(String scheduleNo) {
        this.scheduleNo = scheduleNo;
    }

    public List<CChartOfAccounts> getListChartOfAccounts() {
        return this.listChartOfAccounts;
    }

    public void setListChartOfAccounts(List<CChartOfAccounts> listChartOfAccounts) {
        this.listChartOfAccounts = listChartOfAccounts;
    }

    public String getFinancialYearId() {
        return this.financialYearId;
    }

    public void setFinancialYearId(String financialYearId) {
        this.financialYearId = financialYearId;
    }

    public Integer getFundId() {
        return this.fundId;
    }

    public void setFundId(Integer fundId) {
        this.fundId = fundId;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String getAsOnDateRange() {
        return this.asOnDateRange;
    }

    public void setAsOnDateRange(String asOnDateRange) {
        this.asOnDateRange = asOnDateRange;
    }

    public StringBuffer getScheduleheading() {
        return this.scheduleheading;
    }

    public void setScheduleheading(StringBuffer scheduleheading) {
        this.scheduleheading = scheduleheading;
    }

    public StringBuffer getStatementheading() {
        return this.statementheading;
    }

    public void setStatementheading(StringBuffer statementheading) {
        this.statementheading = statementheading;
    }

    public boolean isDetailReport() {
        return this.detailReport;
    }

    public void setDetailReport(boolean detailReport) {
        this.detailReport = detailReport;
    }
}

