/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.utils.EntityType;
import org.egov.egf.model.BankAdviceReportInfo;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.utils.Constants;
import org.hibernate.FlushMode;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="bankAdviceReport-new.jsp"), @Result(name={"downloadText"}, location="bankAdviceReport-downloadText.jsp"), @Result(name={"reportview"}, type="stream", location="inputStream", params={"contentType", "${contentType}", "contentDisposition", "attachment; filename=${fileName}"}), @Result(name={"txtresult"}, type="stream", location="inStream", params={"contentType", "${contentType}", "contentDisposition", "attachment; filename=${textFileName}"})})
public class BankAdviceReportAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BankAdviceReportAction.class);
    private Bank bank;
    private Bankbranch bankbranch;
    private String bankName;
    private String branchName;
    private String accountNumber;
    private String instrumentNumber;
    private String instrumentDate;
    private Bankaccount bankaccount;
    private InstrumentHeader instrumentnumber;
    private InputStream inputStream;
    private InputStream inStream;
    private Map<Integer, String> monthMap = new LinkedHashMap();
    public List<InstrumentHeader> instrumentHeaderList = new ArrayList();
    private Map<Integer, String> fullNameMonthMap = new TreeMap();
    private FinancialYearHibernateDAO financialYearDAO;
    private Integer month;
    private Long financialYearId;
    private String mode;
    private String heading;
    private String contentType;
    private String fileName;
    private String textFileName;
    private ReportService reportService;
    private BigDecimal totalAmount = BigDecimal.ZERO;
    String countQuery = null;
    public List<BankAdviceReportInfo> bankAdviseResultList = new ArrayList();

    public InputStream getInStream() {
        return this.inStream;
    }

    public void setInStream(InputStream inStream) {
        this.inStream = inStream;
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        this.addDropdownData("bankList", this.persistenceService.findAllBy("select distinct b from Bank b , Bankbranch bb , Bankaccount ba WHERE bb.bank=b and ba.bankbranch=bb and ba.type in ('RECEIPTS_PAYMENTS','PAYMENTS') and b.isactive=true order by b.name", new Object[0]));
        if (this.bankbranch == null) {
            this.addDropdownData("bankBranchList", Collections.EMPTY_LIST);
        } else {
            this.addDropdownData("bankBranchList", this.persistenceService.findAllBy("select distinct bb from Bankbranch bb,Bankaccount ba where bb.bank.id=? and ba.bankbranch=bb and ba.type in ('RECEIPTS_PAYMENTS','PAYMENTS') and bb.isactive=true", new Object[]{this.bank.getId()}));
        }
        if (this.bankaccount == null) {
            this.addDropdownData("bankAccountList", Collections.EMPTY_LIST);
        } else {
            this.addDropdownData("bankAccountList", this.persistenceService.findAllBy("from Bankaccount where bankbranch.id=? and isactive=true", new Object[]{this.bankbranch.getId()}));
        }
        if (this.instrumentnumber == null) {
            this.addDropdownData("chequeNumberList", Collections.EMPTY_LIST);
        } else {
            List resultList = new ArrayList();
            ArrayList<InstrumentHeader> instrumentHeaderList = new ArrayList<InstrumentHeader>();
            resultList = this.getPersistenceService().findAllBy("SELECT ih.id, ih.instrumentNumber FROM InstrumentHeader ih, InstrumentVoucher iv, Paymentheader ph WHERE ih.isPayCheque ='1' AND ih.bankAccountId.id = ? AND ih.statusId.description in ('New') AND ih.statusId.moduletype='Instrument' AND iv.instrumentHeaderId = ih.id and ih.bankAccountId is not null AND iv.voucherHeaderId     = ph.voucherheader AND ph.bankaccount = ih.bankAccountId AND ph.type = 'rtgs' GROUP BY ih.instrumentNumber,ih.id", new Object[]{this.bankaccount.getId()});
            for (Object[] obj : resultList) {
                InstrumentHeader ih = new InstrumentHeader();
                ih = (InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{(Long)obj[0]});
                instrumentHeaderList.add(ih);
            }
            this.addDropdownData("chequeNumberList", instrumentHeaderList);
        }
        this.fullNameMonthMap = DateUtils.getAllMonthsWithFullNames();
        List financialYears = this.financialYearDAO.getAllActiveFinancialYearList();
        this.addDropdownData("financialYearsList", financialYears);
    }

    @Action(value="/report/bankAdviceReport-newForm")
    public String newForm() {
        return "new";
    }

    @Action(value="/report/bankAdviceReport-tnebnewForm")
    public String tnebnewForm() {
        return "downloadText";
    }

    public List getSubLedgerDetailQueryAndParams(InstrumentHeader instrumentHeader) {
        HashMap detailTypeMap = new HashMap();
        HashMap<Object, BigDecimal> detailKeyMap = new HashMap<Object, BigDecimal>();
        Map<Object, BigDecimal> tempMap = new HashMap();
        BigDecimal detailKeyAmt = BigDecimal.ZERO;
        String query = " SELECT gld.detailtypeid, gld.detailkeyid, sum(gld.amount)  FROM egf_instrumentvoucher ivh, generalledger gl, generalledgerdetail gld  WHERE ivh.instrumentheaderid = ? AND ivh.voucherheaderid = gl.voucherheaderid  AND gl.debitamount != 0 AND gl.id = gld.generalledgerid  group by gld.detailkeyid, gld.detailtypeid ";
        String withNoSubledgerQry = " SELECT gld.DETAILTYPEID,gld.DETAILKEYID , sum(gld.amount) FROM   ( (SELECT voucherheaderid   FROM egf_instrumentvoucher   WHERE instrumentheaderid =?   ) except   (SELECT DISTINCT payvhid  FROM miscbilldetail mb, voucherheader vh ,    generalledger gl  LEFT JOIN chartofaccountdetail dtl  ON gl.glcodeid    =dtl.glcodeid   WHERE mb.payvhid  =vh.id  AND vh.id =gl.voucherheaderid  AND dtl.glcodeid IS NOT NULL  AND vh.id  IN (SELECT voucherheaderid FROM egf_instrumentvoucher  WHERE instrumentheaderid =? ))) p ,  miscbilldetail m, generalledger gl, generalledgerdetail gld WHERE p.voucherheaderid=m.payvhid  AND gl.voucherheaderid =m.billvhid AND gl.id=gld.generalledgerid AND gl.debitamount!=0  group by gld.detailtypeid ,gld.detailkeyid  ";
        SQLQuery WithNetPayableSubledgerQuery = this.persistenceService.getSession().createSQLQuery(" SELECT gld.detailtypeid, gld.detailkeyid, sum(gld.amount)  FROM egf_instrumentvoucher ivh, generalledger gl, generalledgerdetail gld  WHERE ivh.instrumentheaderid = ? AND ivh.voucherheaderid = gl.voucherheaderid  AND gl.debitamount != 0 AND gl.id = gld.generalledgerid  group by gld.detailkeyid, gld.detailtypeid ");
        WithNetPayableSubledgerQuery.setParameter(0, (Object)instrumentHeader.getId());
        SQLQuery getDebitsideSubledgerQuery = this.persistenceService.getSession().createSQLQuery(" SELECT gld.DETAILTYPEID,gld.DETAILKEYID , sum(gld.amount) FROM   ( (SELECT voucherheaderid   FROM egf_instrumentvoucher   WHERE instrumentheaderid =?   ) except   (SELECT DISTINCT payvhid  FROM miscbilldetail mb, voucherheader vh ,    generalledger gl  LEFT JOIN chartofaccountdetail dtl  ON gl.glcodeid    =dtl.glcodeid   WHERE mb.payvhid  =vh.id  AND vh.id =gl.voucherheaderid  AND dtl.glcodeid IS NOT NULL  AND vh.id  IN (SELECT voucherheaderid FROM egf_instrumentvoucher  WHERE instrumentheaderid =? ))) p ,  miscbilldetail m, generalledger gl, generalledgerdetail gld WHERE p.voucherheaderid=m.payvhid  AND gl.voucherheaderid =m.billvhid AND gl.id=gld.generalledgerid AND gl.debitamount!=0  group by gld.detailtypeid ,gld.detailkeyid  ");
        getDebitsideSubledgerQuery.setParameter(0, (Object)instrumentHeader.getId());
        getDebitsideSubledgerQuery.setParameter(1, (Object)instrumentHeader.getId());
        List retList = WithNetPayableSubledgerQuery.list();
        retList.addAll(getDebitsideSubledgerQuery.list());
        for (Object[] obj : retList) {
            if (detailTypeMap.isEmpty()) {
                detailKeyMap = new HashMap();
                detailKeyMap.put(obj[1], ((BigDecimal)obj[2]).setScale(2, 6));
                detailTypeMap.put(obj[0], detailKeyMap);
                continue;
            }
            tempMap = new HashMap();
            detailKeyAmt = BigDecimal.ZERO;
            if (null != detailTypeMap.get(obj[0])) {
                tempMap = (Map)detailTypeMap.get(obj[0]);
                if (null != tempMap && tempMap.containsKey(obj[1])) {
                    detailKeyAmt = ((BigDecimal)tempMap.get(obj[1])).add(((BigDecimal)obj[2]).setScale(2, 6));
                    tempMap.put(obj[1], detailKeyAmt);
                    continue;
                }
                tempMap.put(obj[1], ((BigDecimal)obj[2]).setScale(2, 6));
                continue;
            }
            detailKeyMap = new HashMap();
            detailKeyMap.put(obj[1], ((BigDecimal)obj[2]).setScale(2, 6));
            detailTypeMap.put(obj[0], detailKeyMap);
        }
        return retList;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/report/bankAdviceReport-search")
    public String search() {
        if (this.instrumentnumber.getId() == -1L) {
            this.addFieldError("searchCriteria", "Please select all search criteria");
            return "new";
        }
        this.bankAdviseResultList = this.getBankAdviceReportList();
        return "new";
    }

    @SkipValidation
    public String TNEBsearch() {
        String query = "select distinct ih from EBDetails d, EgBillregister br, Miscbilldetail mbd, InstrumentVoucher iv inner join iv.instrumentHeaderId ih where d.receiptNo is null and d.egBillregister = br and br.billnumber = mbd.billnumber and mbd.payVoucherHeader = iv.voucherHeaderId and ih.statusId.code in ('New', 'Reconciled') and month(ih.transactionDate) = ? and year(ih.transactionDate) between  ? and ?";
        CFinancialYear financialYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id = ?", new Object[]{this.financialYearId});
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(financialYear.getStartingDate());
        Integer startingYear = calendar.get(1);
        calendar.setTime(financialYear.getEndingDate());
        Integer endingYear = calendar.get(1);
        this.instrumentHeaderList = this.persistenceService.findAllBy("select distinct ih from EBDetails d, EgBillregister br, Miscbilldetail mbd, InstrumentVoucher iv inner join iv.instrumentHeaderId ih where d.receiptNo is null and d.egBillregister = br and br.billnumber = mbd.billnumber and mbd.payVoucherHeader = iv.voucherHeaderId and ih.statusId.code in ('New', 'Reconciled') and month(ih.transactionDate) = ? and year(ih.transactionDate) between  ? and ?", new Object[]{this.month, startingYear, endingYear});
        this.mode = "search";
        this.monthMap = DateUtils.getAllMonths();
        this.heading = "List of RTGS Bank advice generated for ";
        this.heading = this.heading + (String)this.monthMap.get(this.month) + "-" + financialYear.getFinYearRange();
        return "downloadText";
    }

    @ReadOnly
    private List populateSubLedgerDetails(List subList) {
        List retList = subList;
        ArrayList<BankAdviceReportInfo> subLedgerList = new ArrayList<BankAdviceReportInfo>();
        for (Object[] obj : retList) {
            Accountdetailtype adt = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=?", new Object[]{((BigInteger)obj[0]).intValue()});
            EntityType subDetail = null;
            try {
                Class<?> aClass = Class.forName(adt.getFullQualifiedName());
                Method method = aClass.getMethod("getId", new Class[0]);
                String dataType = method.getReturnType().getSimpleName();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("data Type = " + dataType));
                }
                subDetail = dataType.equals("Long") ? (EntityType)this.persistenceService.find("from " + adt.getFullQualifiedName() + " where id=?", new Object[]{((BigInteger)obj[1]).longValue()}) : (EntityType)this.persistenceService.find("from " + adt.getFullQualifiedName() + " where id=?", new Object[]{((BigInteger)obj[1]).intValue()});
            }
            catch (ClassCastException e) {
                LOGGER.error((Object)e);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception to get EntityType=" + e.getMessage()));
            }
            BankAdviceReportInfo bankAdviceReportInfo = new BankAdviceReportInfo();
            bankAdviceReportInfo.setPartyName(subDetail.getName().toUpperCase());
            bankAdviceReportInfo.setAccountNumber(subDetail.getBankaccount());
            bankAdviceReportInfo.setBank(subDetail.getBankname());
            bankAdviceReportInfo.setIfscCode(subDetail.getIfsccode());
            bankAdviceReportInfo.setAmount(((BigDecimal)obj[2]).setScale(2, 6));
            this.totalAmount = this.totalAmount.add(bankAdviceReportInfo.getAmount());
            subLedgerList.add(bankAdviceReportInfo);
        }
        return subLedgerList;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/report/bankAdviceReport-exportExcel")
    public String exportExcel() {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("bankName", this.getBankName(this.bank.getId()));
        reportParams.put("branchName", this.getBankBranchName(this.bankbranch.getId()));
        reportParams.put("accountNumber", this.getBankAccountNumber(this.bankaccount.getId()));
        List subLedgerList = this.getBankAdviceReportList();
        ReportRequest reportInput = new ReportRequest("bankAdviceExcelReport", (Collection)subLedgerList, reportParams);
        reportInput.setReportFormat(ReportFormat.XLS);
        this.contentType = ReportViewerUtil.getContentType((ReportFormat)ReportFormat.XLS);
        this.fileName = "BankAdviceReport." + ReportFormat.XLS.toString().toLowerCase();
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return "reportview";
    }

    @ValidationErrorPage(value="new")
    @Action(value="/report/bankAdviceReport-exportHtml")
    public String exportHtml() {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        StringBuffer letterContext = new StringBuffer();
        letterContext.append("             I request you to transfer the amount indicated below through RTGS duly debiting from the").append("  Current Account No: ").append(this.getBankAccountNumber(this.bankaccount.getId()) != null ? this.getBankAccountNumber(this.bankaccount.getId()) : "").append("  under your bank to the following bank accounts:");
        reportParams.put("bankName", this.getBankName(this.bank.getId()));
        reportParams.put("letterContext", letterContext.toString());
        reportParams.put("branchName", this.getBankBranchName(this.bankbranch.getId()));
        reportParams.put("accountNumber", this.getBankAccountNumber(this.bankaccount.getId()));
        reportParams.put("chequeNumber", "RTGS Ref. No: " + this.getInstrumentNumber(this.instrumentnumber.getId()));
        reportParams.put("chequeDate", this.getInstrumentDate(this.instrumentnumber.getId()));
        List subLedgerList = this.getBankAdviceReportList();
        ReportRequest reportInput = new ReportRequest("bankAdviceReport", (Collection)subLedgerList, reportParams);
        reportInput.setReportFormat(ReportFormat.HTM);
        this.contentType = ReportViewerUtil.getContentType((ReportFormat)ReportFormat.HTM);
        this.fileName = "BankAdviceReport." + ReportFormat.HTM.toString().toLowerCase();
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return "reportview";
    }

    private String getBankName(Integer bankId) {
        Bank bank = (Bank)this.persistenceService.find("from Bank where id=?", new Object[]{bankId});
        return bank.getName();
    }

    private String getBankBranchName(Integer bankBranchId) {
        Bankbranch bankBranch = (Bankbranch)this.persistenceService.find("from Bankbranch where id=?", new Object[]{bankBranchId});
        return bankBranch.getBranchname();
    }

    private String getBankAccountNumber(Long bankAccountId) {
        Bankaccount bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{bankAccountId});
        return bankAccount.getAccountnumber();
    }

    private String getInstrumentNumber(Long instrumentHeaderId) {
        InstrumentHeader instrumentHeader = (InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{instrumentHeaderId});
        return instrumentHeader.getTransactionNumber();
    }

    private String getInstrumentDate(Long instrumentHeaderId) {
        InstrumentHeader instrumentHeader = (InstrumentHeader)this.persistenceService.find("from InstrumentHeader where id=?", new Object[]{instrumentHeaderId});
        return Constants.DDMMYYYYFORMAT2.format(instrumentHeader.getTransactionDate());
    }

    @ValidationErrorPage(value="new")
    @Action(value="/report/bankAdviceReport-exportPDF")
    public String exportPDF() {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        StringBuffer letterContext = new StringBuffer();
        letterContext.append("             I request you to transfer the amount indicated below through RTGS duly debiting from the").append("  Current Account No: ").append(this.getBankAccountNumber(this.bankaccount.getId()) != null ? this.getBankAccountNumber(this.bankaccount.getId()) : " ").append("  under your bank to the following bank accounts:");
        reportParams.put("bankName", this.getBankName(this.bank.getId()));
        reportParams.put("branchName", this.getBankBranchName(this.bankbranch.getId()));
        reportParams.put("letterContext", letterContext.toString());
        reportParams.put("accountNumber", this.getBankAccountNumber(this.bankaccount.getId()));
        reportParams.put("chequeNumber", "RTGS Ref. No: " + this.getInstrumentNumber(this.instrumentnumber.getId()));
        reportParams.put("chequeDate", this.getInstrumentDate(this.instrumentnumber.getId()));
        List subLedgerList = this.getBankAdviceReportList();
        reportParams.put("totalAmount", this.totalAmount);
        ReportRequest reportInput = new ReportRequest("bankAdviceReport", (Collection)subLedgerList, reportParams);
        reportInput.setReportFormat(ReportFormat.PDF);
        this.contentType = ReportViewerUtil.getContentType((ReportFormat)ReportFormat.PDF);
        this.fileName = "BankAdviceReport." + ReportFormat.PDF.toString().toLowerCase();
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return "reportview";
    }

    private List getBankAdviceReportList() {
        List retList = this.getSubLedgerDetailQueryAndParams(this.instrumentnumber);
        if (retList != null && !retList.isEmpty()) {
            return this.populateSubLedgerDetails(retList);
        }
        return Collections.EMPTY_LIST;
    }

    public Object getModel() {
        return null;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Bankbranch getBankbranch() {
        return this.bankbranch;
    }

    public void setBankbranch(Bankbranch bankbranch) {
        this.bankbranch = bankbranch;
    }

    public Bankaccount getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(Bankaccount bankaccount) {
        this.bankaccount = bankaccount;
    }

    public InstrumentHeader getInstrumentnumber() {
        return this.instrumentnumber;
    }

    public void setInstrumentnumber(InstrumentHeader instrumentnumber) {
        this.instrumentnumber = instrumentnumber;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getInstrumentNumber() {
        return this.instrumentNumber;
    }

    public void setInstrumentNumber(String instrumentNumber) {
        this.instrumentNumber = instrumentNumber;
    }

    public String getInstrumentDate() {
        return this.instrumentDate;
    }

    public void setInstrumentDate(String instrumentDate) {
        this.instrumentDate = instrumentDate;
    }

    public void setBankAdviseResultList(List<BankAdviceReportInfo> bankAdviseResultList) {
        this.bankAdviseResultList = bankAdviseResultList;
    }

    public List<BankAdviceReportInfo> getBankAdviseResultList() {
        return this.bankAdviseResultList;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getTextFileName() {
        return this.textFileName;
    }

    public void setTextFileName(String textFileName) {
        this.textFileName = textFileName;
    }

    public Map<Integer, String> getMonthMap() {
        return this.monthMap;
    }

    public void setMonthMap(Map<Integer, String> monthMap) {
        this.monthMap = monthMap;
    }

    public Map<Integer, String> getFullNameMonthMap() {
        return this.fullNameMonthMap;
    }

    public void setFullNameMonthMap(Map<Integer, String> fullNameMonthMap) {
        this.fullNameMonthMap = fullNameMonthMap;
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Long getFinancialYearId() {
        return this.financialYearId;
    }

    public void setFinancialYearId(Long financialYearId) {
        this.financialYearId = financialYearId;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }
}

