/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.model.AutoRemittanceBeanReport;
import org.egov.egf.web.actions.report.AutoRemittanceCOCLevelBeanReport;
import org.egov.eis.entity.DrawingOfficer;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.recoveries.Recovery;
import org.egov.services.deduction.RemitRecoveryService;
import org.egov.utils.Constants;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=AutoRemittanceReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=AutoRemittanceReport.xls"}), @Result(name={"summary-PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=AutoRemittanceCOCLevel.pdf"}), @Result(name={"summary-XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=AutoRemittanceReportCOCLevel.xls"})})
@ParentPackage(value="egov")
public class AutoRemittanceReportAction
extends BaseFormAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final long serialVersionUID = -6786924278481362059L;
    String deptLevelJasperpath = "AutoRemittanceReport";
    String cocLevelJasperpath = "AutoRemittanceCOCLevelReport";
    private InputStream inputStream;
    private ReportService reportService;
    private Date paymentVoucherFromDate;
    private Date paymentVoucherToDate;
    private Date rtgsAssignedFromDate;
    private Date rtgsAssignedToDate;
    private Recovery recovery = new Recovery();
    private Fund fund = new Fund();
    private Department department = new Department();
    private final List<EntityType> entitiesList = new ArrayList();
    private RemitRecoveryService remitRecoveryService;
    private Bank bank;
    private Bankbranch bankbranch;
    private Bankaccount bankaccount;
    private String instrumentNumber;
    private String level;
    private DrawingOfficer drawingOfficer;
    private String supplierCode;
    private String contractorCode;
    private String accountNumber;
    private BigDecimal remittedAmountTotal = new BigDecimal("0");
    private List<AutoRemittanceBeanReport> autoRemittance = new ArrayList();
    private final Map<String, Object> map = new HashMap();
    Map<AutoRemittanceBeanReport, List<AutoRemittanceBeanReport>> autoremittanceMap = new HashMap();
    private List<AutoRemittanceCOCLevelBeanReport> coaAbstract = new ArrayList(0);
    private List<AutoRemittanceCOCLevelBeanReport> remittanceList = new ArrayList(0);
    private static Logger LOGGER = Logger.getLogger(AutoRemittanceReportAction.class);

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
    }

    public void setRemitRecoveryService(RemitRecoveryService remitRecoveryService) {
        this.remitRecoveryService = remitRecoveryService;
    }

    public String execute() throws Exception {
        return "reportForm";
    }

    @Action(value="/report/autoRemittanceReport-newform")
    public String newform() throws Exception {
        return "reportForm";
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by deptName", new Object[0]));
        this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.addDropdownData("recoveryList", this.persistenceService.findAllBy(" from Recovery where isactive=true order by chartofaccounts.glcode", new Object[0]));
        this.addDropdownData("bankList", Collections.EMPTY_LIST);
        this.addDropdownData("bankBranchList", Collections.EMPTY_LIST);
        this.addDropdownData("bankAccountList", Collections.EMPTY_LIST);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.addDropdownData("drawingList", Collections.EMPTY_LIST);
    }

    @Action(value="/report/autoRemittanceReport-ajaxLoadData")
    public String ajaxLoadData() {
        this.populateData();
        boolean addList = false;
        ArrayList<AutoRemittanceBeanReport> autoremitEntry = new ArrayList<AutoRemittanceBeanReport>();
        new AutoRemittanceBeanReport();
        if (this.level.equals("atcoc")) {
            this.populateCOCLevelSummaryData();
            for (AutoRemittanceBeanReport autoRemit : this.autoRemittance) {
                AutoRemittanceBeanReport autoremitKey = new AutoRemittanceBeanReport();
                if (this.autoremittanceMap.isEmpty()) {
                    autoremitEntry = new ArrayList();
                    autoremitKey.setRemittanceCOA(autoRemit.getRemittanceCOA());
                    autoremitKey.setDepartment(autoRemit.getDepartment());
                    autoremitKey.setDrawingOfficer(autoRemit.getDrawingOfficer());
                    autoremitKey.setBankbranchAccount(autoRemit.getBankbranchAccount());
                    autoremitEntry.add(autoRemit);
                    autoremitKey.setRemittedAmountSubtotal(autoRemit.getRemittedAmount());
                    this.autoremittanceMap.put(autoremitKey, autoremitEntry);
                } else {
                    Set autoRemitKeySet = this.autoremittanceMap.keySet();
                    for (AutoRemittanceBeanReport autormt : autoRemitKeySet) {
                        addList = false;
                        if (autormt.getRemittanceCOA().equals(autoRemit.getRemittanceCOA()) && autormt.getDepartment().equals(autoRemit.getDepartment()) && autormt.getDrawingOfficer().equals(autoRemit.getDrawingOfficer()) && autormt.getBankbranchAccount().equals(autoRemit.getBankbranchAccount())) {
                            autormt.setRemittedAmountSubtotal(autormt.getRemittedAmountSubtotal().add(autoRemit.getRemittedAmount()));
                            autoremitKey = autormt;
                            addList = false;
                            break;
                        }
                        addList = true;
                    }
                    if (!addList) {
                        ((List)this.autoremittanceMap.get(autoremitKey)).add(autoRemit);
                    } else {
                        autoremitEntry = new ArrayList();
                        autoremitKey.setRemittanceCOA(autoRemit.getRemittanceCOA());
                        autoremitKey.setDrawingOfficer(autoRemit.getDrawingOfficer());
                        autoremitKey.setDepartment(autoRemit.getDepartment());
                        autoremitKey.setBankbranchAccount(autoRemit.getBankbranchAccount());
                        autoremitKey.setRemittedAmountSubtotal(autoRemit.getRemittedAmount());
                        autoremitEntry.add(autoRemit);
                        this.autoremittanceMap.put(autoremitKey, autoremitEntry);
                    }
                }
                this.remittedAmountTotal = this.remittedAmountTotal.add(autoRemit.getRemittedAmount());
            }
        } else {
            for (AutoRemittanceBeanReport autoRemit : this.autoRemittance) {
                AutoRemittanceBeanReport autoremitKey = new AutoRemittanceBeanReport();
                if (this.autoremittanceMap.isEmpty()) {
                    autoremitEntry = new ArrayList();
                    autoremitKey.setRemittanceCOA(autoRemit.getRemittanceCOA());
                    autoremitKey.setFundName(autoRemit.getFundName());
                    autoremitKey.setBankbranchAccount(autoRemit.getBankbranchAccount());
                    autoremitEntry.add(autoRemit);
                    autoremitKey.setRemittedAmountSubtotal(autoRemit.getRemittedAmount());
                    this.autoremittanceMap.put(autoremitKey, autoremitEntry);
                } else {
                    Set autoRemitKeySet = this.autoremittanceMap.keySet();
                    for (AutoRemittanceBeanReport autormt : autoRemitKeySet) {
                        addList = false;
                        if (autormt.getRemittanceCOA().equals(autoRemit.getRemittanceCOA()) && autormt.getFundName().equals(autoRemit.getFundName()) && autormt.getBankbranchAccount().equals(autoRemit.getBankbranchAccount())) {
                            autormt.setRemittedAmountSubtotal(autormt.getRemittedAmountSubtotal().add(autoRemit.getRemittedAmount()));
                            autoremitKey = autormt;
                            addList = false;
                            break;
                        }
                        addList = true;
                    }
                    if (!addList) {
                        ((List)this.autoremittanceMap.get(autoremitKey)).add(autoRemit);
                    } else {
                        autoremitEntry = new ArrayList();
                        autoremitKey.setRemittanceCOA(autoRemit.getRemittanceCOA());
                        autoremitKey.setFundName(autoRemit.getFundName());
                        autoremitKey.setBankbranchAccount(autoRemit.getBankbranchAccount());
                        autoremitKey.setRemittedAmountSubtotal(autoRemit.getRemittedAmount());
                        autoremitEntry.add(autoRemit);
                        this.autoremittanceMap.put(autoremitKey, autoremitEntry);
                    }
                }
                this.remittedAmountTotal = this.remittedAmountTotal.add(autoRemit.getRemittedAmount());
            }
        }
        this.getSession().put("autoremittanceMap", this.autoremittanceMap);
        return "results";
    }

    @Action(value="/report/autoRemittanceReport-exportXls")
    public String exportXls() throws JRException, IOException {
        this.populateData();
        if (this.level.equals("atcoc")) {
            StringBuffer finyearQuery = new StringBuffer();
            Date currentDate = new Date();
            finyearQuery.append("from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(currentDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(currentDate)).append("'");
            CFinancialYear financialyear = (CFinancialYear)this.persistenceService.find(finyearQuery.toString());
            if (null == this.paymentVoucherFromDate) {
                this.paymentVoucherFromDate = financialyear.getStartingDate();
            }
            if (null == this.paymentVoucherToDate) {
                this.paymentVoucherToDate = financialyear.getEndingDate();
            }
            this.map.put("autoremittanceList", this.autoRemittance);
            this.populateCOCLevelSummaryData();
            ReportRequest reportInput = new ReportRequest(this.cocLevelJasperpath, (Object)this.map, this.getParamMap());
            reportInput.setReportFormat(ReportFormat.XLS);
            ReportOutput reportOutput = this.reportService.createReport(reportInput);
            this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
            return "summary-XLS";
        }
        ReportRequest reportInput = new ReportRequest(this.deptLevelJasperpath, (Collection)this.autoRemittance, this.getParamMap());
        reportInput.setReportFormat(ReportFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        return "XLS";
    }

    @Action(value="/report/autoRemittanceReport-exportPdf")
    public String exportPdf() {
        this.populateData();
        if (this.level.equals("atcoc")) {
            StringBuffer finyearQuery = new StringBuffer();
            Date currentDate = new Date();
            finyearQuery.append("from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(currentDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(currentDate)).append("'");
            CFinancialYear financialyear = (CFinancialYear)this.persistenceService.find(finyearQuery.toString());
            if (null == this.paymentVoucherFromDate) {
                this.paymentVoucherFromDate = financialyear.getStartingDate();
            }
            if (null == this.paymentVoucherToDate) {
                this.paymentVoucherToDate = financialyear.getEndingDate();
            }
            this.map.put("autoremittanceList", this.autoRemittance);
            this.populateCOCLevelSummaryData();
            ReportRequest reportInput = new ReportRequest(this.cocLevelJasperpath, (Object)this.map, this.getParamMap());
            ReportOutput reportOutput = this.reportService.createReport(reportInput);
            this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
            return "summary-PDF";
        }
        ReportRequest reportInput = new ReportRequest(this.deptLevelJasperpath, (Collection)this.autoRemittance, this.getParamMap());
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.inputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        return "PDF";
    }

    Map<String, Object> getParamMap() {
        String formatedDate;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        StringBuffer header = new StringBuffer("");
        if (this.level.equals("atcoc")) {
            header.append("Summary of remittance for the date range ");
            header.append(Constants.DDMMYYYYFORMAT2.format(this.paymentVoucherFromDate) + "  to  " + Constants.DDMMYYYYFORMAT2.format(this.paymentVoucherToDate));
            StringBuffer detailheader = new StringBuffer("Auto remittance payment report for ");
            this.recovery = (Recovery)this.persistenceService.find("from Recovery  where id =?", new Object[]{this.recovery.getId()});
            detailheader.append(this.recovery.getType() + " - " + this.recovery.getRecoveryName());
            paramMap.put("detailheader", detailheader.toString());
        } else {
            header.append(" Auto remittance payment report for ");
            this.department = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.department.getId()});
            header.append(this.department.getName() + " department ");
        }
        paramMap.put("header", header.toString());
        if (null != this.recovery && null != this.recovery.getId() && this.recovery.getId() != -1L) {
            this.recovery = (Recovery)this.persistenceService.find("from Recovery  where id =?", new Object[]{this.recovery.getId()});
            paramMap.put("remittanceCOA", this.recovery.getType());
        }
        if (null != this.paymentVoucherFromDate) {
            formatedDate = Constants.DDMMYYYYFORMAT2.format(this.paymentVoucherFromDate);
            paramMap.put("payVoucherFromDate", formatedDate);
        }
        if (null != this.paymentVoucherToDate) {
            formatedDate = Constants.DDMMYYYYFORMAT2.format(this.paymentVoucherToDate);
            paramMap.put("payVoucherToDate", formatedDate);
        }
        if (null != this.fund && null != this.fund.getId() && this.fund.getId() != -1) {
            this.fund = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.fund.getId()});
            paramMap.put("fund", this.fund.getName());
        }
        if (null != this.drawingOfficer && null != this.drawingOfficer.getId() && this.drawingOfficer.getId() != -1L) {
            this.drawingOfficer = (DrawingOfficer)this.persistenceService.find("from DrawingOfficer where id=?", new Object[]{this.drawingOfficer.getId()});
            paramMap.put("drawingOfficer", this.drawingOfficer.getName());
        }
        if (null != this.rtgsAssignedFromDate) {
            formatedDate = Constants.DDMMYYYYFORMAT2.format(this.rtgsAssignedFromDate);
            paramMap.put("rtgsFromDate", formatedDate);
        }
        if (null != this.rtgsAssignedToDate) {
            formatedDate = Constants.DDMMYYYYFORMAT2.format(this.rtgsAssignedToDate);
            paramMap.put("rtgsToDate", formatedDate);
        }
        if (null != this.instrumentNumber) {
            paramMap.put("rtgsNum", this.instrumentNumber);
        }
        if (null != this.bank && null != this.bank.getId() && this.bank.getId() != -1) {
            this.bank = (Bank)this.persistenceService.find("from Bank where id = ?", new Object[]{this.bank.getId()});
            paramMap.put("bank", this.bank.getName());
        }
        if (null != this.supplierCode && !this.supplierCode.isEmpty()) {
            paramMap.put("supplierName", this.supplierCode);
        }
        if (null != this.contractorCode && !this.contractorCode.isEmpty()) {
            paramMap.put("contractorName", this.contractorCode);
        }
        if (null != this.bankbranch && null != this.bankbranch.getId() && this.bankbranch.getId() != -1) {
            this.bankbranch = (Bankbranch)this.persistenceService.find("from Bankbranch where id =?", new Object[]{this.bankbranch.getId()});
            paramMap.put("bankBranch", this.bankbranch.getBranchname());
        }
        if (null != this.bankaccount && null != this.bankaccount.getId() && this.bankaccount.getId() != -1L) {
            this.bankaccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id =?", new Object[]{this.bankbranch.getId()});
            paramMap.put("bankAccountNum", this.bankaccount.getAccountnumber());
        }
        Date currentDate = new Date();
        String reportRunDate = Constants.DDMMYYYYFORMAT2.format(currentDate);
        paramMap.put("reportRunDate", reportRunDate);
        return paramMap;
    }

    private void populateData() {
        StringBuffer query = new StringBuffer("");
        Date currentDate = new Date();
        StringBuffer finyearQuery = new StringBuffer();
        finyearQuery.append("from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(currentDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(currentDate)).append("'");
        CFinancialYear financialyear = (CFinancialYear)this.persistenceService.find(finyearQuery.toString());
        if (this.level.equals("atcoc")) {
            query.append("SELECT CONCAT(CONCAT(coa.GLCODE ,' - ') ,coa.NAME) AS remittanceCOA,      dept.DEPT_NAME  AS department,CONCAT(\tCONCAT(DO.NAME,'/') , DO.TAN) AS drawingOfficer ,  CONCAT(CONCAT( CONCAT(CONCAT(bank.NAME, '  '),bnkbranch.BRANCHNAME), ' - '), bnkacc.ACCOUNTNUMBER) AS bankbranchAccount,  vh.VOUCHERNUMBER AS remittancePaymentNo, CONCAT(CONCAT(ih.INSTRUMENTNUMBER ,'/'),ih.INSTRUMENTDATE ) rtgsNoDate, ih.INSTRUMENTAMOUNT AS rtgsamount, remdt.ID AS remittanceDTId ,vh.id as paymentVoucherId  FROM EG_REMITTANCE rem, EG_REMITTANCE_DETAIL remdt,EG_REMITTANCE_GLDTL remgltl, EGF_INSTRUMENTHEADER ih,EGF_INSTRUMENTVOUCHER iv, VOUCHERHEADER vh,TDS TDS,PAYMENTHEADER ph,BANKACCOUNT bnkacc, GENERALLEDGER gl, GENERALLEDGERDETAIL gld, chartofaccounts coa, fund fund,bank bank,bankbranch bnkbranch,EG_DEPARTMENT dept,EG_DRAWINGOFFICER DO  WHERE rem.id = remdt.REMITTANCEID AND remdt.REMITTANCEGLDTLID =remgltl.ID AND   rem.paymentvhid = iv.voucherheaderid AND  iv.instrumentheaderid = ih.ID AND  iv.voucherheaderid= vh.id  AND rem.tdsid = TDS.id AND \t fund.id= vh.fundid  AND TDS.REMITTANCE_MODE='A' AND vh.status=0  AND ph.VOUCHERHEADERID = vh.id   AND ph.BANKACCOUNTNUMBERID = bnkacc.ID AND gl.VOUCHERHEADERID= vh.id AND gld.GENERALLEDGERID=gl.id AND  dept.ID_DEPT = vh.departmentid  AND DO.ID =ph.DRAWINGOFFICER_ID\t AND ph.DRAWINGOFFICER_ID IS NOT NULL AND rem.paymentvhid IS  NOT  NULL  AND ih.ID_STATUS= (SELECT  id  FROM EGW_STATUS WHERE moduletype='Instrument' AND code='New')  AND bnkacc.BRANCHID=bnkbranch.ID  AND bank.id =bnkbranch.BANKID   AND coa.id= tds.GLCODEID ");
        } else {
            query.append("SELECT CONCAT(CONCAT(coa.GLCODE ,' - ') ,coa.NAME) AS remittanceCOA, fund.NAME AS fundName, CONCAT(CONCAT( CONCAT(CONCAT(bank.NAME, '  '),bnkbranch.BRANCHNAME), ' - '), bnkacc.ACCOUNTNUMBER) AS bankbranchAccount,  vh.VOUCHERNUMBER AS remittancePaymentNo, CONCAT(CONCAT(ih.INSTRUMENTNUMBER ,'/'),ih.INSTRUMENTDATE ) rtgsNoDate, ih.INSTRUMENTAMOUNT AS rtgsamount, remdt.ID AS remittanceDTId ,vh.id as paymentVoucherId  FROM EG_REMITTANCE rem, EG_REMITTANCE_DETAIL remdt,EG_REMITTANCE_GLDTL remgltl, EGF_INSTRUMENTHEADER ih,EGF_INSTRUMENTVOUCHER iv, VOUCHERHEADER vh,TDS TDS,PAYMENTHEADER ph,BANKACCOUNT bnkacc, GENERALLEDGER gl, GENERALLEDGERDETAIL gld, chartofaccounts coa, fund fund,bank bank,bankbranch bnkbranch  WHERE rem.id = remdt.REMITTANCEID AND remdt.REMITTANCEGLDTLID =remgltl.ID AND   rem.paymentvhid = iv.voucherheaderid AND  iv.instrumentheaderid = ih.ID AND  iv.voucherheaderid= vh.id  AND rem.tdsid = TDS.id AND \t fund.id= vh.fundid  AND TDS.REMITTANCE_MODE='A' AND vh.status=0  AND ph.VOUCHERHEADERID = vh.id   AND ph.BANKACCOUNTNUMBERID = bnkacc.ID AND gl.VOUCHERHEADERID= vh.id AND gld.GENERALLEDGERID=gl.id AND  rem.paymentvhid IS  NOT  NULL  AND ih.ID_STATUS= (SELECT  id  FROM EGW_STATUS WHERE moduletype='Instrument' AND code='New')  AND bnkacc.BRANCHID=bnkbranch.ID  AND bank.id =bnkbranch.BANKID   AND coa.id= tds.GLCODEID ");
        }
        if (null != this.department && null != this.department.getId() && this.department.getId() != -1L) {
            query.append(" AND vh.DEPARTMENTID = " + this.department.getId());
        }
        if (null != this.recovery && null != this.recovery.getId() && this.recovery.getId() != -1L) {
            query.append(" AND  TDS.id = " + this.recovery.getId());
        }
        if (this.level.equals("atcoc")) {
            if (null != this.paymentVoucherFromDate) {
                query.append(" AND vh.voucherdate >= '" + Constants.DDMMYYYYFORMAT1.format(this.paymentVoucherFromDate) + "'");
            } else {
                query.append(" AND vh.voucherdate >= '" + Constants.DDMMYYYYFORMAT1.format(financialyear.getStartingDate()) + "'");
            }
            if (null != this.paymentVoucherToDate) {
                query.append(" AND vh.voucherdate <= '" + Constants.DDMMYYYYFORMAT1.format(this.paymentVoucherToDate) + "'");
            } else {
                query.append(" AND vh.voucherdate <= '" + Constants.DDMMYYYYFORMAT1.format(financialyear.getEndingDate()) + "'");
            }
        } else {
            if (null != this.paymentVoucherFromDate) {
                query.append(" AND vh.voucherdate >= '" + Constants.DDMMYYYYFORMAT1.format(this.paymentVoucherFromDate) + "'");
            }
            if (null != this.paymentVoucherToDate) {
                query.append(" AND vh.voucherdate <= '" + Constants.DDMMYYYYFORMAT1.format(this.paymentVoucherToDate) + "'");
            }
        }
        if (null != this.fund && null != this.fund.getId() && this.fund.getId() != -1) {
            query.append(" AND vh.fundid= " + this.fund.getId());
        }
        if (null != this.drawingOfficer && null != this.drawingOfficer.getId() && this.drawingOfficer.getId() != -1L) {
            query.append(" AND ph.DRAWINGOFFICER_ID =" + this.drawingOfficer.getId());
        }
        if (null != this.rtgsAssignedFromDate) {
            query.append(" AND ih.INSTRUMENTDATE >= '" + Constants.DDMMYYYYFORMAT1.format(this.rtgsAssignedFromDate) + "'");
        }
        if (null != this.rtgsAssignedToDate) {
            query.append(" AND ih.INSTRUMENTDATE <= '" + Constants.DDMMYYYYFORMAT1.format(this.rtgsAssignedToDate) + "'");
            query.append(this.rtgsAssignedToDate + "'");
        }
        if (null != this.instrumentNumber) {
            query.append(" AND ih.INSTRUMENTNUMBER = '" + this.instrumentNumber + "'");
        }
        if (null != this.bank && null != this.bank.getId() && this.bank.getId() != -1) {
            query.append("AND bank.id = " + this.bank.getId());
        }
        if (null != this.supplierCode && !this.supplierCode.isEmpty()) {
            query.append(" AND ( gld.DETAILKEYID = ").append(this.supplierCode).append(" AND gld.DETAILTYPEID=(SELECT id FROM accountdetailtype WHERE name='Creditor'))");
        }
        if (null != this.contractorCode && !this.contractorCode.isEmpty()) {
            query.append(" AND ( gld.DETAILKEYID = ").append(this.contractorCode).append(" AND gld.DETAILTYPEID=(SELECT id FROM accountdetailtype WHERE name='contractor'))");
        }
        if (null != this.bankbranch && null != this.bankbranch.getId() && this.bankbranch.getId() != -1) {
            query.append("AND bnkacc.BRANCHID = " + this.bankbranch.getId());
        }
        if (null != this.bankaccount && null != this.bankaccount.getId() && this.bankaccount.getId() != -1L) {
            query.append(" AND bnkacc.id = " + this.bankaccount.getId());
        }
        if (this.level.equals("atcoc")) {
            query.append("  GROUP BY coa.GLCODE ,coa.NAME,dept.DEPT_NAME, DO.NAME, DO.TAN,");
        } else {
            query.append("  GROUP BY coa.GLCODE ,coa.NAME, fund.NAME ,");
        }
        query.append(" bank.NAME,bnkbranch.BRANCHNAME, bnkacc.ACCOUNTNUMBER, vh.VOUCHERNUMBER ,ih.INSTRUMENTNUMBER ,ih.INSTRUMENTDATE, ih.INSTRUMENTAMOUNT,remdt.ID,vh.id ");
        if (this.level.equals("atcoc")) {
            query.append(" order by  coa.GLCODE ,coa.NAME,dept.DEPT_NAME, DO.NAME, DO.TAN,");
        } else {
            query.append(" order by  coa.GLCODE ,coa.NAME, fund.NAME ,");
        }
        query.append(" bank.NAME,bnkbranch.BRANCHNAME, bnkacc.ACCOUNTNUMBER, vh.VOUCHERNUMBER ,ih.INSTRUMENTNUMBER ,ih.INSTRUMENTDATE, ih.INSTRUMENTAMOUNT,remdt.ID ");
        Session session = this.persistenceService.getSession();
        Query sqlQuery = null;
        sqlQuery = this.level.equals("atcoc") ? session.createSQLQuery(query.toString()).addScalar("remittanceCOA").addScalar("department").addScalar("drawingOfficer").addScalar("bankbranchAccount").addScalar("remittancePaymentNo").addScalar("rtgsNoDate").addScalar("rtgsAmount").addScalar("remittanceDTId").addScalar("paymentVoucherId").setResultTransformer(Transformers.aliasToBean(AutoRemittanceBeanReport.class)) : session.createSQLQuery(query.toString()).addScalar("remittanceCOA").addScalar("fundName").addScalar("bankbranchAccount").addScalar("remittancePaymentNo").addScalar("rtgsNoDate").addScalar("rtgsAmount").addScalar("remittanceDTId").addScalar("paymentVoucherId").setResultTransformer(Transformers.aliasToBean(AutoRemittanceBeanReport.class));
        this.autoRemittance = this.remitRecoveryService.populateAutoRemittanceDetailbySQL(sqlQuery);
    }

    public void populateCOCLevelSummaryData() {
        StringBuffer queryString1 = new StringBuffer("SELECT (SUM(case when  glcode = 350200101then  rmtAmt  else (case when GLCODE = 350200102  then RMTAMT else NULL end)  end)) AS  incomeTaxRemittedAmt, (SUM(case when glcode =  350200201  then rmtAmt else   (case when GLCODE = 350200202   then RMTAMT else NULL end) )) AS  salesTaxRemittedAmt, (SUM(case when  glcode = 350200402 THEN rmtAmt else   (case when GLCODE =  350200403  then RMTAMT else  NULL end)end)) AS  mwgwfRemittedAmt, (SUM(case when GLCODE = 350200301 then RMTAMT else NULL end  ))AS serviceTaxRemittedAmt, SUM(rmtamt) AS grandTotal FROM( SELECT * FROM ( SELECT remdt.REMITTEDAMT AS rmtAmt,tds.TYPE  AS glcode FROM tds tds, eg_remittance rem, eg_remittance_detail remdt,eg_remittance_gldtl remgltl, voucherheader vh  WHERE rem.id=remdt.REMITTANCEID AND remdt.REMITTANCEGLDTLID = remgltl.id AND tds.id=rem.TDSID AND vh.status=0  AND tds.REMITTANCE_MODE ='A' AND rem.PAYMENTVHID =vh.id  AND tds.TYPE IN (350200101,350200102,350200201,350200202 ,350200402,350200403,350200301)");
        Date currentDate = new Date();
        StringBuffer finyearQuery = new StringBuffer();
        finyearQuery.append("from CFinancialYear where  startingDate <= '").append(Constants.DDMMYYYYFORMAT1.format(currentDate)).append("' AND endingDate >='").append(Constants.DDMMYYYYFORMAT1.format(currentDate)).append("'");
        CFinancialYear financialyear = (CFinancialYear)this.persistenceService.find(finyearQuery.toString());
        if (null != this.paymentVoucherFromDate) {
            queryString1.append(" AND vh.voucherdate >= '" + Constants.DDMMYYYYFORMAT1.format(this.paymentVoucherFromDate) + "'");
        } else {
            queryString1.append(" AND vh.voucherdate >= '" + Constants.DDMMYYYYFORMAT1.format(financialyear.getStartingDate()) + "'");
        }
        if (null != this.paymentVoucherToDate) {
            queryString1.append(" AND vh.voucherdate <= '" + Constants.DDMMYYYYFORMAT1.format(this.paymentVoucherToDate) + "'");
        } else {
            queryString1.append(" AND vh.voucherdate <= '" + Constants.DDMMYYYYFORMAT1.format(financialyear.getEndingDate()) + "'");
        }
        queryString1.append(" )) ");
        Session session = this.persistenceService.getSession();
        Query sqlQuery = session.createSQLQuery(queryString1.toString()).addScalar("incomeTaxRemittedAmt").addScalar("salesTaxRemittedAmt").addScalar("mwgwfRemittedAmt").addScalar("serviceTaxRemittedAmt").addScalar("grandTotal").setResultTransformer(Transformers.aliasToBean(AutoRemittanceCOCLevelBeanReport.class));
        this.coaAbstract = sqlQuery.list();
        this.map.put("coaAbstratct", this.coaAbstract);
        StringBuffer queryString2 = new StringBuffer(" SELECT departmentCode, (SUM(case when  glcode = 350200101 then rmtAmt else    (case when GLCODE =350200102 then RMTAMT else NULL end) end)) AS  incomeTaxRemittedAmt, (SUM(case when  glcode = 350200201 then rmtAmt else   (case when GLCODE=350200202   then RMTAMT else  NULL end) end)) AS  salesTaxRemittedAmt, (SUM(case when  glcode= 350200402 then rmtAmt else  (case when GLCODE = 350200403 then RMTAMT else NULL end )end)) AS  mwgwfRemittedAmt, (SUM(case when GLCODE=350200301 then RMTAMT else NULL end  ))AS serviceTaxRemittedAmt,  SUM(rmtamt) AS departmentTotal FROM(  SELECT * FROM ( SELECT dept.DEPT_code  departmentcode, remdt.REMITTEDAMT AS rmtAmt, tds.TYPE  AS glcode FROM tds tds, eg_remittance rem, eg_remittance_detail remdt,eg_remittance_gldtl remgltl, voucherheader vh, eg_department dept WHERE rem.id=remdt.REMITTANCEID AND remdt.REMITTANCEGLDTLID = remgltl.id AND tds.id=rem.TDSID AND dept.ID_DEPT = vh.DEPARTMENTID AND tds.REMITTANCE_MODE ='A' AND vh.status=0  AND rem.PAYMENTVHID =vh.id AND tds.TYPE IN (350200101,350200102,350200201,350200202 ,350200402,350200403,350200301  )");
        if (null != this.paymentVoucherFromDate) {
            queryString2.append(" AND vh.voucherdate >= '" + Constants.DDMMYYYYFORMAT1.format(this.paymentVoucherFromDate) + "'");
        } else {
            queryString2.append(" AND vh.voucherdate >= '" + Constants.DDMMYYYYFORMAT1.format(financialyear.getStartingDate()) + "'");
        }
        if (null != this.paymentVoucherToDate) {
            queryString2.append(" AND vh.voucherdate <= '" + Constants.DDMMYYYYFORMAT1.format(this.paymentVoucherToDate) + "'");
        } else {
            queryString2.append(" AND vh.voucherdate <= '" + Constants.DDMMYYYYFORMAT1.format(financialyear.getEndingDate()) + "'");
        }
        queryString2.append(" ))GROUP BY departmentcode  ORDER BY departmentcode ");
        Query sqlQuery2 = session.createSQLQuery(queryString2.toString()).addScalar("departmentCode").addScalar("incomeTaxRemittedAmt").addScalar("salesTaxRemittedAmt").addScalar("mwgwfRemittedAmt").addScalar("serviceTaxRemittedAmt").addScalar("departmentTotal").setResultTransformer(Transformers.aliasToBean(AutoRemittanceCOCLevelBeanReport.class));
        this.remittanceList = sqlQuery2.list();
        this.map.put("summarryList", this.remittanceList);
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Object getModel() {
        return null;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setRecovery(Recovery recovery) {
        this.recovery = recovery;
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public Fund getFund() {
        return this.fund;
    }

    public List<EntityType> getEntitiesList() {
        return this.entitiesList;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Department getDepartment() {
        return this.department;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public Bankbranch getBankbranch() {
        return this.bankbranch;
    }

    public void setBankbranch(Bankbranch bankbranch) {
        this.bankbranch = bankbranch;
    }

    public Bankaccount getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(Bankaccount bankaccount) {
        this.bankaccount = bankaccount;
    }

    public Date getPaymentVoucherFromDate() {
        return this.paymentVoucherFromDate;
    }

    public void setPaymentVoucherFromDate(Date paymentVoucherFromDate) {
        this.paymentVoucherFromDate = paymentVoucherFromDate;
    }

    public Date getPaymentVoucherToDate() {
        return this.paymentVoucherToDate;
    }

    public void setPaymentVoucherToDate(Date paymentVoucherToDate) {
        this.paymentVoucherToDate = paymentVoucherToDate;
    }

    public Date getRtgsAssignedFromDate() {
        return this.rtgsAssignedFromDate;
    }

    public void setRtgsAssignedFromDate(Date rtgsAssignedFromDate) {
        this.rtgsAssignedFromDate = rtgsAssignedFromDate;
    }

    public Date getRtgsAssignedToDate() {
        return this.rtgsAssignedToDate;
    }

    public void setRtgsAssignedToDate(Date rtgsAssignedToDate) {
        this.rtgsAssignedToDate = rtgsAssignedToDate;
    }

    public String getInstrumentNumber() {
        return this.instrumentNumber;
    }

    public void setInstrumentNumber(String instrumentNumber) {
        this.instrumentNumber = instrumentNumber;
    }

    public List<AutoRemittanceBeanReport> getAutoRemittance() {
        return this.autoRemittance;
    }

    public void setAutoRemittance(List<AutoRemittanceBeanReport> autoRemittance) {
        this.autoRemittance = autoRemittance;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public DrawingOfficer getDrawingOfficer() {
        return this.drawingOfficer;
    }

    public void setDrawingOfficer(DrawingOfficer drawingOfficer) {
        this.drawingOfficer = drawingOfficer;
    }

    public String getSupplierCode() {
        return this.supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getContractorCode() {
        return this.contractorCode;
    }

    public void setContractorCode(String contractorCode) {
        this.contractorCode = contractorCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Map<AutoRemittanceBeanReport, List<AutoRemittanceBeanReport>> getAutoremittanceMap() {
        return this.autoremittanceMap;
    }

    public void setAutoremittanceMap(Map<AutoRemittanceBeanReport, List<AutoRemittanceBeanReport>> autoremittanceMap) {
        this.autoremittanceMap = autoremittanceMap;
    }

    public BigDecimal getRemittedAmountTotal() {
        return this.remittedAmountTotal;
    }

    public void setRemittedAmountTotal(BigDecimal remittedAmountTotal) {
        this.remittedAmountTotal = remittedAmountTotal;
    }

    public List<AutoRemittanceCOCLevelBeanReport> getCoaAbstract() {
        return this.coaAbstract;
    }

    public void setCoaAbstract(List<AutoRemittanceCOCLevelBeanReport> coaAbstract) {
        this.coaAbstract = coaAbstract;
    }

    public List<AutoRemittanceCOCLevelBeanReport> getRemittanceList() {
        return this.remittanceList;
    }

    public void setRemittanceList(List<AutoRemittanceCOCLevelBeanReport> remittanceList) {
        this.remittanceList = remittanceList;
    }
}

