/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.advance.EgAdvanceReqPayeeDetails;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.model.advance.EgAdvanceRequisitionMis;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.payment.Paymentheader;
import org.egov.services.payment.PaymentService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;

public class AdvanceRequisitionPaymentAction
extends BaseVoucherAction {
    private static final long serialVersionUID = 6620866171442917883L;
    private EgAdvanceRequisition advanceRequisition = new EgAdvanceRequisition();
    private static final Logger LOGGER = Logger.getLogger(AdvanceRequisitionPaymentAction.class);
    private Bankaccount bankaccount = new Bankaccount();
    private PaymentService paymentService;
    private SimpleWorkflowService<Paymentheader> paymentWorkflowService;
    private Paymentheader paymentheader;
    private Date voucherDate = new Date();
    private Map<String, String> modeOfCollectionMap = new HashMap();
    private String paymentMode = "cheque";
    private String narration;
    private VoucherService voucherService;
    private EgovCommon egovCommon;
    private Fund fund;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void prepare() {
        super.prepare();
        this.modeOfCollectionMap.put("others", "Others");
        this.modeOfCollectionMap.put("cash", "Cash");
        this.modeOfCollectionMap.put("cheque", "Cheque");
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
        this.addDropdownData("bankList", this.egovCommon.getActiveBankBranchForActiveBanks());
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        this.loadApproverUser();
    }

    public String execute() {
        if (this.advanceRequisition != null && this.advanceRequisition.getId() != null) {
            this.advanceRequisition = (EgAdvanceRequisition)this.persistenceService.find("from EgAdvanceRequisition where id=?", new Object[]{this.advanceRequisition.getId()});
            this.populateFund();
        }
        return "form";
    }

    private void populateFund() {
        if (this.advanceRequisition != null && this.advanceRequisition.getEgAdvanceReqMises() != null) {
            this.fund = this.advanceRequisition.getEgAdvanceReqMises().getFund();
        }
    }

    @ValidationErrorPage(value="form")
    public String create() {
        try {
            if (this.bankaccount.getId() == null || this.bankaccount.getId() == -1L) {
                throw new ValidationException(Arrays.asList(new ValidationError("invalid.bank", "invalid.bank")));
            }
            if (this.advanceRequisition != null && this.advanceRequisition.getId() != null) {
                this.advanceRequisition = (EgAdvanceRequisition)this.persistenceService.find("from EgAdvanceRequisition where id=?", new Object[]{this.advanceRequisition.getId()});
            }
            this.bankaccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{this.bankaccount.getId()});
            ArrayList accountcodedetails = new ArrayList();
            ArrayList subledgerdetails = new ArrayList();
            HashMap headerdetails = new HashMap();
            this.populateHeaderDetails(headerdetails);
            this.populateAccountCodeDetails(accountcodedetails);
            this.populateSubledgerDetails(subledgerdetails);
            this.parameters.put("paymentMode", new String[]{this.paymentMode});
            this.parameters.put("grandTotal", new String[]{this.advanceRequisition.getAdvanceRequisitionAmount().toPlainString()});
            this.paymentheader = this.paymentService.createPayment(this.parameters, headerdetails, accountcodedetails, subledgerdetails, this.bankaccount);
            this.paymentheader.transition().start().withOwner(this.paymentService.getPosition()).withComments(this.narration);
            Integer userId = null;
            userId = null != this.parameters.get("approverUserId") && Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue());
            this.paymentService.persist((Object)this.paymentheader);
            this.createMiscBill(this.paymentheader, this.advanceRequisition);
            this.advanceRequisition.getEgAdvanceReqMises().setVoucherheader(this.paymentheader.getVoucherheader());
            this.advanceRequisition.transition().end().withComments(this.narration);
            this.addActionMessage(this.getText("payment.transaction.success", new String[]{this.paymentheader.getVoucherheader().getVoucherNumber()}));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("ERROR" + e.getMessage()), (Throwable)e);
            this.populateData();
            throw new ValidationException(e.getErrors());
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)("ERROR" + e.getMessage()), (Throwable)e);
            this.populateData();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exception", e.getMessage()));
            throw new ValidationException(errors);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("ERROR" + e.getMessage()), (Throwable)e);
            this.populateData();
        }
        return "result";
    }

    private void createMiscBill(Paymentheader paymentheader, EgAdvanceRequisition advanceRequisition) {
        Miscbilldetail miscbilldetail = new Miscbilldetail();
        miscbilldetail.setBillnumber(advanceRequisition.getAdvanceRequisitionNumber());
        miscbilldetail.setBilldate(advanceRequisition.getAdvanceRequisitionDate());
        miscbilldetail.setBillamount(advanceRequisition.getAdvanceRequisitionAmount());
        miscbilldetail.setPassedamount(advanceRequisition.getAdvanceRequisitionAmount());
        miscbilldetail.setPaidamount(advanceRequisition.getAdvanceRequisitionAmount());
        miscbilldetail.setPaidto(advanceRequisition.getEgAdvanceReqMises().getPayto());
        miscbilldetail.setPayVoucherHeader(paymentheader.getVoucherheader());
        this.persistenceService.persist((Object)miscbilldetail);
    }

    private void populateData() {
        this.populateBanks();
        this.populateBankAccounts();
        this.populateFund();
    }

    private void populateBanks() {
        if (this.bankaccount.getId() != null) {
            this.addDropdownData("bankList", this.persistenceService.findAllBy("from Bankbranch bb where bb.isactive=true and bb.bank.isactive=true order by bb.bank.name", new Object[0]));
        }
    }

    private void populateBankAccounts() {
        if (this.bankaccount.getId() != null) {
            this.addDropdownData("accNumList", this.persistenceService.findAllBy("from Bankaccount ba where ba.bankbranch.id=? and ba.fund.id=? and ba.isactive=true order by ba.chartofaccounts.glcode", new Object[]{this.bankaccount.getBankbranch().getId(), this.bankaccount.getFund().getId()}));
        }
    }

    void loadApproverUser() {
        String scriptName = "paymentHeader.nextDesg";
        String type = "Payment|";
        Map map = new HashMap();
        map = this.paymentheader != null && this.paymentheader.getVoucherheader().getFiscalPeriodId() != null ? this.voucherService.getDesgByDeptAndTypeAndVoucherDate("Payment|", "paymentHeader.nextDesg", this.paymentheader.getVoucherheader().getVoucherDate(), this.paymentheader) : this.voucherService.getDesgByDeptAndTypeAndVoucherDate("Payment|", "paymentHeader.nextDesg", new Date(), this.paymentheader);
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        List desgList = (List)map.get("designationList");
        String strDesgId = "";
        String dName = "";
        ArrayList designationList = new ArrayList();
        for (Map desgIdAndName : desgList) {
            HashMap desgFuncryMap = new HashMap();
            if (desgIdAndName.get("designationName") != null) {
                desgFuncryMap.put("designationName", desgIdAndName.get("designationName"));
            }
            if (desgIdAndName.get("designationId") != null) {
                strDesgId = (String)desgIdAndName.get("designationId");
                if (strDesgId.indexOf("~") != -1) {
                    strDesgId = strDesgId.substring(0, strDesgId.indexOf(126));
                    dName = (String)desgIdAndName.get("designationId");
                    dName = dName.substring(dName.indexOf(126) + 1);
                }
                desgFuncryMap.put("designationId", strDesgId);
            }
            designationList.add(desgFuncryMap);
        }
        this.addDropdownData("designationList", designationList);
    }

    private void populateSubledgerDetails(List<HashMap<String, Object>> subledgerdetails) {
        HashMap<String, Object> subledgertDetailMap = null;
        for (EgAdvanceRequisitionDetails voucherDetail : this.advanceRequisition.getEgAdvanceReqDetailses()) {
            for (EgAdvanceReqPayeeDetails payeeDetail : voucherDetail.getEgAdvanceReqpayeeDetailses()) {
                subledgertDetailMap = new HashMap<String, Object>();
                subledgertDetailMap.put("debitamount", payeeDetail.getDebitAmount());
                subledgertDetailMap.put("creditamount", payeeDetail.getCreditAmount());
                subledgertDetailMap.put("detailtypeid", payeeDetail.getAccountDetailType().getId());
                subledgertDetailMap.put("detailkeyid", payeeDetail.getAccountdetailKeyId());
                subledgertDetailMap.put("glcode", voucherDetail.getChartofaccounts().getGlcode());
                subledgerdetails.add(subledgertDetailMap);
            }
        }
    }

    private void populateHeaderDetails(HashMap<String, Object> headerdetails) throws ParseException {
        headerdetails.put("vouchername", "Advance Payment");
        headerdetails.put("vouchertype", "Payment");
        if (this.parameters.get("description") != null) {
            headerdetails.put("description", ((String[])this.parameters.get("description"))[0]);
        }
        if (this.voucherDate == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("invalid.date", "invalid.date")));
        }
        headerdetails.put("voucherdate", this.voucherDate);
        if (this.shouldShowHeaderField("vouchernumber") && (this.parameters.get("vouchernumber") == null || "".equals(((String[])this.parameters.get("vouchernumber"))[0]))) {
            throw new ValidationException(Arrays.asList(new ValidationError("invalid.voucher.number", "invalid.voucher.number")));
        }
        headerdetails.put("vouchernumber", ((String[])this.parameters.get("vouchernumber"))[0]);
        EgAdvanceRequisitionMis egAdvanceReqMises = this.advanceRequisition.getEgAdvanceReqMises();
        if (egAdvanceReqMises != null) {
            if (egAdvanceReqMises.getFund() != null && egAdvanceReqMises.getFund().getId() != null) {
                this.voucherHeader.setFundId((Fund)this.persistenceService.find("from Fund where id=?", new Object[]{egAdvanceReqMises.getFund().getId()}));
                headerdetails.put("fundcode", egAdvanceReqMises.getFund().getCode());
            }
            if (egAdvanceReqMises.getEgDepartment() != null && egAdvanceReqMises.getEgDepartment().getId() != null) {
                this.voucherHeader.getVouchermis().setDepartmentid((Department)this.persistenceService.find("from Department where id=?", new Object[]{egAdvanceReqMises.getEgDepartment().getId()}));
                headerdetails.put("departmentcode", egAdvanceReqMises.getEgDepartment().getCode());
            }
            if (egAdvanceReqMises.getFundsource() != null && egAdvanceReqMises.getFundsource().getId() != null) {
                this.voucherHeader.getVouchermis().setFundsource((Fundsource)this.persistenceService.find("from Fundsource where id=?", new Object[]{egAdvanceReqMises.getFundsource().getId()}));
                headerdetails.put("fundsourcecode", egAdvanceReqMises.getFundsource().getCode());
            }
            if (egAdvanceReqMises.getScheme() != null && egAdvanceReqMises.getScheme().getId() != null) {
                this.voucherHeader.getVouchermis().setSchemeid((Scheme)this.persistenceService.find("from Scheme where id=?", new Object[]{egAdvanceReqMises.getScheme().getId()}));
                headerdetails.put("schemecode", egAdvanceReqMises.getScheme().getCode());
            }
            if (egAdvanceReqMises.getSubScheme() != null && egAdvanceReqMises.getSubScheme().getId() != null) {
                this.voucherHeader.getVouchermis().setSubschemeid((SubScheme)this.persistenceService.find("from SubScheme where id=?", new Object[]{egAdvanceReqMises.getSubScheme().getId()}));
                headerdetails.put("subschemecode", egAdvanceReqMises.getSubScheme().getCode());
            }
            if (egAdvanceReqMises.getFunctionaryId() != null && egAdvanceReqMises.getFunctionaryId().getId() != null) {
                this.voucherHeader.getVouchermis().setFunctionary((Functionary)this.persistenceService.find("from Functionary where id=?", new Object[]{egAdvanceReqMises.getFunctionaryId().getId()}));
                headerdetails.put("functionarycode", egAdvanceReqMises.getFunctionaryId().getCode());
            }
            if (egAdvanceReqMises.getFunction() != null && egAdvanceReqMises.getFunction().getId() != null) {
                this.voucherHeader.getVouchermis().setFunction((CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{egAdvanceReqMises.getFunction().getId()}));
                headerdetails.put("functioncode", egAdvanceReqMises.getFunction().getCode());
            }
            if (egAdvanceReqMises.getSubFieldId() != null && egAdvanceReqMises.getSubFieldId().getId() != null) {
                this.voucherHeader.getVouchermis().setDivisionid((Boundary)this.persistenceService.find("from Boundary where id=?", new Object[]{egAdvanceReqMises.getSubFieldId().getId()}));
                headerdetails.put("divisionid", egAdvanceReqMises.getSubFieldId().getId());
            }
        }
    }

    private void populateAccountCodeDetails(List<HashMap<String, Object>> accountcodedetails) {
        HashMap<String, Object> accdetailsMap = new HashMap<String, Object>();
        accdetailsMap.put("glcode", this.bankaccount.getChartofaccounts().getGlcode());
        accdetailsMap.put("narration", this.bankaccount.getChartofaccounts().getName());
        accdetailsMap.put("debitamount", 0);
        accdetailsMap.put("creditamount", this.advanceRequisition.getAdvanceRequisitionAmount());
        accountcodedetails.add(accdetailsMap);
        HashMap<String, Object> accdetailsMap1 = new HashMap<String, Object>();
        for (EgAdvanceRequisitionDetails row : this.advanceRequisition.getEgAdvanceReqDetailses()) {
            accdetailsMap1.put("glcode", row.getChartofaccounts().getGlcode());
            accdetailsMap1.put("narration", row.getChartofaccounts().getName());
        }
        accdetailsMap1.put("debitamount", this.advanceRequisition.getAdvanceRequisitionAmount());
        accdetailsMap1.put("creditamount", 0);
        accountcodedetails.add(accdetailsMap1);
    }

    public StateAware getModel() {
        return this.voucherHeader;
    }

    public void setAdvanceRequisition(EgAdvanceRequisition advanceRequisition) {
        this.advanceRequisition = advanceRequisition;
    }

    public EgAdvanceRequisition getAdvanceRequisition() {
        return this.advanceRequisition;
    }

    public boolean shouldShowHeaderField(String field) {
        return super.shouldShowHeaderField(field);
    }

    public void setBankaccount(Bankaccount bankaccount) {
        this.bankaccount = bankaccount;
    }

    public Bankaccount getBankaccount() {
        return this.bankaccount;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setPaymentWorkflowService(SimpleWorkflowService<Paymentheader> paymentWorkflowService) {
        this.paymentWorkflowService = paymentWorkflowService;
    }

    public void setVoucherDate(Date voucherdate) {
        this.voucherDate = voucherdate;
    }

    public Date getVoucherDate() {
        return this.voucherDate;
    }

    public void setModeOfCollectionMap(Map<String, String> modeOfCollectionMap) {
        this.modeOfCollectionMap = modeOfCollectionMap;
    }

    public Map<String, String> getModeOfCollectionMap() {
        return this.modeOfCollectionMap;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public EgovCommon getEgovCommon() {
        return this.egovCommon;
    }

    public List<String> getValidActions() {
        return null;
    }

    public String formatDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public Fund getFund() {
        return this.fund;
    }
}

