/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Bankaccount;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.Vouchermis;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.payment.BasePaymentAction;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.advance.EgAdvanceReqPayeeDetails;
import org.egov.model.advance.EgAdvanceRequisition;
import org.egov.model.advance.EgAdvanceRequisitionDetails;
import org.egov.model.advance.EgAdvanceRequisitionMis;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.payment.Paymentheader;
import org.egov.model.voucher.CommonBean;
import org.egov.services.payment.PaymentService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.FinancialConstants;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"new"}, location="advancePayment-new.jsp"), @Result(name={"view"}, location="advancePayment-view.jsp")})
public class AdvancePaymentAction
extends BasePaymentAction {
    private static final long serialVersionUID = -9121375867863538525L;
    private static final Logger LOGGER = Logger.getLogger(AdvancePaymentAction.class);
    private EgAdvanceRequisition advanceRequisition = new EgAdvanceRequisition();
    private Paymentheader paymentheader;
    private PaymentService paymentService;
    private VoucherService voucherService;
    private SimpleWorkflowService<Paymentheader> paymentWorkflowService;
    private PersistenceService<Miscbilldetail, Long> miscbilldetailService;
    private Map<String, String> modeOfPaymentMap = new LinkedHashMap();
    private EgovCommon egovCommon;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    CreateVoucher createVoucher;
    private Fund fund;
    private Long advanceRequisitionId;
    private String wfitemstate;
    private Integer departmentId;
    private CommonBean commonBean;
    private String paymentMode = "cheque";
    private String typeOfAccount = "PAYMENTS,RECEIPTS_PAYMENTS";
    private static final String PAYMENTID = "paymentid";
    private static final String CANCEL_ACTION = "cancel";
    private static final String REJECT_ACTION = "reject";
    private static final String ACTION_NAME = "actionName";
    private static final String VIEW = "view";
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving data";
    private static final String FAILED = "Transaction failed";
    private String description;
    public boolean showApprove = false;
    private BigDecimal balance;
    private ScriptService scriptService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void prepare() {
        super.prepare();
        if (this.advanceRequisitionId != null) {
            this.advanceRequisition = (EgAdvanceRequisition)this.persistenceService.find("from EgAdvanceRequisition where id=?", new Object[]{this.advanceRequisitionId});
            this.populateFund();
            this.loadBankBranch(this.fund);
        }
        this.getModeOfPayment();
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
        this.addDropdownData("accountNumberList", Collections.EMPTY_LIST);
    }

    private void getModeOfPayment() {
        this.modeOfPaymentMap = new LinkedHashMap();
        this.modeOfPaymentMap.put("cheque", this.getText("cheque"));
        this.modeOfPaymentMap.put("rtgs", this.getText("rtgs"));
        this.modeOfPaymentMap.put("cash", this.getText("cash"));
    }

    @SkipValidation
    @Action(value="/payment/advancePayment-newform")
    public String newform() {
        this.voucherHeader.reset();
        this.commonBean.reset();
        this.commonBean.setModeOfPayment("cheque");
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.loadDefalutDates();
        this.loadApproverUser("Payment");
        return "new";
    }

    private void populateFund() {
        if (this.advanceRequisition != null && this.advanceRequisition.getEgAdvanceReqMises() != null) {
            this.fund = this.advanceRequisition.getEgAdvanceReqMises().getFund();
        }
    }

    private void loadBankBranch(Fund fund) {
        this.addDropdownData("bankBranchList", this.persistenceService.findAllBy("from Bankbranch br where br.id in (select bankbranch.id from Bankaccount where fund=? and isactive = true and type in (?,?) )  and br.isactive=true and br.bank.isactive = true order by br.bank.name asc", new Object[]{fund, "PAYMENTS", "RECEIPTS_PAYMENTS"}));
    }

    @ValidationErrorPage(value="new")
    @Action(value="/payment/advancePayment-save")
    public String save() {
        this.voucherHeader.setType("Payment");
        this.voucherHeader.setName("Advance Payment");
        this.voucherHeader.setDescription(this.description);
        try {
            this.validateAdvancePaymentExists();
            if (this.commonBean.getModeOfPayment().equalsIgnoreCase("rtgs")) {
                this.validateRTGS();
            }
            this.voucherHeader = this.createVoucherAndledger();
            this.paymentheader = this.paymentService.createPaymentHeader(this.voucherHeader, Integer.valueOf(this.commonBean.getAccountNumberId()), this.commonBean.getModeOfPayment(), this.advanceRequisition.getAdvanceRequisitionAmount());
            this.createMiscBill();
            this.paymentheader.transition().start().withOwner(this.paymentService.getPosition());
            this.advanceRequisition.getEgAdvanceReqMises().setVoucherheader(this.paymentheader.getVoucherheader());
            this.sendForApproval();
            this.addActionMessage(this.getText("arf.payment.transaction.success") + " " + this.voucherHeader.getVoucherNumber());
        }
        catch (ValidationException e) {
            List errorList = e.getErrors();
            Iterator iterator = errorList.iterator();
            if (iterator.hasNext()) {
                ValidationError error = (ValidationError)iterator.next();
                if (error.getMessage().contains("DatabaseSequenceFirstTimeException")) {
                    this.prepare();
                    throw new ValidationException(Arrays.asList(new ValidationError("error", error.getMessage())));
                }
                throw new ValidationException(e.getErrors());
            }
            this.populateBankAccounts(Integer.valueOf(Integer.parseInt(this.commonBean.getBankId().split("-")[1])), this.fund.getId());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.loadApproverUser("Payment");
        }
        return VIEW;
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    public String sendForApproval() {
        this.paymentheader = this.getPayment();
        this.action = ((String[])this.parameters.get("actionname"))[0];
        Integer userId = null;
        userId = ((String[])this.parameters.get("actionname"))[0] != null && ((String[])this.parameters.get("actionname"))[0].contains(REJECT_ACTION) ? Integer.valueOf(this.paymentheader.getCreatedBy().getId().intValue()) : (null != this.parameters.get("approverUserId") && Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue()));
        this.paymentWorkflowService.transition(((String[])this.parameters.get("actionname"))[0] + "|" + userId, (StateAware)this.paymentheader, ((String[])this.parameters.get("comments"))[0]);
        this.paymentService.persist((Object)this.paymentheader);
        if (((String[])this.parameters.get("actionname"))[0].contains("approve")) {
            if ("END".equals(this.paymentheader.getState().getValue())) {
                this.addActionMessage(this.getText("payment.voucher.final.approval"));
            } else {
                this.addActionMessage(this.getText("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
            }
            this.setAction(((String[])this.parameters.get("actionname"))[0]);
        } else {
            this.addActionMessage(this.getText("payment.voucher.rejected", new String[]{this.paymentService.getEmployeeNameForPositionId(this.paymentheader.getState().getOwnerPosition())}));
        }
        return this.viewInboxItem();
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    @Action(value="/payment/advancePayment-viewInboxItem")
    public String viewInboxItem() {
        this.paymentheader = this.getPayment();
        this.showApprove = true;
        this.prepareForView();
        this.loadApproverUser(this.voucherHeader.getType());
        return VIEW;
    }

    @SkipValidation
    @Action(value="/payment/advancePayment-view")
    public String view() {
        this.prepareForView();
        this.wfitemstate = "END";
        return VIEW;
    }

    private void prepareForView() {
        this.voucherHeader = (CVoucherHeader)this.persistenceService.getSession().load(CVoucherHeader.class, (Serializable)this.voucherHeader.getId());
        this.paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where voucherheader=?", new Object[]{this.voucherHeader});
        this.advanceRequisition = (EgAdvanceRequisition)this.persistenceService.find("from EgAdvanceRequisition where egAdvanceReqMises.voucherheader = ?", new Object[]{this.voucherHeader});
        this.advanceRequisitionId = this.advanceRequisition.getId();
        this.commonBean.setAmount(this.paymentheader.getPaymentAmount());
        this.commonBean.setAccountNumberId(this.paymentheader.getBankaccount().getId().toString());
        String bankBranchId = this.paymentheader.getBankaccount().getBankbranch().getBank().getId() + "-" + this.paymentheader.getBankaccount().getBankbranch().getId();
        this.commonBean.setBankId(bankBranchId);
        this.commonBean.setModeOfPayment(this.paymentheader.getType().toUpperCase());
        Miscbilldetail miscbillDetail = (Miscbilldetail)this.persistenceService.find(" from Miscbilldetail where payVoucherHeader=?", new Object[]{this.voucherHeader});
        this.commonBean.setPaidTo(miscbillDetail.getPaidto());
        this.loadAjaxedDropDowns();
        if (!VIEW.equalsIgnoreCase(this.showMode)) {
            this.validateUser("balancecheck");
        }
    }

    private void loadAjaxedDropDowns() {
        this.populateFund();
        this.loadBankBranch(this.fund);
        this.populateBankAccounts(this.paymentheader.getBankaccount().getBankbranch().getId(), this.fund.getId());
    }

    private void populateBankAccounts(Integer bankBranchId, Integer fundId) {
        this.addDropdownData("accountNumberList", this.persistenceService.findAllBy("from Bankaccount ba where ba.bankbranch.id=? and ba.fund.id=? and ba.type in (?,?) and ba.isactive=true order by ba.chartofaccounts.glcode", new Object[]{bankBranchId, fundId, "PAYMENTS", "RECEIPTS_PAYMENTS"}));
    }

    @SkipValidation
    public boolean validateUser(String purpose) {
        Script validScript = (Script)this.getPersistenceService().findAllByNamedQuery("Script.findByName", new Object[]{"Paymentheader.show.bankbalance"}).get(0);
        List list = (List)this.scriptService.executeScript(validScript, ScriptService.createContext((Object[])new Object[]{"persistenceService", this.paymentService, "purpose", purpose}));
        if (((String)list.get(0)).equals("true")) {
            try {
                this.canCheckBalance = true;
                this.commonBean.setAvailableBalance(this.egovCommon.getAccountBalance(new Date(), this.paymentheader.getBankaccount().getId(), this.paymentheader.getPaymentAmount(), this.paymentheader.getId(), this.paymentheader.getBankaccount().getChartofaccounts().getId()));
                this.balance = this.commonBean.getAvailableBalance();
                return true;
            }
            catch (Exception e) {
                this.balance = BigDecimal.valueOf(-1L);
                return true;
            }
        }
        return false;
    }

    private void createMiscBill() {
        Miscbilldetail miscbilldetail = new Miscbilldetail();
        miscbilldetail.setBillnumber(this.advanceRequisition.getAdvanceRequisitionNumber());
        miscbilldetail.setBilldate(this.advanceRequisition.getAdvanceRequisitionDate());
        miscbilldetail.setBillamount(this.advanceRequisition.getAdvanceRequisitionAmount());
        miscbilldetail.setPassedamount(this.advanceRequisition.getAdvanceRequisitionAmount());
        miscbilldetail.setPaidamount(this.advanceRequisition.getAdvanceRequisitionAmount());
        miscbilldetail.setPaidto(this.advanceRequisition.getEgAdvanceReqMises().getPayto());
        miscbilldetail.setPayVoucherHeader(this.paymentheader.getVoucherheader());
        this.miscbilldetailService.persist((Object)miscbilldetail);
    }

    private CVoucherHeader createVoucherAndledger() {
        try {
            HashMap headerDetails = this.createHeaderAndMisDetails();
            headerDetails.put("sourcepath", "/EGF/payment/advancePayment!view.action?voucherHeader.id=");
            HashMap<String, Object> detailMap = null;
            HashMap<String, Object> subledgertDetailMap = null;
            ArrayList accountdetails = new ArrayList();
            ArrayList subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, Object>();
            detailMap.put("creditamount", this.advanceRequisition.getAdvanceRequisitionAmount());
            detailMap.put("debitamount", "0");
            Bankaccount account = (Bankaccount)this.persistenceService.getSession().load(Bankaccount.class, (Serializable)Integer.valueOf(this.commonBean.getAccountNumberId()));
            detailMap.put("glcode", account.getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            HashMap<String, String> glcodeMap = new HashMap<String, String>();
            detailMap = new HashMap();
            detailMap.put("debitamount", this.advanceRequisition.getAdvanceRequisitionAmount());
            detailMap.put("creditamount", "0");
            for (EgAdvanceRequisitionDetails advanceRequisitionDetails : this.advanceRequisition.getEgAdvanceReqDetailses()) {
                detailMap.put("glcode", advanceRequisitionDetails.getChartofaccounts().getGlcode());
            }
            accountdetails.add(detailMap);
            glcodeMap.put(detailMap.get("glcode").toString(), "debit");
            subledgertDetailMap = new HashMap<String, Object>();
            for (EgAdvanceRequisitionDetails advanceDetail : this.advanceRequisition.getEgAdvanceReqDetailses()) {
                for (EgAdvanceReqPayeeDetails payeeDetail : advanceDetail.getEgAdvanceReqpayeeDetailses()) {
                    subledgertDetailMap = new HashMap();
                    subledgertDetailMap.put("debitamount", payeeDetail.getDebitAmount());
                    subledgertDetailMap.put("creditamount", payeeDetail.getCreditAmount());
                    subledgertDetailMap.put("detailtypeid", payeeDetail.getAccountDetailType().getId());
                    subledgertDetailMap.put("detailkeyid", payeeDetail.getAccountdetailKeyId());
                    subledgertDetailMap.put("glcode", advanceDetail.getChartofaccounts().getGlcode());
                    subledgerDetails.add(subledgertDetailMap);
                }
            }
            this.voucherHeader = this.createVoucher.createPreApprovedVoucher(headerDetails, accountdetails, subledgerDetails);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, FAILED)));
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Posted to Ledger " + this.voucherHeader.getId()));
        }
        return this.voucherHeader;
    }

    public String getComments() {
        return this.getText("payment.comments", new String[]{this.paymentheader.getPaymentAmount().toPlainString()});
    }

    protected HashMap<String, Object> createHeaderAndMisDetails() throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", this.voucherHeader.getName());
        headerdetails.put("vouchertype", this.voucherHeader.getType());
        headerdetails.put("voucherdate", this.voucherHeader.getVoucherDate());
        headerdetails.put("description", this.voucherHeader.getDescription());
        EgAdvanceRequisitionMis egAdvanceReqMises = this.advanceRequisition.getEgAdvanceReqMises();
        if (egAdvanceReqMises != null) {
            if (egAdvanceReqMises.getFund() != null && egAdvanceReqMises.getFund().getId() != null) {
                headerdetails.put("fundcode", egAdvanceReqMises.getFund().getCode());
            }
            if (egAdvanceReqMises.getEgDepartment() != null && egAdvanceReqMises.getEgDepartment().getId() != null) {
                headerdetails.put("departmentcode", egAdvanceReqMises.getEgDepartment().getCode());
            }
            if (egAdvanceReqMises.getFundsource() != null && egAdvanceReqMises.getFundsource().getId() != null) {
                headerdetails.put("fundsourcecode", egAdvanceReqMises.getFundsource().getCode());
            }
            if (egAdvanceReqMises.getScheme() != null && egAdvanceReqMises.getScheme().getId() != null) {
                headerdetails.put("schemecode", egAdvanceReqMises.getScheme().getCode());
            }
            if (egAdvanceReqMises.getSubScheme() != null && egAdvanceReqMises.getSubScheme().getId() != null) {
                headerdetails.put("subschemecode", egAdvanceReqMises.getSubScheme().getCode());
            }
            if (egAdvanceReqMises.getFunctionaryId() != null && egAdvanceReqMises.getFunctionaryId().getId() != null) {
                headerdetails.put("functionarycode", egAdvanceReqMises.getFunctionaryId().getCode());
            }
            if (egAdvanceReqMises.getFunction() != null && egAdvanceReqMises.getFunction().getId() != null) {
                headerdetails.put("functioncode", egAdvanceReqMises.getFunction().getCode());
            }
            if (egAdvanceReqMises.getFieldId() != null && egAdvanceReqMises.getFieldId().getId() != null) {
                headerdetails.put("divisionid", egAdvanceReqMises.getFieldId().getId());
            }
        }
        return headerdetails;
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    public String cancelPayment() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting cancelPayment...");
        }
        this.paymentheader = this.getPayment();
        this.voucherHeader = this.paymentheader.getVoucherheader();
        this.voucherHeader.setStatus(FinancialConstants.CANCELLEDVOUCHERSTATUS);
        this.paymentheader.transition().end();
        this.persistenceService.persist((Object)this.voucherHeader);
        this.addActionMessage(this.getText("payment.cancel.success"));
        this.action = ((String[])this.parameters.get("actionname"))[0];
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed cancelPayment...");
        }
        return VIEW;
    }

    public StateAware getModel() {
        this.voucherHeader = (CVoucherHeader)super.getModel();
        return this.voucherHeader;
    }

    @SkipValidation
    public List<String> getValidActions() {
        return null;
    }

    public Paymentheader getPayment() {
        String paymentid = null;
        if (this.parameters.get(PAYMENTID) == null) {
            Object obj = this.getSession().get(PAYMENTID);
            if (obj != null) {
                paymentid = (String)obj;
            }
        } else {
            paymentid = ((String[])this.parameters.get(PAYMENTID))[0];
        }
        if (this.paymentheader == null && paymentid != null) {
            this.paymentheader = (Paymentheader)this.persistenceService.getSession().load(Paymentheader.class, (Serializable)Long.valueOf(paymentid));
        }
        if (this.paymentheader == null) {
            this.paymentheader = new Paymentheader();
        }
        return this.paymentheader;
    }

    private void loadApproverUser(String atype) {
        String scriptName = "paymentHeader.nextDesg";
        if (this.paymentheader != null && this.paymentheader.getPaymentAmount() != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("paymentheader.getPaymentAmount() >>>>>>>>>>>>>>>>>>> :" + this.paymentheader.getPaymentAmount()));
            }
            atype = atype + "|" + this.paymentheader.getPaymentAmount();
        } else {
            atype = atype + "|";
        }
        this.departmentId = this.voucherService.getCurrentDepartment().getId().intValue();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("departmentId :" + this.departmentId));
        }
        Map map = new HashMap();
        map = this.paymentheader != null && this.paymentheader.getVoucherheader().getFiscalPeriodId() != null ? this.voucherService.getDesgByDeptAndTypeAndVoucherDate(atype, "paymentHeader.nextDesg", this.paymentheader.getVoucherheader().getVoucherDate(), this.paymentheader) : this.voucherService.getDesgByDeptAndTypeAndVoucherDate(atype, "paymentHeader.nextDesg", new Date(), this.paymentheader);
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        List desgList = (List)map.get("designationList");
        String strDesgId = "";
        String dName = "";
        boolean bDefaultDeptId = false;
        ArrayList designationList = new ArrayList();
        for (Map desgIdAndName : desgList) {
            HashMap desgFuncryMap = new HashMap();
            if (desgIdAndName.get("designationName") != null) {
                desgFuncryMap.put("designationName", desgIdAndName.get("designationName"));
            }
            if (desgIdAndName.get("designationId") != null) {
                strDesgId = (String)desgIdAndName.get("designationId");
                if (strDesgId.indexOf("~") != -1) {
                    strDesgId = strDesgId.substring(0, strDesgId.indexOf(126));
                    dName = (String)desgIdAndName.get("designationId");
                    dName = dName.substring(dName.indexOf(126) + 1);
                    bDefaultDeptId = true;
                }
                desgFuncryMap.put("designationId", strDesgId);
            }
            designationList.add(desgFuncryMap);
        }
        map.put("designationList", designationList);
        this.addDropdownData("designationList", (List)map.get("designationList"));
        if (bDefaultDeptId && !dName.equals("")) {
            Department dept = (Department)this.persistenceService.find("from Department where deptName like '%" + dName + "' ");
            this.departmentId = dept.getId().intValue();
        }
        this.wfitemstate = map.get("wfitemstate") != null ? map.get("wfitemstate").toString() : "";
    }

    public void validate() {
        String actionName = "";
        if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
            actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        }
        if (!actionName.equalsIgnoreCase(REJECT_ACTION) && !actionName.equalsIgnoreCase(CANCEL_ACTION)) {
            if (this.voucherHeader.getVoucherDate() == null) {
                this.addFieldError("voucherDate", this.getText("arf.payment.voucherdate.required"));
            }
            if (!DateUtils.compareDates((Date)this.voucherHeader.getVoucherDate(), (Date)this.advanceRequisition.getAdvanceRequisitionDate())) {
                this.addFieldError("advanceRequisitionDate", this.getText("arf.payment.voucherdate.lessthan.advancerequisitiondate"));
            }
            if (!DateUtils.compareDates((Date)new Date(), (Date)this.voucherHeader.getVoucherDate())) {
                this.addFieldError("advanceRequisitionDate", this.getText("arf.validate.payment.voucherdate.greaterthan.currentDate"));
            }
            if (StringUtils.isBlank((String)this.commonBean.getBankId()) || this.commonBean.getBankId().equals("-1")) {
                this.addFieldError("commonBean.bankId", this.getText("arf.bankbranch.required"));
            }
            if (StringUtils.isBlank((String)this.commonBean.getAccountNumberId()) || this.commonBean.getAccountNumberId().equals("-1")) {
                this.addFieldError("commonBean.accountNumberId", this.getText("arf.accountnumber.required"));
            }
            if (StringUtils.isBlank((String)this.commonBean.getModeOfPayment())) {
                this.addFieldError("commonBean.modeOfPayment", this.getText("arf.modeOfPayment.required"));
            }
        }
    }

    private void validateRTGS() {
        EntityType entity = null;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (EgAdvanceRequisitionDetails advanceDetail : this.advanceRequisition.getEgAdvanceReqDetailses()) {
            if (!advanceDetail.getEgAdvanceReqpayeeDetailses().isEmpty()) {
                for (EgAdvanceReqPayeeDetails payeeDetail : advanceDetail.getEgAdvanceReqpayeeDetailses()) {
                    try {
                        entity = this.paymentService.getEntity(payeeDetail.getAccountDetailType().getId(), (Serializable)payeeDetail.getAccountdetailKeyId());
                        if (entity == null) {
                            throw new ValidationException(Arrays.asList(new ValidationError("no.entity.for.detailkey", this.getText("no.entity.for.detailkey", new String[]{entity.getCode() + "-" + entity.getName()}))));
                        }
                    }
                    catch (ApplicationException e) {
                        throw new ValidationException(Arrays.asList(new ValidationError("Exception to get EntityType  ", e.getMessage())));
                    }
                    if (!StringUtils.isBlank((String)entity.getPanno()) && !StringUtils.isBlank((String)entity.getBankname()) && !StringUtils.isBlank((String)entity.getBankaccount()) && !StringUtils.isBlank((String)entity.getIfsccode())) continue;
                    this.populateBankAccounts(Integer.valueOf(Integer.parseInt(this.commonBean.getBankId().split("-")[1])), this.fund.getId());
                    LOGGER.error((Object)this.getText("validate.paymentMode.rtgs.subledger.details", new String[]{entity.getCode() + "-" + entity.getName()}));
                    errors.add(new ValidationError("validate.paymentMode.rtgs.subledger.details", this.getText("validate.paymentMode.rtgs.subledger.details", new String[]{entity.getCode() + "-" + entity.getName()})));
                    throw new ValidationException(errors);
                }
                continue;
            }
            throw new ValidationException(Arrays.asList(new ValidationError("no.subledger.cannot.create.rtgs.payment", "arf.payment.no.subledger.cannot.create.rtgs.payment")));
        }
    }

    private void validateAdvancePaymentExists() {
        if (this.advanceRequisition != null && this.advanceRequisition.getEgAdvanceReqMises().getVoucherheader() != null && this.advanceRequisition.getEgAdvanceReqMises().getVoucherheader().getStatus() != 4) {
            this.populateBankAccounts(Integer.valueOf(Integer.parseInt(this.commonBean.getBankId().split("-")[1])), this.fund.getId());
            throw new ValidationException(Arrays.asList(new ValidationError("arf.payment.uniqueCheck.validate.message", this.getText("arf.payment.uniqueCheck.validate.message", new String[]{this.advanceRequisition.getAdvanceRequisitionNumber()}))));
        }
    }

    public void setAdvanceRequisition(EgAdvanceRequisition advanceRequisition) {
        this.advanceRequisition = advanceRequisition;
    }

    public EgAdvanceRequisition getAdvanceRequisition() {
        return this.advanceRequisition;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setPaymentWorkflowService(SimpleWorkflowService<Paymentheader> paymentWorkflowService) {
        this.paymentWorkflowService = paymentWorkflowService;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public EgovCommon getEgovCommon() {
        return this.egovCommon;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public Fund getFund() {
        return this.fund;
    }

    public Long getAdvanceRequisitionId() {
        return this.advanceRequisitionId;
    }

    public void setAdvanceRequisitionId(Long advanceRequisitionId) {
        this.advanceRequisitionId = advanceRequisitionId;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public String getTypeOfAccount() {
        return this.typeOfAccount;
    }

    public void setTypeOfAccount(String typeOfAccount) {
        this.typeOfAccount = typeOfAccount;
    }

    public CommonBean getCommonBean() {
        return this.commonBean;
    }

    public void setCommonBean(CommonBean commonBean) {
        this.commonBean = commonBean;
    }

    public Map<String, String> getModeOfPaymentMap() {
        return this.modeOfPaymentMap;
    }

    public void setModeOfPaymentMap(Map<String, String> modeOfPaymentMap) {
        this.modeOfPaymentMap = modeOfPaymentMap;
    }

    public Paymentheader getPaymentheader() {
        return this.paymentheader;
    }

    public void setPaymentheader(Paymentheader paymentheader) {
        this.paymentheader = paymentheader;
    }

    public void setMiscbilldetailService(PersistenceService<Miscbilldetail, Long> miscbilldetailService) {
        this.miscbilldetailService = miscbilldetailService;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }
}

