/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.Fund;
import org.egov.commons.service.BankAccountService;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.utils.BankAccountType;
import org.egov.egf.web.actions.masters.JQueryGridActionSupport;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infstr.utils.EGovConfig;
import org.egov.model.masters.AccountCodePurpose;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
public class BankAccountAction
extends JQueryGridActionSupport {
    private static final long serialVersionUID = 1L;
    String code = EGovConfig.getProperty((String)"egf_config.xml", (String)"glcodeMaxLength", (String)"", (String)"AccountCode");
    private String mode;
    private String newGLCode = "";
    private String coaID = "";
    private String glCode = "";
    private Integer bankBranchId;
    @Autowired
    @Qualifier(value="bankAccountService")
    private BankAccountService bankAccountService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public String execute() {
        if ("CRUD".equals(this.mode)) {
            try {
                if (this.oper.equals("add")) {
                    this.addBankAccount();
                } else if (this.oper.equals("edit")) {
                    this.editBankAccount();
                } else if (this.oper.equals("del")) {
                    this.deleteBankAccount();
                }
                this.sendAJAXResponse("success");
            }
            catch (RuntimeException e) {
                this.sendAJAXResponse("failed");
                throw new ApplicationRuntimeException("Error occurred in Bank Account.", (Throwable)e);
            }
        } else if ("LIST_BRANCH_ACC".equals(this.mode)) {
            this.listAllBankBranchAccounts();
        }
        return null;
    }

    private void addBankAccount() {
        Bankbranch bankBranch = (Bankbranch)this.persistenceService.getSession().load(Bankbranch.class, (Serializable)this.bankBranchId);
        new Date();
        Bankaccount bankAccount = new Bankaccount();
        HttpServletRequest request = ServletActionContext.getRequest();
        bankAccount.setBankbranch(bankBranch);
        try {
            if (this.autoBankAccountGLCodeEnabled().booleanValue()) {
                if (!request.getParameter("accounttype").equalsIgnoreCase("")) {
                    this.newGLCode = this.prepareBankAccCode(request.getParameter("accounttype").split("#")[0], this.code);
                    this.coaID = this.postInChartOfAccounts(this.newGLCode, request.getParameter("accounttype").split("#")[0], request.getParameter("accountnumber"));
                    if (this.coaID != null && this.coaID.length() > 0) {
                        CChartOfAccounts chartofaccounts = (CChartOfAccounts)this.persistenceService.getSession().load(CChartOfAccounts.class, (Serializable)Long.valueOf(Long.parseLong(this.coaID)));
                        bankAccount.setChartofaccounts(chartofaccounts);
                    }
                }
            } else if (!request.getParameter("glcode").equalsIgnoreCase("")) {
                this.glCode = request.getParameter("glcode");
                this.validateGlCode(this.glCode);
                CChartOfAccounts COA = (CChartOfAccounts)this.chartOfAccountsService.find("select coa from CChartOfAccounts coa where coa.glcode = ?", new Object[]{this.glCode});
                bankAccount.setChartofaccounts(COA);
            }
        }
        catch (Exception e) {
            this.sendAJAXResponse(e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
        this.populateBankAccountDetail(bankAccount);
        this.bankAccountService.applyAuditing((AbstractAuditable)bankAccount);
        this.bankAccountService.persist((Object)bankAccount);
    }

    public String prepareBankAccCode(String accID, String code) throws Exception {
        String glCode = "";
        Long tempCode = 0L;
        glCode = (String)this.persistenceService.find("select glcode from CChartOfAccounts where id=?) order by glcode desc", new Object[]{Long.parseLong(accID)});
        String subminorvalue = EGovConfig.getProperty((String)"egf_config.xml", (String)"subminorvalue", (String)"", (String)"AccountCode");
        glCode = glCode.substring(0, Integer.parseInt(subminorvalue));
        glCode = (String)this.persistenceService.find("select glcode from CChartOfAccounts where glcode like ? || '%' order by glcode desc", new Object[]{glCode});
        String zero = EGovConfig.getProperty((String)"egf_config.xml", (String)"zerofill", (String)"", (String)"AccountCode");
        if (glCode.length() == Integer.parseInt(code)) {
            Long glcode = Long.parseLong(glCode);
            tempCode = glcode + 1L;
        } else {
            glCode = glCode + zero;
            Long glcode = Long.parseLong(glCode);
            tempCode = glcode + 1L;
        }
        glCode = Long.toString(tempCode);
        return glCode;
    }

    public String postInChartOfAccounts(String glCode, String parentId, String accNumber) throws Exception {
        Bankbranch bankBranch = (Bankbranch)this.persistenceService.getSession().load(Bankbranch.class, (Serializable)this.bankBranchId);
        int majorCodeLength = 0;
        majorCodeLength = Integer.valueOf(this.getAppConfigValueFor("EGF", "coa_majorcode_length"));
        CChartOfAccounts chart = new CChartOfAccounts();
        chart.setGlcode(glCode);
        chart.setName(bankBranch.getBank().getName() + " " + bankBranch.getBranchname() + " " + accNumber);
        chart.setParentId(Long.valueOf(Long.parseLong(parentId)));
        chart.setType(Character.valueOf('A'));
        chart.setClassification(Long.valueOf(Long.parseLong("4")));
        chart.setIsActiveForPosting(Boolean.valueOf(true));
        chart.setMajorCode(chart.getGlcode().substring(0, majorCodeLength));
        this.chartOfAccountsService.persist((Object)chart);
        return String.valueOf(chart.getId());
    }

    private void validateGlCode(String glCode) {
        CGeneralLedger glList;
        CChartOfAccounts COA = (CChartOfAccounts)this.chartOfAccountsService.find("select coa from CChartOfAccounts coa where coa.glcode = ?", new Object[]{glCode});
        Bankaccount account = null;
        AccountCodePurpose purpose = null;
        if (COA == null) {
            throw new ApplicationRuntimeException("Given glcode does not exist");
        }
        if (glCode != null && (glList = (CGeneralLedger)this.persistenceService.find("select gl from CGeneralLedger gl where gl.glcodeId.glcode=? and gl.voucherHeaderId.status not in (4) ", new Object[]{glCode})) != null) {
            throw new ApplicationRuntimeException("Transaction already exist for given glcode");
        }
        if (COA != null && (account = (Bankaccount)this.bankAccountService.find("select ba from Bankaccount ba where ba.chartofaccounts.glcode = ?", new Object[]{glCode})) != null) {
            throw new ApplicationRuntimeException("Given glcode is already mapped to another bank account - " + account.getAccountnumber());
        }
        if (!COA.getIsActiveForPosting().booleanValue()) {
            throw new ApplicationRuntimeException("Given glcode is not active for posting");
        }
        if (COA.getChartOfAccountDetails() != null && !COA.getChartOfAccountDetails().isEmpty()) {
            throw new ApplicationRuntimeException("Given glcode should not be a control code");
        }
        if (COA.getType() != null && !COA.getType().equals(Character.valueOf('A'))) {
            throw new ApplicationRuntimeException("Given glcode should be of type Assets");
        }
        if (COA.getPurposeId() == null) {
            throw new ApplicationRuntimeException("Given glcode is not mapped with any purpose ");
        }
        if (COA.getPurposeId() != null && (purpose = (AccountCodePurpose)this.persistenceService.find("select purpose from AccountCodePurpose purpose where purpose.id = ?", new Object[]{COA.getPurposeId()})) != null && !purpose.getName().contains("Bank Account Codes")) {
            throw new ApplicationRuntimeException("Given glcode should be of purpose Bank Account Codes");
        }
    }

    private void editBankAccount() {
        Bankaccount bankAccount = (Bankaccount)this.bankAccountService.getSession().get(Bankaccount.class, (Serializable)Long.valueOf(this.id.longValue()));
        this.populateBankAccountDetail(bankAccount);
        this.bankAccountService.applyAuditing((AbstractAuditable)bankAccount);
        this.bankAccountService.update((Object)bankAccount);
    }

    private void deleteBankAccount() {
        Bankaccount bankBranch = (Bankaccount)this.bankAccountService.getSession().load(Bankaccount.class, (Serializable)Long.valueOf(this.id.longValue()));
        this.persistenceService.delete((Object)bankBranch);
    }

    private void populateBankAccountDetail(Bankaccount bankAccount) {
        HttpServletRequest request = ServletActionContext.getRequest();
        bankAccount.setAccountnumber(request.getParameter("accountnumber"));
        bankAccount.setAccounttype(this.getAccountType(request.getParameter("glcode")));
        if (StringUtils.isNotBlank((String)request.getParameter("fundname"))) {
            Fund fund = (Fund)this.persistenceService.getSession().load(Fund.class, (Serializable)Integer.valueOf(request.getParameter("fundname")));
            bankAccount.setFund(fund);
        }
        bankAccount.setIsactive(Boolean.valueOf(request.getParameter("active").equals("Y")));
        bankAccount.setNarration(request.getParameter("narration"));
        if (StringUtils.isNotBlank((String)request.getParameter("typename"))) {
            BankAccountType type = BankAccountType.valueOf((String)request.getParameter("typename"));
            bankAccount.setType(type);
        }
        bankAccount.setPayTo(request.getParameter("payto"));
    }

    public String getAccountType(String glCode) {
        String name = (String)this.persistenceService.find("select name from CChartOfAccounts where id=(select parentId from CChartOfAccounts where glcode = ?)", new Object[]{glCode});
        return name;
    }

    public Boolean autoBankAccountGLCodeEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "auto_bankaccount_glcode").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    private void listAllBankBranchAccounts() {
        List bankAccounts = this.getPagedResult(Bankaccount.class, "bankbranch.id", (Object)this.bankBranchId).getList();
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        String glCode = "";
        for (Bankaccount bankaccount : bankAccounts) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)bankaccount.getId());
                jsonObject.put("accountnumber", (Object)bankaccount.getAccountnumber());
                jsonObject.put("fundname", (Object)bankaccount.getFund().getName());
                jsonObject.put("narration", (Object)bankaccount.getNarration());
                jsonObject.put("payto", (Object)bankaccount.getPayTo());
                jsonObject.put("typename", (Object)(bankaccount.getType() == null ? "" : bankaccount.getType().name()));
                jsonObject.put("active", (Object)(bankaccount.getIsactive() != false ? "Y" : "N"));
                glCode = (String)this.persistenceService.find("select glcode from CChartOfAccounts where id=(select chartofaccounts.id from Bankaccount where accountnumber = ?)", new Object[]{bankaccount.getAccountnumber()});
                jsonObject.put("glcode", (Object)glCode);
                jsonObject.put("accounttype", (Object)this.getAccountType(glCode));
                jsonObjects.add(jsonObject);
            }
            catch (JSONException e) {
                this.sendAJAXResponse("error");
            }
        }
        String jsonString = new GsonBuilder().create().toJson(jsonObjects);
        this.sendAJAXResponse(this.constructJqGridResponse(jsonString));
    }

    String getAppConfigValueFor(String module, String key) {
        return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey(module, key).get(0)).getValue();
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setBankBranchId(Integer bankBranchId) {
        this.bankBranchId = bankBranchId;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }
}

