/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.masters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.service.BankAccountService;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.cheque.AccountCheques;
import org.egov.model.cheque.ChequeDeptMapping;
import org.egov.model.masters.ChequeDetail;
import org.egov.services.cheque.AccountChequesService;
import org.egov.utils.Constants;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"new"}, location="accountCheque-new.jsp"), @Result(name={"view"}, location="accountCheque-view.jsp"), @Result(name={"viewCheques"}, location="accountCheque-viewCheques.jsp"), @Result(name={"manipulateCheques"}, location="accountCheque-manipulateCheques.jsp")})
public class AccountChequeAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AccountChequeAction.class);
    private AccountCheques accountCheques = new AccountCheques();
    private List<ChequeDeptMapping> chequeList;
    private Bankaccount bankaccount;
    private List<ChequeDetail> chequeDetailsList;
    private Long financialYearId;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="accountChequesService")
    private AccountChequesService accountChequesService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private BankAccountService bankAccountService;
    private String deletedChqDeptId;

    public AccountChequeAction() {
        this.addRelatedEntity("bankAccountId", Bankaccount.class);
    }

    public Object getModel() {
        return this.accountCheques;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
        this.addDropdownData("financialYearList", this.financialYearDAO.getAllActiveFinancialYearList());
    }

    @Action(value="/masters/accountCheque-newform")
    public String newform() {
        this.addDropdownData("bankList", Collections.EMPTY_LIST);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        return "new";
    }

    @Action(value="/masters/accountCheque-view")
    public String view() {
        this.addDropdownData("bankList", Collections.EMPTY_LIST);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
        return "view";
    }

    @ValidationErrorPage(value="manipulateCheques")
    @Action(value="/masters/accountCheque-manipulateCheques")
    public String manipulateCheques() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"AccountChequeAction | manipulateCheques | Start");
        }
        Long bankAccId = Long.valueOf(((String[])this.parameters.get("bankAccId"))[0]);
        Long finId = Long.valueOf(((String[])this.parameters.get("finId"))[0]);
        this.setFinancialYearId(finId);
        this.bankaccount = (Bankaccount)this.bankAccountService.findById((Serializable)bankAccId, false);
        this.chequeList = this.accountChequesService.getChequesByBankAccIdFinId(bankAccId, Long.valueOf(this.financialYearId));
        if (this.chequeList.size() > 0) {
            this.prepareChequeDetails(this.chequeList);
        }
        return "manipulateCheques";
    }

    @Action(value="/masters/accountCheque-viewCheques")
    public String viewCheques() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"AccountChequeAction | manipulateCheques | Start");
        }
        Long bankAccId = Long.valueOf(((String[])this.parameters.get("bankAccId"))[0]);
        Long finId = Long.valueOf(((String[])this.parameters.get("finId"))[0]);
        this.bankaccount = (Bankaccount)this.bankAccountService.findById((Serializable)bankAccId, false);
        this.chequeList = this.accountChequesService.getChequesByBankAccIdFinId(bankAccId, finId);
        if (this.chequeList.size() > 0) {
            this.prepareChequeDetails(this.chequeList);
        }
        return "viewCheques";
    }

    private void prepareChequeDetails(List<ChequeDeptMapping> chequeList) {
        this.chequeDetailsList = new ArrayList();
        for (ChequeDeptMapping chequeDeptMapping : chequeList) {
            ChequeDetail chequeDetail = new ChequeDetail();
            chequeDetail.setFromChqNo(chequeDeptMapping.getAccountCheque().getFromChequeNumber());
            chequeDetail.setToChqNo(chequeDeptMapping.getAccountCheque().getToChequeNumber());
            chequeDetail.setDeptName(chequeDeptMapping.getAllotedTo().getName());
            chequeDetail.setDeptId(Integer.valueOf(chequeDeptMapping.getAllotedTo().getId().intValue()));
            CFinancialYear fy = this.financialYearDAO.findById((Number)chequeDeptMapping.getAccountCheque().getSerialNo(), false);
            chequeDetail.setSerialNoH(fy.getFinYearRange());
            chequeDetail.setReceivedDate(Constants.DDMMYYYYFORMAT2.format(chequeDeptMapping.getAccountCheque().getReceivedDate()));
            chequeDetail.setSerialNo(chequeDeptMapping.getAccountCheque().getSerialNo().toString());
            if (null != chequeDeptMapping.getAccountCheque().getIsExhausted() && chequeDeptMapping.getAccountCheque().getIsExhausted().booleanValue()) {
                chequeDetail.setIsExhusted("Yes");
            } else {
                chequeDetail.setIsExhusted("No");
            }
            chequeDetail.setNextChqPresent(chequeDeptMapping.getAccountCheque().getNextChqNo() != null ? "Yes" : "No");
            chequeDetail.setAccountChequeId(chequeDeptMapping.getAccountCheque().getId());
            chequeDetail.setChequeDeptId(chequeDeptMapping.getId());
            this.chequeDetailsList.add(chequeDetail);
        }
    }

    @ValidationErrorPage(value="manipulateCheques")
    @Action(value="/masters/accountCheque-save")
    public String save() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"AccountChequeAction | save | Start");
        }
        Session session = this.persistenceService.getSession();
        HashMap chequeMap = new HashMap();
        HashMap chequeIdMap = new HashMap();
        this.removeEmptyRows();
        this.bankaccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id =" + Long.valueOf(((String[])this.parameters.get("bankAccId"))[0]));
        if (null == this.chequeDetailsList) {
            this.accountChequesService.deleteRecords(this.deletedChqDeptId, this.bankaccount);
            this.addActionMessage("Cheque Master deleted Successfully : No cheque leafs available");
            return "manipulateCheques";
        }
        this.accountChequesService.createCheques(this.chequeDetailsList, chequeIdMap, chequeMap, this.bankaccount, this.deletedChqDeptId);
        this.accountChequesService.deleteRecords(this.deletedChqDeptId, this.bankaccount);
        StringBuffer query = new StringBuffer(200);
        this.chequeList = this.accountChequesService.getChequesByBankAccIdFinId(this.bankaccount.getId(), Long.valueOf(this.financialYearId));
        if (this.chequeList.size() > 0) {
            this.prepareChequeDetails(this.chequeList);
        }
        this.addActionMessage("Cheque Master updated Successfully");
        return "manipulateCheques";
    }

    private void removeEmptyRows() {
        ArrayList<ChequeDetail> trash = new ArrayList<ChequeDetail>();
        if (this.chequeDetailsList != null) {
            for (ChequeDetail cd : this.chequeDetailsList) {
                if (cd != null) continue;
                trash.add(cd);
            }
        }
        for (ChequeDetail cd : trash) {
            this.chequeDetailsList.remove(cd);
        }
        trash.clear();
    }

    public AccountCheques getAccountCheques() {
        return this.accountCheques;
    }

    public void setAccountCheques(AccountCheques accountCheques) {
        this.accountCheques = accountCheques;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
    }

    public List<ChequeDeptMapping> getChequeList() {
        return this.chequeList;
    }

    public void setChequeList(List<ChequeDeptMapping> chequeList) {
        this.chequeList = chequeList;
    }

    public Bankaccount getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(Bankaccount bankaccount) {
        this.bankaccount = bankaccount;
    }

    public List<ChequeDetail> getChequeDetailsList() {
        return this.chequeDetailsList;
    }

    public void setChequeDetailsList(List<ChequeDetail> chequeDetailsList) {
        this.chequeDetailsList = chequeDetailsList;
    }

    public String getDeletedChqDeptId() {
        return this.deletedChqDeptId;
    }

    public void setDeletedChqDeptId(String deletedChqDeptId) {
        this.deletedChqDeptId = deletedChqDeptId;
    }

    public Long getFinancialYearId() {
        return this.financialYearId;
    }

    public void setFinancialYearId(Long financialYearId) {
        this.financialYearId = financialYearId;
    }
}

