/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.contra;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.Transaxtion;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Bankaccount;
import org.egov.commons.CVoucherHeader;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.contra.ContraBean;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentOtherDetails;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.model.voucher.VoucherTypeBean;
import org.egov.services.contra.ContraService;
import org.egov.services.instrument.InstrumentHeaderService;
import org.egov.services.instrument.InstrumentOtherDetailsService;
import org.egov.services.instrument.InstrumentService;
import org.egov.services.instrument.InstrumentVoucherService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"new"}, location="contraCTB-new.jsp")})
public class ContraCTBAction
extends BaseVoucherAction {
    private static final Logger LOGGER = Logger.getLogger(ContraCTBAction.class);
    private static final long serialVersionUID = 1L;
    private ContraService contraService;
    private VoucherService voucherService;
    private ContraBean contraBean;
    private VoucherTypeBean voucherTypeBean;
    private EgovCommon egovCommon;
    private String message;
    private boolean close;
    private InstrumentService instrumentService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="instrumentHeaderService")
    private InstrumentHeaderService instrumentHeaderService;
    @Autowired
    @Qualifier(value="instrumentVoucherService")
    private InstrumentVoucherService instrumentVoucherService;
    @Autowired
    @Qualifier(value="instrumentOtherDetailsService")
    private InstrumentOtherDetailsService instrumentOtherDetailsService;
    @Autowired
    private ChartOfAccounts chartOfAccounts;

    public InstrumentService getInstrumentService() {
        return this.instrumentService;
    }

    public void setInstrumentService(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }

    @SkipValidation
    @Action(value="/contra/contraCTB-newform")
    public String newform() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"ContraCTBAction | newform | Start ");
        }
        Date currDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        this.contraBean.setChequeDate(sdf.format(currDate));
        return "new";
    }

    public void prepare() {
        super.prepare();
        this.voucherHeader.setType("Contra");
        this.addDropdownData("bankList", this.egovCommon.getBankBranchForActiveBanks());
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        Map boundaryMap = this.egovCommon.getCashChequeInfoForBoundary();
        this.addDropdownData("boundaryLevelList", (List)boundaryMap.get("listBndryLvl"));
        this.contraBean.setChequeInHand(boundaryMap.get("chequeInHand") != null ? boundaryMap.get("chequeInHand").toString() : null);
        this.contraBean.setCashInHand(boundaryMap.get("cashInHand") != null ? boundaryMap.get("cashInHand").toString() : null);
    }

    protected void getHeaderMandateFields() {
        super.getHeaderMandateFields();
        this.mandatoryFields.add("boundarylevel");
    }

    @Action(value="/contra/contraCTB-create")
    public String create() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"ContraCTBAction | depositCTB | Start ");
        }
        this.loadSchemeSubscheme();
        this.loadBankAccountNumber(this.contraBean);
        this.validateFields();
        if (this.validateBankTrans()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"validation passed ");
            }
            try {
                Bankaccount bankAccount;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Cash Deposit Mode" + this.contraBean.getMode()));
                }
                if (null != this.contraBean.getMode() && this.contraBean.getMode().equalsIgnoreCase("edit")) {
                    this.voucherHeader = this.voucherService.updateVoucherHeader(this.voucherHeader, this.voucherTypeBean);
                    InstrumentVoucher iVoucher = (InstrumentVoucher)this.persistenceService.find("from InstrumentVoucher where voucherHeaderId=?", new Object[]{this.voucherHeader});
                    bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Integer.valueOf(this.contraBean.getAccountNumberId())});
                    InstrumentHeader instrHeader = iVoucher.getInstrumentHeaderId();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("instrument header id " + instrHeader.getBankAccountId().getId()));
                    }
                    instrHeader.setBankAccountId(bankAccount);
                    instrHeader.setBankId(bankAccount.getBankbranch().getBank());
                    instrHeader.setBankBranchName(bankAccount.getBankbranch().getBranchname());
                    instrHeader.setInstrumentAmount(this.contraBean.getAmount());
                    instrHeader.setTransactionNumber(this.contraBean.getChequeNumber());
                    try {
                        instrHeader.setTransactionDate(Constants.DDMMYYYYFORMAT2.parse(this.contraBean.getChequeDate()));
                    }
                    catch (ParseException e) {
                        throw new ValidationException(Arrays.asList(new ValidationError("Invalid Referece Date", "invalid.date")));
                    }
                    InstrumentOtherDetails iOther = (InstrumentOtherDetails)this.persistenceService.find("from InstrumentOtherDetails where instrumentHeaderId=?", new Object[]{instrHeader});
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("cash deposit amount : = " + instrHeader.getInstrumentAmount()));
                    }
                    this.instrumentHeaderService.update((Object)instrHeader);
                    this.instrumentVoucherService.update((Object)iVoucher);
                    this.instrumentOtherDetailsService.update((Object)iOther);
                    this.contraService.updateIntoContraJournal(this.voucherHeader, this.contraBean);
                    this.contraService.updateBankreconciliation(instrHeader, this.contraBean);
                    this.voucherService.deleteGLDetailByVHId((Object)this.voucherHeader.getId());
                } else {
                    this.voucherHeader = this.voucherService.postIntoVoucherHeader(this.voucherHeader, this.voucherTypeBean);
                    this.voucherService.insertIntoRecordStatus(this.voucherHeader);
                    List instrumentList = this.instrumentService.addToInstrument(this.createInstruments(this.contraBean));
                    this.persistenceService.getSession().flush();
                    bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Integer.valueOf(this.contraBean.getAccountNumberId())});
                    Map valuesMap = this.contraService.prepareForUpdateInstrumentDeposit(bankAccount.getChartofaccounts().getGlcode());
                    this.contraService.updateCashDeposit(this.voucherHeader.getId(), bankAccount.getChartofaccounts().getGlcode(), (InstrumentHeader)instrumentList.get(0), valuesMap);
                    this.updateInstrument((InstrumentHeader)instrumentList.get(0), this.voucherHeader);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"going to post into transactions");
                }
                List transactions = this.contraService.postInTransaction(this.voucherHeader, this.contraBean);
                this.persistenceService.getSession().flush();
                Transaxtion[] txnList = new Transaxtion[transactions.size()];
                txnList = transactions.toArray(txnList);
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
                if (!this.chartOfAccounts.postTransaxtions(txnList, formatter.format(this.voucherHeader.getVoucherDate()))) {
                    ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                    errors.add(new ValidationError("exp", "Engine Validation failed"));
                    throw new ValidationException(errors);
                }
                this.contraBean.setResult("sucess");
            }
            catch (Exception e) {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", e.getMessage()));
                throw new ValidationException(errors);
            }
        }
        return "new";
    }

    private List<Map<String, Object>> createInstruments(ContraBean cBean) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();
        iMap.put("Is pay cheque", "0");
        iMap.put("Instrument type", "cash");
        iMap.put("Instrument amount", Double.valueOf(cBean.getAmount().toString()));
        Bankaccount bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Integer.valueOf(cBean.getAccountNumberId())});
        iMap.put("Bank code", bankAccount.getBankbranch().getBank().getCode());
        iMap.put("Bank branch name", bankAccount.getBankbranch().getBranchaddress1());
        iMap.put("Bank account id", bankAccount.getId());
        iMap.put("Transaction number", cBean.getChequeNumber());
        try {
            iMap.put("Transaction date", Constants.DDMMYYYYFORMAT2.parse(cBean.getChequeDate()));
        }
        catch (ParseException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("Invalid Referece Date", "invalid.date")));
        }
        iList.add(iMap);
        return iList;
    }

    private void updateInstrument(InstrumentHeader ih, CVoucherHeader vh) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> iList = new ArrayList<HashMap<String, Object>>();
        iMap.put("Instrument header", ih);
        iMap.put("Voucher header", vh);
        iList.add(iMap);
        this.instrumentService.updateInstrumentVoucherReference(iList);
    }

    public String loadCTBVoucher() {
        String vhid = ((String[])this.parameters.get("vhid"))[0];
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("voucher header id received is :" + vhid));
        }
        Map vhInfoMap = this.contraService.getCTBVoucher(vhid, this.contraBean);
        this.voucherHeader = (CVoucherHeader)vhInfoMap.get("voucherHeader");
        this.contraBean = (ContraBean)vhInfoMap.get("contrabean");
        this.loadSchemeSubscheme();
        this.loadBankAccountNumber(this.contraBean);
        if (null != this.parameters.get("showMode")) {
            this.contraBean.setMode(((String[])this.parameters.get("showMode"))[0]);
        }
        if (null != this.parameters.get("showMode") && ((String[])this.parameters.get("showMode"))[0].equalsIgnoreCase("reverse")) {
            return "reverse";
        }
        if (null != this.parameters.get("showMode") && ((String[])this.parameters.get("showMode"))[0].equalsIgnoreCase("edit")) {
            return "edit";
        }
        return "new";
    }

    private boolean validateBankTrans() {
        if (null == this.contraBean.getBankBranchId() || this.contraBean.getBankBranchId().equalsIgnoreCase("-1")) {
            this.addActionError(this.getText("contra.validate.bank"));
            return false;
        }
        if (null == this.contraBean.getAccountNumberId() || this.contraBean.getAccountNumberId().equalsIgnoreCase("-1")) {
            this.addActionError(this.getText("contra.validate.accnum"));
            return false;
        }
        if (null == this.contraBean.getAmount() || this.contraBean.getAmount().compareTo(BigDecimal.ZERO) == 0) {
            this.addActionError(this.getText("contra.validate.amt"));
            return false;
        }
        BigDecimal cashBalance = this.egovCommon.getCashBalance(this.voucherHeader.getVoucherDate(), this.contraBean.getCashInHand(), this.voucherHeader.getFundId().getId());
        if (cashBalance.compareTo(this.contraBean.getAmount()) == -1) {
            this.addActionError(this.getText("contra.validate.cashbalance1", new String[]{"" + cashBalance}));
            return false;
        }
        BigDecimal accountBalance = this.egovCommon.getAccountBalance(this.voucherHeader.getVoucherDate(), Long.valueOf(this.contraBean.getAccountNumberId()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Account balance for the bank account id : " + this.contraBean.getAccountNumberId() + " is :" + accountBalance));
        }
        this.contraBean.setAccountBalance(accountBalance);
        return true;
    }

    public ContraService getContraService() {
        return this.contraService;
    }

    public void setContraService(ContraService contraService) {
        this.contraService = contraService;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public ContraBean getContraBean() {
        return this.contraBean;
    }

    public void setContraBean(ContraBean contraBean) {
        this.contraBean = contraBean;
    }

    public VoucherTypeBean getVoucherTypeBean() {
        return this.voucherTypeBean;
    }

    public void setVoucherTypeBean(VoucherTypeBean voucherTypeBean) {
        this.voucherTypeBean = voucherTypeBean;
    }

    public EgovCommon getEgovCommon() {
        return this.egovCommon;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public String getReversalVoucherDate() {
        return super.getReversalVoucherDate();
    }

    public String getReversalVoucherNumber() {
        return super.getReversalVoucherNumber();
    }

    public void setReversalVoucherDate(String reversalVoucherDate) {
        super.setReversalVoucherDate(reversalVoucherDate);
    }

    public String reverse() {
        super.saveReverse("CashToBank", "Contra");
        return "new";
    }

    public String reverseAndView() {
        super.saveReverse("CashToBank", "Contra");
        this.setMessage(this.getText("transaction.success") + this.voucherHeader.getVoucherNumber());
        return "view";
    }

    public String reverseAndClose() {
        super.saveReverse("CashToBank", "Contra");
        this.setClose(true);
        this.setMessage(this.getText("transaction.success") + this.voucherHeader.getVoucherNumber());
        return "view";
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}

