/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.contra;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.Transaxtion;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Bankaccount;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Vouchermis;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.voucher.BaseVoucherAction;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.contra.ContraBean;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.services.cheque.ChequeService;
import org.egov.services.instrument.InstrumentService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"view"}, location="contraBTC-view.jsp"), @Result(name={"new"}, location="contraBTC-new.jsp"), @Result(name={"availableBalance"}, location="contraBTC-availableBalance.jsp")})
public class ContraBTCAction
extends BaseVoucherAction {
    private static final long serialVersionUID = 8307131392372518372L;
    private static final String SOURCEPATH = "/EGF/contra/contraBTC!view.action?voucherHeader.id=";
    private ContraBean contraBean = new ContraBean();
    private EgovCommon egovCommon;
    private InstrumentService instrumentService;
    private static final String EXCEPTION_WHILE_SAVING_DATA = "Exception while saving Data";
    private static final String TRANSACTION_FAILED = "Transaction failed";
    @Autowired
    @Qualifier(value="contraJournalVoucherService")
    private PersistenceService<ContraJournalVoucher, Long> contraJournalVoucherService;
    private static final Logger LOGGER = Logger.getLogger(ContraBTCAction.class);
    private BigDecimal availableBalance = BigDecimal.ZERO;
    private boolean close = false;
    private String message = "";
    private Date reverseVoucherDate;
    private String reverseVoucherNumber;
    public PersistenceService<InstrumentHeader, Long> instrumentHeaderService;
    private VoucherService voucherService;
    InstrumentHeader instrumentHeader = null;
    private ChequeService chequeService;
    private String showMode;
    private String saveType;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    CreateVoucher createVoucher;
    @Autowired
    private ChartOfAccounts chartOfAccounts;

    public void prepare() {
        super.prepare();
        this.contraBean.setModeOfCollection("");
        this.voucherHeader.setName("BankToCash");
        this.voucherHeader.setType("Contra");
        this.addDropdownData("bankList", this.egovCommon.getBankBranchForActiveBanks());
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.setCashInHandAccount();
        this.loadSchemeSubscheme();
        this.loadBankAccountNumber(this.contraBean);
    }

    private void setCashInHandAccount() {
        Map boundaryMap = this.egovCommon.getCashChequeInfoForBoundary();
        this.addDropdownData("boundaryLevelList", (List)boundaryMap.get("listBndryLvl"));
        this.contraBean.setCashInHand(boundaryMap.get("cashInHand") != null ? boundaryMap.get("cashInHand").toString() : null);
    }

    @Action(value="/contra/contraBTC-create")
    public String create() {
        if (this.validateInputData()) {
            List instrumentList = new ArrayList();
            try {
                if (!this.showChequeNumber()) {
                    Bankaccount bankAccount = this.getBank(Integer.valueOf(this.contraBean.getAccountNumberId()));
                    this.contraBean.setChequeNumber(this.chequeService.nextChequeNumber(bankAccount.getId().toString(), 1, this.getVouchermis().getDepartmentid().getId().intValue()));
                }
                instrumentList = this.instrumentService.addToInstrument(this.createInstruments(this.contraBean));
                this.voucherHeader = this.createVoucher(this.voucherHeader);
                this.persistenceService.getSession().flush();
                this.updateInstrumentVoucherReference(instrumentList);
                this.saveContraJournalVoucher((InstrumentHeader)instrumentList.get(0), this.voucherHeader);
                this.addActionMessage(this.getText("transaction.success") + this.voucherHeader.getVoucherNumber());
                if (this.saveType.equals("saveAndClose")) {
                    return this.saveAndClose();
                }
                if (this.saveType.equals("saveAndView")) {
                    return this.saveAndView();
                }
                if (this.saveType.equals("saveAndNew")) {
                    return this.saveAndNew();
                }
                return "new";
            }
            catch (ValidationException e) {
                LOGGER.error((Object)("Validation error" + e.getMessage()), (Throwable)e);
                this.addActionMessage(this.getText(((ValidationError)e.getErrors().get(0)).getMessage()));
                return "new";
            }
        }
        return "new";
    }

    public String saveAndView() {
        this.message = this.getText("transaction.success") + this.voucherHeader.getVoucherNumber();
        return "view";
    }

    public String saveAndClose() {
        this.setClose(true);
        this.message = this.getText("transaction.success") + this.voucherHeader.getVoucherNumber();
        return "view";
    }

    public String saveAndNew() {
        this.contraBean = new ContraBean();
        this.setCashInHandAccount();
        this.voucherHeader = new CVoucherHeader();
        return "new";
    }

    @Action(value="/contra/contraBTC-view")
    public String view() {
        if (this.voucherHeader != null && this.voucherHeader.getId() != null) {
            this.populateData();
            this.loadSchemeSubscheme();
        }
        return "view";
    }

    private void populateData() {
        this.voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{this.voucherHeader.getId()});
        ContraJournalVoucher contraVoucher = (ContraJournalVoucher)this.persistenceService.find("from ContraJournalVoucher where voucherHeaderId.id=?", new Object[]{this.voucherHeader.getId()});
        this.contraBean.setAccountNumberId(contraVoucher.getFromBankAccountId().getId().toString());
        String fromBankAndBranchId = contraVoucher.getFromBankAccountId().getBankbranch().getBank().getId().toString() + "-" + contraVoucher.getFromBankAccountId().getBankbranch().getId().toString();
        this.contraBean.setBankBranchId(fromBankAndBranchId);
        this.loadBankAccountNumber(this.contraBean);
        InstrumentHeader instrumentHeader = contraVoucher.getInstrumentHeaderId();
        this.contraBean.setChequeNumber(instrumentHeader.getInstrumentNumber());
        String chequeDate = Constants.DDMMYYYYFORMAT2.format(instrumentHeader.getInstrumentDate());
        this.contraBean.setChequeDate(chequeDate);
        BigDecimal instrumentAmount = instrumentHeader.getInstrumentAmount();
        this.contraBean.setAmount(instrumentAmount == null ? BigDecimal.ZERO.setScale(2) : instrumentAmount.setScale(2));
    }

    private void updateInstrumentVoucherReference(List<InstrumentHeader> instrumentList) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> iList = new ArrayList<HashMap<String, Object>>();
        iMap.put("Instrument header", instrumentList.get(0));
        iMap.put("Voucher header", this.voucherHeader);
        iList.add(iMap);
        this.instrumentService.updateInstrumentVoucherReference(iList);
    }

    boolean validateInputData() {
        if (null == this.contraBean.getBankBranchId() || this.contraBean.getBankBranchId().equalsIgnoreCase("-1")) {
            this.addActionError(this.getText("contra.validate.bank"));
            return false;
        }
        if (null == this.contraBean.getAccountNumberId() || this.contraBean.getAccountNumberId().equalsIgnoreCase("-1")) {
            this.addActionError(this.getText("contra.validate.accnum"));
            return false;
        }
        if (null == this.contraBean.getAmount() || this.contraBean.getAmount().compareTo(BigDecimal.ZERO) == 0) {
            this.addActionError(this.getText("contra.validate.amt"));
            return false;
        }
        if (this.showChequeNumber() && (null == this.contraBean.getChequeDate() || this.contraBean.getChequeNumber() == null || !this.validateChequeNumber())) {
            this.addActionError(this.getText("contra.invalid.cheque.number"));
            return false;
        }
        if (this.shouldShowHeaderField("vouchernumber") && StringUtils.isBlank((String)this.voucherHeader.getVoucherNumber())) {
            this.addActionError(this.getText("contra.invalid.voucher.number"));
            return false;
        }
        if (this.shouldShowHeaderField("vouchernumber") && this.voucherHeader.getVoucherDate().compareTo(new Date()) >= 1) {
            this.addActionError(this.getText("contra.invalid.voucher.date"));
            return false;
        }
        BigDecimal cashBalance = this.getCashBalance();
        if (cashBalance.compareTo(this.contraBean.getAmount()) == -1 && this.isBankBalanceMandatory()) {
            this.addActionError(this.getText("contra.insufficient.bankbalance", new String[]{"" + cashBalance}));
            return false;
        }
        this.contraBean.setAccountBalance(cashBalance);
        return true;
    }

    protected BigDecimal getCashBalance() {
        BigDecimal accountBalance;
        try {
            accountBalance = this.egovCommon.getAccountBalance(this.voucherHeader.getVoucherDate(), Long.valueOf(this.contraBean.getAccountNumberId()));
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Error in retriving" + e.getMessage()), (Throwable)e);
            accountBalance = BigDecimal.valueOf(-1L);
        }
        return accountBalance;
    }

    private boolean validateChequeNumber() {
        if (this.instrumentHeader == null && !this.instrumentService.isChequeNumberValid(this.contraBean.getChequeNumber(), Long.valueOf(Long.parseLong(this.contraBean.getAccountNumberId())), Integer.valueOf(this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()), null)) {
            return false;
        }
        return this.instrumentHeader == null || this.contraBean.getChequeNumber().equalsIgnoreCase(this.instrumentHeader.getInstrumentNumber()) || this.instrumentService.isChequeNumberValid(this.contraBean.getChequeNumber(), Long.valueOf(Long.parseLong(this.contraBean.getAccountNumberId())), Integer.valueOf(this.voucherHeader.getVouchermis().getDepartmentid().getId().intValue()), null);
    }

    public String execute() throws Exception {
        return "new";
    }

    @Action(value="/contra/contraBTC-newForm")
    public String newForm() throws Exception {
        return "new";
    }

    public Vouchermis getVouchermis() {
        return this.voucherHeader.getVouchermis();
    }

    public void setVouchermis(Vouchermis vouchermis) {
        this.voucherHeader.setVouchermis(vouchermis);
    }

    public void setContraBean(ContraBean contraBean) {
        this.contraBean = contraBean;
    }

    public ContraBean getContraBean() {
        return this.contraBean;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    private List<Map<String, Object>> createInstruments(ContraBean cBean) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> iList = new ArrayList<Map<String, Object>>();
        if (!this.showChequeNumber()) {
            Bankaccount bankAccount = this.getBank(Integer.valueOf(this.contraBean.getAccountNumberId()));
            cBean.setChequeNumber(this.chequeService.nextChequeNumber(bankAccount.getId().toString(), 1, this.getVouchermis().getDepartmentid().getId().intValue()));
        }
        iMap.put("Instrument number", cBean.getChequeNumber());
        Date dt = null;
        try {
            dt = Constants.DDMMYYYYFORMAT2.parse(this.contraBean.getChequeDate());
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Parse Error" + e.getMessage()), (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        iMap.put("Instrument date", dt);
        iMap.put("Instrument amount", Double.valueOf(cBean.getAmount().toString()));
        iMap.put("Instrument type", "cheque");
        Bankaccount bankAccount = this.getBank(Integer.valueOf(cBean.getAccountNumberId()));
        iMap.put("Bank code", bankAccount.getBankbranch().getBank().getCode());
        iMap.put("Bank branch name", bankAccount.getBankbranch().getBranchaddress1());
        iMap.put("Bank account id", bankAccount.getId());
        iMap.put("Is pay cheque", "1");
        iList.add(iMap);
        return iList;
    }

    private Bankaccount getBank(Integer id) {
        return (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{id});
    }

    ContraJournalVoucher saveContraJournalVoucher(InstrumentHeader instrumentHeader, CVoucherHeader vh) {
        ContraJournalVoucher cjv = new ContraJournalVoucher();
        cjv.setInstrumentHeaderId(instrumentHeader);
        cjv.setVoucherHeaderId(vh);
        Bankaccount bankAccount = this.getBank(Integer.valueOf(this.contraBean.getAccountNumberId()));
        cjv.setFromBankAccountId(bankAccount);
        cjv.setToBankAccountId(this.getCashBankAccount());
        this.contraJournalVoucherService.persist((Object)cjv);
        return cjv;
    }

    public void setInstrumentService(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }

    Bankaccount getCashBankAccount() {
        return (Bankaccount)this.persistenceService.find("from Bankaccount where chartofaccounts.glcode=?", new Object[]{this.contraBean.getCashInHand()});
    }

    @Action(value="/contra/contraBTC-ajaxAvailableBalance")
    public String ajaxAvailableBalance() {
        if (((String[])this.parameters.get("accountNumberId"))[0] != null && !"-1".equals(((String[])this.parameters.get("accountNumberId"))[0]) && this.voucherHeader.getVoucherDate() != null) {
            try {
                this.availableBalance = this.egovCommon.getAccountBalance(this.voucherHeader.getVoucherDate(), Long.valueOf(((String[])this.parameters.get("accountNumberId"))[0]));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error in retriving balance" + e.getMessage()), (Throwable)e);
                this.availableBalance = BigDecimal.valueOf(-1L);
            }
        }
        return "availableBalance";
    }

    public void setAvailableBalance(BigDecimal availableBalance) {
        this.availableBalance = availableBalance;
    }

    public BigDecimal getAvailableBalance() {
        return this.availableBalance;
    }

    private CVoucherHeader createVoucher(CVoucherHeader voucher) {
        try {
            HashMap headerDetails = this.createHeaderAndMisDetails();
            headerDetails.put("sourcepath", SOURCEPATH);
            ArrayList subledgerDetails = new ArrayList();
            List accountdetails = this.populateAccountDetails();
            this.voucherHeader = this.createVoucher(headerDetails, subledgerDetails, accountdetails);
            this.voucherHeader.getVouchermis().setSourcePath(SOURCEPATH + this.voucherHeader.getId());
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return this.voucherHeader;
    }

    CVoucherHeader createVoucher(HashMap<String, Object> headerDetails, List<HashMap<String, Object>> subledgerDetails, List<HashMap<String, Object>> accountdetails) {
        return this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerDetails);
    }

    private List<HashMap<String, Object>> populateAccountDetails() {
        Bankaccount bankAccount = this.getBank(Integer.valueOf(this.contraBean.getAccountNumberId()));
        ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
        accountdetails.add(this.populateDetailMap(this.contraBean.getCashInHand(), BigDecimal.ZERO, this.contraBean.getAmount()));
        accountdetails.add(this.populateDetailMap(bankAccount.getChartofaccounts().getGlcode(), this.contraBean.getAmount(), BigDecimal.ZERO));
        return accountdetails;
    }

    HashMap<String, Object> populateDetailMap(String glCode, BigDecimal creditAmount, BigDecimal debitAmount) {
        HashMap<String, Object> detailMap = new HashMap<String, Object>();
        detailMap.put("creditamount", creditAmount.toString());
        detailMap.put("debitamount", debitAmount.toString());
        detailMap.put("glcode", glCode);
        return detailMap;
    }

    public boolean shouldShowHeaderField(String field) {
        return super.shouldShowHeaderField(field);
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String reverseAndView() {
        this.saveReverse();
        this.message = this.getText("transaction.success") + this.voucherHeader.getVoucherNumber();
        return "view";
    }

    public String reverseAndClose() {
        this.saveReverse();
        this.close = true;
        this.message = this.getText("transaction.success") + this.voucherHeader.getVoucherNumber();
        return "view";
    }

    public String reverse() {
        if (this.voucherHeader != null && this.voucherHeader.getId() != null) {
            this.populateData();
        }
        return "reverse";
    }

    public String saveReverse() {
        CVoucherHeader reversalVoucher = null;
        HashMap<String, Object> reversalVoucherMap = new HashMap<String, Object>();
        reversalVoucherMap.put("Original voucher header id", this.voucherHeader.getId());
        reversalVoucherMap.put("Reversal voucher type", "Contra");
        reversalVoucherMap.put("Reversal voucher name", "BankToCash");
        reversalVoucherMap.put("Reversal voucher date", this.reverseVoucherDate);
        reversalVoucherMap.put("Reversal voucher number", this.reverseVoucherNumber);
        ArrayList<HashMap<String, Object>> reversalList = new ArrayList<HashMap<String, Object>>();
        reversalList.add(reversalVoucherMap);
        try {
            reversalVoucher = this.createVoucher.reverseVoucher(reversalList);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.addActionError(this.getText(((ValidationError)e.getErrors().get(0)).getMessage()));
            return "reverse";
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.addActionError(this.getText(e.getMessage()));
            return "reverse";
        }
        catch (ParseException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError("Date is not in proper Format", "Date is not in proper Format")));
        }
        this.addActionMessage(this.getText("transaction.success") + reversalVoucher.getVoucherNumber());
        this.voucherHeader = reversalVoucher;
        return "view";
    }

    public void setReverseVoucherDate(Date reversalVoucherDate) {
        this.reverseVoucherDate = reversalVoucherDate;
    }

    public Date getReverseVoucherDate() {
        return this.reverseVoucherDate;
    }

    public void setReverseVoucherNumber(String reverseVoucherNumber) {
        this.reverseVoucherNumber = reverseVoucherNumber;
    }

    public String getReverseVoucherNumber() {
        return this.reverseVoucherNumber;
    }

    @Action(value="/contra/contraBTC-redirect")
    public String redirect() {
        this.showMode = ((String[])this.parameters.get("showMode"))[0];
        if (this.showMode == null || StringUtils.isBlank((String)this.showMode) || this.voucherHeader == null || this.voucherHeader.getId() == null) {
            return "view";
        }
        this.populateData();
        return this.showMode;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    @Action(value="/contra/contraBTC-edit")
    public String edit() {
        ContraJournalVoucher contraVoucher = (ContraJournalVoucher)this.persistenceService.find("from ContraJournalVoucher where voucherHeaderId.id=?", new Object[]{this.voucherHeader.getId()});
        this.instrumentHeader = contraVoucher.getInstrumentHeaderId();
        if (this.validateInputData()) {
            try {
                CVoucherHeader oldVoucher = this.voucherService.updateVoucherHeader(this.voucherHeader, "Contra");
                InstrumentVoucher instrumentVoucher = (InstrumentVoucher)this.persistenceService.find("from InstrumentVoucher where voucherHeaderId.id=?", new Object[]{oldVoucher.getId()});
                if (instrumentVoucher == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError(" System Error :Instrument is not linked with voucher", "")));
                }
                InstrumentHeader oldInstrumentHeader = instrumentVoucher.getInstrumentHeaderId();
                this.instrumentService.cancelInstrument(oldInstrumentHeader);
                this.persistenceService.getSession().flush();
                List instrument = this.instrumentService.addToInstrument(this.createInstruments(this.contraBean));
                this.persistenceService.getSession().flush();
                contraVoucher.setFromBankAccountId(this.getBank(Integer.valueOf(this.contraBean.getAccountNumberId())));
                contraVoucher.setInstrumentHeaderId((InstrumentHeader)instrument.get(0));
                this.contraJournalVoucherService.persist((Object)contraVoucher);
                this.createLedgerAndPost(oldVoucher);
                this.addActionMessage(this.getText("transaction.success") + oldVoucher.getVoucherNumber());
                return "view";
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", e.getMessage()));
                throw new ValidationException(errors);
            }
        }
        return "edit";
    }

    void createLedgerAndPost(CVoucherHeader voucher) {
        try {
            this.createVoucher.deleteVoucherdetailAndGL(voucher);
            this.persistenceService.getSession().flush();
            ArrayList<HashMap> accountdetails = new ArrayList<HashMap>();
            ArrayList subledgerDetails = new ArrayList();
            Bankaccount bankAccount = this.getBank(Integer.valueOf(this.contraBean.getAccountNumberId()));
            accountdetails.add(this.populateDetailMap(this.contraBean.getCashInHand(), this.contraBean.getAmount(), BigDecimal.ZERO));
            accountdetails.add(this.populateDetailMap(bankAccount.getChartofaccounts().getGlcode(), BigDecimal.ZERO, this.contraBean.getAmount()));
            List transactions = this.createVoucher.createTransaction(null, accountdetails, subledgerDetails, voucher);
            this.persistenceService.getSession().flush();
            Transaxtion[] txnList = new Transaxtion[transactions.size()];
            txnList = transactions.toArray(txnList);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            if (!this.chartOfAccounts.postTransaxtions(txnList, formatter.format(this.voucherHeader.getVoucherDate()))) {
                throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
            }
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (SQLException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(EXCEPTION_WHILE_SAVING_DATA, TRANSACTION_FAILED)));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    public void modifyInstrument(InstrumentHeader ih, CVoucherHeader vh) {
        HashMap<String, Object> iMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> iList = new ArrayList<HashMap<String, Object>>();
        iMap.put("Instrument header", ih);
        iMap.put("Voucher header", vh);
        iList.add(iMap);
        this.instrumentService.modifyInstrumentVoucher(iList);
    }

    public boolean showChequeNumber() {
        return this.egovCommon.isShowChequeNumber();
    }

    public void setChequeService(ChequeService chequeService) {
        this.chequeService = chequeService;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public String getSaveType() {
        return this.saveType;
    }

    public void setSaveType(String saveType) {
        this.saveType = saveType;
    }
}

