/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.model.BudgetReAppropriationView;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.budget.BudgetReAppropriation;
import org.egov.model.budget.BudgetReAppropriationMisc;
import org.egov.pims.commons.Position;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetReAppropriationService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetDetailConfig;
import org.egov.utils.BudgetDetailHelper;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="budgetReAppropriation-new.jsp"), @Result(name={"search"}, location="budgetReAppropriation-search.jsp"), @Result(name={"beRe"}, location="budgetReAppropriation-beRe.jsp")})
public class BudgetReAppropriationAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final String BERE = "beRe";
    private static final Logger LOGGER = Logger.getLogger(BudgetReAppropriationAction.class);
    private List<BudgetReAppropriationView> budgetReAppropriationList = new ArrayList();
    private List<BudgetReAppropriationView> newBudgetReAppropriationList = new ArrayList();
    @Autowired
    protected BudgetDetailConfig budgetDetailConfig;
    private BudgetDetail budgetDetail;
    protected Budget budget;
    protected List<String> headerFields = new ArrayList();
    protected List<String> gridFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    @Autowired
    private BudgetDetailHelper budgetDetailHelper;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    @Qualifier(value="budgetService")
    private BudgetService budgetService;
    @Autowired
    @Qualifier(value="budgetDetailService")
    private BudgetDetailService budgetDetailService;
    @Autowired
    @Qualifier(value="budgetReAppropriationService")
    private BudgetReAppropriationService budgetReAppropriationService;
    @Autowired
    @Qualifier(value="workflowService")
    private WorkflowService<BudgetReAppropriation> budgetReAppropriationWorkflowService;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    private CFinancialYear financialYear;
    private String beRe = "BE";
    private String sequenceNumber;
    private BudgetReAppropriationMisc appropriationMisc = new BudgetReAppropriationMisc();
    private List<BudgetReAppropriation> reAppropriationList = null;
    private String type = "";
    private String finalStatus = "";
    private static final String ACTIONNAME = "actionName";
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    private String message = "";

    public BudgetReAppropriationMisc getAppropriationMisc() {
        return this.appropriationMisc;
    }

    public void setAppropriationMisc(BudgetReAppropriationMisc appropriationMisc) {
        this.appropriationMisc = appropriationMisc;
    }

    public String getBeRe() {
        return this.beRe;
    }

    public void setBudgetReAppropriationService(BudgetReAppropriationService budgetReAppropriationService) {
        this.budgetReAppropriationService = budgetReAppropriationService;
    }

    public void setBeRe(String beRe) {
        this.beRe = beRe;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setBudgetDetailHelper(BudgetDetailHelper budgetDetailHelper) {
        this.budgetDetailHelper = budgetDetailHelper;
    }

    public List<BudgetReAppropriationView> getNewBudgetReAppropriationList() {
        return this.newBudgetReAppropriationList;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }

    public void setBudgetDetail(BudgetDetail budgetDetail) {
        this.budgetDetail = budgetDetail;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public List<BudgetReAppropriationView> getBudgetReAppropriationList() {
        return this.budgetReAppropriationList;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public List<String> getGridFields() {
        return this.gridFields;
    }

    public List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    protected void setupDropdownsInHeader() {
        this.setupDropdownDataExcluding(new String[]{"subScheme"});
        this.finalStatus = this.getFinalStatus();
        this.dropdownData.put("financialYearList", this.getFinancialYearDropDown());
        if (this.financialYear != null && this.financialYear.getId() != 0L) {
            this.dropdownData.put("budgetList", this.getApprovedBudgetsForFY(this.financialYear.getId(), this.finalStatus));
        } else {
            this.dropdownData.put("budgetList", Collections.EMPTY_LIST);
        }
        this.dropdownData.put("budgetGroupList", this.persistenceService.findAllBy("from BudgetGroup where isActive=true order by name", new Object[0]));
        if (this.shouldShowField("subScheme")) {
            this.dropdownData.put("subSchemeList", Collections.EMPTY_LIST);
        }
        if (this.shouldShowField("functionary")) {
            this.dropdownData.put("functionaryList", this.masterDataCache.get("egi-functionary"));
        }
        if (this.shouldShowField("function")) {
            this.dropdownData.put("functionList", this.masterDataCache.get("egi-function"));
        }
        if (this.shouldShowField("scheme")) {
            this.dropdownData.put("schemeList", this.persistenceService.findAllBy("from Scheme where isActive=true order by name", new Object[0]));
        }
        if (this.shouldShowField("executingDepartment")) {
            this.dropdownData.put("executingDepartmentList", this.masterDataCache.get("egi-department"));
        }
        if (this.shouldShowField("fund")) {
            this.dropdownData.put("fundList", this.persistenceService.findAllBy("from Fund where isNotLeaf=false and isActive=true order by name", new Object[0]));
        }
        if (this.shouldShowField("boundary")) {
            this.dropdownData.put("boundaryList", this.persistenceService.findAllBy("from Boundary order by name", new Object[0]));
        }
        this.dropdownData.put("finYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
    }

    public final boolean shouldShowField(String fieldName) {
        if (this.headerFields.isEmpty() && this.gridFields.isEmpty()) {
            return true;
        }
        return this.budgetDetailConfig.shouldShowField(this.headerFields, fieldName) || this.budgetDetailConfig.shouldShowField(this.gridFields, fieldName);
    }

    public boolean shouldShowHeaderField(String fieldName) {
        return this.budgetDetailConfig.shouldShowField(this.headerFields, fieldName);
    }

    public boolean shouldShowGridField(String fieldName) {
        return this.budgetDetailConfig.shouldShowField(this.gridFields, fieldName);
    }

    public String execute() throws Exception {
        return "new";
    }

    public void prepare() {
        super.prepare();
        this.headerFields = this.budgetDetailConfig.getHeaderFields();
        this.gridFields = this.budgetDetailConfig.getGridFields();
        this.mandatoryFields = this.budgetDetailConfig.getMandatoryFields();
        this.addRelatedEntity("budgetGroup", BudgetGroup.class);
        this.addRelatedEntity("budget", Budget.class);
        if (this.shouldShowField("functionary")) {
            this.addRelatedEntity("functionary", Functionary.class);
        }
        if (this.shouldShowField("function")) {
            this.addRelatedEntity("function", CFunction.class);
        }
        if (this.shouldShowField("scheme")) {
            this.addRelatedEntity("scheme", Scheme.class);
        }
        if (this.shouldShowField("subScheme")) {
            this.addRelatedEntity("subScheme", SubScheme.class);
        }
        if (this.shouldShowField("fund")) {
            this.addRelatedEntity("fund", Fund.class);
        }
        if (this.shouldShowField("executingDepartment")) {
            this.addRelatedEntity("executingDepartment", Department.class);
        }
        if (this.shouldShowField("boundary")) {
            this.addRelatedEntity("boundary", Boundary.class);
        }
        this.appropriationMisc.setReAppropriationDate(new Date());
        if (this.financialYear != null && this.financialYear.getId() != 0L && this.budgetService.hasApprovedReForYear(this.financialYear.getId())) {
            this.beRe = "RE";
        }
        this.setupDropdownsInHeader();
        this.dropdownData.put("departmentList", this.masterDataCache.get("egi-department"));
        this.dropdownData.put("designationList", Collections.EMPTY_LIST);
        this.dropdownData.put("userList", Collections.EMPTY_LIST);
    }

    public Object getModel() {
        return this.budgetDetail;
    }

    @Action(value="/budget/budgetReAppropriation-create")
    public String create() {
        this.save(Integer.valueOf(ApplicationThreadLocals.getUserId().intValue()));
        return "new";
    }

    @Action(value="/budget/budgetReAppropriation-createAndForward")
    public String createAndForward() {
        BudgetReAppropriationMisc misc = this.save(this.getUserId());
        this.addActionMessage(this.getText("budget.reapp.approved.end"));
        this.clearFields();
        return "new";
    }

    private void clearFields() {
        this.budgetDetail = new BudgetDetail();
        this.budgetReAppropriationList = new ArrayList();
        this.newBudgetReAppropriationList = new ArrayList();
    }

    private BudgetReAppropriationMisc save(Integer userId) {
        boolean reAppropriationCreated = false;
        boolean reAppForNewBudgetCreated = false;
        BudgetReAppropriationMisc misc = null;
        if (this.financialYear != null && this.financialYear.getId() != 0L) {
            this.financialYear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{this.financialYear.getId()});
        }
        try {
            misc = this.budgetReAppropriationService.createBudgetReAppropriationMisc(((String[])this.parameters.get(ACTIONNAME))[0] + "|" + userId, this.beRe, this.financialYear, this.appropriationMisc, this.getPosition());
            this.removeEmptyReAppropriation(this.budgetReAppropriationList);
            reAppropriationCreated = this.budgetReAppropriationService.createReAppropriation(((String[])this.parameters.get(ACTIONNAME))[0] + "|" + userId, this.budgetReAppropriationList, this.getPosition(), this.financialYear, this.beRe, misc, ((String[])this.parameters.get("appropriationMisc.reAppropriationDate"))[0]);
            this.removeEmptyReAppropriation(this.newBudgetReAppropriationList);
            reAppForNewBudgetCreated = this.budgetReAppropriationService.createReAppropriationForNewBudgetDetail(((String[])this.parameters.get(ACTIONNAME))[0] + "|" + userId, this.newBudgetReAppropriationList, this.getPosition(), misc);
            if (!reAppropriationCreated && !reAppForNewBudgetCreated) {
                throw new ValidationException(Arrays.asList(new ValidationError("budgetDetail.budgetGroup.mandatory", "budgetDetail.budgetGroup.mandatory")));
            }
            this.newBudgetReAppropriationList.clear();
            this.budgetReAppropriationList.clear();
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        if (reAppropriationCreated) {
            this.addActionMessage(this.getText("budget.reappropriation.existing.saved") + misc.getSequenceNumber());
        }
        if (reAppForNewBudgetCreated) {
            this.addActionMessage(this.getText("budget.reappropriation.new.saved") + misc.getSequenceNumber());
        }
        this.clearFields();
        return misc;
    }

    private Integer getUserId() {
        Integer userId = null;
        userId = null != this.parameters.get("approverUserId") && Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue());
        return userId;
    }

    protected BudgetReAppropriationMisc createBudgetReAppropriationMisc(String actionName) {
        Budget budget = new Budget();
        budget.setIsbere(this.beRe);
        budget.setFinancialYear(this.financialYear);
        BudgetDetail budgetDetail = new BudgetDetail();
        budgetDetail.setBudget(budget);
        return this.budgetReAppropriationService.createReAppropriationMisc(actionName, this.appropriationMisc, budgetDetail, this.getPosition());
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    protected Position getPosition() {
        try {
            return this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("Do transaction with proper user", "Do transaction with proper user")));
        }
    }

    public void removeEmptyReAppropriation(List<BudgetReAppropriationView> reAppropriationList) {
        Iterator<BudgetReAppropriationView> detail = reAppropriationList.iterator();
        while (detail.hasNext()) {
            if (detail.next() != null) continue;
            detail.remove();
        }
    }

    protected String getFinalStatus() {
        return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budget_final_approval_status").get(0)).getValue();
    }

    @ValidationErrorPage(value="new")
    @Action(value="/budget/budgetReAppropriation-loadActuals")
    public String loadActuals() {
        this.removeEmptyReAppropriation(this.budgetReAppropriationList);
        this.removeEmptyReAppropriation(this.newBudgetReAppropriationList);
        if (this.budgetReAppropriationService.rowsToAddForExistingDetails(this.budgetReAppropriationList)) {
            this.loadData(this.budgetReAppropriationList);
        }
        if (this.budgetReAppropriationService.rowsToAddExists(this.newBudgetReAppropriationList)) {
            this.loadData(this.newBudgetReAppropriationList);
        }
        return "new";
    }

    private void loadData(List<BudgetReAppropriationView> reAppList) {
        this.budgetReAppropriationService.validateMandatoryFields(reAppList);
        for (BudgetReAppropriationView entry : reAppList) {
            entry.setBudgetDetail(this.budgetReAppropriationService.setRelatedValues(entry.getBudgetDetail()));
            List detailList = this.budgetDetailService.searchByCriteriaWithTypeAndFY(this.financialYear.getId(), this.beRe, entry.getBudgetDetail());
            if (detailList.size() != 1) continue;
            BudgetDetail budgetDetail = (BudgetDetail)detailList.get(0);
            Map paramMap = this.budgetDetailHelper.constructParamMap(this.getValueStack(), budgetDetail);
            paramMap.put("asondate", this.appropriationMisc.getReAppropriationDate());
            entry.setActuals(this.budgetDetailHelper.getTotalActualsFor(paramMap, this.appropriationMisc.getReAppropriationDate()));
            entry.setApprovedAmount(budgetDetail.getApprovedAmount());
            entry.setAppropriatedAmount(budgetDetail.getApprovedReAppropriationsTotal());
            entry.setAvailableAmount(entry.getApprovedAmount().add(entry.getAppropriatedAmount()).subtract(entry.getActuals()));
            if (budgetDetail.getPlanningPercent() == null) {
                entry.setPlanningPercent(BigDecimal.ZERO);
            } else {
                entry.setPlanningPercent(budgetDetail.getPlanningPercent());
            }
            if (budgetDetail.getPlanningPercent() == BigDecimal.ZERO) {
                entry.setPlanningBudgetApproved(entry.getApprovedAmount().add(entry.getAppropriatedAmount()));
            } else {
                entry.setPlanningBudgetApproved(entry.getApprovedAmount().add(entry.getAppropriatedAmount()).multiply(entry.getPlanningPercent()).divide(new BigDecimal(String.valueOf(100))));
            }
            entry.setPlanningBudgetUsage(this.budgetDetailsDAO.getPlanningBudgetUsage(budgetDetail));
            entry.setPlanningBudgetAvailable(entry.getPlanningBudgetApproved().subtract(entry.getPlanningBudgetUsage()));
        }
    }

    @Action(value="/budget/budgetReAppropriation-ajaxLoadBeRe")
    public String ajaxLoadBeRe() {
        if (this.parameters.get("id") != null) {
            Long id = Long.valueOf(((String[])this.parameters.get("id"))[0]);
            this.beRe = id != 0L && this.budgetService.hasApprovedReForYear(id) ? "RE" : "BE";
            this.dropdownData.put("budgetList", this.getApprovedBudgetsForFY(id, this.finalStatus));
        }
        return BERE;
    }

    protected ValueStack getValueStack() {
        return ActionContext.getContext().getValueStack();
    }

    List getFinancialYearDropDown() {
        List ids = new ArrayList();
        ids = this.persistenceService.findAllBy("select distinct financialYear.id from Budget where isActiveBudget=true and isPrimaryBudget=true and status.code='Approved'", new Object[0]);
        if (!ids.isEmpty()) {
            Query query = this.persistenceService.getSession().createQuery("from CFinancialYear where id in (:ids) order by finYearRange desc").setParameterList("ids", ids);
            return query.list();
        }
        return new ArrayList();
    }

    protected List getApprovedBudgetsForFY(Long id, String finalStatus) {
        if (id != null && id != 0L) {
            return this.budgetService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = true and status.moduletype='BUDGET' and status.code='" + finalStatus + "' and financialYear.id=? and isbere=? order by name", new Object[]{id, this.beRe});
        }
        return new ArrayList();
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    @Action(value="/budget/budgetReAppropriation-beforeSearch")
    public String beforeSearch() {
        return "search";
    }

    @SkipValidation
    @Action(value="/budget/budgetReAppropriation-search")
    public String search() {
        String sql = " ba.budgetDetail.budget.financialYear=" + this.financialYear.getId() + " and ba.budgetDetail.budget.isbere='" + this.budgetDetail.getBudget().getIsbere() + "' ";
        if (this.budgetDetail.getFund().getId() != null && this.budgetDetail.getFund().getId() != 0) {
            sql = sql + " and ba.budgetDetail.fund=" + this.budgetDetail.getFund().getId();
        }
        if (this.budgetDetail.getExecutingDepartment() != null && this.budgetDetail.getExecutingDepartment().getId() != 0L) {
            sql = sql + " and ba.budgetDetail.executingDepartment=" + this.budgetDetail.getExecutingDepartment().getId();
        }
        if (this.budgetDetail.getFunction() != null && this.budgetDetail.getFunction().getId() != 0L) {
            sql = sql + " and ba.budgetDetail.function=" + this.budgetDetail.getFunction().getId();
        }
        if (this.budgetDetail.getFunctionary() != null && this.budgetDetail.getFunctionary().getId() != 0) {
            sql = sql + " and ba.budgetDetail.functionary=" + this.budgetDetail.getFunctionary().getId();
        }
        if (this.budgetDetail.getScheme() != null && this.budgetDetail.getScheme().getId() != 0) {
            sql = sql + " and ba.budgetDetail.scheme=" + this.budgetDetail.getScheme().getId();
        }
        if (this.budgetDetail.getSubScheme() != null && this.budgetDetail.getSubScheme().getId() != 0) {
            sql = sql + " and ba.budgetDetail.subScheme=" + this.budgetDetail.getSubScheme().getId();
        }
        if (this.budgetDetail.getBoundary() != null && this.budgetDetail.getBoundary().getId() != 0L) {
            sql = sql + " and ba.budgetDetail.boundary=" + this.budgetDetail.getBoundary().getId();
        }
        if (this.budgetDetail.getBudgetGroup().getId() != null && this.budgetDetail.getBudgetGroup().getId() != 0L) {
            sql = sql + " and ba.budgetDetail.budgetGroup=" + this.budgetDetail.getBudgetGroup().getId();
        }
        if (this.type.equals("A")) {
            sql = sql + " and ba.additionAmount is not null and ba.additionAmount!=0 ";
        } else if (this.type.equals("R")) {
            sql = sql + " and ba.deductionAmount is not null and ba.deductionAmount!=0 ";
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("search query==" + sql));
        }
        this.reAppropriationList = this.getPersistenceService().findAllBy(" from BudgetReAppropriation ba where ba.status.code='Approved' and " + sql + " order by ba.budgetDetail.fund,ba.budgetDetail.executingDepartment,ba.budgetDetail.function,ba.reAppropriationMisc.sequenceNumber", new Object[0]);
        return "search";
    }

    public void transition(String actionName, BudgetReAppropriation detail, String comment) {
        this.budgetReAppropriationWorkflowService.transition(actionName, (StateAware)detail, comment);
    }

    public List<BudgetReAppropriation> getReAppropriationList() {
        return this.reAppropriationList;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setReAppropriationList(List<BudgetReAppropriation> reAppropriationList) {
        this.reAppropriationList = reAppropriationList;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setBudgetReAppropriationWorkflowService(WorkflowService<BudgetReAppropriation> budgetReAppropriationWorkflowService) {
        this.budgetReAppropriationWorkflowService = budgetReAppropriationWorkflowService;
    }

    public BudgetDetailsDAO getBudgetDetailsDAO() {
        return this.budgetDetailsDAO;
    }

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }
}

