/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.CFinancialYearService;
import org.egov.commons.service.FunctionService;
import org.egov.egf.model.BudgetAmountView;
import org.egov.egf.web.actions.budget.BaseBudgetDetailAction;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.voucher.WorkflowBean;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new-re"}, location="budgetProposalDetail-new-re.jsp"), @Result(name={"newDetail-re"}, location="budgetProposalDetail-newDetail-re.jsp"), @Result(name={"budgets"}, location="budgetProposalDetail-budgets.jsp"), @Result(name={"functions"}, location="budgetProposalDetail-functions.jsp"), @Result(name={"budgetGroup"}, location="budgetProposalDetail-budgetGroup.jsp"), @Result(name={"AJAX_RESULT"}, type="stream", location="returnStream", params={"contentType", "text/plain"})})
public class BudgetProposalDetailAction
extends BaseBudgetDetailAction {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private static final long serialVersionUID = 1L;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private CFinancialYearService financialYearService;
    @PersistenceContext
    private EntityManager entityManager;
    public static final String NEWDETAIL = "newDetail-re";
    public static final String NEWRE = "new-re";
    public static final String BUDGETS = "budgets";
    public static final String FUNCTION = "functions";
    public static final String BUDGETGROUP = "budgetGroup";
    private static final String ACTIONNAME = "actionName";
    private static final String NAME = "name";
    private Budget topBudget;
    private Map<Long, BigDecimal> beNextYearAmounts = new HashMap();
    private static Logger LOGGER = Logger.getLogger(BudgetProposalDetailAction.class);
    private final String streamResult = "";
    private Long function;
    private Long budgetGroups;
    public List<CFunction> functionList = Collections.EMPTY_LIST;
    public List<BudgetGroup> budgetGroupList = Collections.EMPTY_LIST;

    public void setBudgetGroupList(List budgetGroupList) {
        this.budgetGroupList = budgetGroupList;
    }

    public StateAware getModel() {
        return this.budgetDetail;
    }

    public InputStream getReturnStream() {
        ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());
        return is;
    }

    protected void saveAndStartWorkFlow(BudgetDetail detail, WorkflowBean workflowBean) {
        try {
            if (this.budgetDocumentNumber != null && this.budgetDetail.getBudget() != null) {
                Budget b = (Budget)this.budgetService.findById((Serializable)this.budgetDetail.getBudget().getId(), false);
                b.setDocumentNumber(this.budgetDocumentNumber);
                this.budgetService.persist((Object)b);
                this.persistenceService.getSession().flush();
            }
            this.budgetDetailService.createBudgetDetail(detail, this.getPosition(), this.getPersistenceService());
            this.populateSavedbudgetDetailListForDetail(detail);
            this.headerDisabled = true;
        }
        catch (ValidationException e) {
            this.handleDuplicateBudgetDetailError(e);
            this.populateSavedbudgetDetailListForDetail(detail);
        }
    }

    protected void handleDuplicateBudgetDetailError(ValidationException e) {
        for (ValidationError error : e.getErrors()) {
            if (!"budgetDetail.duplicate".equals(error.getKey())) continue;
            this.headerDisabled = true;
            break;
        }
        throw e;
    }

    public void populateSavedbudgetDetailListFor(Budget budget) {
        if (budget != null && budget.getId() != null) {
            this.savedbudgetDetailList = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=? order by function.name,budgetGroup.name", new Object[]{budget.getId()});
        }
    }

    public void populateSavedbudgetDetailListForDetail(BudgetDetail bd) {
        if (bd != null) {
            List findAllBy;
            this.savedbudgetDetailList = findAllBy = this.budgetDetailService.findAllBy("from BudgetDetail where budget=? and function.id=? order by function.name,budgetGroup.name", new Object[]{bd.getBudget(), bd.getFunction().getId()});
            this.savedbudgetDetailList.addAll(this.budgetDetailService.findAllBy("from BudgetDetail where budget=(select bd from Budget bd where bd.referenceBudget=?) and function.id=? order by function.name,budgetGroup.name", new Object[]{bd.getBudget(), bd.getFunction().getId()}));
        }
    }

    public String ajaxLoadBudgetDetailList() {
        Long id = (Long)this.request.get("id");
        if (!Long.valueOf(0L).equals(id)) {
            this.savedbudgetDetailList = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=?", new Object[]{id});
            Budget budget = (Budget)this.budgetService.findById((Serializable)id, false);
            this.re = this.budgetService.hasReForYear(budget.getFinancialYear().getId());
            this.budgetDetail.setBudget(budget);
            this.setReferenceBudget(this.budgetService.getReferenceBudgetFor(budget));
            this.budgetDocumentNumber = budget.getDocumentNumber();
        }
        this.populateBeNextYearAmounts();
        this.populateFinancialYear();
        return "savedData";
    }

    @ValidationErrorPage(value="new-re")
    @Action(value="/budget/budgetProposalDetail-loadBudgetDetailList")
    public String loadBudgetDetailList() {
        if (this.addNewDetails) {
            return this.addNewDetails();
        }
        Long id = this.budgetDetail.getBudget().getId();
        this.showRe = true;
        this.getDetailsFilterdBy();
        Budget budget = (Budget)this.budgetService.findById((Serializable)id, false);
        this.re = this.budgetService.hasReForYear(budget.getFinancialYear().getId());
        this.budgetDetail.setBudget(budget);
        this.setReferenceBudget(this.budgetService.getReferenceBudgetFor(budget));
        this.budgetDocumentNumber = budget.getDocumentNumber();
        this.budgetAmountView = new ArrayList(this.savedbudgetDetailList.size());
        for (int i = 0; i < this.savedbudgetDetailList.size(); ++i) {
            this.budgetAmountView.add(new BudgetAmountView());
        }
        this.budgetDetailList = this.savedbudgetDetailList;
        this.populateBeNextYearAmountsAndBEAmounts();
        this.populateFinancialYear();
        this.loadAjaxedFunctionAndBudgetGroup();
        this.populateBudgetList();
        this.showDetails = true;
        return NEWRE;
    }

    @SkipValidation
    @Action(value="/budget/budgetProposalDetail-loadNewBudgetDetailList")
    public String loadNewBudgetDetailList() {
        LOGGER.info((Object)"Initiating load budgets .....");
        if (this.addNewDetails) {
            return this.addNewDetails();
        }
        Long id = this.budgetDetail.getBudget().getId();
        this.showRe = true;
        Budget budget = (Budget)this.budgetService.findById((Serializable)id, false);
        this.re = this.budgetService.hasReForYear(budget.getFinancialYear().getId());
        this.budgetDetail.setBudget(budget);
        this.setReferenceBudget(this.budgetService.getReferenceBudgetFor(budget));
        this.budgetDocumentNumber = budget.getDocumentNumber();
        this.budgetAmountView = new ArrayList(this.savedbudgetDetailList.size());
        for (int i = 0; i < this.savedbudgetDetailList.size(); ++i) {
            this.budgetAmountView.add(new BudgetAmountView());
        }
        this.budgetDetailList = this.savedbudgetDetailList;
        this.populateBeNextYearAmountsAndBEAmounts();
        this.populateFinancialYear();
        this.loadAjaxedFunctionAndBudgetGroup();
        this.showDetails = true;
        return NEWDETAIL;
    }

    public String addNewDetails() {
        Long id = this.budgetDetail.getBudget().getId();
        this.addNewDetails = true;
        this.showRe = true;
        this.savedbudgetDetailList = new ArrayList();
        Budget budget = (Budget)this.budgetService.findById((Serializable)id, false);
        this.re = this.budgetService.hasReForYear(budget.getFinancialYear().getId());
        this.budgetDetail.setBudget(budget);
        this.setReferenceBudget(this.budgetService.getReferenceBudgetFor(budget));
        this.budgetDocumentNumber = budget.getDocumentNumber();
        this.populateFinancialYear();
        this.loadAjaxedFunctionAndBudgetGroup();
        return NEWDETAIL;
    }

    private void loadAjaxedFunctionAndBudgetGroup() {
        this.ajaxLoadFunctions();
        this.ajaxLoadBudgetGroups();
    }

    @Action(value="/budget/budgetProposalDetail-ajaxLoadBudgets")
    public String ajaxLoadBudgets() {
        String bere = ((String[])this.parameters.get("bere"))[0];
        this.loadBudgets(bere);
        return BUDGETS;
    }

    @Action(value="/budget/budgetProposalDetail-ajaxLoadFunctions")
    public String ajaxLoadFunctions() {
        String functionLists = "functionList";
        if (this.getBudgetDetail() != null && this.getBudgetDetail().getBudget() != null && this.getBudgetDetail().getExecutingDepartment() != null) {
            Budget budget = (Budget)this.budgetService.find("from Budget where id=?", new Object[]{this.getBudgetDetail().getBudget().getId()});
            String budgetName = budget.getName();
            Integer deptId = this.getBudgetDetail().getExecutingDepartment().getId().intValue();
            String accountType = this.budgetDetailHelper.accountTypeForFunctionDeptMap(budgetName);
            String sqlStr = "select distinct (f.name)  as name,f.id as id  from eg_dept_functionmap m,function f where departmentid=:deptId and  budgetaccount_Type=:accountType and f.id= m.functionid order by f.name";
            SQLQuery sqlQuery = this.persistenceService.getSession().createSQLQuery("select distinct (f.name)  as name,f.id as id  from eg_dept_functionmap m,function f where departmentid=:deptId and  budgetaccount_Type=:accountType and f.id= m.functionid order by f.name");
            sqlQuery.setInteger("deptId", deptId.intValue()).setString("accountType", accountType);
            sqlQuery.addScalar(NAME).addScalar("id", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CFunction.class));
            this.functionList = !sqlQuery.list().isEmpty() ? sqlQuery.list() : this.employeeService.getAllFunctions();
            if (this.functionList.isEmpty()) {
                this.dropdownData.put("functionList", this.functionService.findAll());
            } else {
                this.dropdownData.put("functionList", this.functionList);
            }
        }
        return FUNCTION;
    }

    @Action(value="/budget/budgetProposalDetail-ajaxLoadBudgetGroups")
    public String ajaxLoadBudgetGroups() {
        this.request.get("id");
        String sqlStr = "select  distinct (bg.name) as name ,bg.id  as id from egf_budgetgroup bg where bg.isActive=true   order  by bg.name";
        SQLQuery sqlQuery = this.persistenceService.getSession().createSQLQuery("select  distinct (bg.name) as name ,bg.id  as id from egf_budgetgroup bg where bg.isActive=true   order  by bg.name");
        sqlQuery.addScalar(NAME).addScalar("id", (Type)LongType.INSTANCE).setResultTransformer(Transformers.aliasToBean(BudgetGroup.class));
        this.budgetGroupList = sqlQuery.list();
        return BUDGETGROUP;
    }

    public String saveAndNewRe() {
        return this.createRe();
    }

    public void prepare() {
        super.prepare();
        this.populateSavedbudgetDetailListFor(this.budgetDetail.getBudget());
        if (this.parameters.containsKey("re")) {
            this.dropdownData.put("budgetList", Collections.EMPTY_LIST);
        }
        this.loadAjaxedFunctionAndBudgetGroup();
    }

    public boolean isShowMessage() {
        return super.isShowMessage();
    }

    public String getActionMessage() {
        if (this.getActionMessages() != null && this.getActionMessages().iterator() != null && this.getActionMessages().iterator().next() != null) {
            return ((String)this.getActionMessages().iterator().next()).toString();
        }
        return "";
    }

    private void populateBeNextYearAmounts() {
        if (this.savedbudgetDetailList == null || this.savedbudgetDetailList.size() == 0) {
            return;
        }
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(((BudgetDetail)this.savedbudgetDetailList.get(0)).getBudget());
        if (referenceBudgetFor != null) {
            List result = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=?", new Object[]{referenceBudgetFor.getId()});
            for (BudgetDetail budgetDetail : this.savedbudgetDetailList) {
                for (BudgetDetail row : result) {
                    if (!this.compareDetails(row, budgetDetail)) continue;
                    this.beNextYearAmounts.put(budgetDetail.getId(), row.getOriginalAmount().setScale(2));
                }
            }
        }
    }

    private void populateBeNextYearAmountsAndBEAmounts() {
        if (this.savedbudgetDetailList == null || this.savedbudgetDetailList.size() == 0) {
            return;
        }
        this.beAmounts = new ArrayList(this.savedbudgetDetailList.size());
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(((BudgetDetail)this.savedbudgetDetailList.get(0)).getBudget());
        if (referenceBudgetFor != null) {
            List result = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=?", new Object[]{referenceBudgetFor.getId()});
            for (BudgetDetail budgetDetail : this.savedbudgetDetailList) {
                for (BudgetDetail row : result) {
                    if (!this.compareDetails(row, budgetDetail)) continue;
                    this.beNextYearAmounts.put(budgetDetail.getId(), row.getOriginalAmount().setScale(2));
                    this.beAmounts.add(row.getOriginalAmount());
                }
            }
        }
    }

    protected void saveAndStartWorkFlowForRe(BudgetDetail detail, int index, CFinancialYear finYear, Budget refBudget, WorkflowBean workflowBean) {
        try {
            if (this.budgetDocumentNumber != null && this.budgetDetail.getBudget() != null) {
                Budget b = (Budget)this.budgetService.findById((Serializable)this.budgetDetail.getBudget().getId(), false);
                b.setDocumentNumber(this.budgetDocumentNumber);
                this.budgetService.persist((Object)b);
                this.persistenceService.getSession().flush();
            }
            detail.getBudget().setFinancialYear(finYear);
            BudgetDetail reCurrentYear = this.budgetDetailService.createBudgetDetail(detail, null, this.getPersistenceService());
            reCurrentYear.setUniqueNo(reCurrentYear.getFund().getId() + "-" + reCurrentYear.getExecutingDepartment().getId() + "-" + reCurrentYear.getFunction().getId() + "-" + reCurrentYear.getBudgetGroup().getId());
            this.budgetDetailService.applyAuditing((AbstractAuditable)reCurrentYear);
            reCurrentYear = this.budgetDetailService.transitionWorkFlow(reCurrentYear, workflowBean);
            this.budgetDetailService.applyAuditing((AbstractAuditable)reCurrentYear.getState());
            this.budgetDetailService.persist(reCurrentYear);
            this.headerDisabled = true;
            BudgetDetail beNextYear = new BudgetDetail();
            if (this.addNewDetails) {
                beNextYear.transition().progressWithStateCopy().withStateValue("END").withOwner(this.getPosition()).withComments("");
            }
            beNextYear.copyFrom(detail);
            beNextYear.setBudget(refBudget);
            beNextYear.setOriginalAmount((BigDecimal)this.beAmounts.get(index));
            beNextYear.setDocumentNumber(detail.getDocumentNumber());
            beNextYear.setAnticipatoryAmount(reCurrentYear.getAnticipatoryAmount());
            beNextYear = this.budgetDetailService.createBudgetDetail(beNextYear, null, this.getPersistenceService());
            beNextYear.setUniqueNo(beNextYear.getFund().getId() + "-" + beNextYear.getExecutingDepartment().getId() + "-" + beNextYear.getFunction().getId() + "-" + beNextYear.getBudgetGroup().getId());
            this.budgetDetailService.applyAuditing((AbstractAuditable)beNextYear);
            beNextYear.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Created"));
            this.budgetDetailService.persist(beNextYear);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.loadAjaxedFunctionAndBudgetGroup();
            this.populateBeNextYearAmounts();
            this.handleDuplicateBudgetDetailError(e);
            this.populateSavedbudgetDetailListFor(this.budgetDetail.getBudget());
            throw e;
        }
    }

    public Assignment getWorkflowInitiator(BudgetDetail budgetDetail) {
        return (Assignment)this.assignmentService.findByEmployeeAndGivenDate(budgetDetail.getCreatedBy().getId(), new Date()).get(0);
    }

    public List<String> getValidActions() {
        List<String> validActions = Collections.emptyList();
        if (this.budgetDetail.getId() == null || this.budgetDetail.getId() == 0L || this.budgetDetail.getCurrentState() == null) {
            validActions = Arrays.asList("Save", "Forward");
        } else if (this.budgetDetail.getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.budgetDetail.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.budgetDetail.getCurrentState().getValue(), this.getPendingActions(), this.budgetDetail.getCreatedDate());
        } else if (this.budgetDetail.getId() == null || this.budgetDetail.getId() == 0L || this.budgetDetail.getCurrentState().getValue().endsWith("NEW")) {
            validActions = Arrays.asList("Forward");
        } else if (this.budgetDetail.getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.budgetDetail.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.budgetDetail.getCurrentState().getValue(), this.getPendingActions(), this.budgetDetail.getCreatedDate());
        }
        return validActions;
    }

    public void approve() {
        if (!this.savedbudgetDetailList.isEmpty()) {
            this.topBudget = ((BudgetDetail)this.savedbudgetDetailList.get(0)).getBudget();
            this.setTopBudget(this.topBudget);
        }
        Integer userId = null;
        userId = ((String[])this.parameters.get(ACTIONNAME))[0] != null && ((String[])this.parameters.get(ACTIONNAME))[0].contains("reject") ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : (null != this.parameters.get("approverUserId") && Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) != -1 ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]) : Integer.valueOf(ApplicationThreadLocals.getUserId().intValue()));
        for (BudgetDetail detail : this.savedbudgetDetailList) {
            if (new String("forward").equals(((String[])this.parameters.get(ACTIONNAME))[0])) {
                detail.transition().progressWithStateCopy().withStateValue("Forwarded by " + this.getPosition().getName()).withOwner(this.getPositionByUserId(userId)).withComments(detail.getComment());
            }
            this.budgetDetailService.persist(detail);
        }
        if (this.topBudget != null) {
            this.setTopBudget(this.budgetService.getReferenceBudgetFor(this.topBudget));
        }
        if (((String[])this.parameters.get(ACTIONNAME))[0].contains("approv")) {
            if (this.topBudget.getState().getValue().equals("END")) {
                this.addActionMessage(this.getMessage("budgetdetail.approved.end"));
            } else {
                this.addActionMessage(this.getMessage("budgetdetail.approved") + this.budgetService.getEmployeeNameAndDesignationForPosition(this.getPositionByUserId(userId)));
            }
        } else {
            this.addActionMessage(this.getMessage("budgetdetail.approved") + this.budgetService.getEmployeeNameAndDesignationForPosition(this.getPositionByUserId(userId)));
        }
    }

    @Action(value="/budget/budgetProposalDetail-newRe")
    public String newRe() {
        this.showRe = true;
        CFinancialYear date = this.financialYearService.getFinancialYearByDate(new Date());
        this.asOnDate = date.getStartingDate();
        this.asOnDate.setMonth(8);
        this.asOnDate.setDate(30);
        return NEWRE;
    }

    @Action(value="/budget/budgetProposalDetail-newDetailRe")
    public String newDetailRe() {
        this.showRe = true;
        return NEWDETAIL;
    }

    @ValidationErrorPage(value="new-re")
    @Action(value="/budget/budgetProposalDetail-loadActualsForRe")
    public String loadActualsForRe() {
        this.showRe = true;
        try {
            Long id = this.budgetDetail.getBudget().getId();
            Budget budget = (Budget)this.budgetService.findById((Serializable)id, false);
            this.budgetDetail.setBudget(budget);
            this.loadAjaxedFunctionAndBudgetGroup();
            this.loadActuals();
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.populateBudgetList();
            throw e;
        }
        this.populateBudgetList();
        return NEWRE;
    }

    @ValidationErrorPage(value="newDetail-re")
    @Action(value="/budget/budgetProposalDetail-loadActualsForBudgetDetailRe")
    public String loadActualsForBudgetDetailRe() {
        this.showRe = true;
        try {
            this.loadActuals();
            this.showDetails = true;
        }
        catch (ValidationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.populateBudgetList();
            throw e;
        }
        this.populateBudgetList();
        return NEWDETAIL;
    }

    public void setShowRe(boolean showRe) {
        this.showRe = showRe;
    }

    public boolean isShowRe() {
        return this.showRe;
    }

    protected String getMessage(String key) {
        return this.getText(key);
    }

    public Budget getTopBudget() {
        return this.topBudget;
    }

    public void setTopBudget(Budget topBudget) {
        this.topBudget = topBudget;
    }

    public void setBeNextYearAmounts(Map<Long, BigDecimal> beNextYearAmounts) {
        this.beNextYearAmounts = beNextYearAmounts;
    }

    public Map<Long, BigDecimal> getBeNextYearAmounts() {
        return this.beNextYearAmounts;
    }

    public List getFunctionList() {
        return this.functionList;
    }

    public void setFunctionList(List functionList) {
        this.functionList = functionList;
    }

    public List getBudgetGroupList() {
        return this.budgetGroupList;
    }

    public Long getFunction() {
        return this.function;
    }

    public void setFunction(Long function) {
        this.function = function;
    }

    public Long getBudgetGroups() {
        return this.budgetGroups;
    }

    public void setBudgetGroups(Long budgetGroups) {
        this.budgetGroups = budgetGroups;
    }
}

