/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.budget.BudgetProposalBean;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EisUtilService;
import org.egov.services.budget.BudgetDetailActionHelper;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.BudgetDetailHelper;
import org.egov.utils.ReportHelper;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"reportview"}, location="budgetProposal-reportview.jsp"), @Result(name={"message"}, location="budgetProposal-message.jsp"), @Result(name={"detailList"}, location="budgetProposal-detailList.jsp"), @Result(name={"list"}, location="budgetproposal-list.jsp"), @Result(name={"failure"}, location="budgetProposal-failure.jsp"), @Result(name={"reportview"}, type="stream", location="inputStream", params={"contentType", "${contentType}", "contentDisposition", "attachment; filename=${fileName}"})})
public class BudgetProposalAction
extends GenericWorkFlowAction {
    private static final String BUDGET_DETAIL_BUDGET_ID = "budgetDetail.budget.id";
    public static final String MESSAGE = "message";
    private static final long serialVersionUID = 1L;
    private static final String ACTIONNAME = "actionName";
    public static final String REPORTVIEW = "reportview";
    private static final Logger LOGGER = Logger.getLogger(BudgetProposalAction.class);
    private BudgetProposalBean bpBean = new BudgetProposalBean();
    private BudgetDetail budgetDetail;
    private Budget topBudget;
    private VoucherService voucherService;
    protected FinancialYearHibernateDAO financialYearDAO;
    protected String currentfinYearRange = "";
    protected String nextfinYearRange = "";
    protected String previousfinYearRange = "";
    protected String twopreviousfinYearRange = "";
    private List<BudgetDetail> budgetDetailList = new ArrayList();
    protected List<BudgetDetail> savedbudgetDetailList = new ArrayList();
    protected WorkflowBean workflowBean = new WorkflowBean();
    @Autowired
    @Qualifier(value="budgetDetailService")
    protected BudgetDetailService budgetDetailService;
    protected BudgetService budgetService;
    private BudgetDetailHelper budgetDetailHelper;
    private Map<Long, String> previuosYearBudgetDetailMap = new HashMap();
    private Map<Long, String> beforePreviousYearBudgetDetailMap = new HashMap();
    private Map<String, BigDecimal> budgetDetailIdsAndAmount = new HashMap();
    private Map<String, BigDecimal> previousYearBudgetDetailIdsAndAmount = new HashMap();
    private Map<String, BigDecimal> twopreviousYearBudgetDetailIdsAndAmount = new HashMap();
    private final Map<String, BigDecimal> uniqueNoAndBEMap = new HashMap();
    private final Map<String, BigDecimal> uniqueNoAndApprMap = new HashMap();
    private final Map<String, String> majorCodeAndNameMap = new TreeMap();
    private String wfitemstate;
    private Integer defaultDept;
    private Department department;
    private List<BudgetProposalBean> bpBeanList = new ArrayList();
    private static final String HEADING = "heading";
    private static final String MAJORCODE = "majorcode";
    private static final String DETAIL = "detail";
    private static final String TOTAL = "total";
    public static final String FAILURE = "failure";
    private static final String SUCCESSFUL = "successful";
    private java.util.Date asOndate;
    @Autowired
    private BudgetDetailActionHelper budgetDetailActionHelper;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private AssignmentService assignmentService;
    private InputStream inputStream;
    private ReportHelper reportHelper;
    private Long docNo;
    protected WorkflowService<Budget> budgetWorkflowService;
    protected EisCommonService eisCommonService;
    private boolean consolidatedScreen;
    private boolean allfunctionsArrived;
    private Integer approverUserId;
    private String comment;
    private String actionName = "";
    private CFinancialYear financialYear;
    private CFinancialYear prevFinancialYear;
    private CFinancialYear nextFinancialYear;
    private CFinancialYear beforeLastFinancialYear;
    private boolean hod;
    private boolean asstFMU;
    private boolean functionHeading = true;
    private boolean deptHeading = true;
    private String functionsNotYetReceiced;
    private Map<Long, BudgetGroup> budgetGroupMap;
    private Map<Integer, Fund> fundMap;
    private Map<Long, CFunction> functionMap;
    private Map<Long, Department> deptMap;
    private List<AppConfigValues> excludelist = new ArrayList();
    protected EisUtilService eisService;
    private String contentType;
    private String fileName;
    private String amountField;
    private BigDecimal amount;
    private Long detailId;
    private String factor;
    private Long validId;
    private final BigDecimal bigThousand = new BigDecimal(1000);
    @Autowired
    private EgovMasterDataCaching masterDataCache;

    public void setReportService(ReportService reportService) {
    }

    public String execute() {
        try {
            super.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.update();
    }

    public StateAware getModel() {
        return this.budgetDetail;
    }

    public void prepare() {
        super.prepare();
    }

    @Action(value="/budget/budgetProposal-modifyDetailList")
    public String modifyDetailList() {
        this.loadToMasterDataMap();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"starting modifyDetailList...");
        }
        if (((String[])this.parameters.get(BUDGET_DETAIL_BUDGET_ID))[0] != null) {
            this.budgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where budget.id=?", new Object[]{Long.valueOf(((String[])this.parameters.get(BUDGET_DETAIL_BUDGET_ID))[0])});
            this.setTopBudget(this.budgetDetail.getBudget());
        }
        this.financialYear = this.topBudget.getFinancialYear();
        this.currentfinYearRange = this.financialYear.getFinYearRange();
        this.nextFinancialYear = this.getFinancialYearDAO().getNextFinancialYearByDate(this.financialYear.getStartingDate());
        this.nextfinYearRange = this.nextFinancialYear.getFinYearRange();
        this.prevFinancialYear = this.getFinancialYearDAO().getPreviousFinancialYearByDate(this.financialYear.getStartingDate());
        this.previousfinYearRange = this.prevFinancialYear.getFinYearRange();
        this.beforeLastFinancialYear = this.getFinancialYearDAO().getTwoPreviousYearByDate(this.financialYear.getStartingDate());
        this.twopreviousfinYearRange = this.beforeLastFinancialYear.getFinYearRange();
        this.budgetDetailApprove();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"completed modifyDetailList");
        }
        this.setDocNo(this.budgetDetail.getDocumentNumber());
        return "detailList";
    }

    @Action(value="/budget/budgetProposal-modifyBudgetDetailList")
    public String modifyBudgetDetailList() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting modifyBudgetDetailList..............");
        }
        if (((String[])this.parameters.get(BUDGET_DETAIL_BUDGET_ID))[0] != null) {
            this.budgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where budget.id=?", new Object[]{Long.valueOf(((String[])this.parameters.get(BUDGET_DETAIL_BUDGET_ID))[0])});
            this.setTopBudget(this.budgetDetail.getBudget());
        }
        this.populateBudgetDetailReport();
        return "list";
    }

    private void populateBudgetDetailReport() {
        this.loadToMasterDataMap();
        if (this.budgetDetail.getBudget().getId() != null) {
            this.budgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where budget.id=?", new Object[]{Long.valueOf(((String[])this.parameters.get(BUDGET_DETAIL_BUDGET_ID))[0])});
        }
        this.consolidatedScreen = this.budgetDetailService.toBeConsolidated();
        this.hod = this.isHOD();
        if (this.hod) {
            this.allfunctionsArrived = this.validateForAllFunctionsMappedForDept(this.topBudget, this.getPosition());
        }
        this.financialYear = this.topBudget.getFinancialYear();
        this.currentfinYearRange = this.financialYear.getFinYearRange();
        this.nextFinancialYear = this.getFinancialYearDAO().getNextFinancialYearByDate(this.financialYear.getStartingDate());
        this.nextfinYearRange = this.nextFinancialYear.getFinYearRange();
        this.prevFinancialYear = this.getFinancialYearDAO().getPreviousFinancialYearByDate(this.financialYear.getStartingDate());
        this.previousfinYearRange = this.prevFinancialYear.getFinYearRange();
        this.beforeLastFinancialYear = this.getFinancialYearDAO().getTwoPreviousYearByDate(this.financialYear.getStartingDate());
        this.twopreviousfinYearRange = this.beforeLastFinancialYear.getFinYearRange();
        this.budgetApprove();
    }

    public List<String> getValidActions() {
        List<String> validActions = Collections.emptyList();
        if (this.budgetDetail.getId() == null || this.budgetDetail.getId() == 0L) {
            validActions = Arrays.asList("Save", "Forward");
        } else if (this.budgetDetail.getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.budgetDetail.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.budgetDetail.getCurrentState().getValue(), this.getPendingActions(), this.budgetDetail.getCreatedDate());
        } else if (this.budgetDetail.getId() == null || this.budgetDetail.getId() == 0L || this.budgetDetail.getCurrentState().getValue().endsWith("NEW")) {
            validActions = Arrays.asList("Forward");
        }
        return validActions;
    }

    private void loadToMasterDataMap() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting loadToMasterDataMap...... ");
        }
        List bgList = this.masterDataCache.get("egf-budgetGroup");
        this.budgetGroupMap = new HashMap();
        for (Object bg : bgList) {
            this.budgetGroupMap.put(bg.getId(), bg);
        }
        List fnList = this.masterDataCache.get("egi-function");
        this.functionMap = new HashMap();
        for (Object fn : fnList) {
            this.functionMap.put(fn.getId(), fn);
        }
        List fundList = this.masterDataCache.get("egi-fund");
        this.fundMap = new HashMap();
        for (Fund f : fundList) {
            this.fundMap.put(f.getId(), f);
        }
        List deptList = this.masterDataCache.get("egi-department");
        this.deptMap = new HashMap();
        for (Department d : deptList) {
            this.deptMap.put(Long.valueOf(d.getId()), d);
        }
        this.excludelist = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual");
        if (this.excludelist.isEmpty()) {
            throw new ValidationException("", "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished loadToMasterDataMap...... ");
        }
    }

    @SkipValidation
    public String ajaxUpdateBudgetDetail() {
        if (this.validateOwner().booleanValue()) {
            Query updateQuery;
            int executeUpdate;
            if (this.factor.equalsIgnoreCase(this.bigThousand.toString())) {
                this.amount = this.amount.multiply(this.bigThousand);
            }
            String query = "update egf_budgetdetail set  " + this.amountField + "=:amount,Modifiedby=:modifiedby,modifieddate=:modifiedate  where id=:detailId";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)query);
            }
            if ((executeUpdate = (updateQuery = this.persistenceService.getSession().createSQLQuery(query).setBigDecimal("amount", this.amount).setLong("detailId", this.detailId.longValue()).setDate("modifiedate", (java.util.Date)new Date(new java.util.Date().getTime())).setInteger("modifiedby", ApplicationThreadLocals.getUserId().intValue())).executeUpdate()) == 1) {
                return SUCCESSFUL;
            }
            return FAILURE;
        }
        return FAILURE;
    }

    @Action(value="/budget/budgetProposal-ajaxDeleteBudgetDetail")
    public String ajaxDeleteBudgetDetail() {
        try {
            if (this.bpBean.getId() != null && this.bpBean.getNextYrId() != null) {
                this.persistenceService.getSession().createSQLQuery("delete from egf_budgetdetail where id in (" + this.bpBean.getId() + "," + this.bpBean.getNextYrId() + ")").executeUpdate();
                this.persistenceService.getSession().flush();
            }
        }
        catch (HibernateException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"error while deleting");
            }
            return FAILURE;
        }
        return SUCCESSFUL;
    }

    public boolean isHod() {
        return this.hod;
    }

    public void setHod(boolean hod) {
        this.hod = hod;
    }

    public void budgetDetailApprove() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting budgetDetailApprove()..............");
        }
        String query = " from BudgetDetail bd where bd.budget=? and (state.value='END' or state.ownerPosition=?) and bd.function=" + this.budgetDetail.getFunction().getId() + "  order by bd.function.name,bd.budgetGroup.name";
        this.savedbudgetDetailList = this.budgetDetailService.findAllBy(query, new Object[]{this.topBudget, this.getPosition()});
        if (!this.savedbudgetDetailList.isEmpty()) {
            this.populateMajorCodewiseData();
            this.populateNextYrBEinBudgetDetailList();
            this.populateMajorCodewiseDetailData();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"finished loading detail List--------------------------------------------------------------");
        }
    }

    public void budgetApprove() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting budgetApprove..............");
        }
        List functionList = this.persistenceService.findAllBy("select distinct f from BudgetDetail bd inner join bd.function as f  where budget=? order by f.name ", new Object[]{this.topBudget});
        this.populateMajorCodewiseDataAcrossFunction();
        int i = 0;
        for (CFunction function : functionList) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Starting budgetDetailApprove...for functin ....centre......." + function.getName() + "     count " + ++i));
            }
            this.budgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where budget=? and function=? order by budgetGroup.name", new Object[]{this.topBudget, function});
            this.budgetDetailApprove();
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info((Object)("Finished budgetDetailApprove...for functin ....centre......." + function.getName()));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished budgetApprove");
        }
    }

    private void populateMajorCodewiseData() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting populateMajorCodewiseData()...........");
        }
        HashMap majorCodeAndCurrentActuals = new HashMap();
        HashMap majorCodeAndPreviousActuals = new HashMap();
        HashMap majorCodeAndBeforePreviousActuals = new HashMap();
        HashMap majorCodeAndBEMap = new HashMap();
        HashMap majorCodeAndAppropriationMap = new HashMap();
        HashMap<String, BigDecimal> majorCodeAndAnticipatoryMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> majorCodeAndOriginalMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> majorCodeAndBENextYrMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> majorCodeAndApprovedMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> majorCodeAndBENextYrApprovedMap = new HashMap<String, BigDecimal>();
        Position pos = this.getPosition();
        this.majorCodeAndNameMap.clear();
        List resultMajorCode = this.budgetDetailService.fetchMajorCodeAndName(this.topBudget, this.budgetDetail, this.budgetDetail.getFunction(), pos);
        this.addToMap(resultMajorCode, this.majorCodeAndNameMap);
        List resultCurrentActuals = this.budgetDetailService.fetchMajorCodeAndActuals(this.financialYear, this.topBudget, this.asOndate, this.budgetDetail.getFunction(), this.budgetDetail.getExecutingDepartment(), pos);
        this.addToMapStringBigDecimal(resultCurrentActuals, majorCodeAndCurrentActuals);
        List resultPreviousActuals = this.budgetDetailService.fetchMajorCodeAndActuals(this.prevFinancialYear, this.topBudget, null, this.budgetDetail.getFunction(), this.budgetDetail.getExecutingDepartment(), pos);
        this.addToMapStringBigDecimal(resultPreviousActuals, majorCodeAndPreviousActuals);
        List resultBeforePreviousActuals = this.budgetDetailService.fetchMajorCodeAndActuals(this.beforeLastFinancialYear, this.topBudget, null, this.budgetDetail.getFunction(), this.budgetDetail.getExecutingDepartment(), pos);
        this.addToMapStringBigDecimal(resultBeforePreviousActuals, majorCodeAndBeforePreviousActuals);
        List resultMajorCodeBE = this.budgetDetailService.fetchMajorCodeAndBEAmount(this.topBudget, this.budgetDetail, this.budgetDetail.getFunction(), pos);
        this.addToMapStringBigDecimal(resultMajorCodeBE, majorCodeAndBEMap);
        List resultMajorCodeAppropriation = this.budgetDetailService.fetchMajorCodeAndAppropriation(this.topBudget, this.budgetDetail, this.budgetDetail.getFunction(), pos, this.asOndate);
        this.addToMapStringBigDecimal(resultMajorCodeAppropriation, majorCodeAndAppropriationMap);
        List resultMajorCodeAncipatory = this.budgetDetailService.fetchMajorCodeAndAnticipatory(this.topBudget, this.budgetDetail, this.budgetDetail.getFunction(), pos);
        for (Object row : resultMajorCodeAncipatory) {
            majorCodeAndAnticipatoryMap.put(row[0].toString(), ((BigDecimal)row[1]).setScale(2));
            majorCodeAndOriginalMap.put(row[0].toString(), ((BigDecimal)row[2]).setScale(2));
            majorCodeAndApprovedMap.put(row[0].toString(), ((BigDecimal)row[3]).setScale(2));
        }
        List resultMajorCodeBENextYr = this.budgetDetailService.fetchMajorCodeAndBENextYr(this.topBudget, this.budgetDetail, this.budgetDetail.getFunction(), pos);
        for (Object[] row : resultMajorCodeBENextYr) {
            majorCodeAndBENextYrMap.put(row[0].toString(), ((BigDecimal)row[1]).setScale(2));
            majorCodeAndBENextYrApprovedMap.put(row[0].toString(), ((BigDecimal)row[2]).setScale(2));
        }
        if (this.deptHeading) {
            this.bpBeanList.add(new BudgetProposalBean(this.budgetDetail.getExecutingDepartment().getName(), HEADING));
            this.deptHeading = false;
        }
        if (this.functionHeading) {
            this.bpBeanList.add(new BudgetProposalBean("FUNCTIONWISE BUDGET SUMMARY", HEADING));
            this.functionHeading = false;
        }
        this.bpBeanList.add(new BudgetProposalBean("FUNCTION CENTRE-" + this.budgetDetail.getFunction().getName(), HEADING));
        BudgetProposalBean bpbeanTotal = new BudgetProposalBean();
        for (Map.Entry entry : this.majorCodeAndNameMap.entrySet()) {
            String formValue = this.getAppConfigValueByKey("functionWiseBudgetReport-" + (String)entry.getKey());
            BudgetProposalBean bpbean = new BudgetProposalBean();
            bpbean.setReference(formValue);
            bpbean.setRowType(MAJORCODE);
            bpbean.setBudgetGroup((String)entry.getValue());
            bpbean.setCurrentYearActuals(majorCodeAndCurrentActuals.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndCurrentActuals.get(entry.getKey())).toString());
            bpbean.setPreviousYearActuals(majorCodeAndPreviousActuals.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndPreviousActuals.get(entry.getKey())).toString());
            bpbean.setTwoPreviousYearActuals(majorCodeAndBeforePreviousActuals.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndBeforePreviousActuals.get(entry.getKey())).toString());
            bpbean.setCurrentYearBE(majorCodeAndBEMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndBEMap.get(entry.getKey())).toString());
            bpbean.setReappropriation(majorCodeAndAppropriationMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndAppropriationMap.get(entry.getKey())).toString());
            bpbean.setTotal(new BigDecimal(bpbean.getCurrentYearBE()).add(new BigDecimal(bpbean.getReappropriation())).toString());
            bpbean.setAnticipatory(majorCodeAndAnticipatoryMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndAnticipatoryMap.get(entry.getKey())).toString());
            bpbean.setProposedRE(majorCodeAndOriginalMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)majorCodeAndOriginalMap.get(entry.getKey()));
            bpbean.setProposedBE(majorCodeAndBENextYrMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)majorCodeAndBENextYrMap.get(entry.getKey()));
            bpbean.setApprovedRE(majorCodeAndApprovedMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)majorCodeAndApprovedMap.get(entry.getKey()));
            bpbean.setApprovedBE(majorCodeAndBENextYrApprovedMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)majorCodeAndBENextYrApprovedMap.get(entry.getKey()));
            this.bpBeanList.add(bpbean);
            this.computeTotal(bpbeanTotal, bpbean);
        }
        this.bpBeanList.add(bpbeanTotal);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished populateMajorCodewiseData()");
        }
    }

    void populateMajorCodewiseDataAcrossFunction() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting populateMajorCodewiseDataAcrossFunction..............");
        }
        HashMap majorCodeAndCurrentActuals = new HashMap();
        HashMap majorCodeAndPreviousActuals = new HashMap();
        HashMap majorCodeAndBeforePreviousActuals = new HashMap();
        HashMap majorCodeAndBEMap = new HashMap();
        HashMap majorCodeAndAppropriationMap = new HashMap();
        HashMap majorCodeAndAnticipatoryMap = new HashMap();
        HashMap majorCodeAndOriginalMap = new HashMap();
        HashMap majorCodeAndBENextYrMap = new HashMap();
        HashMap majorCodeAndApprovedMap = new HashMap();
        HashMap majorCodeAndBENextYrApprovedMap = new HashMap();
        Position pos = this.getPosition();
        List resultMajorCode = this.budgetDetailService.fetchMajorCodeAndName(this.topBudget, this.budgetDetail, null, pos);
        this.addToMap(resultMajorCode, this.majorCodeAndNameMap);
        List resultCurrentActuals = this.budgetDetailService.fetchMajorCodeAndActuals(this.financialYear, this.topBudget, this.asOndate, null, this.budgetDetail.getExecutingDepartment(), pos);
        this.addToMapStringBigDecimal(resultCurrentActuals, majorCodeAndCurrentActuals);
        List resultPreviousActuals = this.budgetDetailService.fetchMajorCodeAndActuals(this.prevFinancialYear, this.topBudget, null, null, this.budgetDetail.getExecutingDepartment(), pos);
        this.addToMapStringBigDecimal(resultPreviousActuals, majorCodeAndPreviousActuals);
        List resultBeforePreviousActuals = this.budgetDetailService.fetchMajorCodeAndActuals(this.beforeLastFinancialYear, this.topBudget, null, null, this.budgetDetail.getExecutingDepartment(), pos);
        this.addToMapStringBigDecimal(resultBeforePreviousActuals, majorCodeAndBeforePreviousActuals);
        List resultMajorCodeBE = this.budgetDetailService.fetchMajorCodeAndBEAmount(this.topBudget, this.budgetDetail, null, pos);
        this.addToMapStringBigDecimal(resultMajorCodeBE, majorCodeAndBEMap);
        List resultMajorCodeAppropriation = this.budgetDetailService.fetchMajorCodeAndAppropriation(this.topBudget, this.budgetDetail, null, pos, this.asOndate);
        this.addToMapStringBigDecimal(resultMajorCodeAppropriation, majorCodeAndAppropriationMap);
        this.budgetDetailService.fetchMajorCodeAndAnticipatory(this.topBudget, this.budgetDetail, null, pos);
        this.addToMapStringBigDecimal(resultMajorCodeAppropriation, majorCodeAndAnticipatoryMap);
        List resultMajorCodeOriginal = this.budgetDetailService.fetchMajorCodeAndOriginalAmount(this.topBudget, this.budgetDetail, null, pos);
        this.addToMapStringBigDecimal(resultMajorCodeOriginal, majorCodeAndOriginalMap);
        List resultMajorCodeBENextYr = this.budgetDetailService.fetchMajorCodeAndBENextYr(this.topBudget, this.budgetDetail, null, pos);
        this.addToMapStringBigDecimal(resultMajorCodeBENextYr, majorCodeAndBENextYrMap);
        List resultMajorCodeApproved = this.budgetDetailService.fetchMajorCodeAndApprovedAmount(this.topBudget, this.budgetDetail, null, pos);
        this.addToMapStringBigDecimal(resultMajorCodeApproved, majorCodeAndApprovedMap);
        List resultMajorCodeBENextYrApproved = this.budgetDetailService.fetchMajorCodeAndBENextYrApproved(this.topBudget, this.budgetDetail, null, pos);
        this.addToMapStringBigDecimal(resultMajorCodeBENextYrApproved, majorCodeAndBENextYrApprovedMap);
        this.bpBeanList.add(new BudgetProposalBean(this.budgetDetail.getExecutingDepartment().getName(), HEADING));
        this.deptHeading = false;
        this.bpBeanList.add(new BudgetProposalBean("DEPARTMENTWISE BUDGET SUMMARY", HEADING));
        BudgetProposalBean bpbeanTotal = new BudgetProposalBean();
        for (Map.Entry entry : this.majorCodeAndNameMap.entrySet()) {
            String formValue = this.getAppConfigValueByKey("functionWiseBudgetReport-" + (String)entry.getKey());
            BudgetProposalBean bpbean = new BudgetProposalBean();
            bpbean.setReference(formValue);
            bpbean.setRowType(MAJORCODE);
            bpbean.setBudgetGroup((String)entry.getValue());
            bpbean.setCurrentYearActuals(majorCodeAndCurrentActuals.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndCurrentActuals.get(entry.getKey())).toString());
            bpbean.setPreviousYearActuals(majorCodeAndPreviousActuals.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndPreviousActuals.get(entry.getKey())).toString());
            bpbean.setTwoPreviousYearActuals(majorCodeAndBeforePreviousActuals.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndBeforePreviousActuals.get(entry.getKey())).toString());
            bpbean.setCurrentYearBE(majorCodeAndBEMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndBEMap.get(entry.getKey())).toString());
            bpbean.setReappropriation(majorCodeAndAppropriationMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndAppropriationMap.get(entry.getKey())).toString());
            bpbean.setTotal(new BigDecimal(bpbean.getCurrentYearBE()).add(new BigDecimal(bpbean.getReappropriation())).toString());
            bpbean.setAnticipatory(majorCodeAndAnticipatoryMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)majorCodeAndAnticipatoryMap.get(entry.getKey())).toString());
            bpbean.setProposedRE(majorCodeAndOriginalMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)majorCodeAndOriginalMap.get(entry.getKey()));
            bpbean.setProposedBE(majorCodeAndBENextYrMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)majorCodeAndBENextYrMap.get(entry.getKey()));
            bpbean.setApprovedRE(majorCodeAndApprovedMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)majorCodeAndApprovedMap.get(entry.getKey()));
            bpbean.setApprovedBE(majorCodeAndBENextYrApprovedMap.get(entry.getKey()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)majorCodeAndBENextYrApprovedMap.get(entry.getKey()));
            this.bpBeanList.add(bpbean);
            this.computeTotal(bpbeanTotal, bpbean);
        }
        this.bpBeanList.add(bpbeanTotal);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished populateMajorCodewiseDataAcrossFunction");
        }
    }

    void populateMajorCodewiseDetailData() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting populateMajorCodewiseDetailData()................");
        }
        ArrayList<String> mandatoryFields = new ArrayList<String>();
        mandatoryFields.add("fund");
        mandatoryFields.add("function");
        mandatoryFields.add("executingDepartment");
        Position pos = this.getPosition();
        CFinancialYear financialYear = this.topBudget.getFinancialYear();
        CFinancialYear lastFinancialYearByDate = this.getFinancialYearDAO().getPreviousFinancialYearByDate(financialYear.getStartingDate());
        CFinancialYear beforeLastFinancialYearByDate = this.getFinancialYearDAO().getTwoPreviousYearByDate(financialYear.getStartingDate());
        List resultCurrentActuals = this.budgetDetailService.fetchActualsForFinYear(financialYear, mandatoryFields, this.topBudget, null, this.asOndate, Integer.valueOf(this.budgetDetail.getExecutingDepartment().getId().intValue()), this.budgetDetail.getFunction().getId(), this.excludelist);
        this.addToMapStringBigDecimal(resultCurrentActuals, this.budgetDetailIdsAndAmount);
        List resultPreviousActuals = this.budgetDetailService.fetchActualsForFinYear(lastFinancialYearByDate, mandatoryFields, this.topBudget, null, null, Integer.valueOf(this.budgetDetail.getExecutingDepartment().getId().intValue()), this.budgetDetail.getFunction().getId(), this.excludelist);
        this.addToMapStringBigDecimal(resultPreviousActuals, this.previousYearBudgetDetailIdsAndAmount);
        List resultTwoPreviousActuals = this.budgetDetailService.fetchActualsForFinYear(beforeLastFinancialYearByDate, mandatoryFields, this.topBudget, null, null, Integer.valueOf(this.budgetDetail.getExecutingDepartment().getId().intValue()), this.budgetDetail.getFunction().getId(), this.excludelist);
        this.addToMapStringBigDecimal(resultTwoPreviousActuals, this.twopreviousYearBudgetDetailIdsAndAmount);
        List resultUniqueNoBE = this.budgetDetailService.fetchUniqueNoAndBEAmount(this.topBudget, this.budgetDetail, this.budgetDetail.getFunction(), pos);
        this.addToMapStringBigDecimal(resultUniqueNoBE, this.uniqueNoAndBEMap);
        List resultUniqueNoAppr = this.budgetDetailService.fetchUniqueNoAndApprAmount(this.topBudget, this.budgetDetail, this.budgetDetail.getFunction(), pos);
        this.addToMapStringBigDecimal(resultUniqueNoAppr, this.uniqueNoAndApprMap);
        for (Map.Entry entry : this.majorCodeAndNameMap.entrySet()) {
            String formValue = this.getAppConfigValueByKey("functionWiseBudgetReport-" + (String)entry.getKey());
            boolean detailExist = false;
            boolean headerAdded = false;
            BudgetProposalBean bpbeanTotal = new BudgetProposalBean();
            for (BudgetDetail bd : this.savedbudgetDetailList) {
                if (!((String)entry.getKey()).equals(bd.getBudgetGroup().getMinCode().getMajorCode())) continue;
                detailExist = true;
                if (!headerAdded) {
                    this.bpBeanList.add(new BudgetProposalBean((String)entry.getValue(), HEADING, formValue));
                    headerAdded = true;
                }
                BudgetProposalBean bpbean = new BudgetProposalBean();
                this.populateBudgetProposalBean(bpbean, bd);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(bd.getUniqueNo() + "---" + this.budgetDetailIdsAndAmount.get(bd.getUniqueNo())));
                }
                this.bpBeanList.add(bpbean);
                this.computeTotal(bpbeanTotal, bpbean);
            }
            if (!detailExist) continue;
            this.bpBeanList.add(bpbeanTotal);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished populateMajorCodewiseDetailData()");
        }
    }

    private void populateBudgetProposalBean(BudgetProposalBean bpbean, BudgetDetail bd) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting populateBudgetProposalBean..... ");
        }
        bpbean.setRowType(DETAIL);
        bpbean.setId(bd.getId());
        bpbean.setNextYrId(bd.getNextYrId());
        bpbean.setBudget(this.topBudget.getName());
        bpbean.setFund(((Fund)this.fundMap.get(bd.getFund().getId())).getName());
        bpbean.setFunction(((CFunction)this.functionMap.get(bd.getFunction().getId())).getName());
        bpbean.setBudgetGroup(((BudgetGroup)this.budgetGroupMap.get(bd.getBudgetGroup().getId())).getName());
        bpbean.setExecutingDepartment(((Department)this.deptMap.get(bd.getExecutingDepartment().getId())).getCode());
        bpbean.setPreviousYearActuals(this.previousYearBudgetDetailIdsAndAmount.get(bd.getUniqueNo()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)this.previousYearBudgetDetailIdsAndAmount.get(bd.getUniqueNo())).toString());
        bpbean.setTwoPreviousYearActuals(this.twopreviousYearBudgetDetailIdsAndAmount.get(bd.getUniqueNo()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)this.twopreviousYearBudgetDetailIdsAndAmount.get(bd.getUniqueNo())).toString());
        bpbean.setCurrentYearActuals(this.budgetDetailIdsAndAmount.get(bd.getUniqueNo()) == null ? BigDecimal.ZERO.setScale(2).toString() : ((BigDecimal)this.budgetDetailIdsAndAmount.get(bd.getUniqueNo())).toString());
        BigDecimal lastBEAmount = this.uniqueNoAndBEMap.get(bd.getUniqueNo()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)this.uniqueNoAndBEMap.get(bd.getUniqueNo());
        BigDecimal approvedReAppropriationsTotal = this.uniqueNoAndApprMap.get(bd.getUniqueNo()) == null ? BigDecimal.ZERO.setScale(2) : (BigDecimal)this.uniqueNoAndApprMap.get(bd.getUniqueNo());
        bpbean.setCurrentYearBE(lastBEAmount.toString());
        bpbean.setReappropriation(approvedReAppropriationsTotal.toString());
        bpbean.setTotal(lastBEAmount.add(approvedReAppropriationsTotal).toString());
        bpbean.setAnticipatory(bd.getAnticipatoryAmount().setScale(2).toString());
        bpbean.setProposedRE(bd.getOriginalAmount().setScale(2));
        bpbean.setProposedBE(bd.getNextYroriginalAmount().setScale(2));
        bpbean.setApprovedRE(bd.getApprovedAmount().setScale(2));
        bpbean.setApprovedBE(bd.getNextYrapprovedAmount().setScale(2));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"before bd.getstate().getExtraInfo1()");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished populateBudgetProposalBean..... ");
        }
    }

    private Map<String, String> addToMap(List<Object[]> tempList, Map<String, String> resultMap) {
        for (Object[] row : tempList) {
            resultMap.put(row[0].toString(), row[1].toString());
        }
        return resultMap;
    }

    private Map<String, BigDecimal> addToMapStringBigDecimal(List<Object[]> tempList, Map<String, BigDecimal> resultMap) {
        for (Object[] row : tempList) {
            resultMap.put(row[0].toString(), ((BigDecimal)row[1]).setScale(2));
        }
        return resultMap;
    }

    public void populateNextYrBEinBudgetDetailList() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"starting populateNextYrBEinBudgetDetailList..................");
        }
        if (!this.savedbudgetDetailList.isEmpty()) {
            for (BudgetDetail budgetDetail : this.savedbudgetDetailList) {
                BudgetDetail nextYrbudgetDetail = (BudgetDetail)this.persistenceService.find("from BudgetDetail where uniqueNo=? and budget.referenceBudget=?", new Object[]{budgetDetail.getUniqueNo(), budgetDetail.getBudget()});
                budgetDetail.setNextYroriginalAmount(nextYrbudgetDetail.getOriginalAmount());
                budgetDetail.setNextYrapprovedAmount(nextYrbudgetDetail.getApprovedAmount());
                budgetDetail.setNextYrId(nextYrbudgetDetail.getId());
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Completed populateNextYrBEinBudgetDetailList");
        }
    }

    public boolean isConsolidatedScreen() {
        return this.consolidatedScreen;
    }

    public void setConsolidatedScreen(boolean consolidated) {
        this.consolidatedScreen = consolidated;
    }

    public boolean isAllfunctionsArrived() {
        return this.allfunctionsArrived;
    }

    public void setAllfunctionsArrived(boolean allfunctionsArrived) {
        this.allfunctionsArrived = allfunctionsArrived;
    }

    public Integer getApproverUserId() {
        return this.approverUserId;
    }

    public void setApproverUserId(Integer approverUserId) {
        this.approverUserId = approverUserId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setBudgetWorkflowService(WorkflowService<Budget> budgetWorkflowService) {
        this.budgetWorkflowService = budgetWorkflowService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public java.util.Date subtractYear(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return cal.getTime();
    }

    private String getAppConfigValueByKey(String key) {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", key);
        String appValue = "-1";
        appValue = appList.isEmpty() ? " " : ((AppConfigValues)appList.get(0)).getValue();
        return appValue;
    }

    void computeTotal(BudgetProposalBean bpbeanTotal, BudgetProposalBean bpbean) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Starting computeTotal................");
        }
        bpbeanTotal.setPreviousYearActuals(bpbeanTotal.getPreviousYearActuals() == null ? bpbean.getPreviousYearActuals() : new BigDecimal(bpbeanTotal.getPreviousYearActuals()).add(new BigDecimal(bpbean.getPreviousYearActuals())).toString());
        bpbeanTotal.setTwoPreviousYearActuals(bpbeanTotal.getTwoPreviousYearActuals() == null ? bpbean.getTwoPreviousYearActuals() : new BigDecimal(bpbeanTotal.getTwoPreviousYearActuals()).add(new BigDecimal(bpbean.getTwoPreviousYearActuals())).toString());
        bpbeanTotal.setCurrentYearActuals(bpbeanTotal.getCurrentYearActuals() == null ? bpbean.getCurrentYearActuals() : new BigDecimal(bpbeanTotal.getCurrentYearActuals()).add(new BigDecimal(bpbean.getCurrentYearActuals())).toString());
        bpbeanTotal.setCurrentYearBE(bpbeanTotal.getCurrentYearBE() == null ? bpbean.getCurrentYearBE() : new BigDecimal(bpbeanTotal.getCurrentYearBE()).add(new BigDecimal(bpbean.getCurrentYearBE())).toString());
        bpbeanTotal.setReappropriation(bpbeanTotal.getReappropriation() == null ? bpbean.getReappropriation() : new BigDecimal(bpbeanTotal.getReappropriation()).add(new BigDecimal(bpbean.getReappropriation())).toString());
        bpbeanTotal.setTotal(bpbeanTotal.getTotal() == null ? bpbean.getTotal() : new BigDecimal(bpbeanTotal.getTotal()).add(new BigDecimal(bpbean.getTotal())).toString());
        bpbeanTotal.setAnticipatory(bpbeanTotal.getAnticipatory() == null ? bpbean.getAnticipatory() : new BigDecimal(bpbeanTotal.getAnticipatory()).add(new BigDecimal(bpbean.getAnticipatory())).toString());
        bpbeanTotal.setProposedRE(bpbeanTotal.getProposedRE() == null ? bpbean.getProposedRE() : bpbeanTotal.getProposedRE().add(bpbean.getProposedRE()).setScale(2));
        bpbeanTotal.setProposedBE(bpbeanTotal.getProposedBE() == null ? bpbean.getProposedBE() : bpbeanTotal.getProposedBE().add(bpbean.getProposedBE()).setScale(2));
        bpbeanTotal.setApprovedRE(bpbeanTotal.getApprovedRE() == null ? bpbean.getApprovedRE() : bpbeanTotal.getApprovedRE().add(bpbean.getApprovedRE()).setScale(2));
        bpbeanTotal.setApprovedBE(bpbeanTotal.getApprovedBE() == null ? bpbean.getApprovedBE() : bpbeanTotal.getApprovedBE().add(bpbean.getApprovedBE()).setScale(2));
        bpbeanTotal.setRowType(TOTAL);
        bpbeanTotal.setBudgetGroup("TOTAL");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Finished computeTotal");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SkipValidation
    @Action(value="/budget/budgetProposal-update")
    public String update() {
        List assignment;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Stating updation .....");
        }
        for (BudgetProposalBean bpBean : this.bpBeanList) {
            if (bpBean == null || bpBean.getId() == null) continue;
            this.budgetDetail = (BudgetDetail)this.budgetDetailService.find("from BudgetDetail where id=?", new Object[]{bpBean.getId()});
            break;
        }
        if (!(assignment = this.assignmentService.findAllAssignmentsByHODDeptAndDates(this.budgetDetail.getExecutingDepartment().getId(), this.budgetDetail.getBudget().getAsOnDate())).isEmpty()) {
            this.approverPositionId = ((Assignment)assignment.get(0)).getPosition().getId();
        }
        this.populateWorkflowBean();
        if (this.actionName.contains("Forward")) {
            if (assignment.isEmpty()) throw new ValidationException("", "Approver doesn't exists for the selected department", new String[0]);
            this.addActionMessage(this.getText("budgetdetail.forward", new String[]{((Assignment)assignment.get(0)).getEmployee().getName()}));
        } else if (this.actionName.contains("Verify")) {
            this.addActionMessage(this.getText("budgetdetail.verify"));
        } else if (this.actionName.contains("Cancel")) {
            this.addActionMessage(this.getText("budgetdetail.cancel"));
        } else {
            Assignment initiator = this.budgetDetailService.getWorkflowInitiator(this.budgetDetail);
            this.addActionMessage(this.getText("budgetdetail.reject", new String[]{initiator.getEmployee().getName()}));
        }
        this.budgetDetailActionHelper.update(this.bpBeanList, this.workflowBean);
        if (!LOGGER.isDebugEnabled()) return MESSAGE;
        LOGGER.debug((Object)"Completed updation .....");
        return MESSAGE;
    }

    protected void populateWorkflowBean() {
        this.workflowBean.setApproverPositionId(this.approverPositionId);
        this.workflowBean.setApproverComments(this.approverComments);
        this.workflowBean.setWorkFlowAction(this.actionName);
        this.workflowBean.setCurrentState(this.currentState);
    }

    public String modifyList() {
        if (this.budgetDetail.getBudget().getId() != null) {
            this.topBudget = (Budget)this.budgetService.find("from Budget where id=?", new Object[]{this.budgetDetail.getBudget().getId()});
        }
        this.consolidatedScreen = this.budgetDetailService.toBeConsolidated();
        if (this.isHOD()) {
            this.allfunctionsArrived = this.validateForAllFunctionsMappedForDept(this.topBudget, this.getPosition());
        }
        return "detailList";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isHOD() {
        Assignment empAssignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(ApplicationThreadLocals.getUserId(), new java.util.Date());
        if (empAssignment.getDesignation().getName().equalsIgnoreCase("assistant")) {
            this.asstFMU = true;
            BudgetDetail approvedBd = (BudgetDetail)this.persistenceService.find(" from  BudgetDetail where budget=? and approvedAmount>0 ", new Object[]{this.topBudget});
            if (approvedBd == null) return this.eisCommonService.isHod(empAssignment.getId());
        }
        if (!empAssignment.getDesignation().getName().equalsIgnoreCase("CHIEF ACCOUNTS OFFICER")) return this.eisCommonService.isHod(empAssignment.getId());
        this.asstFMU = true;
        return this.eisCommonService.isHod(empAssignment.getId());
    }

    public Position getPosition() throws ApplicationRuntimeException {
        Position pos = this.eisCommonService.getPrimaryAssignmentPositionForEmp(ApplicationThreadLocals.getUserId());
        return pos;
    }

    private boolean validateForAllFunctionsMappedForDept(Budget topBudget, Position position) {
        BudgetDetail bd = (BudgetDetail)this.budgetDetailService.find("from BudgetDetail  where budget.id=?", new Object[]{topBudget.getId()});
        String Query2 = "select distinct(f.name) as functionid from eg_dept_functionmap m,function f where departmentid=" + bd.getExecutingDepartment().getId() + " and f.id= m.functionid and m.budgetaccount_Type='" + this.budgetDetailHelper.accountTypeForFunctionDeptMap(topBudget.getName()) + "' EXCEPT  select distinct(f.name) as functionid from egf_budgetdetail bd,eg_wf_states s,function f where bd.budget=" + topBudget.getId() + " and bd.state_id=s.id and s.owner_pos=" + position.getId() + " and bd.function=f.id order by functionid";
        SQLQuery functionsNotUsed = this.persistenceService.getSession().createSQLQuery(Query2);
        List notUsedList = functionsNotUsed.list();
        if (notUsedList.size() > 0) {
            this.functionsNotYetReceiced = "";
            for (String s : notUsedList) {
                this.functionsNotYetReceiced = this.functionsNotYetReceiced + s + " ,";
            }
            return false;
        }
        return true;
    }

    public String capitalize(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
    }

    public String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("select name from companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    protected Boolean validateOwner() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("validating owner for user " + ApplicationThreadLocals.getUserId()));
        }
        List positionsForUser = null;
        positionsForUser = this.eisService.getPositionsForUser(Long.valueOf(ApplicationThreadLocals.getUserId()), new java.util.Date());
        State state = this.factor.equalsIgnoreCase(this.bigThousand.toString()) ? (State)this.persistenceService.find("select b.state from Budget b where b.id =(select bd.budget.id from BudgetDetail bd where bd.id=?) ", new Object[]{this.validId}) : (State)this.persistenceService.find("select bd.state from BudgetDetail bd where bd.id=? ", new Object[]{this.validId});
        if (state != null && positionsForUser.contains(state.getOwnerPosition())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Valid Owner :return true");
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Invalid  Owner :return false");
        }
        return false;
    }

    public BudgetProposalBean getBpBean() {
        return this.bpBean;
    }

    public void setBpBean(BudgetProposalBean bpBean) {
        this.bpBean = bpBean;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }

    public void setBudgetDetail(BudgetDetail budgetDetail) {
        this.budgetDetail = budgetDetail;
    }

    public Budget getTopBudget() {
        return this.topBudget;
    }

    public void setTopBudget(Budget topBudget) {
        this.topBudget = topBudget;
    }

    public VoucherService getVoucherService() {
        return this.voucherService;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public String getCurrentfinYearRange() {
        return this.currentfinYearRange;
    }

    public void setCurrentfinYearRange(String currentfinYearRange) {
        this.currentfinYearRange = currentfinYearRange;
    }

    public String getNextfinYearRange() {
        return this.nextfinYearRange;
    }

    public void setNextfinYearRange(String nextfinYearRange) {
        this.nextfinYearRange = nextfinYearRange;
    }

    public String getPreviousfinYearRange() {
        return this.previousfinYearRange;
    }

    public void setPreviousfinYearRange(String previousfinYearRange) {
        this.previousfinYearRange = previousfinYearRange;
    }

    public String getTwopreviousfinYearRange() {
        return this.twopreviousfinYearRange;
    }

    public void setTwopreviousfinYearRange(String twopreviousfinYearRange) {
        this.twopreviousfinYearRange = twopreviousfinYearRange;
    }

    public List<BudgetDetail> getBudgetDetailList() {
        return this.budgetDetailList;
    }

    public void setBudgetDetailList(List<BudgetDetail> budgetDetailList) {
        this.budgetDetailList = budgetDetailList;
    }

    public List<BudgetDetail> getSavedbudgetDetailList() {
        return this.savedbudgetDetailList;
    }

    public void setSavedbudgetDetailList(List<BudgetDetail> savedbudgetDetailList) {
        this.savedbudgetDetailList = savedbudgetDetailList;
    }

    public BudgetDetailService getBudgetDetailService() {
        return this.budgetDetailService;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailService) {
        this.budgetDetailService = budgetDetailService;
    }

    public BudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public Map<Long, String> getPreviuosYearBudgetDetailMap() {
        return this.previuosYearBudgetDetailMap;
    }

    public void setPreviuosYearBudgetDetailMap(Map<Long, String> previuosYearBudgetDetailMap) {
        this.previuosYearBudgetDetailMap = previuosYearBudgetDetailMap;
    }

    public Map<Long, String> getBeforePreviousYearBudgetDetailMap() {
        return this.beforePreviousYearBudgetDetailMap;
    }

    public void setBeforePreviousYearBudgetDetailMap(Map<Long, String> beforePreviousYearBudgetDetailMap) {
        this.beforePreviousYearBudgetDetailMap = beforePreviousYearBudgetDetailMap;
    }

    public Map<String, BigDecimal> getBudgetDetailIdsAndAmount() {
        return this.budgetDetailIdsAndAmount;
    }

    public void setBudgetDetailIdsAndAmount(Map<String, BigDecimal> budgetDetailIdsAndAmount) {
        this.budgetDetailIdsAndAmount = budgetDetailIdsAndAmount;
    }

    public Map<String, BigDecimal> getPreviousYearBudgetDetailIdsAndAmount() {
        return this.previousYearBudgetDetailIdsAndAmount;
    }

    public void setPreviousYearBudgetDetailIdsAndAmount(Map<String, BigDecimal> previousYearBudgetDetailIdsAndAmount) {
        this.previousYearBudgetDetailIdsAndAmount = previousYearBudgetDetailIdsAndAmount;
    }

    public Map<String, BigDecimal> getTwopreviousYearBudgetDetailIdsAndAmount() {
        return this.twopreviousYearBudgetDetailIdsAndAmount;
    }

    public void setTwopreviousYearBudgetDetailIdsAndAmount(Map<String, BigDecimal> twopreviousYearBudgetDetailIdsAndAmount) {
        this.twopreviousYearBudgetDetailIdsAndAmount = twopreviousYearBudgetDetailIdsAndAmount;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public Integer getDefaultDept() {
        return this.defaultDept;
    }

    public void setDefaultDept(Integer defaultDept) {
        this.defaultDept = defaultDept;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public static String getActionname() {
        return ACTIONNAME;
    }

    public List<BudgetProposalBean> getBpBeanList() {
        return this.bpBeanList;
    }

    public void setBpBeanList(List<BudgetProposalBean> bpBeanList) {
        this.bpBeanList = bpBeanList;
    }

    public java.util.Date getAsOndate() {
        return this.asOndate;
    }

    public void setAsOndate(java.util.Date asOndate) {
        this.asOndate = asOndate;
    }

    public String getFunctionsNotYetReceiced() {
        return this.functionsNotYetReceiced;
    }

    public void setFunctionsNotYetReceiced(String functionsNotYetReceiced) {
        this.functionsNotYetReceiced = functionsNotYetReceiced;
    }

    public boolean isAsstFMU() {
        return this.asstFMU;
    }

    public void setAsstFMU(boolean asstFMU) {
        this.asstFMU = asstFMU;
    }

    public void setBudgetDetailHelper(BudgetDetailHelper budgetDetailHelper) {
        this.budgetDetailHelper = budgetDetailHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getDocNo() {
        return this.docNo;
    }

    public void setDocNo(Long docNo) {
        this.docNo = docNo;
    }

    public String getAmountField() {
        return this.amountField;
    }

    public void setAmountField(String amountField) {
        this.amountField = amountField;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getFactor() {
        return this.factor;
    }

    public void setFactor(String factor) {
        this.factor = factor;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public Long getDetailId() {
        return this.detailId;
    }

    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }

    public Long getValidId() {
        return this.validId;
    }

    public void setValidId(Long validId) {
        this.validId = validId;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }
}

