/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FunctionDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.BudgetUpload;
import org.egov.services.budget.BudgetDetailService;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.multipart.MultipartFile;

@ParentPackage(value="egov")
@Results(value={@Result(name={"upload"}, location="budgetLoad-upload.jsp"), @Result(name={"result"}, location="budgetLoad-result.jsp")})
public class BudgetLoadAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BudgetLoadAction.class);
    private File budgetInXls;
    private String budgetInXlsFileName;
    private String budgetInXlsContentType;
    private static final int RE_YEAR_ROW_INDEX = 1;
    private static final int BE_YEAR_ROW_INDEX = 2;
    private static final int DATA_STARTING_ROW_INDEX = 4;
    private static final int FUNDCODE_CELL_INDEX = 0;
    private static final int DEPARTMENTCODE_CELL_INDEX = 1;
    private static final int FUNCTIONCODE_CELL_INDEX = 2;
    private static final int GLCODE_CELL_INDEX = 3;
    private static final int REAMOUNT_CELL_INDEX = 4;
    private static final int BEAMOUNT_CELL_INDEX = 5;
    private static final int PLANNINGPERCENTAGE_CELL_INDEX = 6;
    private boolean errorInMasterData = false;
    private MultipartFile[] originalFile = new MultipartFile[1];
    private MultipartFile[] outPutFile = new MultipartFile[1];
    private String originalFileStoreId;
    private String outPutFileStoreId;
    private List<FileStoreMapper> originalFiles = new ArrayList();
    private List<FileStoreMapper> outPutFiles = new ArrayList();
    private String budgetOriginalFileName;
    private String budgetOutPutFileName;
    private String timeStamp;
    private String budgetUploadError = "Upload the Budget Data as shown in the Download Template format";
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private FundHibernateDAO fundDAO;
    @Autowired
    private FunctionDAO functionDAO;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="budgetDetailService")
    private BudgetDetailService budgetDetailService;
    @Autowired
    protected FileStoreService fileStoreService;

    public void prepare() {
    }

    public Object getModel() {
        return null;
    }

    @Action(value="/budget/budgetLoad-beforeUpload")
    public String beforeUpload() {
        this.originalFiles = this.persistenceService.getSession().createQuery("from FileStoreMapper where fileName like '%budget_original%' order by id desc ").setMaxResults(5).list();
        this.outPutFiles = this.persistenceService.getSession().createQuery("from FileStoreMapper where fileName like '%budget_output%' order by id desc ").setMaxResults(5).list();
        return "upload";
    }

    @ValidationErrorPage(value="upload")
    @Action(value="/budget/budgetLoad-upload")
    public String upload() {
        try {
            FileInputStream fsIP = new FileInputStream(this.budgetInXls);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fsIP);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.getNumberOfSheets();
            HSSFSheet sheet = wb.getSheetAt(0);
            HSSFRow reRow = sheet.getRow(1);
            HSSFRow beRow = sheet.getRow(2);
            String reFinYearRange = this.getStrValue(reRow.getCell(1));
            String beFinYearRange = this.getStrValue(beRow.getCell(1));
            CFinancialYear reFYear = this.financialYearDAO.getFinancialYearByFinYearRange(reFinYearRange);
            CFinancialYear beFYear = this.financialYearDAO.getNextFinancialYearByDate(reFYear.getStartingDate());
            if (!this.validateFinancialYears(reFYear, beFYear, beFinYearRange)) {
                throw new ValidationException(Arrays.asList(new ValidationError(this.getText("be.year.is.not.immediate.next.fy.year.of.re.year"), this.getText("be.year.is.not.immediate.next.fy.year.of.re.year"))));
            }
            this.timeStamp = new Timestamp(new Date().getTime()).toString().replace(".", "_");
            if (this.budgetInXlsFileName.contains("_budget_original_")) {
                this.budgetOriginalFileName = this.budgetInXlsFileName.split("_budget_original_")[0] + "_budget_original_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            } else if (this.budgetInXlsFileName.contains("_budget_output_")) {
                this.budgetOriginalFileName = this.budgetInXlsFileName.split("_budget_output_")[0] + "_budget_original_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            } else {
                if (this.budgetInXlsFileName.length() > 60) {
                    throw new ValidationException(Arrays.asList(new ValidationError(this.getText("file.name.should.be.less.then.60.characters"), this.getText("file.name.should.be.less.then.60.characters"))));
                }
                this.budgetOriginalFileName = this.budgetInXlsFileName.split("\\.")[0] + "_budget_original_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            }
            FileStoreMapper originalFileStore = this.fileStoreService.store(this.budgetInXls, this.budgetOriginalFileName, this.budgetInXlsContentType, "EGF", false);
            this.persistenceService.persist((Object)originalFileStore);
            this.originalFileStoreId = originalFileStore.getFileStoreId();
            List budgetUploadList = this.loadToBudgetUpload(sheet);
            budgetUploadList = this.validateMasterData(budgetUploadList);
            budgetUploadList = this.validateDuplicateData(budgetUploadList);
            if (this.errorInMasterData) {
                fsIP.close();
                this.prepareOutPutFileWithErrors(budgetUploadList);
                this.addActionMessage(this.getText("error.while.validating.masterdata"));
                return "result";
            }
            budgetUploadList = this.removeEmptyRows(budgetUploadList);
            budgetUploadList = this.budgetDetailService.loadBudget(budgetUploadList, reFYear, beFYear);
            fsIP.close();
            this.prepareOutPutFileWithFinalStatus(budgetUploadList);
            this.addActionMessage(this.getText("budget.load.sucessful"));
        }
        catch (ValidationException e) {
            this.originalFiles = this.persistenceService.getSession().createQuery("from FileStoreMapper where fileName like '%budget_original%' order by id desc ").setMaxResults(5).list();
            this.outPutFiles = this.persistenceService.getSession().createQuery("from FileStoreMapper where fileName like '%budget_output%' order by id desc ").setMaxResults(5).list();
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            this.originalFiles = this.persistenceService.getSession().createQuery("from FileStoreMapper where fileName like '%budget_original%' order by id desc ").setMaxResults(5).list();
            this.outPutFiles = this.persistenceService.getSession().createQuery("from FileStoreMapper where fileName like '%budget_output%' order by id desc ").setMaxResults(5).list();
            throw new ValidationException(Arrays.asList(new ValidationError(this.budgetUploadError, this.budgetUploadError)));
        }
        return "result";
    }

    private void prepareOutPutFileWithErrors(List<BudgetUpload> budgetUploadList) {
        try {
            FileInputStream fsIP = new FileInputStream(this.budgetInXls);
            HashMap<String, String> errorsMap = new HashMap<String, String>();
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fsIP);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.getNumberOfSheets();
            HSSFSheet sheet = wb.getSheetAt(0);
            HSSFRow row = sheet.getRow(3);
            HSSFCell cell = row.createCell(7);
            cell.setCellValue("Error Reason");
            for (BudgetUpload budget : budgetUploadList) {
                errorsMap.put(budget.getFundCode() + "-" + budget.getFunctionCode() + "-" + budget.getDeptCode() + "-" + budget.getBudgetHead(), budget.getErrorReason());
            }
            for (int i = 4; i <= sheet.getLastRowNum(); ++i) {
                HSSFRow errorRow = sheet.getRow(i);
                HSSFCell errorCell = errorRow.createCell(7);
                errorCell.setCellValue((String)errorsMap.get(this.getStrValue(sheet.getRow(i).getCell(0)) + "-" + this.getStrValue(sheet.getRow(i).getCell(2)) + "-" + this.getStrValue(sheet.getRow(i).getCell(1)) + "-" + this.getStrValue(sheet.getRow(i).getCell(3))));
            }
            FileOutputStream output_file = new FileOutputStream(this.budgetInXls);
            wb.write((OutputStream)output_file);
            output_file.close();
            if (this.budgetInXlsFileName.contains("_budget_original_")) {
                this.budgetOutPutFileName = this.budgetInXlsFileName.split("_budget_original_")[0] + "_budget_output_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            } else if (this.budgetInXlsFileName.contains("_budget_output_")) {
                this.budgetOutPutFileName = this.budgetInXlsFileName.split("_budget_output_")[0] + "_budget_output_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            } else {
                if (this.budgetInXlsFileName.length() > 60) {
                    throw new ValidationException(Arrays.asList(new ValidationError(this.getText("file.name.should.be.less.then.60.characters"), this.getText("file.name.should.be.less.then.60.characters"))));
                }
                this.budgetOutPutFileName = this.budgetInXlsFileName.split("\\.")[0] + "_budget_output_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            }
            FileStoreMapper outPutFileStore = this.fileStoreService.store(this.budgetInXls, this.budgetOutPutFileName, this.budgetInXlsContentType, "EGF");
            this.persistenceService.persist((Object)outPutFileStore);
            this.outPutFileStoreId = outPutFileStore.getFileStoreId();
        }
        catch (FileNotFoundException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (IOException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    private void prepareOutPutFileWithFinalStatus(List<BudgetUpload> budgetUploadList) {
        try {
            FileInputStream fsIP = new FileInputStream(this.budgetInXls);
            HashMap errorsMap = new HashMap();
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fsIP);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.getNumberOfSheets();
            HSSFSheet sheet = wb.getSheetAt(0);
            HashMap<String, String> finalStatusMap = new HashMap<String, String>();
            HSSFRow row = sheet.getRow(3);
            HSSFCell cell = row.createCell(7);
            cell.setCellValue("Status");
            for (BudgetUpload budget : budgetUploadList) {
                finalStatusMap.put(budget.getFundCode() + "-" + budget.getFunctionCode() + "-" + budget.getDeptCode() + "-" + budget.getBudgetHead(), budget.getFinalStatus());
            }
            for (int i = 4; i <= sheet.getLastRowNum(); ++i) {
                HSSFRow finalStatusRow = sheet.getRow(i);
                HSSFCell finalStatusCell = finalStatusRow.createCell(7);
                finalStatusCell.setCellValue((String)finalStatusMap.get(this.getStrValue(sheet.getRow(i).getCell(0)) + "-" + this.getStrValue(sheet.getRow(i).getCell(2)) + "-" + this.getStrValue(sheet.getRow(i).getCell(1)) + "-" + this.getStrValue(sheet.getRow(i).getCell(3))));
            }
            FileOutputStream output_file = new FileOutputStream(this.budgetInXls);
            wb.write((OutputStream)output_file);
            output_file.close();
            if (this.budgetInXlsFileName.contains("_budget_original_")) {
                this.budgetOutPutFileName = this.budgetInXlsFileName.split("_budget_original_")[0] + "_budget_output_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            } else if (this.budgetInXlsFileName.contains("_budget_output_")) {
                this.budgetOutPutFileName = this.budgetInXlsFileName.split("_budget_output_")[0] + "_budget_output_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            } else {
                if (this.budgetInXlsFileName.length() > 60) {
                    throw new ValidationException(Arrays.asList(new ValidationError(this.getText("file.name.should.be.less.then.60.characters"), this.getText("file.name.should.be.less.then.60.characters"))));
                }
                this.budgetOutPutFileName = this.budgetInXlsFileName.split("\\.")[0] + "_budget_output_" + this.timeStamp + "." + this.budgetInXlsFileName.split("\\.")[1];
            }
            FileStoreMapper outPutFileStore = this.fileStoreService.store(this.budgetInXls, this.budgetOutPutFileName, this.budgetInXlsContentType, "EGF");
            this.persistenceService.persist((Object)outPutFileStore);
            this.outPutFileStoreId = outPutFileStore.getFileStoreId();
        }
        catch (FileNotFoundException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        catch (IOException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    private List<BudgetUpload> removeEmptyRows(List<BudgetUpload> budgetUploadList) {
        ArrayList<BudgetUpload> tempList = new ArrayList<BudgetUpload>();
        for (BudgetUpload budget : budgetUploadList) {
            if (budget.getErrorReason().equalsIgnoreCase("Empty Record")) continue;
            tempList.add(budget);
        }
        return tempList;
    }

    private List<BudgetUpload> validateMasterData(List<BudgetUpload> budgetUploadList) {
        ArrayList<BudgetUpload> tempList = new ArrayList<BudgetUpload>();
        try {
            String error = "";
            HashMap<String, Fund> fundMap = new HashMap<String, Fund>();
            HashMap<String, CFunction> functionMap = new HashMap<String, CFunction>();
            HashMap<String, Department> departmentMap = new HashMap<String, Department>();
            HashMap<String, CChartOfAccounts> coaMap = new HashMap<String, CChartOfAccounts>();
            List fundList = this.fundDAO.findAllActiveIsLeafFunds();
            List functionList = this.functionDAO.getAllActiveFunctions();
            List departmentList = this.departmentService.getAllDepartments();
            List coaList = this.chartOfAccountsService.findAll();
            for (Fund fund : fundList) {
                fundMap.put(fund.getCode(), fund);
            }
            for (CFunction function : functionList) {
                functionMap.put(function.getCode(), function);
            }
            for (Department department : departmentList) {
                departmentMap.put(department.getCode(), department);
            }
            for (CChartOfAccounts coa : coaList) {
                coaMap.put(coa.getGlcode(), coa);
            }
            for (BudgetUpload budget : budgetUploadList) {
                error = "";
                if (budget.getFundCode() != null && !budget.getFundCode().equalsIgnoreCase("") && fundMap.get(budget.getFundCode()) == null) {
                    error = error + this.getText("fund.is.not.exist") + budget.getFundCode();
                } else {
                    budget.setFund((Fund)fundMap.get(budget.getFundCode()));
                }
                if (budget.getFunctionCode() != null && !budget.getFunctionCode().equalsIgnoreCase("") && functionMap.get(budget.getFunctionCode()) == null) {
                    error = error + " " + this.getText("function.is.not.exist") + budget.getFunctionCode();
                } else {
                    budget.setFunction((CFunction)functionMap.get(budget.getFunctionCode()));
                }
                if (budget.getDeptCode() != null && !budget.getFundCode().equalsIgnoreCase("") && departmentMap.get(budget.getDeptCode()) == null) {
                    error = error + " " + this.getText("department.is.not.exist") + budget.getDeptCode();
                } else {
                    budget.setDept((Department)departmentMap.get(budget.getDeptCode()));
                }
                if (budget.getBudgetHead() != null && !budget.getBudgetHead().equalsIgnoreCase("") && coaMap.get(budget.getBudgetHead()) == null) {
                    error = error + " " + this.getText("coa.is.not.exist") + budget.getBudgetHead();
                } else {
                    budget.setCoa((CChartOfAccounts)coaMap.get(budget.getBudgetHead()));
                }
                budget.setErrorReason(error);
                if (!error.equalsIgnoreCase("")) {
                    this.errorInMasterData = true;
                }
                tempList.add(budget);
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return tempList;
    }

    private List<BudgetUpload> validateDuplicateData(List<BudgetUpload> budgetUploadList) {
        ArrayList<BudgetUpload> tempList = new ArrayList<BudgetUpload>();
        try {
            String error = "";
            HashMap<String, BudgetUpload> budgetUploadMap = new HashMap<String, BudgetUpload>();
            for (BudgetUpload budget : budgetUploadList) {
                if (!(budget.getFundCode() == null || budget.getFunctionCode() == null || budget.getDeptCode() == null || budget.getBudgetHead() == null || budget.getFundCode().equalsIgnoreCase("") || budget.getFunctionCode().equalsIgnoreCase("") || budget.getDeptCode().equalsIgnoreCase("") || budget.getBudgetHead().equalsIgnoreCase(""))) {
                    if (budgetUploadMap.get(budget.getFundCode() + "-" + budget.getFunctionCode() + "-" + budget.getDeptCode() + "-" + budget.getBudgetHead()) == null) {
                        budgetUploadMap.put(budget.getFundCode() + "-" + budget.getFunctionCode() + "-" + budget.getDeptCode() + "-" + budget.getBudgetHead(), budget);
                    } else {
                        budget.setErrorReason(budget.getErrorReason() + this.getText("duplicate.record"));
                        this.errorInMasterData = true;
                    }
                } else if (budget.getFundCode() == null && budget.getFunctionCode() == null && budget.getDeptCode() == null && budget.getBudgetHead() == null) {
                    budget.setErrorReason(this.getText("empty.record"));
                } else {
                    budget.setErrorReason(this.getText("empty.record"));
                }
                tempList.add(budget);
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return tempList;
    }

    private List<BudgetUpload> loadToBudgetUpload(HSSFSheet sheet) {
        ArrayList<BudgetUpload> budgetUploadList = new ArrayList<BudgetUpload>();
        try {
            for (int i = 4; i <= sheet.getLastRowNum(); ++i) {
                budgetUploadList.add(this.getBudgetUpload(sheet.getRow(i)));
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return budgetUploadList;
    }

    private BudgetUpload getBudgetUpload(HSSFRow row) {
        BudgetUpload budget = new BudgetUpload();
        try {
            if (row != null) {
                budget.setFundCode(this.getStrValue(row.getCell(0)) == null ? "" : this.getStrValue(row.getCell(0)));
                budget.setDeptCode(this.getStrValue(row.getCell(1)) == null ? "" : this.getStrValue(row.getCell(1)));
                budget.setFunctionCode(this.getStrValue(row.getCell(2)) == null ? "" : this.getStrValue(row.getCell(2)));
                budget.setBudgetHead(this.getStrValue(row.getCell(3)) == null ? "" : this.getStrValue(row.getCell(3)));
                budget.setReAmount(BigDecimal.valueOf(Long.valueOf(this.getStrValue(row.getCell(4)) == null ? "0" : this.getStrValue(row.getCell(4)))));
                budget.setBeAmount(BigDecimal.valueOf(Long.valueOf(this.getStrValue(row.getCell(5)) == null ? "0" : this.getStrValue(row.getCell(5)))));
                budget.setPlanningPercentage(Long.valueOf(this.getNumericValue(row.getCell(6)) == null ? 0L : this.getNumericValue(row.getCell(6)).longValue()));
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return budget;
    }

    private boolean validateFinancialYears(CFinancialYear reFYear, CFinancialYear beFYear, String beYear) {
        try {
            if (reFYear == null) {
                throw new ValidationException(Arrays.asList(new ValidationError(this.getText("re.year.is.not.exist"), this.getText("re.year.is.not.exist"))));
            }
            if (beFYear == null) {
                throw new ValidationException(Arrays.asList(new ValidationError(this.getText("be.year.is.not.exist"), this.getText("be.year.is.not.exist"))));
            }
            return beFYear.getFinYearRange().equalsIgnoreCase(beYear);
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(this.getText("year.is.not.exist"), this.getText("year.is.not.exist"))));
        }
    }

    public void validate() {
    }

    private String getStrValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        double numericCellValue = 0.0;
        String strValue = "";
        switch (cell.getCellType()) {
            case 0: {
                numericCellValue = cell.getNumericCellValue();
                DecimalFormat decimalFormat = new DecimalFormat("#");
                strValue = decimalFormat.format(numericCellValue);
                break;
            }
            case 1: {
                strValue = cell.getStringCellValue();
            }
        }
        return strValue;
    }

    private BigDecimal getNumericValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        double numericCellValue = 0.0;
        BigDecimal bigDecimalValue = BigDecimal.ZERO;
        String strValue = "";
        switch (cell.getCellType()) {
            case 0: {
                numericCellValue = cell.getNumericCellValue();
                bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                break;
            }
            case 1: {
                strValue = cell.getStringCellValue();
                strValue = strValue.replaceAll("[^\\p{L}\\p{Nd}]", "");
                if (strValue != null && strValue.contains("E+")) {
                    String[] split = strValue.split("E+");
                    String mantissa = split[0].replaceAll(".", "");
                    int exp = Integer.parseInt(split[1]);
                    while (mantissa.length() <= exp + 1) {
                        mantissa = mantissa + "0";
                    }
                    numericCellValue = Double.parseDouble(mantissa);
                    bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                } else if (strValue != null && strValue.contains(",")) {
                    strValue = strValue.replaceAll(",", "");
                }
                try {
                    numericCellValue = Double.parseDouble(strValue);
                    bigDecimalValue = BigDecimal.valueOf(numericCellValue);
                    break;
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break;
                    LOGGER.debug((Object)("Found : Non numeric value in Numeric Field :" + strValue + ":"));
                }
            }
        }
        return bigDecimalValue;
    }

    public File getBudgetInXls() {
        return this.budgetInXls;
    }

    public void setBudgetInXls(File budgetInXls) {
        this.budgetInXls = budgetInXls;
    }

    public String getOriginalFileStoreId() {
        return this.originalFileStoreId;
    }

    public void setOriginalFileStoreId(String originalFileStoreId) {
        this.originalFileStoreId = originalFileStoreId;
    }

    public void setBudgetInXlsFileName(String budgetInXlsFileName) {
        this.budgetInXlsFileName = budgetInXlsFileName;
    }

    public void setBudgetInXlsContentType(String budgetInXlsContentType) {
        this.budgetInXlsContentType = budgetInXlsContentType;
    }

    public String getOutPutFileStoreId() {
        return this.outPutFileStoreId;
    }

    public void setOutPutFileStoreId(String outPutFileStoreId) {
        this.outPutFileStoreId = outPutFileStoreId;
    }

    public List<FileStoreMapper> getOriginalFiles() {
        return this.originalFiles;
    }

    public void setOriginalFiles(List<FileStoreMapper> originalFiles) {
        this.originalFiles = originalFiles;
    }

    public List<FileStoreMapper> getOutPutFiles() {
        return this.outPutFiles;
    }

    public void setOutPutFiles(List<FileStoreMapper> outPutFiles) {
        this.outPutFiles = outPutFiles;
    }

    public String getBudgetOriginalFileName() {
        return this.budgetOriginalFileName;
    }

    public void setBudgetOriginalFileName(String budgetOriginalFileName) {
        this.budgetOriginalFileName = budgetOriginalFileName;
    }

    public String getBudgetOutPutFileName() {
        return this.budgetOutPutFileName;
    }

    public void setBudgetOutPutFileName(String budgetOutPutFileName) {
        this.budgetOutPutFileName = budgetOutPutFileName;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }
}

