/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.budget;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.EgwStatus;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.CFinancialYearService;
import org.egov.egf.model.BudgetAmountView;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.budget.Budget;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.services.budget.BudgetDetailActionHelper;
import org.egov.services.budget.BudgetDetailHelperBean;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetService;
import org.egov.utils.BudgetDetailConfig;
import org.egov.utils.BudgetDetailHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseBudgetDetailAction
extends GenericWorkFlowAction {
    private static final String EGF_BUDGET_GROUP = "egf-budgetGroup";
    private static final String EGI_FUNCTIONARY = "egi-functionary";
    private static final String EGI_FUNCTION = "egi-function";
    private static final String EGI_DEPARTMENT = "egi-department";
    private static final String HOD_NOT_FOUND = "hod.not.found";
    private static final long serialVersionUID = 1L;
    protected BudgetDetail budgetDetail = new BudgetDetail();
    protected List<BudgetDetail> budgetDetailList = new ArrayList();
    protected List<BudgetDetail> savedbudgetDetailList = new ArrayList();
    @Autowired
    @Qualifier(value="budgetDetailService")
    protected BudgetDetailService budgetDetailService;
    @Autowired
    @Qualifier(value="budgetService")
    protected BudgetService budgetService;
    protected List<String> headerFields = new ArrayList();
    protected List<String> gridFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    public WorkflowBean workflowBean = new WorkflowBean();
    protected WorkflowService<Budget> budgetWorkflowService;
    protected WorkflowService<BudgetDetail> budgetDetailWorkflowService;
    protected boolean headerDisabled = false;
    protected List<BudgetAmountView> budgetAmountView = new ArrayList();
    protected String currentYearRange;
    protected String previousYearRange;
    private String nextYearRange;
    protected String lastButOneYearRange;
    protected List<Scheme> subSchemes;
    protected Integer schemeId;
    protected Date asOnDate;
    @Autowired
    private EisCommonService eisCommonService;
    protected BudgetDetailHelper budgetDetailHelper;
    protected boolean addNewDetails = false;
    @Autowired
    private BudgetDetailActionHelper budgetDetailActionHelper;
    private static final String NEWRE = "new-re";
    private static final String BUDGETLIST = "budgetList";
    private static final String RE = "RE";
    private static final String SAVE = "budgetdetail.save";
    private static final String BUDGETRE = "budgetDetail.re.amount";
    private static final String BUDGETBE = "budgetDetail.be.amount";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    protected BudgetDetailConfig budgetDetailConfig;
    private static final String BUDGETMANDATORY = "budgetDetail.budget.mandatory";
    @Autowired
    private CFinancialYearService financialYearService;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    protected boolean re = false;
    private boolean showMessage = false;
    protected List<BigDecimal> beAmounts = new ArrayList();
    private Budget referenceBudget;
    private CFinancialYear financialYear;
    protected List<Budget> budgetList = new ArrayList();
    protected boolean showRe;
    public Long budgetDocumentNumber;
    protected boolean showDetails;
    protected Long searchfunctionid;
    protected Long searchbudgetGroupid;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private static Logger LOGGER = Logger.getLogger(BaseBudgetDetailAction.class);

    public abstract void populateSavedbudgetDetailListFor(Budget var1);

    public abstract void populateSavedbudgetDetailListForDetail(BudgetDetail var1);

    protected abstract void saveAndStartWorkFlow(BudgetDetail var1, WorkflowBean var2);

    protected abstract void saveAndStartWorkFlowForRe(BudgetDetail var1, int var2, CFinancialYear var3, Budget var4, WorkflowBean var5);

    protected abstract void approve();

    public String execute() {
        return "new";
    }

    @ValidationErrorPage(value="new-re")
    @Action(value="/budget/budgetProposalDetail-createRE")
    public String createRe() {
        this.showRe = true;
        try {
            this.getActionMessages().clear();
            this.validateMandatoryFields();
            this.budgetDetailHelper.removeEmptyBudgetDetails(this.budgetDetailList);
            this.budgetDetail = (BudgetDetail)this.budgetDetailList.get(0);
            this.validateAmounts(this.budgetDetailList);
            Assignment assignment = new Assignment();
            if (!"Save".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                List assignmentList = this.assignmentService.findAllAssignmentsByHODDeptAndDates(this.budgetDetail.getExecutingDepartment().getId(), new Date());
                if (assignmentList.isEmpty()) {
                    throw new ValidationException(Arrays.asList(new ValidationError(HOD_NOT_FOUND, HOD_NOT_FOUND)));
                }
                assignment = (Assignment)assignmentList.get(0);
                this.approverPositionId = assignment.getPosition().getId();
            } else {
                this.approverPositionId = this.getPosition().getId();
            }
            this.populateWorkflowBean();
            this.financialYear = this.financialYearService.findOne(this.financialYear.getId());
            EgwStatus egwStatus = this.egwStatusHibernateDAO.getStatusByModuleAndCode("BUDGETDETAIL", "Created");
            this.budgetDetailActionHelper.create(new BudgetDetailHelperBean(Boolean.valueOf(this.addNewDetails), this.beAmounts, this.budgetDetailList, egwStatus, this.budgetDetail, this.searchbudgetGroupid, this.searchfunctionid, this.workflowBean));
            this.setAsOnDateOnSelectedBudget();
            this.showMessage = true;
            if ("Save".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText(SAVE));
            } else {
                this.addActionMessage(this.getText("budgetdetail.forwarded") + assignment.getEmployee().getName());
            }
            this.dropdownData.put(BUDGETLIST, Collections.emptyList());
            this.budgetDetail = new BudgetDetail();
            this.budgetDetail.setExecutingDepartment(null);
        }
        catch (ValidationException e) {
            this.loadBudgets(RE);
            this.dropdownData.put(BUDGETLIST, this.budgetList);
            this.referenceBudget = this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget());
            throw e;
        }
        return NEWRE;
    }

    private void validateAmounts(List<BudgetDetail> detailList) {
        for (int i = 0; i < detailList.size(); ++i) {
            if (this.beAmounts.get(i) == null) {
                throw new ValidationException(Arrays.asList(new ValidationError(BUDGETRE, BUDGETRE)));
            }
            if (detailList.get(i).getOriginalAmount() != null) continue;
            throw new ValidationException(Arrays.asList(new ValidationError(BUDGETBE, BUDGETBE)));
        }
    }

    protected void validateMandatoryFields() {
        String deptMandatory = "budgetDetail.executingDepartment.mandatory";
        String functionMandatory = "budgetDetail.function.mandatory";
        String functionaryMandatory = "budgetDetail.functionary.mandatory";
        String fundMandatory = "budgetDetail.fund.mandatory";
        this.checkHeaderMandatoryField("executingDepartment", (Object)this.budgetDetail.getExecutingDepartment(), "budgetDetail.executingDepartment.mandatory");
        this.checkHeaderMandatoryField("function", (Object)this.budgetDetail.getFunction(), "budgetDetail.function.mandatory");
        this.checkHeaderMandatoryField("functionary", (Object)this.budgetDetail.getFunctionary(), "budgetDetail.functionary.mandatory");
        this.checkHeaderMandatoryField("fund", (Object)this.budgetDetail.getFund(), "budgetDetail.fund.mandatory");
        for (BudgetDetail detail : this.budgetDetailList) {
            this.setRelatedValues(detail);
            this.checkGridMandatoryField("executingDepartment", (Object)detail.getExecutingDepartment(), "budgetDetail.executingDepartment.mandatory");
            this.checkGridMandatoryField("function", (Object)detail.getFunction(), "budgetDetail.function.mandatory");
            this.checkGridMandatoryField("functionary", (Object)detail.getFunctionary(), "budgetDetail.functionary.mandatory");
            this.checkGridMandatoryField("fund", (Object)detail.getFund(), "budgetDetail.fund.mandatory");
        }
    }

    private void setRelatedValues(BudgetDetail detail) {
        if (detail.getExecutingDepartment() != null && detail.getExecutingDepartment().getId() == 0L) {
            detail.setExecutingDepartment(null);
        }
        if (detail.getFunction() != null && detail.getFunction().getId() == 0L) {
            detail.setFunction(null);
        }
        if (detail.getScheme() != null && detail.getScheme().getId() == 0) {
            detail.setScheme(null);
        }
        if (detail.getSubScheme() != null && detail.getSubScheme().getId() == 0) {
            detail.setSubScheme(null);
        }
        if (detail.getFunctionary() != null && detail.getFunctionary().getId() == 0) {
            detail.setFunctionary(null);
        }
        if (detail.getBoundary() != null && detail.getBoundary().getId() == 0L) {
            detail.setBoundary(null);
        }
        if (detail.getFund() != null && detail.getFund().getId() == 0) {
            detail.setFund(null);
        }
    }

    protected void checkHeaderMandatoryField(String fieldName, Object value, String errorKey) {
        if (this.headerFields.contains(fieldName) && this.mandatoryFields.contains(fieldName) && value == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(errorKey, errorKey)));
        }
    }

    protected void checkGridMandatoryField(String fieldName, Object value, String errorKey) {
        if (this.gridFields.contains(fieldName) && this.mandatoryFields.contains(fieldName) && value == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(errorKey, errorKey)));
        }
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    private void setAsOnDateOnSelectedBudget() {
        if (this.budgetDetail.getBudget() != null && this.budgetDetail.getBudget().getId() != null) {
            Budget selectedBudget = (Budget)this.getPersistenceService().find("from Budget where id=?", new Object[]{this.budgetDetail.getBudget().getId()});
            selectedBudget.setAsOnDate(this.getAsOnDate());
            this.budgetService.update((Object)selectedBudget);
        }
    }

    public void loadBudgets(String bere) {
        this.budgetList = new ArrayList();
        if (!this.addNewDetails) {
            this.budgetList.addAll(this.persistenceService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = true  and isbere='" + bere.toUpperCase() + "' and status.code!='Approved' and financialYear.id = " + this.getFinancialYear().getId() + " order by name", new Object[0]));
        } else {
            this.budgetList.addAll(this.persistenceService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = true  and isbere='" + bere.toUpperCase() + "'  and financialYear.id = " + this.getFinancialYear().getId() + " order by name", new Object[0]));
        }
    }

    public void prepare() {
        super.prepare();
        this.populateFinancialYear();
        this.headerFields = this.budgetDetailConfig.getHeaderFields();
        this.gridFields = this.budgetDetailConfig.getGridFields();
        this.mandatoryFields = this.budgetDetailConfig.getMandatoryFields();
        this.addRelatedEntity("budget", Budget.class);
        this.addRelatedEntity("budgetGroup", BudgetGroup.class);
        if (this.shouldShowField("functionary")) {
            this.addRelatedEntity("functionary", Functionary.class);
        }
        if (this.shouldShowField("function")) {
            this.addRelatedEntity("function", CFunction.class);
        }
        if (this.shouldShowField("scheme")) {
            this.addRelatedEntity("scheme", Scheme.class);
        }
        if (this.shouldShowField("subScheme")) {
            this.addRelatedEntity("subScheme", SubScheme.class);
        }
        if (this.shouldShowField("fund")) {
            this.addRelatedEntity("fund", Fund.class);
        }
        if (this.shouldShowField("executingDepartment")) {
            this.addRelatedEntity("executingDepartment", Department.class);
        }
        if (this.shouldShowField("boundary")) {
            this.addRelatedEntity("boundary", Boundary.class);
        }
        this.setupDropdownsInHeader();
        this.re = this.budgetService.hasReForYear(Long.valueOf(this.financialYearService.getFinancialYearByDate(new Date()).getId().toString()));
    }

    private void setupDropdownsInHeader() {
        this.setupDropdownDataExcluding(new String[]{"subScheme"});
        this.setBudgetDropDown();
        this.dropdownData.put("budgetGroupList", this.masterDataCache.get(EGF_BUDGET_GROUP));
        if (this.shouldShowField("subScheme")) {
            this.dropdownData.put("subSchemeList", Collections.EMPTY_LIST);
        }
        if (this.shouldShowField("functionary")) {
            this.dropdownData.put("functionaryList", this.masterDataCache.get(EGI_FUNCTIONARY));
        }
        if (this.shouldShowField("function")) {
            this.dropdownData.put("functionList", this.masterDataCache.get(EGI_FUNCTION));
        }
        if (this.shouldShowField("scheme")) {
            this.dropdownData.put("schemeList", this.persistenceService.findAllBy("from Scheme where isActive=true order by name", new Object[0]));
        }
        if (this.shouldShowField("executingDepartment")) {
            this.dropdownData.put("executingDepartmentList", this.masterDataCache.get(EGI_DEPARTMENT));
        }
        if (this.shouldShowField("fund")) {
            this.dropdownData.put("fundList", this.persistenceService.findAllBy("from Fund where isNotLeaf=false and isActive=true order by name", new Object[0]));
        }
        if (this.shouldShowField("boundary")) {
            this.dropdownData.put("boundaryList", this.persistenceService.findAllBy("from Boundary order by name", new Object[0]));
        }
        this.addDropdownData("financialYearList", this.getPersistenceService().findAllBy("from CFinancialYear where isActive=true order by finYearRange desc ", new Object[0]));
        this.dropdownData.put("departmentList", this.masterDataCache.get(EGI_DEPARTMENT));
        this.dropdownData.put("designationList", Collections.emptyList());
        this.dropdownData.put("userList", Collections.emptyList());
    }

    protected void populateFinancialYear() {
        Budget budget = this.budgetDetail.getBudget();
        if (budget != null) {
            this.populateYearRange(budget);
            return;
        }
        if (this.request.get("id") != null) {
            Long id = (Long)this.request.get("id");
            if (!Long.valueOf(0L).equals(id)) {
                Budget b = (Budget)this.budgetService.findById((Serializable)id, false);
                this.populateYearRange(b);
                return;
            }
        }
        CFinancialYear finYear = this.financialYearService.findOne(this.budgetDetailHelper.getFinancialYear());
        this.currentYearRange = finYear.getFinYearRange();
        this.computePreviousYearRange();
        this.computeLastButOneYearRange();
        this.computeNextYearRange();
    }

    private void populateYearRange(Budget budget) {
        if (budget != null) {
            this.currentYearRange = budget.getFinancialYear() != null ? budget.getFinancialYear().getFinYearRange() : this.financialYearService.findOne(this.budgetDetailHelper.getFinancialYear()).getFinYearRange();
            this.computePreviousYearRange();
            this.computeLastButOneYearRange();
            this.computeNextYearRange();
        }
    }

    public String computeYearRange(String range) {
        if (StringUtils.isNotBlank((String)range)) {
            String[] list = range.split("-");
            return this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
        return "";
    }

    public String addYearRange(String range) {
        if (StringUtils.isNotBlank((String)range)) {
            String[] list = range.split("-");
            return this.add(list[0]) + "-" + this.add(list[1]);
        }
        return "";
    }

    private void computeLastButOneYearRange() {
        if (StringUtils.isNotBlank((String)this.previousYearRange)) {
            String[] list = this.previousYearRange.split("-");
            this.lastButOneYearRange = this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
    }

    protected void computePreviousYearRange() {
        if (StringUtils.isNotBlank((String)this.currentYearRange)) {
            String[] list = this.currentYearRange.split("-");
            this.previousYearRange = this.subtract(list[0]) + "-" + this.subtract(list[1]);
        }
    }

    protected void computeNextYearRange() {
        if (StringUtils.isNotBlank((String)this.currentYearRange)) {
            String[] list = this.currentYearRange.split("-");
            this.nextYearRange = this.add(list[0]) + "-" + this.add(list[1]);
        }
    }

    protected String subtract(String value) {
        int val = Integer.parseInt(value) - 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    protected String add(String value) {
        int val = Integer.parseInt(value) + 1;
        if (val < 10) {
            return "0" + val;
        }
        return String.valueOf(val);
    }

    public void populateWorkflowBean() {
        this.workflowBean.setApproverPositionId(this.approverPositionId);
        this.workflowBean.setApproverComments(this.approverComments);
        this.workflowBean.setWorkFlowAction(this.workFlowAction);
        this.workflowBean.setCurrentState(this.currentState);
    }

    public String getCurrentYearRange() {
        return this.currentYearRange;
    }

    public String getPreviousYearRange() {
        return this.previousYearRange;
    }

    public String getLastButOneYearRange() {
        return this.lastButOneYearRange;
    }

    protected void setBudgetDropDown() {
        if (this.addNewDetails) {
            if (this.getFinancialYear() != null && this.getFinancialYear().getId() != null) {
                this.budgetList.addAll(this.persistenceService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = true and state.type='Budget' and isbere='RE' and financialYear.id = " + this.getFinancialYear().getId() + " order by name", new Object[0]));
                this.dropdownData.put(BUDGETLIST, this.budgetList);
            } else {
                this.dropdownData.put(BUDGETLIST, Collections.emptyList());
            }
        } else {
            this.dropdownData.put(BUDGETLIST, this.persistenceService.findAllBy("from Budget where id not in (select parent from Budget where parent is not null) and isactivebudget = true and state.type='Budget' and (state.value='NEW' or lower(state.value) like lower('Forwarded by SMADMIN%')) order by name", new Object[0]));
        }
    }

    public List<BudgetDetail> getSavedbudgetDetailList() {
        return this.savedbudgetDetailList;
    }

    public List<BudgetDetail> getBudgetDetailList() {
        return this.budgetDetailList;
    }

    public void setBudgetDetailList(List<BudgetDetail> budgetDetailList) {
        this.budgetDetailList = budgetDetailList;
    }

    public List<BudgetAmountView> getBudgetAmountView() {
        return this.budgetAmountView;
    }

    protected User getUser() {
        return (User)this.persistenceService.find("from User where id=?", new Object[]{ApplicationThreadLocals.getUserId()});
    }

    protected Position getPosition() {
        return this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
    }

    protected Position getPositionByUserId(Integer userId) {
        return this.eisCommonService.getPositionByUserId(Long.valueOf(userId.longValue()));
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public void setBudgetDetailWorkflowService(WorkflowService<BudgetDetail> budgetDetailWorkflowService) {
        this.budgetDetailWorkflowService = budgetDetailWorkflowService;
    }

    public StateAware getModel() {
        return this.budgetDetail;
    }

    public BudgetDetail getBudgetDetail() {
        return this.budgetDetail;
    }

    public void setBudgetDetail(BudgetDetail budgetDetails) {
        this.budgetDetail = budgetDetails;
    }

    public void setBudgetDetailService(BudgetDetailService budgetDetailsService) {
        this.budgetDetailService = budgetDetailsService;
    }

    public String loadActuals() {
        this.validateAsOnDate();
        this.getDetailsFilterdBy();
        this.re = this.budgetService.hasReForYear(this.budgetDetail.getBudget().getFinancialYear().getId());
        this.budgetDetailHelper.removeEmptyBudgetDetails(this.budgetDetailList);
        this.budgetAmountView.addAll(this.populateAmountData(this.budgetDetailList, this.getAsOnDate(), this.budgetDetail.getBudget().getFinancialYear()));
        this.loadBeAmounts(this.budgetDetailList, this.beAmounts);
        return "new";
    }

    protected void getDetailsFilterdBy() {
        StringBuilder mainQry = new StringBuilder(100);
        mainQry.append("from BudgetDetail where budget.id=? and status.code = 'NEW' order by function.name,budgetGroup.name ");
        if (this.budgetDetail.getBudget() != null && this.budgetDetail.getBudget().getId() != 0L) {
            this.savedbudgetDetailList = this.budgetDetailService.findAllBy(mainQry.toString(), new Object[]{this.budgetDetail.getBudget().getId()});
        }
    }

    protected void loadBeAmounts(List<BudgetDetail> savedbudgetDetailList2, List<BigDecimal> amounts) {
        this.beAmounts = new ArrayList(savedbudgetDetailList2.size());
        if (this.savedbudgetDetailList.isEmpty()) {
            this.beAmounts = amounts;
            return;
        }
        Budget referenceBudgetFor = this.budgetService.getReferenceBudgetFor(((BudgetDetail)this.savedbudgetDetailList.get(0)).getBudget());
        if (referenceBudgetFor != null) {
            List result = this.budgetDetailService.findAllBy("from BudgetDetail where budget.id=?", new Object[]{referenceBudgetFor.getId()});
            if (!this.savedbudgetDetailList.isEmpty()) {
                amounts.subList(0, this.savedbudgetDetailList.size()).clear();
            }
            for (BudgetDetail bd : this.savedbudgetDetailList) {
                for (BudgetDetail row : result) {
                    if (!this.compareDetails(row, bd)) continue;
                    this.beAmounts.add(row.getOriginalAmount());
                }
            }
        }
        this.beAmounts.addAll(amounts);
    }

    protected boolean compareDetails(BudgetDetail nextYear, BudgetDetail current) {
        if (nextYear.getExecutingDepartment() != null && current.getExecutingDepartment() != null && current.getExecutingDepartment().getId() != nextYear.getExecutingDepartment().getId()) {
            return false;
        }
        if (nextYear.getFunction() != null && current.getFunction() != null && current.getFunction().getId() != nextYear.getFunction().getId()) {
            return false;
        }
        if (nextYear.getFund() != null && current.getFund() != null && current.getFund().getId() != nextYear.getFund().getId()) {
            return false;
        }
        if (nextYear.getFunctionary() != null && current.getFunctionary() != null && current.getFunctionary().getId() != nextYear.getFunctionary().getId()) {
            return false;
        }
        if (nextYear.getScheme() != null && current.getScheme() != null && current.getScheme().getId() != nextYear.getScheme().getId()) {
            return false;
        }
        if (nextYear.getSubScheme() != null && current.getSubScheme() != null && current.getSubScheme().getId() != nextYear.getSubScheme().getId()) {
            return false;
        }
        if (nextYear.getBoundary() != null && current.getBoundary() != null && current.getBoundary().getId() != nextYear.getBoundary().getId()) {
            return false;
        }
        if (nextYear.getBudgetGroup() != null && current.getBudgetGroup() != null && current.getBudgetGroup().getId() != nextYear.getBudgetGroup().getId()) {
            return false;
        }
        return nextYear.getBudget() == null || current.getBudget() == null || current.getBudget().getId() != nextYear.getBudget().getId();
    }

    protected boolean compareREandBEDetails(BudgetDetail nextYear, BudgetDetail current) {
        if (nextYear.getExecutingDepartment() != null && current.getExecutingDepartment() != null && current.getExecutingDepartment().getId().intValue() != nextYear.getExecutingDepartment().getId().intValue()) {
            return false;
        }
        if (nextYear.getFunction() != null && current.getFunction() != null && current.getFunction().getId().intValue() != nextYear.getFunction().getId().intValue()) {
            return false;
        }
        if (nextYear.getFund() != null && current.getFund() != null && current.getFund().getId().intValue() != nextYear.getFund().getId().intValue()) {
            return false;
        }
        if (nextYear.getFunctionary() != null && current.getFunctionary() != null && current.getFunctionary().getId().intValue() != nextYear.getFunctionary().getId().intValue()) {
            return false;
        }
        if (nextYear.getScheme() != null && current.getScheme() != null && current.getScheme().getId().intValue() != nextYear.getScheme().getId().intValue()) {
            return false;
        }
        if (nextYear.getSubScheme() != null && current.getSubScheme() != null && current.getSubScheme().getId().intValue() != nextYear.getSubScheme().getId().intValue()) {
            return false;
        }
        if (nextYear.getBoundary() != null && current.getBoundary() != null && current.getBoundary().getId().intValue() != nextYear.getBoundary().getId().intValue()) {
            return false;
        }
        return nextYear.getBudgetGroup() == null || current.getBudgetGroup() == null || current.getBudgetGroup().getId().intValue() == nextYear.getBudgetGroup().getId().intValue();
    }

    protected void populateBudgetList() {
        this.loadBudgets(RE);
        this.dropdownData.put(BUDGETLIST, this.budgetList);
        if (this.budgetDetail.getBudget() != null && this.budgetDetail.getBudget().getId() != null) {
            this.referenceBudget = this.budgetService.getReferenceBudgetFor(this.budgetDetail.getBudget());
        }
    }

    private void validateAsOnDate() {
        if (this.budgetDetail.getBudget() == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(BUDGETMANDATORY, BUDGETMANDATORY)));
        }
        this.financialYearService.findOne(this.budgetDetail.getBudget().getFinancialYear().getId()).getStartingDate();
        this.financialYearService.findOne(this.budgetDetail.getBudget().getFinancialYear().getId()).getEndingDate();
    }

    public Date getPreviousYearFor(Date date) {
        GregorianCalendar previousYearToDate = new GregorianCalendar();
        previousYearToDate.setTime(date);
        int prevYear = previousYearToDate.get(1) - 1;
        previousYearToDate.set(1, prevYear);
        return previousYearToDate.getTime();
    }

    public List<String> getGridFields() {
        return this.gridFields;
    }

    public List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public boolean isHeaderDisabled() {
        return this.headerDisabled;
    }

    public final boolean shouldShowHeaderField(String field) {
        return this.headerFields.isEmpty() || this.headerFields.contains(field);
    }

    public final boolean shouldShowField(String field) {
        if (this.headerFields.isEmpty() && this.gridFields.isEmpty()) {
            return true;
        }
        return this.shouldShowHeaderField(field) || this.shouldShowGridField(field);
    }

    public final boolean shouldShowGridField(String field) {
        return this.gridFields.isEmpty() || this.gridFields.contains(field);
    }

    public String ajaxLoadSubSchemes() {
        this.subSchemes = this.getPersistenceService().findAllBy("from SubScheme where scheme.id=? and isActive=true order by name", new Object[]{this.schemeId});
        return "subSchemes";
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    protected ValueStack getValueStack() {
        return ActionContext.getContext().getValueStack();
    }

    public List<BudgetAmountView> populateAmountData(List<BudgetDetail> budgetDetails, Date asOnDate, CFinancialYear finYear) {
        ArrayList<BudgetAmountView> list = new ArrayList<BudgetAmountView>();
        Long finYearId = finYear.getId();
        List appList = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "coa_majorcode_length");
        if (appList.isEmpty()) {
            throw new ValidationException("", "coa.majorcode.not.defined", new String[0]);
        }
        int majorcodelength = Integer.valueOf(((AppConfigValues)appList.get(0)).getValue());
        List appListExcludeStatus = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "exclude_status_forbudget_actual");
        if (appListExcludeStatus.isEmpty()) {
            throw new ValidationException("", "exclude.status.not.defined", new String[0]);
        }
        CFinancialYear finyear = this.financialYearService.getFinancialYearByDate(asOnDate);
        Date fromdate = finyear.getStartingDate();
        String voucherstatusExclude = ((AppConfigValues)appListExcludeStatus.get(0)).getValue();
        for (BudgetDetail detail : budgetDetails) {
            Map paramMap = this.budgetDetailHelper.constructParamMap(this.getValueStack(), detail);
            paramMap.put("MAJORCODELENGTH", majorcodelength);
            paramMap.put("VOUCHERSTATUSEXCLUDE", voucherstatusExclude);
            paramMap.put("FYFROMDATE", fromdate);
            BudgetAmountView view = new BudgetAmountView();
            this.budgetDetailHelper.populateData(view, paramMap, asOnDate, this.re);
            BudgetDetail detailWithoutBudget = new BudgetDetail();
            detailWithoutBudget.copyFrom(detail);
            detailWithoutBudget.setBudget(null);
            List bd = this.budgetDetailService.searchByCriteriaWithTypeAndFY(finYearId, "BE", detailWithoutBudget);
            if (!bd.isEmpty()) {
                BigDecimal approvedAmount = ((BudgetDetail)bd.get(0)).getApprovedAmount();
                view.setCurrentYearBeApproved(approvedAmount == null ? BigDecimal.ZERO.toString() : approvedAmount.toString());
                view.setReappropriation(((BudgetDetail)bd.get(0)).getApprovedReAppropriationsTotal().toString());
            }
            view.setTotal(new BigDecimal(view.getCurrentYearBeApproved()).add(new BigDecimal(view.getReappropriation())).toString());
            list.add(view);
        }
        return list;
    }

    public void setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
    }

    public boolean isShowMessage() {
        return this.showMessage;
    }

    public void setBeAmounts(List<BigDecimal> beAmounts) {
        this.beAmounts = beAmounts;
    }

    public List<BigDecimal> getBeAmounts() {
        return this.beAmounts;
    }

    public void setNextYearRange(String nextYearRange) {
        this.nextYearRange = nextYearRange;
    }

    public String getNextYearRange() {
        return this.nextYearRange;
    }

    public void setReferenceBudget(Budget referenceBudget) {
        this.referenceBudget = referenceBudget;
    }

    public Budget getReferenceBudget() {
        return this.referenceBudget;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setBudgetList(List<Budget> budgetList) {
        this.budgetList = budgetList;
    }

    public List<Budget> getBudgetList() {
        return this.budgetList;
    }

    public void setBudgetWorkflowService(WorkflowService<Budget> budgetWorkflowService) {
        this.budgetWorkflowService = budgetWorkflowService;
    }

    public void removeEmptyBudgetDetails(List<BudgetDetail> budgetDetailList) {
        int i = 0;
        Iterator<BudgetDetail> detail = budgetDetailList.iterator();
        while (detail.hasNext()) {
            if (detail.next() == null) {
                detail.remove();
            }
            if (this.beAmounts.get(i) == null) {
                throw new ValidationException(Arrays.asList(new ValidationError(BUDGETRE, BUDGETRE)));
            }
            if (budgetDetailList.get(i).getOriginalAmount() == null) {
                throw new ValidationException(Arrays.asList(new ValidationError(BUDGETBE, BUDGETBE)));
            }
            ++i;
        }
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public Long getSearchfunctionid() {
        return this.searchfunctionid;
    }

    public void setSearchfunctionid(Long searchfunctionid) {
        this.searchfunctionid = searchfunctionid;
    }

    public Long getSearchbudgetGroupid() {
        return this.searchbudgetGroupid;
    }

    public void setSearchbudgetGroupid(Long searchbudgetGroupid) {
        this.searchbudgetGroupid = searchbudgetGroupid;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public boolean isAddNewDetails() {
        return this.addNewDetails;
    }

    public void setAddNewDetails(boolean addDetails) {
        this.addNewDetails = addDetails;
    }

    public void setBudgetDocumentNumber(Long documentNumber) {
        this.budgetDocumentNumber = documentNumber;
    }

    public Long getBudgetDocumentNumber() {
        return this.budgetDocumentNumber;
    }

    public boolean isRe() {
        return this.re;
    }

    public void setBudgetDetailHelper(BudgetDetailHelper budgetHelper) {
        this.budgetDetailHelper = budgetHelper;
    }

    public Date getAsOnDate() {
        return this.asOnDate == null ? new Date() : this.asOnDate;
    }

    public void setAsOnDate(Date date) {
        this.asOnDate = date;
    }

    public Integer getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Integer scheme) {
        this.schemeId = scheme;
    }

    public List<Scheme> getSubSchemes() {
        return this.subSchemes;
    }
}

