/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.bill;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.voucher.VoucherSearchAction;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.utils.Constants;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"view"}, location="billView-view.jsp")})
public class BillViewAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(VoucherSearchAction.class);
    private static final long serialVersionUID = 1L;
    EgBillregister egBillRegister = new EgBillregister();
    List<Map<String, Object>> billDetailsList = new ArrayList();
    List<Map<String, Object>> subledgerList = new ArrayList();
    @Autowired
    private EgovCommon egovCommon;
    public final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);

    public List<Map<String, Object>> getSubledgerList() {
        return this.subledgerList;
    }

    public void setSubledgerList(List<Map<String, Object>> subledgerList) {
        this.subledgerList = subledgerList;
    }

    public List<Map<String, Object>> getBillDetailsList() {
        return this.billDetailsList;
    }

    public void setBillDetailsList(List<Map<String, Object>> billDetailsList) {
        this.billDetailsList = billDetailsList;
    }

    public EgBillregister getEgBillRegister() {
        return this.egBillRegister;
    }

    public void setEgBillRegister(EgBillregister egBillRegister) {
        this.egBillRegister = egBillRegister;
    }

    public Object getModel() {
        return this.egBillRegister;
    }

    public void prepare() {
        super.prepare();
    }

    @Action(value="/bill/billView-view")
    public String view() throws ApplicationException, ParseException {
        this.loadBillDetails();
        return "view";
    }

    private void loadBillDetails() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"-----------Start of loadBillDetails()-----------");
        }
        HashMap<String, Object> temp = null;
        Map<String, String> subLedgerTemp = null;
        if (this.egBillRegister.getEgBilldetailes() != null && this.egBillRegister.getEgBilldetailes().size() != 0) {
            List billDetList = this.persistenceService.findAllBy(" from EgBilldetails where egBillregister.id=? ", new Object[]{this.egBillRegister.getId()});
            for (EgBilldetails billDetail : billDetList) {
                CChartOfAccounts coa = (CChartOfAccounts)this.persistenceService.find(" from CChartOfAccounts where id=?  ", new Object[]{billDetail.getGlcodeid().longValue()});
                temp = new HashMap<String, Object>();
                if (billDetail.getFunctionid() != null) {
                    CFunction function = (CFunction)this.getPersistenceService().find("from CFunction where id=?", new Object[]{billDetail.getFunctionid().longValue()});
                    temp.put("function", function.getName());
                } else {
                    temp.put("function", "");
                }
                temp.put("glcode", coa.getGlcode());
                temp.put("accountHead", coa.getName());
                temp.put("debitAmount", billDetail.getDebitamount() == null ? 0L : billDetail.getDebitamount().longValue());
                temp.put("creditAmount", billDetail.getCreditamount() == null ? 0L : billDetail.getCreditamount().longValue());
                this.billDetailsList.add(temp);
                for (EgBillPayeedetails payeeDetails : billDetail.getEgBillPaydetailes()) {
                    Accountdetailtype detailtype = (Accountdetailtype)this.persistenceService.find(" from Accountdetailtype where id=?", new Object[]{payeeDetails.getAccountDetailTypeId()});
                    subLedgerTemp = new HashMap();
                    try {
                        subLedgerTemp = this.getAccountDetails(detailtype, payeeDetails.getAccountDetailKeyId(), subLedgerTemp);
                    }
                    catch (ApplicationException e) {
                        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                        errors.add(new ValidationError("exp", e.getMessage()));
                        throw new ValidationException(errors);
                    }
                    subLedgerTemp.put("function", (String)temp.get("function"));
                    subLedgerTemp.put("glcode", coa.getGlcode());
                    if (payeeDetails.getDebitAmount() != null && payeeDetails.getDebitAmount().longValue() != 0L) {
                        subLedgerTemp.put("amount", (String)((Object)Long.valueOf(payeeDetails.getDebitAmount().longValue())));
                    } else {
                        subLedgerTemp.put("amount", (String)((Object)Long.valueOf(payeeDetails.getCreditAmount().longValue())));
                    }
                    this.subledgerList.add(subLedgerTemp);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"-----------End of loadBillDetails()-----------");
        }
    }

    public Map<String, Object> getAccountDetails(Accountdetailtype detailtype, Integer detailkeyid, Map<String, Object> tempMap) throws ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"-----------Start of getAccountDetails()-----------");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("-----------detailtype::" + detailtype.getId()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("-----------detailkeyid::" + detailkeyid));
        }
        this.egovCommon.setPersistenceService(this.persistenceService);
        EntityType entityType = this.egovCommon.getEntityType(detailtype, (Serializable)detailkeyid);
        tempMap.put("detailkey", entityType.getName());
        tempMap.put("detailname", detailtype.getName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"-----------End of loadBillDetails()-----------");
        }
        return tempMap;
    }

    public void setBillId(long billId) {
        this.egBillRegister = (EgBillregister)this.persistenceService.find(" from EgBillregister where id = ?", new Object[]{billId});
    }
}

