/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.voucher;

import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;

@Controller
public abstract class BaseVoucherController
extends GenericWorkFlowController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseVoucherController.class);
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;

    @Autowired
    public BaseVoucherController(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    protected void setDropDownValues(Model model) {
        ArrayList<String> headerFields = new ArrayList<String>();
        ArrayList<String> mandatoryFields = new ArrayList<String>();
        List appConfigList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DEFAULTTXNMISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf(124));
            headerFields.add(header);
            String mandate = value.substring(value.indexOf(124) + 1);
            if (!"M".equals(mandate)) continue;
            mandatoryFields.add(header);
        }
        mandatoryFields.add("voucherdate");
        if (headerFields.contains("department")) {
            model.addAttribute("departments", (Object)this.masterDataCache.get("egi-department"));
        }
        if (headerFields.contains("functionary")) {
            model.addAttribute("functionarys", (Object)this.masterDataCache.get("egi-functionary"));
        }
        if (headerFields.contains("function")) {
            model.addAttribute("functions", (Object)this.masterDataCache.get("egi-function"));
        }
        if (headerFields.contains("fund")) {
            model.addAttribute("funds", (Object)this.masterDataCache.get("egi-fund"));
        }
        if (headerFields.contains("fundsource")) {
            model.addAttribute("fundsources", (Object)this.masterDataCache.get("egi-fundSource"));
        }
        if (headerFields.contains("field")) {
            model.addAttribute("fields", (Object)this.masterDataCache.get("egi-ward"));
        }
        if (headerFields.contains("scheme")) {
            model.addAttribute("schemes", Collections.emptyList());
        }
        if (headerFields.contains("subscheme")) {
            model.addAttribute("subschemes", Collections.emptyList());
        }
        model.addAttribute("headerFields", headerFields);
        model.addAttribute("mandatoryFields", mandatoryFields);
    }

    protected void prepareValidActionListByCutOffDate(Model model) {
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (!cutOffDateconfigValue.isEmpty()) {
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
            model.addAttribute("validActionList", Arrays.asList("Forward", "Create And Approve"));
            try {
                model.addAttribute("cutOffDate", (Object)DateUtils.getDefaultFormattedDate((Date)df.parse(((AppConfigValues)cutOffDateconfigValue.get(0)).getValue())));
            }
            catch (ParseException e) {
                LOGGER.warn("Could not parse cutoff date passed {} ", (Object)((AppConfigValues)cutOffDateconfigValue.get(0)).getValue());
            }
        }
    }

    protected Boolean isVoucherNumberGenerationAuto(CVoucherHeader voucherHeader, Model model) {
        String vNumGenMode = voucherHeader.getType() != null && "Journal Voucher".equalsIgnoreCase(voucherHeader.getType()) ? this.voucherTypeForULB.readVoucherTypes("Journal") : this.voucherTypeForULB.readVoucherTypes(voucherHeader.getType());
        if (!"Auto".equalsIgnoreCase(vNumGenMode)) {
            ((List)model.asMap().get("mandatoryFields")).add("vouchernumber");
            return true;
        }
        return false;
    }

    protected void populateAccountDetails(CVoucherHeader voucherHeader) {
        if (voucherHeader.getGeneralLedger() != null) {
            voucherHeader.getGeneralLedger().clear();
        } else {
            voucherHeader.setGeneralLedger(new HashSet());
        }
        voucherHeader.getGeneralLedger().addAll(voucherHeader.getAccountDetails());
        Integer voucherLineId = 1;
        for (CGeneralLedger details : voucherHeader.getGeneralLedger()) {
            Integer n = voucherLineId;
            Integer n2 = voucherLineId = Integer.valueOf(voucherLineId + 1);
            details.setVoucherlineId(n);
            details.setEffectiveDate(new Date());
            if (voucherHeader.getVouchermis().getFunction() != null) {
                details.setFunctionId(Integer.valueOf(voucherHeader.getVouchermis().getFunction().getId().intValue()));
            }
            details.setVoucherHeaderId(voucherHeader);
            details.setGlcodeId((CChartOfAccounts)this.chartOfAccountsService.findById((Serializable)details.getGlcodeId().getId(), false));
            if (details.getDebitAmount() != null) {
                details.setCreditAmount(Double.valueOf(0.0));
                continue;
            }
            details.setDebitAmount(Double.valueOf(0.0));
        }
    }

    protected void populateVoucherName(CVoucherHeader voucherHeader) {
        switch (voucherHeader.getVoucherSubType()) {
            case "JVGeneral": {
                voucherHeader.setVoucherNumType("Journal");
                voucherHeader.setName("JVGeneral");
                break;
            }
            case "Works": {
                voucherHeader.setVoucherNumType("worksjv");
                voucherHeader.setName("Contractor Journal");
                break;
            }
            case "Purchase": {
                voucherHeader.setVoucherNumType("purchasejv");
                voucherHeader.setName("Supplier Journal");
                break;
            }
            case "Salary": {
                voucherHeader.setVoucherNumType("salaryjv");
                voucherHeader.setName("Salary Journal");
                break;
            }
            case "Expense": {
                voucherHeader.setVoucherNumType("contingentjv");
                voucherHeader.setName("Expense Journal");
                break;
            }
            case "Fixed Asset": {
                voucherHeader.setVoucherNumType("fixedassetjv");
                voucherHeader.setName("Supplier Journal");
                break;
            }
            case "Pension": {
                voucherHeader.setVoucherNumType("pensionjv");
                voucherHeader.setName("Pension Journal");
                break;
            }
        }
    }
}

