/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.expensebill;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.utils.FinancialUtils;
import org.egov.egf.web.controller.expensebill.BaseBillController;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.DocumentUpload;
import org.egov.model.bills.EgBillregister;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/expensebill"})
public class CreateExpenseBillController
extends BaseBillController {
    private static final String DESIGNATION = "designation";
    private static final String NET_PAYABLE_ID = "netPayableId";
    private static final String EXPENSEBILL_FORM = "expensebill-form";
    private static final String STATE_TYPE = "stateType";
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String APPROVAL_DESIGNATION = "approvalDesignation";
    private static final int BUFFER_SIZE = 4096;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private FinancialUtils financialUtils;
    @Autowired
    private FileStoreService fileStoreService;

    public CreateExpenseBillController(AppConfigValueService appConfigValuesService) {
        super(appConfigValuesService);
    }

    protected void setDropDownValues(Model model) {
        super.setDropDownValues(model);
    }

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="egBillregister") EgBillregister egBillregister, Model model) {
        this.setDropDownValues(model);
        model.addAttribute(STATE_TYPE, (Object)egBillregister.getClass().getSimpleName());
        this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
        this.prepareValidActionListByCutOffDate(model);
        egBillregister.setBilldate(new Date());
        return EXPENSEBILL_FORM;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="egBillregister") EgBillregister egBillregister, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam String workFlowAction) throws IOException {
        EgBillregister savedEgBillregister;
        String[] contentType = ((MultiPartRequestWrapper)request).getContentTypes("file");
        ArrayList<DocumentUpload> list = new ArrayList<DocumentUpload>();
        UploadedFile[] uploadedFiles = ((MultiPartRequestWrapper)request).getFiles("file");
        String[] fileName = ((MultiPartRequestWrapper)request).getFileNames("file");
        if (uploadedFiles != null) {
            for (int i = 0; i < uploadedFiles.length; ++i) {
                Path path = Paths.get(uploadedFiles[i].getAbsolutePath(), new String[0]);
                byte[] fileBytes = Files.readAllBytes(path);
                ByteArrayInputStream bios = new ByteArrayInputStream(fileBytes);
                DocumentUpload upload = new DocumentUpload();
                upload.setInputStream(bios);
                upload.setFileName(fileName[i]);
                upload.setContentType(contentType[i]);
                list.add(upload);
            }
        }
        this.populateBillDetails(egBillregister);
        this.validateBillNumber(egBillregister, resultBinder);
        this.validateLedgerAndSubledger(egBillregister, resultBinder);
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute(STATE_TYPE, (Object)egBillregister.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
            model.addAttribute(NET_PAYABLE_ID, (Object)request.getParameter(NET_PAYABLE_ID));
            model.addAttribute(APPROVAL_DESIGNATION, (Object)request.getParameter(APPROVAL_DESIGNATION));
            model.addAttribute(APPROVAL_POSITION, (Object)request.getParameter(APPROVAL_POSITION));
            model.addAttribute(DESIGNATION, (Object)request.getParameter(DESIGNATION));
            egBillregister.getBillPayeedetails().clear();
            this.prepareBillDetailsForView(egBillregister);
            this.prepareValidActionListByCutOffDate(model);
            return EXPENSEBILL_FORM;
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        egBillregister.setDocumentDetail(list);
        try {
            savedEgBillregister = this.expenseBillService.create(egBillregister, approvalPosition, approvalComment, null, workFlowAction);
        }
        catch (ValidationException e) {
            this.setDropDownValues(model);
            model.addAttribute(STATE_TYPE, (Object)egBillregister.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)egBillregister, new WorkflowContainer());
            model.addAttribute(NET_PAYABLE_ID, (Object)request.getParameter(NET_PAYABLE_ID));
            model.addAttribute(APPROVAL_DESIGNATION, (Object)request.getParameter(APPROVAL_DESIGNATION));
            model.addAttribute(APPROVAL_POSITION, (Object)request.getParameter(APPROVAL_POSITION));
            model.addAttribute(DESIGNATION, (Object)request.getParameter(DESIGNATION));
            egBillregister.getBillPayeedetails().clear();
            this.prepareBillDetailsForView(egBillregister);
            this.prepareValidActionListByCutOffDate(model);
            resultBinder.reject("", ((ValidationError)e.getErrors().get(0)).getMessage());
            return EXPENSEBILL_FORM;
        }
        String approverDetails = this.financialUtils.getApproverDetails(workFlowAction, savedEgBillregister.getState(), savedEgBillregister.getId(), approvalPosition);
        return "redirect:/expensebill/success?approverDetails= " + approverDetails + "&billNumber=" + savedEgBillregister.getBillnumber();
    }

    @RequestMapping(value={"/success"}, method={RequestMethod.GET})
    public String showSuccessPage(@RequestParam(value="billNumber") String billNumber, Model model, HttpServletRequest request) {
        String[] keyNameArray = request.getParameter("approverDetails").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0].trim());
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0].trim());
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0].trim());
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            model.addAttribute("approverName", (Object)approverName);
        }
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        EgBillregister expenseBill = this.expenseBillService.getByBillnumber(billNumber);
        String message = this.getMessageByStatus(expenseBill, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        return "expensebill-success";
    }

    private String getMessageByStatus(EgBillregister expenseBill, String approverName, String nextDesign) {
        String message = "";
        if ("CREATED".equals(expenseBill.getStatus().getCode())) {
            message = StringUtils.isNotBlank((String)expenseBill.getEgBillregistermis().getBudgetaryAppnumber()) && !BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) ? this.messageSource.getMessage("msg.expense.bill.create.success.with.budgetappropriation", (Object[])new String[]{expenseBill.getBillnumber(), approverName, nextDesign, expenseBill.getEgBillregistermis().getBudgetaryAppnumber()}, null) : this.messageSource.getMessage("msg.expense.bill.create.success", (Object[])new String[]{expenseBill.getBillnumber(), approverName, nextDesign}, null);
        } else if ("Approved".equals(expenseBill.getStatus().getCode())) {
            message = this.messageSource.getMessage("msg.expense.bill.approved.success", (Object[])new String[]{expenseBill.getBillnumber()}, null);
        } else if ("Rejected".equals(expenseBill.getState().getValue())) {
            message = this.messageSource.getMessage("msg.expense.bill.reject", (Object[])new String[]{expenseBill.getBillnumber(), approverName, nextDesign}, null);
        } else if ("Cancelled".equals(expenseBill.getState().getValue())) {
            message = this.messageSource.getMessage("msg.expense.bill.cancel", (Object[])new String[]{expenseBill.getBillnumber()}, null);
        }
        return message;
    }

    @RequestMapping(value={"/downloadBillDoc"}, method={RequestMethod.GET})
    public void getBillDoc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = request.getServletContext();
        String fileStoreId = request.getParameter("fileStoreId");
        String fileName = "";
        File downloadFile = this.fileStoreService.fetch(fileStoreId, "EGF");
        FileInputStream inputStream = new FileInputStream(downloadFile);
        EgBillregister egBillregister = this.expenseBillService.getById(Long.valueOf(Long.parseLong(request.getParameter("egBillRegisterId"))));
        egBillregister = this.getBillDocuments(egBillregister);
        for (DocumentUpload doc : egBillregister.getDocumentDetail()) {
            if (!doc.getFileStore().getFileStoreId().equalsIgnoreCase(fileStoreId)) continue;
            fileName = doc.getFileStore().getFileName();
        }
        String mimeType = context.getMimeType(downloadFile.getAbsolutePath());
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        response.setContentType(mimeType);
        response.setContentLength((int)downloadFile.length());
        String headerKey = "Content-Disposition";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        ServletOutputStream outStream = response.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        outStream.close();
    }

    private EgBillregister getBillDocuments(EgBillregister egBillregister) {
        List documentDetailsList = this.expenseBillService.findByObjectIdAndObjectType(egBillregister.getId(), "egBillRegister");
        egBillregister.setDocumentDetail(documentDetailsList);
        return egBillregister;
    }
}

