/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.es.dashboard;

import java.io.IOException;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.egf.bean.dashboard.FinancialsBudgetDetailResponse;
import org.egov.egf.bean.dashboard.FinancialsDetailResponse;
import org.egov.egf.bean.dashboard.FinancialsDetailsRequest;
import org.egov.egf.bean.dashboard.FinancialsRatioAnalysisResponse;
import org.egov.egf.es.utils.FinancialsDashBoardUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.services.es.dashboard.FinancialsDashboardService;
import org.egov.services.es.dashboard.RatioAnalysisDashboardService;
import org.egov.utils.FinancialConstants;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/findashboard", "/findashboard"})
public class FinancialsDashboardController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinancialsDashboardController.class);
    @Autowired
    private FinancialsDashboardService financialsDashboardService;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private RatioAnalysisDashboardService ratioAnalysisDashboardService;

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<FinancialsDetailResponse> getFinancialDetails(FinancialsDetailsRequest financialsDetailsRequest) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("financialsDetailsRequest input : regionName = " + financialsDetailsRequest.getRegion() + ", districtName = " + financialsDetailsRequest.getDistrict() + ", ulbGrade = " + financialsDetailsRequest.getGrade() + ", ulbCode = " + financialsDetailsRequest.getUlbCode() + ", fromDate = " + financialsDetailsRequest.getFromDate() + ", toDate = " + financialsDetailsRequest.getToDate() + ", aggregationlevel = " + financialsDetailsRequest.getAggregationLevel());
        }
        this.setAsOnDate(financialsDetailsRequest);
        BoolQueryBuilder boolQuery = FinancialsDashBoardUtils.prepareWhereClause((FinancialsDetailsRequest)financialsDetailsRequest);
        String aggrField = FinancialsDashBoardUtils.getAggregationGroupingField((FinancialsDetailsRequest)financialsDetailsRequest);
        return this.financialsDashboardService.getFinancialsData(financialsDetailsRequest, boolQuery, aggrField);
    }

    private void setAsOnDate(FinancialsDetailsRequest financialsDetailsRequest) {
        if (financialsDetailsRequest.getToDate() != null && financialsDetailsRequest.getFromDate() == null) {
            CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(DateUtils.getDate((String)financialsDetailsRequest.getToDate(), (String)"yyyy-MM-dd"));
            financialsDetailsRequest.setFromDate(FinancialConstants.DATEFORMATTER_YYYY_MM_DD.format(financialYear.getStartingDate()));
            financialsDetailsRequest.setCurrentFinancialYear(financialYear.getFinYearRange());
            financialsDetailsRequest.setLastFinancialYear(this.cFinancialYearService.getPreviousFinancialYearForDate(DateUtils.getDate((String)financialsDetailsRequest.getToDate(), (String)"yyyy-MM-dd")).getFinYearRange());
        } else if (financialsDetailsRequest.getToDate() != null && financialsDetailsRequest.getFromDate() != null) {
            CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(DateUtils.getDate((String)financialsDetailsRequest.getToDate(), (String)"yyyy-MM-dd"));
            financialsDetailsRequest.setCurrentFinancialYear(financialYear.getFinYearRange());
            financialsDetailsRequest.setLastFinancialYear(this.cFinancialYearService.getPreviousFinancialYearForDate(DateUtils.getDate((String)financialsDetailsRequest.getToDate(), (String)"yyyy-MM-dd")).getFinYearRange());
        } else {
            CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(DateUtils.now());
            financialsDetailsRequest.setToDate(FinancialConstants.DATEFORMATTER_YYYY_MM_DD.format(DateUtils.now()));
            financialsDetailsRequest.setFromDate(FinancialConstants.DATEFORMATTER_YYYY_MM_DD.format(financialYear.getStartingDate()));
            financialsDetailsRequest.setCurrentFinancialYear(financialYear.getFinYearRange());
            financialsDetailsRequest.setLastFinancialYear(this.cFinancialYearService.getPreviousFinancialYearForDate(DateUtils.now()).getFinYearRange());
        }
    }

    @RequestMapping(value={"/statewisebudget"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<FinancialsBudgetDetailResponse> getFinDetails(FinancialsDetailsRequest financialsDetailsRequest) throws IOException {
        this.setAsOnDate(financialsDetailsRequest);
        BoolQueryBuilder boolQuery = FinancialsDashBoardUtils.prepareWhereClauseForBudget((FinancialsDetailsRequest)financialsDetailsRequest);
        String aggrField = FinancialsDashBoardUtils.getAggregationGroupingFieldForBudget((FinancialsDetailsRequest)financialsDetailsRequest);
        return this.financialsDashboardService.getBudgetData(financialsDetailsRequest, boolQuery, aggrField);
    }

    @RequestMapping(value={"/ratios"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<FinancialsRatioAnalysisResponse> getRatioAnalysisReport(FinancialsDetailsRequest financialsDetailsRequest) throws IOException {
        this.setAsOnDate(financialsDetailsRequest);
        this.setFinancialYear(financialsDetailsRequest);
        BoolQueryBuilder boolQuery = FinancialsDashBoardUtils.prepareWhereClause((FinancialsDetailsRequest)financialsDetailsRequest);
        String aggrField = FinancialsDashBoardUtils.getAggregationGroupingField((FinancialsDetailsRequest)financialsDetailsRequest);
        return this.ratioAnalysisDashboardService.getRatios(financialsDetailsRequest, boolQuery, aggrField);
    }

    private void setFinancialYear(FinancialsDetailsRequest financialsDetailsRequest) {
        if (financialsDetailsRequest.getFinancialYear() != null) {
            CFinancialYear financialYear = this.cFinancialYearService.getFinacialYearByYearRange(financialsDetailsRequest.getFinancialYear());
            financialsDetailsRequest.setFromDate(FinancialConstants.DATEFORMATTER_YYYY_MM_DD.format(financialYear.getStartingDate()));
            financialsDetailsRequest.setLastFinancialYear(this.cFinancialYearService.getPreviousFinancialYearForDate(financialYear.getStartingDate()).getFinYearRange());
        } else {
            CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(DateUtils.now());
            financialsDetailsRequest.setCurrentFinancialYear(financialYear.getFinYearRange());
            financialsDetailsRequest.setFinancialYear(financialYear.getFinYearRange());
            financialsDetailsRequest.setLastFinancialYear(this.cFinancialYearService.getPreviousFinancialYearForDate(DateUtils.now()).getFinYearRange());
        }
    }
}

