/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.common;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.service.FunctionService;
import org.egov.commons.service.FundsourceService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.billsubtype.service.EgBillSubTypeService;
import org.egov.egf.commons.bankaccount.service.CreateBankAccountService;
import org.egov.egf.commons.bankbranch.service.CreateBankBranchService;
import org.egov.egf.web.adaptor.ChartOfAccountsAdaptor;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.support.json.adapter.HibernateProxyTypeAdapter;
import org.egov.model.bills.EgBillSubType;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/common"})
public class AjaxCommonController {
    @Autowired
    @Qualifier(value="schemeService")
    private SchemeService schemeService;
    @Autowired
    @Qualifier(value="subSchemeService")
    private SubSchemeService subSchemeService;
    @Autowired
    private CreateBankBranchService createBankBranchService;
    @Autowired
    private FundsourceService fundsourceService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private EgBillSubTypeService egBillSubTypeService;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    private CreateBankAccountService createBankAccountService;

    @RequestMapping(value={"/getschemesbyfundid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Scheme> getAllSchemesByFundId(@RequestParam(value="fundId") String fundId) throws ApplicationException {
        return this.schemeService.getByFundId(Integer.valueOf(Integer.parseInt(fundId)));
    }

    @RequestMapping(value={"/getsubschemesbyschemeid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SubScheme> getAllSubSchemesBySchemeId(@RequestParam(value="schemeId") String schemeId) throws ApplicationException {
        return this.subSchemeService.getBySchemeId(Integer.valueOf(Integer.parseInt(schemeId)));
    }

    @RequestMapping(value={"/getfundsourcesbysubschemeid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Fundsource> getAllFundSourcesBySubSchemeId(@RequestParam(value="subSchemeId") String subSchemeId) throws ApplicationException {
        return this.fundsourceService.getBySubSchemeId(Integer.valueOf(Integer.parseInt(subSchemeId)));
    }

    @RequestMapping(value={"/ajaxfunctionnames"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findFunctionNames(@RequestParam String name) {
        ArrayList<String> functionNames = new ArrayList<String>();
        List functions = this.functionService.findByNameLikeOrCodeLike(name);
        for (CFunction function : functions) {
            if (function.getIsNotLeaf().booleanValue()) continue;
            functionNames.add(function.getCode() + " - " + function.getName() + " ~ " + function.getId());
        }
        return functionNames;
    }

    @RequestMapping(value={"/getentitesbyaccountdetailtype"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEntitesByAccountDetailType(@RequestParam String name, @RequestParam String accountDetailType) {
        ArrayList<String> entityNames = new ArrayList<String>();
        List entitiesList = new ArrayList();
        Accountdetailtype detailType = this.accountdetailtypeService.findOne(Integer.valueOf(Integer.parseInt(accountDetailType)));
        try {
            String table = detailType.getFullQualifiedName();
            Class<?> service = Class.forName(table);
            String simpleName = service.getSimpleName();
            simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1) + "Service";
            EntityTypeService entityService = (EntityTypeService)this.applicationContext.getBean(simpleName);
            entitiesList = entityService.filterActiveEntities(name, 20, detailType.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            entitiesList = new ArrayList();
        }
        for (EntityType entity : entitiesList) {
            entityNames.add(entity.getCode() + " - " + entity.getName() + "~" + entity.getEntityId());
        }
        return entityNames;
    }

    @RequestMapping(value={"/getaccountcodesforaccountdetailtype"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String findAccountCodesForAccountDetailType(@RequestParam String glcode, @RequestParam String accountDetailType) {
        List chartOfAccounts = this.chartOfAccountsService.getSubledgerAccountCodesForAccountDetailTypeAndNonSubledgers(Integer.valueOf(Integer.parseInt(accountDetailType)), glcode);
        for (CChartOfAccounts coa : chartOfAccounts) {
            if (coa.getChartOfAccountDetails().isEmpty()) {
                coa.setIsSubLedger(Boolean.valueOf(false));
                continue;
            }
            coa.setIsSubLedger(Boolean.valueOf(true));
        }
        return AjaxCommonController.toJSON((Collection)chartOfAccounts, CChartOfAccounts.class, ChartOfAccountsAdaptor.class);
    }

    @RequestMapping(value={"/getnetpayablecodesbyaccountdetailtype"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getNetPayableCodesByAccountDetailType(@RequestParam(value="accountDetailType") String accountDetailType) throws ApplicationException {
        List chartOfAccounts = this.chartOfAccountsService.getNetPayableCodesByAccountDetailType(Integer.valueOf(Integer.parseInt(accountDetailType)));
        for (CChartOfAccounts coa : chartOfAccounts) {
            if (coa.getChartOfAccountDetails().isEmpty()) {
                coa.setIsSubLedger(Boolean.valueOf(false));
                continue;
            }
            coa.setIsSubLedger(Boolean.valueOf(true));
        }
        return AjaxCommonController.toJSON((Collection)chartOfAccounts, CChartOfAccounts.class, ChartOfAccountsAdaptor.class);
    }

    @RequestMapping(value={"/getchecklistbybillsubtype"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<AppConfigValues> getCheckListByBillSubType(@RequestParam(value="billSubType") String billSubType) {
        EgBillSubType egBillSubType = this.egBillSubTypeService.getById(Long.valueOf(Long.parseLong(billSubType)));
        List checkList = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", egBillSubType.getName());
        if (checkList == null || checkList.isEmpty()) {
            checkList = this.appConfigValueService.getConfigValuesByModuleAndKey("EGF", "Others");
        }
        return checkList;
    }

    @RequestMapping(value={"/getallaccountcodes"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String findAllAccountCodes(@RequestParam String glcode) {
        List chartOfAccounts = this.chartOfAccountsService.getAllAccountCodes(glcode);
        for (CChartOfAccounts coa : chartOfAccounts) {
            if (coa.getChartOfAccountDetails().isEmpty()) {
                coa.setIsSubLedger(Boolean.valueOf(false));
                continue;
            }
            coa.setIsSubLedger(Boolean.valueOf(true));
        }
        return AjaxCommonController.toJSON((Collection)chartOfAccounts, CChartOfAccounts.class, ChartOfAccountsAdaptor.class);
    }

    @RequestMapping(value={"/getaccountdetailtypesbyglcodeid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Accountdetailtype> getAccountDetailTypesByGlcodeId(@RequestParam(value="glcodeId") String glcodeId) throws ApplicationException {
        return this.accountdetailtypeService.findByGlcodeId(Long.valueOf(Long.parseLong(glcodeId)));
    }

    @RequestMapping(value={"/getbankbranchesbybankid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Bankbranch> getBankbranchesByBankId(@RequestParam(value="bankId") String bankId) throws ApplicationException {
        if (!"0".equals(bankId)) {
            return this.createBankBranchService.getByBankId(Integer.valueOf(Integer.parseInt(bankId)));
        }
        return this.createBankBranchService.getByIsActiveTrueOrderByBranchname();
    }

    @RequestMapping(value={"/getbankaccountbybranchid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Bankaccount> getBankAccountByBranchId(@RequestParam(value="branchId") String branchId) throws ApplicationException {
        return this.createBankAccountService.getByBranchId(Integer.valueOf(Integer.parseInt(branchId)));
    }

    public static <T> String toJSON(Collection<T> objects, Class<? extends T> objectClazz, Class<? extends JsonSerializer<T>> adptorClazz) {
        try {
            return new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).registerTypeAdapter(objectClazz, adptorClazz.newInstance()).create().toJson(objects);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ApplicationRuntimeException("Could not convert object list to json string", (Throwable)e);
        }
    }
}

