/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller.bankstatement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.egf.commons.bank.service.CreateBankService;
import org.egov.egf.commons.bankbranch.service.CreateBankBranchService;
import org.egov.egf.web.actions.brs.AutoReconcileHelper;
import org.egov.egf.web.controller.bankstatement.adaptor.DocumentUploadJsonAdaptor;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.model.bills.DocumentUpload;
import org.egov.model.brs.BankStatementUploadFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/bankstatement"})
public class BankStatementUploadSearchController {
    private static final int BUFFER_SIZE = 4096;
    @Autowired
    private CreateBankService createBankService;
    @Autowired
    private CreateBankBranchService createBankBranchService;
    @Autowired
    private AutoReconcileHelper autoReconcileHelper;
    @Autowired
    private FileStoreService fileStoreService;

    private void setDropDownValues(Model model) {
        model.addAttribute("banks", (Object)this.createBankService.getByIsActiveTrueOrderByName());
        model.addAttribute("bankbranches", (Object)this.createBankBranchService.getByIsActiveTrueOrderByBranchname());
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        this.setDropDownValues(model);
        model.addAttribute("bankStatementUploadFile", (Object)new BankStatementUploadFile());
        return "bankstatement-search";
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(Model model, @ModelAttribute BankStatementUploadFile bankStatementUploadFile) {
        List list = this.autoReconcileHelper.getUploadedFiles(bankStatementUploadFile);
        return "{ \"data\":" + this.toSearchResultJson((Object)list) + "}";
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DocumentUpload.class, (Object)new DocumentUploadJsonAdaptor()).create();
        return gson.toJson(object);
    }

    @RequestMapping(value={"/downloadDoc"}, method={RequestMethod.GET})
    public void getBillDoc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String mimeType;
        ServletContext context = request.getServletContext();
        String fileStoreId = request.getParameter("fileStoreId");
        String fileName = "";
        File downloadFile = this.fileStoreService.fetch(fileStoreId, "EGF");
        FileInputStream inputStream = new FileInputStream(downloadFile);
        DocumentUpload doc = this.autoReconcileHelper.getDocumentsByFileStoreId(fileStoreId);
        if (doc.getFileStore().getFileStoreId().equalsIgnoreCase(fileStoreId)) {
            fileName = doc.getFileStore().getFileName();
        }
        if ((mimeType = context.getMimeType(downloadFile.getAbsolutePath())) == null) {
            mimeType = "application/octet-stream";
        }
        response.setContentType(mimeType);
        response.setContentLength((int)downloadFile.length());
        String headerKey = "Content-Disposition";
        String headerValue = String.format("attachment; filename=\"%s\"", fileName);
        response.setHeader("Content-Disposition", headerValue);
        ServletOutputStream outStream = response.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        outStream.close();
    }
}

