/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.commons.service.CFinancialYearService;
import org.egov.commons.service.FundService;
import org.egov.egf.receiptpayment.service.ReceiptPaymentService;
import org.egov.egf.web.adaptor.ReceiptPaymentJsonAdaptor;
import org.egov.enums.FinancialPeriodEnum;
import org.egov.model.receiptpayment.ReceiptPayment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/receiptpayment"})
public class ReceiptPaymentController {
    private static final String RECEIPTPAYMENT_RESULT = "receiptpayment-result";
    private static final String RECEIPTPAYMENT_VIEW = "receiptpayment-view";
    private static final String RECEIPTPAYMENT_SEARCH = "receiptpayment-search";
    @Autowired
    private ReceiptPaymentService receiptPaymentService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private FundService fundService;

    private void prepareNewForm(Model model) {
        model.addAttribute("cFinancialYears", (Object)this.cFinancialYearService.findAll());
        model.addAttribute("funds", (Object)this.fundService.findAllActiveAndIsnotleaf());
        model.addAttribute("financialPeriodEnums", (Object)FinancialPeriodEnum.values());
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        ReceiptPayment receiptPayment = new ReceiptPayment();
        this.prepareNewForm(model);
        model.addAttribute("receiptPayment", (Object)receiptPayment);
        return RECEIPTPAYMENT_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(Model model, @ModelAttribute ReceiptPayment receiptPayment) {
        List searchResultList = this.receiptPaymentService.search(receiptPayment);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ReceiptPayment.class, (Object)new ReceiptPaymentJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

