/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.CFunction;
import org.egov.commons.service.FunctionService;
import org.egov.egf.web.adaptor.FunctionJsonAdaptor;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/function"})
public class FunctionController {
    private static final String FUNCTION_NEW = "function-new";
    private static final String FUNCTION_RESULT = "function-result";
    private static final String FUNCTION_EDIT = "function-edit";
    private static final String FUNCTION_VIEW = "function-view";
    private static final String FUNCTION_SEARCH = "function-search";
    @Autowired
    private FunctionService functionService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private EgovMasterDataCaching egovMasterDataCaching;

    private void prepareNewForm(Model model) {
        model.addAttribute("functions", (Object)this.functionService.findAllIsNotLeafTrue());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("CFunction", (Object)new CFunction());
        return FUNCTION_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CFunction function, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return FUNCTION_NEW;
        }
        if (function.getParentId() != null && function.getParentId().getId() != null) {
            function.setParentId(this.functionService.findOne(function.getParentId().getId()));
        } else {
            function.setParentId(null);
        }
        this.functionService.create(function);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.function.success", null, null));
        EgovMasterDataCaching.removeFromCache((String)"egi-activeFunctions");
        EgovMasterDataCaching.removeFromCache((String)"egi-function");
        return "redirect:/function/result/" + function.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CFunction function = this.functionService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("CFunction", (Object)function);
        return FUNCTION_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CFunction function, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return FUNCTION_EDIT;
        }
        this.functionService.update(function);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.function.success", null, null));
        EgovMasterDataCaching.removeFromCache((String)"egi-activeFunctions");
        EgovMasterDataCaching.removeFromCache((String)"egi-function");
        return "redirect:/function/result/" + function.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CFunction function = this.functionService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("function", (Object)function);
        return FUNCTION_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CFunction function = this.functionService.findOne(id);
        model.addAttribute("function", (Object)function);
        return FUNCTION_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CFunction function = new CFunction();
        this.prepareNewForm(model);
        model.addAttribute("function", (Object)function);
        return FUNCTION_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CFunction function) {
        List searchResultList = this.functionService.search(function);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CFunction.class, (Object)new FunctionJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

