/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.controller;

import java.util.List;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/budgetcheckconfig"})
public class BudgetCheckConfigController {
    private static final String BUDGETCHECKCONFIG_NEW = "budgetcheckconfig-new";
    private static final String BUDGETCHECKCONFIG_RESULT = "budgetcheckconfig-result";
    @Autowired
    private BudgetControlTypeService budgetCheckConfigService;
    @Autowired
    private MessageSource messageSource;

    private BudgetControlType prepareNewForm(Model model) {
        List configs = this.budgetCheckConfigService.findAll();
        if (configs.size() > 0) {
            return (BudgetControlType)configs.get(0);
        }
        return new BudgetControlType();
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        model.addAttribute("budgetControlType", (Object)this.prepareNewForm(model));
        model.addAttribute("configoptions", (Object)BudgetControlType.BudgetCheckOption.values());
        return BUDGETCHECKCONFIG_NEW;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@ModelAttribute BudgetControlType budgetControlType, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return BUDGETCHECKCONFIG_NEW;
        }
        this.budgetCheckConfigService.update(budgetControlType);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.budgetcheckconfig.success", null, null));
        return "redirect:/budgetcheckconfig/result/" + budgetControlType.getId();
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        BudgetControlType budgetControlType = this.budgetCheckConfigService.findOne(id);
        model.addAttribute("budgetControlType", (Object)budgetControlType);
        return BUDGETCHECKCONFIG_RESULT;
    }
}

