/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import com.exilant.eGov.src.transactions.VoucherTypeForULB;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.billsaccounting.services.BillsAccountingService;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.Relation;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.service.ChartOfAccountDetailService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.voucher.JournalVoucherModifyAction;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigService;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.masters.model.AccountEntity;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.voucher.PreApprovedVoucher;
import org.egov.model.voucher.WorkflowBean;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EisUtilService;
import org.egov.services.bills.BillsService;
import org.egov.services.contra.ContraService;
import org.egov.services.voucher.PreApprovedActionHelper;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.VoucherHelper;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Results(value={@Result(name={"editVoucher"}, type="redirectAction", location="journalVoucherModify-beforeModify", params={"namespace", "/voucher", "voucherId", "${voucherId}"}), @Result(name={"view"}, location="preApprovedVoucher-view.jsp"), @Result(name={"voucheredit"}, location="preApprovedVoucher-voucheredit.jsp"), @Result(name={"billview"}, location="preApprovedVoucher-billview.jsp"), @Result(name={"voucherview"}, location="preApprovedVoucher-voucherview.jsp"), @Result(name={"message"}, location="preApprovedVoucher-message.jsp")})
@ParentPackage(value="egov")
public class PreApprovedVoucherAction
extends GenericWorkFlowAction {
    private static final String FORWARD = "Forward";
    private static final String EGF = "EGF";
    private static final String EMPTY_STRING = "";
    private static final long serialVersionUID = 1L;
    private VoucherService voucherService;
    private CVoucherHeader voucherHeader = new CVoucherHeader();
    private EgBillregister egBillregister = new EgBillregister();
    private SimpleWorkflowService<CVoucherHeader> voucherWorkflowService;
    protected WorkflowBean workflowBean = new WorkflowBean();
    protected EisCommonService eisCommonService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovCommon egovCommon;
    @Autowired
    @Qualifier(value="preApprovedActionHelper")
    private PreApprovedActionHelper preApprovedActionHelper;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private VoucherTypeForULB voucherTypeForULB;
    private List<EgBillregister> preApprovedVoucherList;
    protected List<String> headerFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    protected EisUtilService eisService;
    @Autowired
    private static BillsService billsService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private BillsAccountingService billsAccountingService;
    @Autowired
    private BillsService billsManager;
    @Autowired
    private ChartOfAccountDetailService chartOfAccountDetailService;
    @Autowired
    private AppConfigService appConfigService;
    private static final Logger LOGGER;
    protected FinancialYearHibernateDAO financialYearDAO;
    private final PreApprovedVoucher preApprovedVoucher = new PreApprovedVoucher();
    private List<PreApprovedVoucher> billDetailslist;
    private List<PreApprovedVoucher> subLedgerlist;
    @Autowired
    private CreateVoucher createVoucher;
    private ContraJournalVoucher contraVoucher;
    private static final String ERROR = "error";
    private static final String BILLID = "billid";
    protected static final String VOUCHEREDIT = "voucheredit";
    private static final String VHID = "vhid";
    private static final String CGN = "cgn";
    private static final String VOUCHERQUERY = " from CVoucherHeader where id=?";
    private static final String VOUCHERQUERYBYCGN = " from CVoucherHeader where cgn=?";
    private static final String ACCDETAILTYPEQUERY = " from Accountdetailtype where id=?";
    private static final String ACTIONNAME = "actionName";
    private String values = "";
    private String from = "";
    private String methodName = "";
    private Integer departmentId;
    private String type;
    private String wfitemstate;
    private String voucherNumber;
    private Boolean displayVoucherNumber = true;
    private String action = "";
    SimpleWorkflowService<ContraJournalVoucher> contraWorkflowService;
    private Map<String, Object> billDetails;
    private VoucherHelper voucherHelper;
    private JournalVoucherModifyAction journalvouchermodify;
    private boolean showVoucherDate;
    private ScriptService scriptService;
    private String mode = "";
    protected Long voucherId;
    private EgBillregister billRegister;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    private String cutOffDate;
    protected DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    DateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
    Date date;

    public StateAware getModel() {
        return this.voucherHeader;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("departmentList", Collections.EMPTY_LIST);
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
        this.addDropdownData("userList", Collections.EMPTY_LIST);
    }

    @SkipValidation
    public String list() {
        EgwStatus egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("SBILL", "Approved");
        this.getHeaderMandateFields();
        this.preApprovedVoucherList = this.isFieldMandatory("department") ? this.getPersistenceService().findAllBy(" from EgBillregister br where br.status=? and br.egBillregistermis.egDepartment.id=? and ( br.egBillregistermis.voucherHeader is null or br.egBillregistermis.voucherHeader in (from CVoucherHeader vh where vh.status =4 )) ", new Object[]{egwStatus, this.getCurrentDepartment().getId()}) : this.getPersistenceService().findAllBy(" from EgBillregister br where br.status=? and ( br.egBillregistermis.voucherHeader is null or br.egBillregistermis.voucherHeader in (from CVoucherHeader vh where vh.status =4 )) ", new Object[]{egwStatus});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)this.preApprovedVoucherList);
        }
        return "list";
    }

    @SkipValidation
    @Action(value="/voucher/preApprovedVoucher-voucher")
    public String voucher() {
        ArrayList<ValidationError> errors;
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "DataEntryCutOffDate");
        if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
            try {
                this.date = this.df.parse(((AppConfigValues)cutOffDateconfigValue.get(0)).getValue());
                this.cutOffDate = this.formatter.format(this.date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.egBillregister = (EgBillregister)this.getPersistenceService().find(" from EgBillregister where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get(BILLID))[0])});
        this.voucherHeader = this.egBillregister.getEgBillregistermis().getVoucherHeader();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("egBillregister==" + this.egBillregister));
        }
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "pjv_saveasworkingcopy_enabled");
        String pjv_wc_enabled = ((AppConfigValues)appList.get(0)).getValue();
        this.preApprovedVoucher.setVoucherDate(new Date());
        this.type = this.egBillregister.getExpendituretype();
        this.getHeaderMandateFields();
        String purposeValueVN = EMPTY_STRING;
        try {
            List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "VOUCHERDATE_FROM_UI");
            for (AppConfigValues appConfigVal : configValues) {
                purposeValueVN = appConfigVal.getValue();
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Appconfig value for VOUCHERDATE_FROM_UI is not defined in the system");
        }
        if (purposeValueVN.equals("Y")) {
            this.showVoucherDate = true;
        }
        if ("Y".equals(pjv_wc_enabled)) {
            try {
                this.getMasterDataForBillVoucher();
            }
            catch (Exception e) {
                errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", e.getMessage()));
                throw new ValidationException(errors);
            }
            return VOUCHEREDIT;
        }
        try {
            this.getMasterDataForBill();
        }
        catch (Exception e) {
            errors = new ArrayList();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        this.action = "save";
        return "billview";
    }

    public List<String> getValidActions() {
        List<String> validActions = Collections.emptyList();
        if (!this.action.equalsIgnoreCase("save")) {
            if (null == this.getModel() || null == this.getModel().getId() || this.getModel().getCurrentState().getValue().endsWith("NEW")) {
                validActions = Arrays.asList(FORWARD);
            } else if (this.getModel().getCurrentState() != null) {
                validActions = this.customizedWorkFlowService.getNextValidActions(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.getModel().getCurrentState().getValue(), this.getPendingActions(), this.getModel().getCreatedDate());
            }
        } else {
            CVoucherHeader model = new CVoucherHeader();
            List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "DataEntryCutOffDate");
            if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
                if (null == model || null == model.getId() || model.getCurrentState().getValue().endsWith("NEW")) {
                    validActions = Arrays.asList(FORWARD, "Create And Approve");
                } else if (model.getCurrentState() != null) {
                    validActions = this.customizedWorkFlowService.getNextValidActions(model.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), model.getCurrentState().getValue(), this.getPendingActions(), model.getCreatedDate());
                }
            } else if (null == model || null == model.getId() || model.getCurrentState().getValue().endsWith("NEW")) {
                validActions = Arrays.asList(FORWARD);
            } else if (model.getCurrentState() != null) {
                validActions = this.customizedWorkFlowService.getNextValidActions(model.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), model.getCurrentState().getValue(), this.getPendingActions(), model.getCreatedDate());
            }
        }
        return validActions;
    }

    public String getNextAction() {
        WorkFlowMatrix wfMatrix = null;
        if (!this.action.equalsIgnoreCase("save")) {
            if (this.getModel().getId() != null) {
                wfMatrix = this.getModel().getCurrentState() != null ? this.customizedWorkFlowService.getWfMatrix(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.getModel().getCurrentState().getValue(), this.getPendingActions(), this.getModel().getCreatedDate()) : this.customizedWorkFlowService.getWfMatrix(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), "Created", this.getPendingActions(), this.getModel().getCreatedDate());
            }
        } else {
            CVoucherHeader model = new CVoucherHeader();
            if (model.getId() != null) {
                wfMatrix = model.getCurrentState() != null ? this.customizedWorkFlowService.getWfMatrix(model.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), model.getCurrentState().getValue(), this.getPendingActions(), model.getCreatedDate()) : this.customizedWorkFlowService.getWfMatrix(model.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), "Created", this.getPendingActions(), model.getCreatedDate());
            }
        }
        return wfMatrix == null ? EMPTY_STRING : wfMatrix.getNextAction();
    }

    @SkipValidation
    @Action(value="/voucher/preApprovedVoucher-loadvoucher")
    public String loadvoucher() {
        String result = null;
        this.voucherHeader = (CVoucherHeader)this.getPersistenceService().find(VOUCHERQUERY, new Object[]{Long.valueOf(((String[])this.parameters.get(VHID))[0])});
        this.voucherId = Long.valueOf(((String[])this.parameters.get(VHID))[0]);
        boolean ismodifyJv = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("voucherHeader==" + this.voucherHeader));
        }
        if (this.voucherHeader != null && this.voucherHeader.getState() != null && !this.validateOwner(this.voucherHeader.getState()).booleanValue()) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", "Invalid User"));
            throw new ValidationException(errors);
        }
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "pjv_saveasworkingcopy_enabled");
        String pjv_wc_enabled = ((AppConfigValues)appList.get(0)).getValue();
        this.type = billsService.getBillTypeforVoucher(this.voucherHeader);
        if (null == this.type) {
            this.type = "default";
        }
        try {
            this.getMasterDataForBillVoucher();
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        this.getHeaderMandateFields();
        this.getSession().put("voucherId", ((String[])this.parameters.get(VHID))[0]);
        if (this.voucherHeader.getState() != null && this.voucherHeader.getState().getValue().contains("Rejected") && this.voucherHeader.getModuleId() == null) {
            EgBillregistermis billMis = (EgBillregistermis)this.persistenceService.find("from EgBillregistermis where voucherHeader.id=?", new Object[]{this.voucherHeader.getId()});
            if (billMis != null) {
                State billWorkFlowState = billMis.getEgBillregister().getState();
                if (billWorkFlowState == null) {
                    result = "editVoucher";
                    ismodifyJv = true;
                }
            } else if (this.voucherHeader.getName().equalsIgnoreCase("JVGeneral")) {
                this.type = "JVGeneral";
                result = "editVoucher";
                ismodifyJv = true;
            }
        }
        if (!ismodifyJv) {
            result = "Y".equals(pjv_wc_enabled) ? VOUCHEREDIT : "voucherview";
        }
        this.billRegister = (EgBillregister)this.persistenceService.find("select mis.egBillregister from EgBillregistermis mis where mis.voucherHeader.id=?", new Object[]{this.voucherHeader.getId()});
        return result;
    }

    private void loadApproverUser(String type) {
        String scriptName = "billvoucher.nextDesg";
        this.departmentId = this.voucherService.getCurrentDepartment().getId().intValue();
        Map map = this.voucherService.getDesgByDeptAndType(type, "billvoucher.nextDesg");
        if (null == map.get("wfitemstate")) {
            if (this.mandatoryFields.contains("department")) {
                this.addDropdownData("departmentList", this.voucherHelper.getAllAssgnDeptforUser());
            } else {
                this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
            }
            this.addDropdownData("designationList", (List)map.get("designationList"));
            this.wfitemstate = EMPTY_STRING;
        } else {
            this.wfitemstate = map.get("wfitemstate").toString();
        }
    }

    @SkipValidation
    @Action(value="/voucher/preApprovedVoucher-loadvoucherview")
    public String loadvoucherview() throws ApplicationException {
        this.billDetails = new HashMap();
        if (this.parameters.get("from") != null && "Contra".equals(((String[])this.parameters.get("from"))[0])) {
            this.contraVoucher = (ContraJournalVoucher)this.persistenceService.find(" from ContraJournalVoucher where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get(VHID))[0])});
            this.voucherHeader = this.contraVoucher.getVoucherHeaderId();
            this.from = "Contra";
        } else {
            this.voucherHeader = (CVoucherHeader)this.getPersistenceService().find(VOUCHERQUERY, new Object[]{Long.valueOf(((String[])this.parameters.get(VHID))[0])});
            this.from = "Journal Voucher";
        }
        this.getMasterDataForBillVoucher();
        this.getHeaderMandateFields();
        return "view";
    }

    @SkipValidation
    @Action(value="/voucher/preApprovedVoucher-approve")
    public String approve() throws ApplicationException {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"classpath:org/serviceconfig-Bean.xml", "classpath:org/egov/infstr/beanfactory/globalApplicationContext.xml", "classpath:org/egov/infstr/beanfactory/applicationContext-egf.xml"});
        this.voucherHeader = (CVoucherHeader)this.persistenceService.find(VOUCHERQUERY, new Object[]{Long.valueOf(((String[])this.parameters.get(VHID))[0])});
        if (this.voucherHeader.getType().equals("Contra")) {
            this.contraVoucher = (ContraJournalVoucher)this.persistenceService.find("from ContraJournalVoucher where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("contraId"))[0])});
            ContraService contraService = (ContraService)applicationContext.getBean("contraService");
            this.contraWorkflowService.transition(((String[])this.parameters.get(ACTIONNAME))[0], (StateAware)this.contraVoucher, ((String[])this.parameters.get("comments"))[0]);
            contraService.persist((Object)this.contraVoucher);
            this.addActionMsg(this.contraVoucher.getState().getValue(), (Position)this.contraVoucher.getState().getOwnerPosition());
        } else if (this.voucherHeader.getType().equals("Journal Voucher") || this.voucherHeader.getType().equals("Contra")) {
            this.voucherWorkflowService.transition(((String[])this.parameters.get(ACTIONNAME))[0], (StateAware)this.voucherHeader, ((String[])this.parameters.get("comments"))[0]);
            this.voucherService.persist((Object)this.voucherHeader);
            this.addActionMsg(this.voucherHeader.getState().getValue(), (Position)this.voucherHeader.getState().getOwnerPosition());
        }
        this.methodName = "approval";
        this.getMasterDataForBillVoucher();
        return "view";
    }

    private void addActionMsg(String stateValue, Position pos) {
        if (((String[])this.parameters.get(ACTIONNAME))[0].contains("approve")) {
            if ("END".equals(stateValue)) {
                this.addActionMessage(this.getText("pjv.voucher.final.approval", new String[]{"The File has been approved"}));
            } else {
                this.addActionMessage(this.getText("pjv.voucher.approved", new String[]{this.voucherService.getEmployeeNameForPositionId(pos)}));
            }
        } else if (((String[])this.parameters.get(ACTIONNAME))[0].contains("co_reject") || ((String[])this.parameters.get(ACTIONNAME))[0].contains("aa_reject") || "END".equals(stateValue)) {
            this.addActionMessage(this.getText("voucher.cancelled"));
        } else {
            this.addActionMessage(this.getText("pjv.voucher.rejected", new String[]{this.voucherService.getEmployeeNameForPositionId(pos)}));
        }
    }

    @SkipValidation
    @Action(value="/voucher/preApprovedVoucher-loadvoucherviewByCGN")
    public String loadvoucherviewByCGN() throws ApplicationException {
        this.billDetails = new HashMap();
        this.voucherHeader = (CVoucherHeader)this.getPersistenceService().find(VOUCHERQUERYBYCGN, new Object[]{((String[])this.parameters.get(CGN))[0]});
        this.getHeaderMandateFields();
        this.getMasterDataForBillVoucher();
        return "view";
    }

    @ValidationErrorPage(value="billview")
    @SkipValidation
    @Action(value="/voucher/preApprovedVoucher-save")
    public String save() throws ValidationException {
        this.mode = "save";
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("bill id=======" + ((String[])this.parameters.get(BILLID))[0]));
            }
            this.methodName = "save";
            String voucherDate = this.formatter1.format(this.voucherHeader.getVoucherDate());
            String cutOffDate1 = null;
            this.egBillregister = billsService.getBillRegisterById(Integer.valueOf(((String[])this.parameters.get(BILLID))[0]));
            this.validateBillVoucherDate(this.egBillregister, this.voucherHeader);
            this.getMasterDataForBill();
            this.populateWorkflowBean();
            this.voucherHeader = this.preApprovedActionHelper.createVoucherFromBill(this.voucherHeader, this.workflowBean, Long.valueOf(Long.parseLong(((String[])this.parameters.get(BILLID))[0])), this.voucherNumber, this.voucherHeader.getVoucherDate());
            if (!this.cutOffDate.isEmpty() && this.cutOffDate != null) {
                try {
                    this.date = this.sdf.parse(this.cutOffDate);
                    cutOffDate1 = this.formatter1.format(this.date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (cutOffDate1 != null && voucherDate.compareTo(cutOffDate1) <= 0 && "Create And Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                if (this.voucherHeader.getVouchermis().getBudgetaryAppnumber() == null) {
                    this.addActionMessage(this.getText("Voucher created successfully. Voucher No : ") + this.voucherHeader.getVoucherNumber());
                } else {
                    this.addActionMessage(this.getText("Voucher created successfully. Voucher No : ") + this.voucherHeader.getVoucherNumber() + " And " + this.getText("budget.recheck.sucessful", new String[]{this.voucherHeader.getVouchermis().getBudgetaryAppnumber()}));
                }
            } else if (this.voucherHeader.getVouchermis().getBudgetaryAppnumber() == null) {
                this.addActionMessage(this.getText(this.egBillregister.getExpendituretype() + ".voucher.created", new String[]{this.voucherHeader.getVoucherNumber(), this.voucherService.getEmployeeNameForPositionId((Position)this.voucherHeader.getState().getOwnerPosition())}));
            } else {
                this.addActionMessage(this.getText(this.egBillregister.getExpendituretype() + ".voucher.created", new String[]{this.voucherHeader.getVoucherNumber(), this.voucherService.getEmployeeNameForPositionId((Position)this.voucherHeader.getState().getOwnerPosition())}) + " And " + this.getText("budget.recheck.sucessful", new String[]{this.voucherHeader.getVouchermis().getBudgetaryAppnumber()}));
            }
        }
        catch (ValidationException e) {
            this.voucher();
            this.mode = EMPTY_STRING;
            if (((ValidationError)e.getErrors().get(0)).getMessage() != null && !((ValidationError)e.getErrors().get(0)).getMessage().equals(EMPTY_STRING)) {
                throw new ValidationException(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage(), new String[0]);
            }
            throw new ValidationException("Voucher creation failed", "Voucher creation failed", new String[0]);
        }
        catch (ApplicationRuntimeException e) {
            this.voucher();
            this.mode = EMPTY_STRING;
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            this.voucher();
            this.mode = EMPTY_STRING;
            if (e.getCause().getClass().equals(ValidationException.class)) {
                ValidationException s = (ValidationException)((Object)e);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", ((ValidationError)s.getErrors().get(0)).getMessage()));
                throw new ValidationException(errors);
            }
            LOGGER.error((Object)e.getMessage());
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            ValidationException s = (ValidationException)((Object)e);
            errors.add(new ValidationError("exception", ((ValidationError)s.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        this.getHeaderMandateFields();
        this.displayVoucherNumber = false;
        return "billview";
    }

    private void validateBillVoucherDate(EgBillregister egBillregister, CVoucherHeader voucherHeader) {
        AppConfig appConfigAccrossYears = this.appConfigService.getAppConfigByModuleNameAndKeyName(EGF, "allow_billsaccounting_across_years");
        AppConfig appConfigAccrossYearsEndDate = this.appConfigService.getAppConfigByModuleNameAndKeyName(EGF, "billsaccounting_accrossyears_enddate");
        try {
            if ("no".equalsIgnoreCase(((AppConfigValues)appConfigAccrossYears.getConfValues().get(0)).getValue()) && !this.financialYearDAO.isSameFinancialYear(egBillregister.getBilldate(), voucherHeader.getVoucherDate())) {
                throw new ValidationException("bill.accounting.year.check", "bill.accounting.year.check", new String[0]);
            }
            if ("yes".equalsIgnoreCase(((AppConfigValues)appConfigAccrossYears.getConfValues().get(0)).getValue()) && !appConfigAccrossYearsEndDate.getConfValues().isEmpty() && voucherHeader.getVoucherDate().after(this.df.parse(((AppConfigValues)appConfigAccrossYearsEndDate.getConfValues().get(0)).getValue()))) {
                throw new ValidationException("bill.accounting.voucherdate.enddate.check", this.getText("bill.accounting.voucherdate.enddate.check", new String[]{((AppConfigValues)appConfigAccrossYearsEndDate.getConfValues().get(0)).getValue()}), new String[0]);
            }
            if (egBillregister.getBilldate().after(voucherHeader.getVoucherDate())) {
                throw new ValidationException("bill.accounting.voucher.date.check", "bill.accounting.voucher.date.check", new String[0]);
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    @Action(value="/voucher/preApprovedVoucher-update")
    public String update() throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("voucher id=======" + ((String[])this.parameters.get(VHID))[0]));
        }
        this.methodName = "update";
        try {
            this.voucherHeader = (CVoucherHeader)this.voucherService.findById((Serializable)Long.valueOf(Long.parseLong(((String[])this.parameters.get(VHID))[0])), false);
            this.populateWorkflowBean();
            this.voucherHeader = this.preApprovedActionHelper.sendForApproval(this.voucherHeader, this.workflowBean);
            this.type = billsService.getBillTypeforVoucher(this.voucherHeader);
            if (null == this.type) {
                this.type = "default";
            }
            if ("Reject".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("pjv.voucher.rejected", new String[]{this.voucherService.getEmployeeNameForPositionId((Position)this.voucherHeader.getState().getOwnerPosition())}));
            }
            if (FORWARD.equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("pjv.voucher.approved", new String[]{this.voucherService.getEmployeeNameForPositionId((Position)this.voucherHeader.getState().getOwnerPosition())}));
            }
            if ("Cancel".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("billVoucher.file.canceled"));
            } else if ("Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("pjv.voucher.final.approval", new String[]{"The File has been approved"}));
            }
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return "message";
    }

    protected void populateWorkflowBean() {
        this.workflowBean.setApproverPositionId(this.approverPositionId);
        this.workflowBean.setApproverComments(this.approverComments);
        this.workflowBean.setWorkFlowAction(this.workFlowAction);
        this.workflowBean.setCurrentState(this.currentState);
    }

    public String saveAsWorkingCopy() throws ValidationException {
        this.methodName = "saveAsWorkingCopy";
        if (((String[])this.parameters.get(VHID))[0].equals(EMPTY_STRING)) {
            this.egBillregister = (EgBillregister)this.getPersistenceService().find(" from EgBillregister where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get(BILLID))[0])});
            boolean budgetcheck = this.voucherService.budgetaryCheck(this.egBillregister);
            if (budgetcheck) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("saveAsWorkingCopy===========" + this.billDetailslist + this.subLedgerlist));
                }
                Long vhid = this.billsAccountingService.createPreApprovedVoucherFromBillForPJV(Integer.valueOf(((String[])this.parameters.get(BILLID))[0]).intValue(), this.billDetailslist, this.subLedgerlist);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("voucher id=======" + vhid));
                }
                this.voucherHeader = (CVoucherHeader)this.getPersistenceService().find(VOUCHERQUERY, new Object[]{vhid});
                this.voucherHeader.transition().start().withOwner((OwnerGroup)this.getPosition());
                this.addActionMessage(this.getText("pjv.voucher.wc.created", new String[]{this.voucherHeader.getVoucherNumber()}));
            } else {
                this.addActionError(this.getText("pjv.budgetcheck.failed"));
            }
        } else {
            Long vhid = Long.valueOf(((String[])this.parameters.get(VHID))[0]);
            this.voucherHeader = (CVoucherHeader)this.getPersistenceService().find(VOUCHERQUERY, new Object[]{vhid});
            this.billsAccountingService.updatePJV(this.voucherHeader, this.billDetailslist, this.subLedgerlist);
            this.addActionMessage(this.getText("pjv.voucher.updated"));
        }
        return VOUCHEREDIT;
    }

    public void sendForApproval() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"PreApprovedVoucherAction | sendForApproval | Start");
        }
        if (this.voucherHeader.getId() == null) {
            this.voucherHeader = (CVoucherHeader)this.getPersistenceService().find(VOUCHERQUERY, new Object[]{Long.valueOf(((String[])this.parameters.get(VHID))[0])});
        }
        if (this.voucherHeader != null && this.voucherHeader.getState() != null && !this.validateOwner(this.voucherHeader.getState()).booleanValue()) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", "Invalid User"));
            throw new ValidationException(errors);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Voucherheader==" + this.voucherHeader.getId() + ", actionname=" + ((String[])this.parameters.get(ACTIONNAME))[0]));
        }
        Integer userId = null;
        userId = ((String[])this.parameters.get(ACTIONNAME))[0].contains("approve") ? Integer.valueOf(this.parameters.get("approverUserId") != null ? Integer.valueOf(((String[])this.parameters.get("approverUserId"))[0]).intValue() : ApplicationThreadLocals.getUserId().intValue()) : Integer.valueOf(this.voucherHeader.getCreatedBy().getId().intValue());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("User selected id is : " + userId));
        }
        this.voucherService.persist((Object)this.voucherHeader);
    }

    public String sendForApprovalForWC() throws ValidationException {
        this.methodName = "sendForApprovalForWC";
        this.sendForApproval();
        if (((String[])this.parameters.get(ACTIONNAME))[0].contains("approve")) {
            if ("END".equals(this.voucherHeader.getState().getValue())) {
                this.addActionMessage(this.getText("pjv.voucher.final.approval", new String[]{"The File has been approved"}));
            } else {
                this.addActionMessage(this.getText("pjv.voucher.approved", new String[]{this.voucherService.getEmployeeNameForPositionId((Position)this.voucherHeader.getState().getOwnerPosition())}));
            }
        } else {
            this.addActionMessage(this.getText("pjv.voucher.rejected", new String[]{this.voucherService.getEmployeeNameForPositionId((Position)this.voucherHeader.getState().getOwnerPosition())}));
        }
        return "message";
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public List<EgBillregister> getPreApprovedVoucherList() {
        return this.preApprovedVoucherList;
    }

    public void validate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"validate==============");
        }
    }

    public void setEgBillregister(EgBillregister egBillregister) {
        this.egBillregister = egBillregister;
    }

    public Department getCurrentDepartment() {
        return this.voucherService.getCurrentDepartment();
    }

    public String getMasterName(String name) {
        String val = EMPTY_STRING;
        if (this.voucherHeader != null) {
            if (name.equals("fund") && this.voucherHeader.getFundId() != null) {
                val = this.voucherHeader.getFundId().getName();
            } else if (name.equals("fundsource") && this.voucherHeader.getVouchermis().getFundsource() != null) {
                val = this.voucherHeader.getVouchermis().getFundsource().getName();
            } else if (name.equals("department") && this.voucherHeader.getVouchermis().getDepartmentid() != null) {
                val = this.voucherHeader.getVouchermis().getDepartmentid().getName();
            } else if (name.equals("scheme") && this.voucherHeader.getVouchermis().getSchemeid() != null) {
                val = this.voucherHeader.getVouchermis().getSchemeid().getName();
            } else if (name.equals("subscheme") && this.voucherHeader.getVouchermis().getSubschemeid() != null) {
                val = this.voucherHeader.getVouchermis().getSubschemeid().getName();
            } else if (name.equals("field") && this.voucherHeader.getVouchermis().getDivisionid() != null) {
                val = this.voucherHeader.getVouchermis().getDivisionid().getName();
            } else if (name.equals("functionary") && this.voucherHeader.getVouchermis().getFunctionary() != null) {
                val = this.voucherHeader.getVouchermis().getFunctionary().getName();
            } else if ("narration".equals(name)) {
                val = this.voucherHeader.getDescription();
            } else if ("billnumber".equals(name)) {
                val = ((EgBillregister)this.getPersistenceService().find(" from EgBillregister br where br.egBillregistermis.voucherHeader=?", new Object[]{this.voucherHeader})).getBillnumber();
            }
        } else if (name.equals("fund") && this.egBillregister.getEgBillregistermis().getFund() != null) {
            val = this.egBillregister.getEgBillregistermis().getFund().getName();
        } else if (name.equals("fundsource") && this.egBillregister.getEgBillregistermis().getFundsource() != null) {
            val = this.egBillregister.getEgBillregistermis().getFundsource().getName();
        } else if (name.equals("department") && this.egBillregister.getEgBillregistermis().getEgDepartment() != null) {
            val = this.egBillregister.getEgBillregistermis().getEgDepartment().getName();
        } else if (name.equals("scheme") && this.egBillregister.getEgBillregistermis().getScheme() != null) {
            val = this.egBillregister.getEgBillregistermis().getScheme().getName();
        } else if (name.equals("subscheme") && this.egBillregister.getEgBillregistermis().getSubScheme() != null) {
            val = this.egBillregister.getEgBillregistermis().getSubScheme().getName();
        } else if (name.equals("field") && this.egBillregister.getEgBillregistermis().getFieldid() != null) {
            val = this.egBillregister.getEgBillregistermis().getFieldid().getName();
        } else if (name.equals("functionary") && this.egBillregister.getEgBillregistermis().getFunctionaryid() != null) {
            val = this.egBillregister.getEgBillregistermis().getFunctionaryid().getName();
        } else if ("narration".equals(name)) {
            val = this.egBillregister.getEgBillregistermis().getNarration();
        } else if ("billnumber".equals(name)) {
            val = this.egBillregister.getBillnumber();
        }
        return val;
    }

    public String getSourcePath() {
        String sourcePath = this.voucherHeader != null && this.voucherHeader.getGeneralledger() != null && this.voucherHeader.getGeneralledger().size() > 0 ? this.voucherHeader.getVouchermis().getSourcePath() : this.egBillregister.getEgBillregistermis().getSourcePath();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Source Path = " + sourcePath));
        }
        return sourcePath;
    }

    public Map<String, Object> getMasterName() throws ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"getmastername===============");
        }
        HashMap<String, Object> names = new HashMap<String, Object>();
        List gllist = this.getPersistenceService().findAllBy(" from CGeneralLedger where voucherHeaderId.id=? order by voucherlineId", new Object[]{Long.valueOf(this.voucherHeader.getId() + EMPTY_STRING)});
        Map<String, BigDecimal> temp = null;
        ArrayList<Map<String, BigDecimal>> tempList = new ArrayList<Map<String, BigDecimal>>();
        for (CGeneralLedger gl : gllist) {
            List gldetailList;
            if (gl.getFunctionId() != null) {
                names.put(gl.getGlcodeId().getGlcode(), ((CFunction)this.getPersistenceService().find(" from CFunction where id=?", new Object[]{(long)gl.getFunctionId().intValue()})).getName());
            }
            if ((gldetailList = this.getPersistenceService().findAllBy("from CGeneralLedgerDetail where generalLedgerId.id=?", new Object[]{gl.getId()})) == null || gldetailList.isEmpty()) continue;
            for (CGeneralLedgerDetail gldetail : gldetailList) {
                if (this.chartOfAccountDetailService.getByGlcodeIdAndDetailTypeId(gl.getGlcodeId().getId(), gldetail.getDetailTypeId().getId()) == null) continue;
                temp = new HashMap();
                temp = this.getAccountDetails(gldetail.getDetailTypeId().getId(), gldetail.getDetailKeyId(), temp);
                temp.put("glcode", (BigDecimal)((Object)gl.getGlcode()));
                temp.put("amount", gldetail.getAmount());
                tempList.add(temp);
            }
            names.put("tempList", tempList);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("voucher details ==" + names));
        }
        return names;
    }

    public void getMasterDataForBill() throws ApplicationException {
        this.billDetails = new HashMap();
        CChartOfAccounts coa = null;
        HashMap<String, Object> temp = null;
        Map<String, Integer> payeeMap = null;
        ArrayList tempList = new ArrayList();
        ArrayList<Map<String, Integer>> payeeList = new ArrayList<Map<String, Integer>>();
        List egBillDetails = this.persistenceService.findAllBy("from EgBilldetails where  egBillregister.id=? ", new Object[]{this.egBillregister.getId()});
        for (EgBilldetails billdetails : egBillDetails) {
            temp = new HashMap<String, Object>();
            if (billdetails.getFunctionid() != null) {
                temp.put("function", ((CFunction)this.getPersistenceService().find("from CFunction where id=?", new Object[]{Long.valueOf(billdetails.getFunctionid() + EMPTY_STRING)})).getName());
            }
            coa = (CChartOfAccounts)this.getPersistenceService().find("from CChartOfAccounts where id=?", new Object[]{Long.valueOf(billdetails.getGlcodeid() + EMPTY_STRING)});
            temp.put("glcode", coa.getGlcode());
            temp.put("accounthead", coa.getName());
            temp.put("debitamount", billdetails.getDebitamount() == null ? Integer.valueOf(0) : billdetails.getDebitamount());
            temp.put("creditamount", billdetails.getCreditamount() == null ? Integer.valueOf(0) : billdetails.getCreditamount());
            temp.put("billdetailid", billdetails.getId());
            tempList.add(temp);
            for (EgBillPayeedetails payeeDetails : billdetails.getEgBillPaydetailes()) {
                payeeMap = new HashMap();
                if (this.chartOfAccountDetailService.getByGlcodeIdAndDetailTypeId(Long.valueOf(payeeDetails.getEgBilldetailsId().getGlcodeid().longValue()), Integer.valueOf(payeeDetails.getAccountDetailTypeId())) == null) continue;
                payeeMap = this.getAccountDetails(payeeDetails.getAccountDetailTypeId(), payeeDetails.getAccountDetailKeyId(), payeeMap);
                payeeMap.put("glcode", (Integer)((Object)coa.getGlcode()));
                payeeMap.put("debitamount", (Integer)(payeeDetails.getDebitAmount() == null ? Integer.valueOf(0) : payeeDetails.getDebitAmount()));
                payeeMap.put("creditamount", (Integer)(payeeDetails.getCreditAmount() == null ? Integer.valueOf(0) : payeeDetails.getCreditAmount()));
                payeeList.add(payeeMap);
            }
        }
        this.billDetails.put("tempList", tempList);
        this.billDetails.put("payeeList", payeeList);
    }

    public void getMasterDataForBillVoucher() throws ApplicationException {
        this.billDetails = new HashMap();
        CChartOfAccounts coa = null;
        HashMap<String, Object> temp = null;
        Map payeeMap = null;
        ArrayList tempList = new ArrayList();
        ArrayList<PreApprovedVoucher> payeeList = new ArrayList<PreApprovedVoucher>();
        ArrayList<Long> glcodeIdList = new ArrayList<Long>();
        ArrayList<Accountdetailtype> detailtypeIdList = new ArrayList<Accountdetailtype>();
        PreApprovedVoucher subledger = null;
        if (this.voucherHeader != null) {
            List gllist = this.getPersistenceService().findAllBy(" from CGeneralLedger where voucherHeaderId.id=? order by id asc", new Object[]{Long.valueOf(this.voucherHeader.getId() + EMPTY_STRING)});
            for (CGeneralLedger gl : gllist) {
                temp = new HashMap();
                if (gl.getFunctionId() != null) {
                    temp.put("function", ((CFunction)this.getPersistenceService().find("from CFunction where id=?", new Object[]{(long)gl.getFunctionId().intValue()})).getName());
                    temp.put("functionid", gl.getFunctionId());
                }
                coa = (CChartOfAccounts)this.getPersistenceService().find("from CChartOfAccounts where glcode=?", new Object[]{gl.getGlcode()});
                temp.put("glcodeid", coa.getId());
                glcodeIdList.add(coa.getId());
                temp.put("glcode", coa.getGlcode());
                temp.put("accounthead", coa.getName());
                temp.put("debitamount", gl.getDebitAmount() == null ? 0.0 : gl.getDebitAmount());
                temp.put("creditamount", gl.getCreditAmount() == null ? 0.0 : gl.getCreditAmount());
                temp.put("billdetailid", gl.getId());
                tempList.add(temp);
                for (CGeneralLedgerDetail gldetail : gl.getGeneralLedgerDetails()) {
                    if (this.chartOfAccountDetailService.getByGlcodeIdAndDetailTypeId(gl.getGlcodeId().getId(), Integer.valueOf(gldetail.getDetailTypeId().getId())) == null) continue;
                    subledger = new PreApprovedVoucher();
                    subledger.setGlcode(coa);
                    Accountdetailtype detailtype = (Accountdetailtype)this.getPersistenceService().find(ACCDETAILTYPEQUERY, new Object[]{gldetail.getDetailTypeId().getId()});
                    detailtypeIdList.add(detailtype);
                    subledger.setDetailType(detailtype);
                    payeeMap = new HashMap();
                    payeeMap = this.getAccountDetails(gldetail.getDetailTypeId().getId(), gldetail.getDetailKeyId(), payeeMap);
                    subledger.setDetailKey(payeeMap.get("detailkey") + EMPTY_STRING);
                    if ((payeeMap.get("detailkey") + EMPTY_STRING).contains("This Entity Missing(Deleted) in Masters *")) {
                        this.addActionError("Loaded with Errors refer the * ");
                    }
                    subledger.setDetailCode(payeeMap.get("detailcode") + EMPTY_STRING);
                    subledger.setDetailKeyId(gldetail.getDetailKeyId());
                    subledger.setAmount(gldetail.getAmount());
                    subledger.setFunctionDetail(temp.get("function") != null ? temp.get("function").toString() : EMPTY_STRING);
                    if (gl.getDebitAmount() == null || gl.getDebitAmount() == 0.0) {
                        subledger.setDebitAmount(BigDecimal.ZERO);
                        subledger.setCreditAmount(gldetail.getAmount());
                    } else {
                        subledger.setDebitAmount(gldetail.getAmount());
                        subledger.setCreditAmount(BigDecimal.ZERO);
                    }
                    payeeList.add(subledger);
                }
            }
        } else {
            for (EgBilldetails billdetails : this.egBillregister.getEgBilldetailes()) {
                temp = new HashMap<String, Object>();
                if (billdetails.getFunctionid() != null) {
                    temp.put("function", ((CFunction)this.getPersistenceService().find("from CFunction where id=?", new Object[]{Long.valueOf(billdetails.getFunctionid() + EMPTY_STRING)})).getName());
                    temp.put("functionid", billdetails.getFunctionid());
                }
                coa = (CChartOfAccounts)this.getPersistenceService().find("from CChartOfAccounts where id=?", new Object[]{Long.valueOf(billdetails.getGlcodeid() + EMPTY_STRING)});
                temp.put("glcodeid", coa.getId());
                glcodeIdList.add(coa.getId());
                temp.put("glcode", coa.getGlcode());
                temp.put("accounthead", coa.getName());
                temp.put("debitamount", billdetails.getDebitamount() == null ? Integer.valueOf(0) : billdetails.getDebitamount());
                temp.put("creditamount", billdetails.getCreditamount() == null ? Integer.valueOf(0) : billdetails.getCreditamount());
                temp.put("billdetailid", billdetails.getId());
                tempList.add(temp);
                for (EgBillPayeedetails payeeDetails : billdetails.getEgBillPaydetailes()) {
                    if (this.chartOfAccountDetailService.getByGlcodeIdAndDetailTypeId(Long.valueOf(payeeDetails.getEgBilldetailsId().getGlcodeid().longValue()), Integer.valueOf(payeeDetails.getAccountDetailTypeId())) == null) continue;
                    subledger = new PreApprovedVoucher();
                    subledger.setGlcode(coa);
                    Accountdetailtype detailtype = (Accountdetailtype)this.getPersistenceService().find(ACCDETAILTYPEQUERY, new Object[]{payeeDetails.getAccountDetailTypeId()});
                    detailtypeIdList.add(detailtype);
                    subledger.setDetailType(detailtype);
                    payeeMap = new HashMap();
                    payeeMap = this.getAccountDetails(payeeDetails.getAccountDetailTypeId(), payeeDetails.getAccountDetailKeyId(), payeeMap);
                    subledger.setDetailKey(payeeMap.get("detailkey") + EMPTY_STRING);
                    subledger.setDetailCode(payeeMap.get("detailcode") + EMPTY_STRING);
                    subledger.setDetailKeyId(payeeDetails.getAccountDetailKeyId());
                    if (payeeDetails.getDebitAmount() == null) {
                        subledger.setDebitAmount(BigDecimal.ZERO);
                        subledger.setCreditAmount(payeeDetails.getCreditAmount());
                    } else {
                        subledger.setDebitAmount(payeeDetails.getDebitAmount());
                        subledger.setCreditAmount(BigDecimal.ZERO);
                    }
                    payeeList.add(subledger);
                }
            }
        }
        this.billDetails.put("tempList", tempList);
        this.billDetails.put("subLedgerlist", payeeList);
        this.setupDropDownForSL(glcodeIdList);
        this.setupDropDownForSLDetailtype(detailtypeIdList);
    }

    public Map<String, Object> getAccountDetails(Integer detailtypeid, Integer detailkeyid, Map<String, Object> tempMap) throws ApplicationException {
        Accountdetailtype detailtype = (Accountdetailtype)this.getPersistenceService().find(ACCDETAILTYPEQUERY, new Object[]{detailtypeid});
        tempMap.put("detailtype", detailtype.getDescription());
        tempMap.put("detailtypeid", detailtype.getId());
        tempMap.put("detailkeyid", detailkeyid);
        this.egovCommon.setPersistenceService(this.persistenceService);
        EntityType entityType = this.egovCommon.getEntityType(detailtype, (Serializable)detailkeyid);
        if (entityType == null) {
            tempMap.put("detailkey", detailkeyid + " " + "This Entity Missing(Deleted) in Masters *");
            tempMap.put("detailcode", "This Entity Missing(Deleted) in Masters *");
        } else {
            tempMap.put("detailkey", entityType.getName());
            tempMap.put("detailcode", entityType.getCode());
        }
        return tempMap;
    }

    public void setupDropDownForSL(List<Long> glcodeIdList) {
        List glcodeList = null;
        Query glcodeListQuery = this.persistenceService.getSession().createQuery(" from CChartOfAccounts where id in (select glCodeId from CChartOfAccountDetail) and id in  ( :IDS )");
        glcodeListQuery.setParameterList("IDS", glcodeIdList);
        glcodeList = glcodeListQuery.list();
        if (glcodeIdList.isEmpty()) {
            this.dropdownData.put("glcodeList", Collections.EMPTY_LIST);
        } else {
            this.dropdownData.put("glcodeList", glcodeList);
        }
    }

    public void setupDropDownForSLDetailtype(List<Accountdetailtype> detailtypeIdList) {
        this.dropdownData.put("detailTypeList", detailtypeIdList);
    }

    public EgBillregister getEgBillregister() {
        return this.egBillregister;
    }

    protected void getHeaderMandateFields() {
        List appConfigList = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "DEFAULTTXNMISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf("|"));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf("|") + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            this.mandatoryFields.add(header);
        }
    }

    public boolean shouldShowHeaderField(String field) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside shouldShowHeaderField menthod");
        }
        if ("vouchernumber".equals(field)) {
            String vNumGenMode = "Manual";
            vNumGenMode = this.voucherTypeForULB.readVoucherTypes("Journal");
            if (!"Auto".equalsIgnoreCase(vNumGenMode)) {
                this.mandatoryFields.add("vouchernumber");
                return true;
            }
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Header field contains = " + this.headerFields.contains(field)));
        }
        return this.headerFields.contains(field);
    }

    public boolean isFieldMandatory(String field) {
        return this.mandatoryFields.contains(field);
    }

    public Position getPosition() throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getPosition====" + ApplicationThreadLocals.getUserId()));
        }
        Position pos = this.eisCommonService.getPositionByUserId(ApplicationThreadLocals.getUserId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("position===" + pos.getId()));
        }
        return pos;
    }

    public String ajaxValidateDetailCode() {
        String code = ((String[])this.parameters.get("code"))[0];
        String index = ((String[])this.parameters.get("index"))[0];
        Accountdetailtype adt = (Accountdetailtype)this.getPersistenceService().find(ACCDETAILTYPEQUERY, new Object[]{Integer.valueOf(((String[])this.parameters.get("detailtypeid"))[0])});
        if (adt == null) {
            this.values = index + "~" + ERROR;
            return "result";
        }
        if (adt.getTablename().equalsIgnoreCase("EG_EMPLOYEE")) {
            PersonalInformation information = (PersonalInformation)this.getPersistenceService().find(" from PersonalInformation where employeeCode=? and isActive=true", new Object[]{code});
            this.values = information == null ? index + "~" + ERROR : index + "~" + information.getIdPersonalInformation() + "~" + information.getEmployeeFirstName();
        } else if (adt.getTablename().equalsIgnoreCase("RELATION")) {
            Relation relation = (Relation)this.getPersistenceService().find(" from Relation where code=? and isactive=true", new Object[]{code});
            this.values = relation == null ? index + "~" + ERROR : index + "~" + relation.getId() + "~" + relation.getName();
        } else if (adt.getTablename().equalsIgnoreCase("ACCOUNTENTITYMASTER")) {
            AccountEntity accountEntity = (AccountEntity)this.getPersistenceService().find(" from AccountEntity where code=? and isactive=true ", new Object[]{code});
            this.values = accountEntity == null ? index + "~" + ERROR : index + "~" + accountEntity.getId() + "~" + accountEntity.getCode();
        }
        return "result";
    }

    protected Boolean validateOwner(State state) {
        Boolean check = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("validating owner for user " + ApplicationThreadLocals.getUserId()));
        }
        List positionsForUser = null;
        positionsForUser = this.eisService.getPositionsForUser(ApplicationThreadLocals.getUserId(), new Date());
        for (Position pos : positionsForUser) {
            if (!pos.getId().equals(state.getOwnerPosition().getId())) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Valid Owner :return true");
            }
            check = true;
        }
        return check;
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public void setVoucherWorkflowService(SimpleWorkflowService<CVoucherHeader> voucherWorkflowService) {
        this.voucherWorkflowService = voucherWorkflowService;
    }

    public CVoucherHeader getVoucherHeader() {
        return this.voucherHeader;
    }

    public void setVoucherHeader(CVoucherHeader voucherHeader) {
        this.voucherHeader = voucherHeader;
    }

    public void setBillsAccountingService(BillsAccountingService mngr) {
        this.billsAccountingService = mngr;
    }

    public List<PreApprovedVoucher> getSubLedgerlist() {
        return this.subLedgerlist;
    }

    public void setSubLedgerlist(List<PreApprovedVoucher> subLedgerlist) {
        this.subLedgerlist = subLedgerlist;
    }

    public List<PreApprovedVoucher> getBillDetailslist() {
        return this.billDetailslist;
    }

    public void setBillDetailslist(List<PreApprovedVoucher> billDetailslist) {
        this.billDetailslist = billDetailslist;
    }

    public String getValues() {
        return this.values;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<String> getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(List<String> headerFields) {
        this.headerFields = headerFields;
    }

    public List<String> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public void setMandatoryFields(List<String> mandatoryFields) {
        this.mandatoryFields = mandatoryFields;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public ContraJournalVoucher getContraVoucher() {
        return this.contraVoucher;
    }

    public void setContraVoucher(ContraJournalVoucher contraVoucher) {
        this.contraVoucher = contraVoucher;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Map<String, Object> getBillDetails() {
        return this.billDetails;
    }

    public void setBillDetails(Map<String, Object> billDetails) {
        this.billDetails = billDetails;
    }

    public String getFinConstExpendTypeContingency() {
        return "Expense";
    }

    public VoucherHelper getVoucherHelper() {
        return this.voucherHelper;
    }

    public void setVoucherHelper(VoucherHelper voucherHelper) {
        this.voucherHelper = voucherHelper;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public Boolean getDisplayVoucherNumber() {
        return this.displayVoucherNumber;
    }

    public void setDisplayVoucherNumber(Boolean displayVoucherNumber) {
        this.displayVoucherNumber = displayVoucherNumber;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public JournalVoucherModifyAction getJournalvouchermodify() {
        return this.journalvouchermodify;
    }

    public void setJournalvouchermodify(JournalVoucherModifyAction journalvouchermodify) {
        this.journalvouchermodify = journalvouchermodify;
    }

    public void setContraWorkflowService(SimpleWorkflowService<ContraJournalVoucher> contraWorkflowService) {
        this.contraWorkflowService = contraWorkflowService;
    }

    public PreApprovedVoucherAction() {
        try {
            this.addRelatedEntity("glcode", CChartOfAccounts.class);
            this.addRelatedEntity("detailType", Accountdetailtype.class);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception in PreApprovedVoucher", (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    public boolean isShowVoucherDate() {
        return this.showVoucherDate;
    }

    public void setShowVoucherDate(boolean showVoucherDate) {
        this.showVoucherDate = showVoucherDate;
    }

    public FinancialYearHibernateDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public static BillsService getBillsService() {
        return billsService;
    }

    public static void setBillsService(BillsService billsService) {
        PreApprovedVoucherAction.billsService = billsService;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Long getVoucherId() {
        return this.voucherId;
    }

    public void setVoucherId(Long voucherId) {
        this.voucherId = voucherId;
    }

    public EgBillregister getBillRegister() {
        return this.billRegister;
    }

    public void setBillRegister(EgBillregister billRegister) {
        this.billRegister = billRegister;
    }

    public String getCutOffDate() {
        return this.cutOffDate;
    }

    public void setCutOffDate(String cutOffDate) {
        this.cutOffDate = cutOffDate;
    }

    static {
        LOGGER = Logger.getLogger(PreApprovedVoucherAction.class);
    }
}

