/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.voucher;

import com.exilant.eGov.src.domain.BillRegisterBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.EgwStatus;
import org.egov.commons.Fund;
import org.egov.egf.web.actions.voucher.CancelBillAndVoucher;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.bills.EgBillregister;
import org.egov.services.bills.BillsService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Results(value={@Result(name={"search"}, location="cancelBill-search.jsp")})
public class CancelBillAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CancelBillAction.class);
    @Autowired
    private BillsService billsService;
    private String billNumber;
    private String fromDate;
    private String toDate;
    private Fund fund = new Fund();
    private Department deptImpl = new Department();
    private String expType;
    private List<BillRegisterBean> billListDisplay = new ArrayList();
    private boolean afterSearch = false;
    Integer loggedInUser = ApplicationThreadLocals.getUserId().intValue();
    public final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private CancelBillAndVoucher cancelBillAndVoucher;

    public Object getModel() {
        return null;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setFromDate(String fromBillDate) {
        this.fromDate = fromBillDate;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setToDate(String toBillDate) {
        this.toDate = toBillDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setExpType(String expType) {
        this.expType = expType;
    }

    public String getExpType() {
        return this.expType;
    }

    public void prepare() {
        super.prepare();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Prepare method");
        }
        this.dropdownData.put("DepartmentList", this.masterDataCache.get("egi-department"));
        this.addDropdownData("fundList", this.persistenceService.findAllBy("from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
        this.addDropdownData("expenditureList", this.persistenceService.findAllBy("select distinct bill.expendituretype from EgBillregister bill where bill.expendituretype like 'Expense'   order by bill.expendituretype", new Object[0]));
    }

    public void prepareBeforeSearch() {
        this.fund.setId(null);
        this.billNumber = "";
        this.fromDate = "";
        this.toDate = "";
        this.expType = "";
        this.billListDisplay.clear();
    }

    @SkipValidation
    @Action(value="/voucher/cancelBill-beforeSearch")
    public String beforeSearch() {
        return "search";
    }

    public StringBuilder filterQuery() {
        String userCond = " where ";
        StringBuilder query = new StringBuilder(" select billmis.egBillregister.id, billmis.egBillregister.billnumber, billmis.egBillregister.billdate, billmis.egBillregister.billamount, billmis.egDepartment.name  from EgBillregistermis billmis ");
        query.append(" where ");
        if (this.fund != null && this.fund.getId() != null && this.fund.getId() != -1 && this.fund.getId() != 0) {
            query.append(" billmis.fund.id=" + this.fund.getId());
        }
        if (this.billNumber != null && this.billNumber.length() != 0) {
            query.append(" and billmis.egBillregister.billnumber ='" + this.billNumber + "'");
        }
        if (this.deptImpl != null && this.deptImpl.getId() != null && this.deptImpl.getId() != -1L && this.deptImpl.getId() != 0L) {
            query.append(" and billmis.egDepartment.id ='" + this.deptImpl.getId() + "'");
        }
        if (this.fromDate != null && this.fromDate.length() != 0) {
            try {
                Date fDate = this.formatter.parse(this.fromDate);
                query.append(" and billmis.egBillregister.billdate >= '" + Constants.DDMMYYYYFORMAT1.format(fDate) + "'");
            }
            catch (ParseException e) {
                LOGGER.error((Object)" From Date parse error");
            }
        }
        if (this.toDate != null && this.toDate.length() != 0) {
            try {
                Date tDate = this.formatter.parse(this.toDate);
                query.append(" and billmis.egBillregister.billdate <= '" + Constants.DDMMYYYYFORMAT1.format(tDate) + "'");
            }
            catch (ParseException e) {
                LOGGER.error((Object)" To Date parse error");
            }
        }
        if (this.expType == null || this.expType.equalsIgnoreCase("")) {
            query.append(" and billmis.egBillregister.expendituretype ='Expense'");
            query.append(" and billmis.egBillregister.status.moduletype='EXPENSEBILL' and billmis.egBillregister.status.description='Approved'");
        } else {
            query.append(" and billmis.egBillregister.expendituretype ='" + this.expType + "'");
            if ("Salary".equalsIgnoreCase(this.expType)) {
                query.append(" and billmis.egBillregister.status.moduletype='SALBILL' and billmis.egBillregister.status.description='Approved'");
            } else if ("Expense".equalsIgnoreCase(this.expType)) {
                query.append(" and billmis.egBillregister.status.moduletype='EXPENSEBILL' and billmis.egBillregister.status.description='Approved'");
            } else if ("Purchase".equalsIgnoreCase(this.expType)) {
                query.append(" and billmis.egBillregister.status.moduletype='PURCHBILL' and billmis.egBillregister.status.description='Passed'");
            } else if ("Works".equalsIgnoreCase(this.expType)) {
                query.append(" and billmis.egBillregister.status.moduletype='WORKSBILL' and billmis.egBillregister.status.description='Passed'");
            }
        }
        return query;
    }

    public String[] query() {
        String[] retQry = new String[2];
        StringBuilder filterQry = this.filterQuery();
        retQry[0] = filterQry + " and billmis.voucherHeader is null ";
        retQry[1] = filterQry + " and billmis.voucherHeader.status in (" + FinancialConstants.REVERSEDVOUCHERSTATUS + "," + FinancialConstants.CANCELLEDVOUCHERSTATUS + ") ";
        return retQry;
    }

    public void prepareSearch() {
        this.billListDisplay.clear();
    }

    public void validateFund() {
        if (this.fund == null || this.fund.getId() == -1) {
            this.addFieldError("fund.id", this.getText("voucher.fund.mandatory"));
        }
    }

    @ValidationErrorPage(value="search")
    @Action(value="/voucher/cancelBill-search")
    public String search() {
        this.validateFund();
        if (!this.hasFieldErrors()) {
            this.billListDisplay.clear();
            String[] searchQuery = this.query();
            ArrayList tempBillList = new ArrayList();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Search Query - " + searchQuery));
            }
            List billListWithNoVouchers = this.persistenceService.findAllBy(searchQuery[0], new Object[0]);
            List billListWithCancelledReversedVouchers = this.persistenceService.findAllBy(searchQuery[1], new Object[0]);
            tempBillList.addAll(billListWithNoVouchers);
            tempBillList.addAll(billListWithCancelledReversedVouchers);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Size of tempBillList - " + tempBillList.size()));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            for (Object[] bill : tempBillList) {
                BillRegisterBean billRegstrBean = new BillRegisterBean();
                billRegstrBean.setId(bill[0].toString());
                billRegstrBean.setBillNumber(bill[1].toString());
                if (!bill[2].toString().equalsIgnoreCase("")) {
                    billRegstrBean.setBillDate(sdf.format(bill[2]));
                }
                billRegstrBean.setBillAmount(Double.parseDouble(bill[3].toString()));
                billRegstrBean.setBillDeptName(bill[4].toString());
                this.billListDisplay.add(billRegstrBean);
            }
            this.afterSearch = true;
        }
        return "search";
    }

    @Action(value="/voucher/cancelBill-cancelBill")
    public String cancelBill() {
        new Date();
        Long[] idList = new Long[this.billListDisplay.size()];
        int i = 0;
        int idListLength = 0;
        String idString = "";
        StringBuilder statusQuery = new StringBuilder("from EgwStatus where ");
        StringBuilder cancelQuery = new StringBuilder("Update eg_billregister set ");
        for (BillRegisterBean billRgistrBean : this.billListDisplay) {
            if (!billRgistrBean.getIsSelected()) continue;
            idList[i++] = Long.parseLong(billRgistrBean.getId());
            ++idListLength;
        }
        if (this.expType == null || this.expType.equalsIgnoreCase("")) {
            statusQuery.append("moduletype='EXPENSEBILL' and description='Cancelled'");
            cancelQuery.append(" billstatus='Cancelled' , statusid=:statusId ");
        } else if ("Salary".equalsIgnoreCase(this.expType)) {
            statusQuery.append("moduletype='SALBILL' and description='Cancelled'");
            cancelQuery.append(" billstatus='Cancelled' , statusid=:statusId ");
        } else if ("Expense".equalsIgnoreCase(this.expType)) {
            statusQuery.append("moduletype='EXPENSEBILL' and description='Cancelled'");
            cancelQuery.append(" billstatus='Cancelled' , statusid=:statusId ");
        } else if ("Purchase".equalsIgnoreCase(this.expType)) {
            statusQuery.append("moduletype='PURCHBILL' and description='Cancelled'");
            cancelQuery.append(" billstatus='Cancelled' , statusid=:statusId ");
        } else if ("Works".equalsIgnoreCase(this.expType)) {
            statusQuery.append("moduletype='WORKSBILL' and description='Cancelled'");
            cancelQuery.append(" billstatus='Cancelled' , statusid=:statusId ");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(" Status Query - " + statusQuery.toString()));
        }
        EgwStatus status = (EgwStatus)this.persistenceService.find(statusQuery.toString());
        this.persistenceService.getSession();
        if (idListLength != 0) {
            for (i = 0; i < idListLength; ++i) {
                EgBillregister billRegister = this.billsService.getBillRegisterById(Integer.valueOf(idList[i].intValue()));
                boolean value = this.cancelBillAndVoucher.canCancelBill(billRegister);
                if (!value) {
                    this.addActionMessage(this.getText("cancel.bill.failure", new String[]{billRegister.getBillnumber()}));
                    continue;
                }
                idString = idString + idList[i] + (i == idListLength - 1 ? "" : ",");
            }
            if (StringUtils.isNotBlank((CharSequence)idString) && idString.charAt(idString.length() - 1) == ',') {
                idString = idString.replace(",", "");
            }
            cancelQuery.append(" where id in (" + idString + ")");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(" Cancel Query - " + cancelQuery.toString()));
            }
            SQLQuery totalSQLQuery = this.persistenceService.getSession().createSQLQuery(cancelQuery.toString());
            totalSQLQuery.setLong("statusId", (long)status.getId().intValue());
            if (StringUtils.isNotBlank((CharSequence)idString)) {
                totalSQLQuery.executeUpdate();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)idString)) {
            this.addActionMessage(this.getText("cancel.bill.success"));
        }
        this.prepareBeforeSearch();
        return "search";
    }

    public void setBillListDisplay(List<BillRegisterBean> billListDisplay) {
        this.billListDisplay = billListDisplay;
    }

    public List<BillRegisterBean> getBillListDisplay() {
        return this.billListDisplay;
    }

    public void setAfterSearch(boolean afterSearch) {
        this.afterSearch = afterSearch;
    }

    public boolean getAfterSearch() {
        return this.afterSearch;
    }

    public Department getDeptImpl() {
        return this.deptImpl;
    }

    public void setDeptImpl(Department deptImpl) {
        this.deptImpl = deptImpl;
    }

    public Integer getLoggedInUser() {
        return this.loggedInUser;
    }

    public void setLoggedInUser(Integer loggedInUser) {
        this.loggedInUser = loggedInUser;
    }
}

