/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.voucher.VoucherReport;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberToWordConverter;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.model.payment.Paymentheader;
import org.egov.pims.commons.Position;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"print"}, location="billPaymentVoucherPrint-print.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BankPaymentVoucherReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BankPaymentVoucherReport.xls"}), @Result(name={"HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
@ParentPackage(value="egov")
public class BillPaymentVoucherPrintAction
extends BaseFormAction {
    public static final String PRINT = "print";
    private static final long serialVersionUID = 1L;
    private static final String ACCDETAILTYPEQUERY = " from Accountdetailtype where id=?";
    private static final String JASPERPATH = "/reports/templates/billPaymentVoucherReport.jasper";
    private static final String MULTIPLE = "MULTIPLE";
    private String chequeNumber = "";
    private transient InstrumentHeader instrumentHeader = null;
    private String cashModePartyName = "";
    private String chequeDate = "";
    private String rtgsRefNo = "";
    private String rtgsDate = "";
    private String paymentMode = "";
    private transient CVoucherHeader voucher = new CVoucherHeader();
    private transient Paymentheader paymentHeader = new Paymentheader();
    private transient List<Object> voucherReportList = new ArrayList();
    private transient InputStream inputStream;
    private transient ReportHelper reportHelper;
    private Long id;
    private transient List<Miscbilldetail> miscBillDetailList;
    private String bankName = "";
    private String bankAccountNumber = "";
    private transient ArrayList<Long> chequeNoList = new ArrayList();
    private transient ArrayList<String> chequeNosList = new ArrayList();
    @Autowired
    private transient EgovCommon egovCommon;

    public Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bpvNumber", this.getVoucherNumber());
        paramMap.put("voucherDate", this.getVoucherDate());
        paramMap.put("bankName", this.bankName);
        paramMap.put("bankAccountNumber", this.bankAccountNumber);
        if (this.paymentHeader != null && this.paymentHeader.getState() != null) {
            this.loadInboxHistoryData(this.paymentHeader.getStateHistory(), paramMap);
        }
        if (this.miscBillDetailList != null) {
            paramMap.put("partyName", this.getPartyName());
            paramMap.put("billNumber", this.getBillNumber());
            paramMap.put("linkNo", this.getLinkNo());
        }
        paramMap.put("amountInWords", this.getAmountInWords());
        paramMap.put("chequeNumber", this.chequeNumber);
        paramMap.put("chequeDate", this.chequeDate);
        paramMap.put("rtgsRefNo", this.rtgsRefNo);
        paramMap.put("paymentMode", this.paymentMode);
        paramMap.put("rtgsDate", this.rtgsDate);
        paramMap.put("ulbName", ReportUtil.getCityName());
        paramMap.put("narration", this.getPaymentNarration());
        return paramMap;
    }

    private String getLinkNo() {
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() > 1) {
            return MULTIPLE;
        }
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() == 1 && ((Miscbilldetail)this.miscBillDetailList.get(0)).getBillVoucherHeader() != null) {
            return ((Miscbilldetail)this.miscBillDetailList.get(0)).getBillVoucherHeader().getVoucherNumber();
        }
        return "";
    }

    private String getAmountInWords() {
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() > 1) {
            Float totalAmt = Float.valueOf(0.0f);
            for (Miscbilldetail misBillDet : this.miscBillDetailList) {
                totalAmt = Float.valueOf(totalAmt.floatValue() + misBillDet.getPaidamount().floatValue());
            }
            return NumberToWordConverter.amountInWordsWithCircumfix((BigDecimal)new BigDecimal(totalAmt.floatValue()));
        }
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() == 1) {
            return ((Miscbilldetail)this.miscBillDetailList.get(0)).getAmtInWords();
        }
        return "";
    }

    private String getBillNumber() {
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() > 1) {
            return MULTIPLE;
        }
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() == 1) {
            return ((Miscbilldetail)this.miscBillDetailList.get(0)).getBillnumber();
        }
        return "";
    }

    private String getPartyName() {
        if (this.cashModePartyName != null && !this.cashModePartyName.equalsIgnoreCase("")) {
            return this.cashModePartyName;
        }
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() > 1 && this.hasSamePartyName(this.miscBillDetailList)) {
            return ((Miscbilldetail)this.miscBillDetailList.get(0)).getPaidto();
        }
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() > 1) {
            return MULTIPLE;
        }
        if (this.miscBillDetailList != null && this.miscBillDetailList.size() == 1) {
            return ((Miscbilldetail)this.miscBillDetailList.get(0)).getPaidto();
        }
        return "";
    }

    boolean hasSamePartyName(List<Miscbilldetail> billList) {
        String name = "initial";
        for (Miscbilldetail miscbilldetail : billList) {
            if ("initial".equalsIgnoreCase(name)) {
                name = miscbilldetail.getPaidto();
                continue;
            }
            if (name.equalsIgnoreCase(miscbilldetail.getPaidto())) continue;
            return false;
        }
        return true;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReportHelper(ReportHelper helper) {
        this.reportHelper = helper;
    }

    public List<Object> getVoucherReportList() {
        return this.voucherReportList;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String execute() {
        return this.print();
    }

    @Action(value="/report/billPaymentVoucherPrint-ajaxPrint")
    public String ajaxPrint() {
        return this.exportHtml();
    }

    public Object getModel() {
        return this.voucher;
    }

    @Action(value="/report/billPaymentVoucherPrint-print")
    public String print() {
        return PRINT;
    }

    private void populateVoucher() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        if (!StringUtils.isBlank((String)((String[])this.parameters.get("id"))[0])) {
            this.chequeNosList = new ArrayList();
            Long id = Long.valueOf(((String[])this.parameters.get("id"))[0]);
            this.paymentHeader = (Paymentheader)this.persistenceService.getSession().get(Paymentheader.class, (Serializable)id);
            if (this.paymentHeader != null && this.paymentHeader.getType().equalsIgnoreCase("rtgs")) {
                this.paymentMode = "rtgs";
                this.voucher = this.paymentHeader.getVoucherheader();
                if (this.voucher != null) {
                    List instrumentVoucherList = this.persistenceService.findAllBy("from InstrumentVoucher where voucherHeaderId.id=?", new Object[]{this.voucher.getId()});
                    if (instrumentVoucherList != null && !instrumentVoucherList.isEmpty()) {
                        InstrumentHeader instrumentHeader = ((InstrumentVoucher)instrumentVoucherList.get(0)).getInstrumentHeaderId();
                        this.rtgsRefNo = instrumentHeader.getTransactionNumber();
                        this.rtgsDate = Constants.DDMMYYYYFORMAT2.format(instrumentHeader.getTransactionDate());
                    }
                    this.generateVoucherReportList();
                    Bankaccount bankAccount = this.paymentHeader.getBankaccount();
                    if (bankAccount != null) {
                        this.bankName = bankAccount.getBankbranch().getBank().getName().concat("-").concat(bankAccount.getBankbranch().getBranchname());
                        this.bankAccountNumber = bankAccount.getAccountnumber();
                    }
                    this.miscBillDetailList = this.persistenceService.findAllBy("from Miscbilldetail where payVoucherHeader.id=?", new Object[]{this.voucher.getId()});
                }
                return;
            }
            if (this.paymentHeader != null) {
                this.voucher = this.paymentHeader.getVoucherheader();
                ArrayList<String> excludeChequeStatusses = new ArrayList<String>();
                excludeChequeStatusses.add("Cancelled");
                excludeChequeStatusses.add("Surrender_For_Reassign");
                excludeChequeStatusses.add("Surrendered");
                List instrumentVoucherList = this.persistenceService.findAllBy("from InstrumentVoucher where voucherHeaderId.id=?", new Object[]{this.voucher.getId()});
                if (instrumentVoucherList != null && !instrumentVoucherList.isEmpty()) {
                    for (InstrumentVoucher instrumentVoucher : instrumentVoucherList) {
                        try {
                            if (excludeChequeStatusses.contains(instrumentVoucher.getInstrumentHeaderId().getStatusId().getDescription())) continue;
                            this.instrumentHeader = instrumentVoucher.getInstrumentHeaderId();
                            this.chequeNumber = instrumentVoucher.getInstrumentHeaderId().getInstrumentNumber();
                            this.chequeDate = Constants.DDMMYYYYFORMAT2.format(instrumentVoucher.getInstrumentHeaderId().getInstrumentDate());
                            if (this.isInstrumentMultiVoucherMapped(instrumentVoucher.getInstrumentHeaderId().getId())) {
                                this.chequeNosList.add(this.chequeNumber + "-MULTIPLE");
                            } else {
                                this.chequeNosList.add(this.chequeNumber);
                            }
                            Long chequeNumberPass = Long.parseLong(this.chequeNumber);
                            this.chequeNoList.add(chequeNumberPass);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                this.generateVoucherReportList();
                Bankaccount bankAccount = this.paymentHeader.getBankaccount();
                if (bankAccount != null) {
                    this.bankName = bankAccount.getBankbranch().getBank().getName().concat("-").concat(bankAccount.getBankbranch().getBranchname());
                    this.bankAccountNumber = bankAccount.getAccountnumber();
                }
                if (this.paymentHeader.getType().equalsIgnoreCase("cash") && this.instrumentHeader != null && this.instrumentHeader.getPayTo() != null) {
                    this.cashModePartyName = this.instrumentHeader.getPayTo();
                }
            }
            this.miscBillDetailList = this.persistenceService.findAllBy("from Miscbilldetail where payVoucherHeader.id=?", new Object[]{this.voucher.getId()});
        }
        Collections.sort(this.chequeNoList);
        this.chequeNumber = "";
        block3: for (Long lval : this.chequeNoList) {
            for (String sval : this.chequeNosList) {
                Long chequeNoCompL = sval.contains(MULTIPLE) ? Long.valueOf(Long.parseLong(sval.substring(0, sval.lastIndexOf(45)))) : Long.valueOf(Long.parseLong(sval));
                if (!lval.equals(chequeNoCompL)) continue;
                this.chequeNumber = this.chequeNumber + sval + "/";
                continue block3;
            }
        }
        if (this.chequeNumber.length() > 1) {
            this.chequeNumber = this.chequeNumber.substring(0, this.chequeNumber.length() - 1);
        }
    }

    private boolean isInstrumentMultiVoucherMapped(Long instrumentHeaderId) {
        List instrumentVoucherList = this.persistenceService.findAllBy("from InstrumentVoucher where instrumentHeaderId.id=?", new Object[]{instrumentHeaderId});
        boolean rep = false;
        if (!instrumentVoucherList.isEmpty()) {
            Long voucherId = ((InstrumentVoucher)instrumentVoucherList.get(0)).getVoucherHeaderId().getId();
            for (InstrumentVoucher instrumentVoucher : instrumentVoucherList) {
                if (voucherId == instrumentVoucher.getVoucherHeaderId().getId()) continue;
                rep = true;
                break;
            }
        }
        return rep;
    }

    private void generateVoucherReportList() {
        if (this.voucher != null) {
            VoucherReport voucherReport;
            for (CGeneralLedger vd : this.voucher.getGeneralledger()) {
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(vd.getCreditAmount())) != 0) continue;
                voucherReport = new VoucherReport(this.persistenceService, Integer.valueOf(this.voucher.getId().toString()), vd, this.egovCommon);
                voucherReport.setDepartment(this.voucher.getVouchermis().getDepartmentid());
                this.voucherReportList.add(voucherReport);
            }
            for (CGeneralLedger vd : this.voucher.getGeneralledger()) {
                if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(vd.getDebitAmount())) != 0) continue;
                voucherReport = new VoucherReport(this.persistenceService, Integer.valueOf(this.voucher.getId().toString()), vd, this.egovCommon);
                voucherReport.setDepartment(this.voucher.getVouchermis().getDepartmentid());
                this.voucherReportList.add(voucherReport);
            }
        }
    }

    String getUlbName() {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("SELECT name FROM companydetail");
        List result = query.list();
        if (result != null) {
            return (String)result.get(0);
        }
        return "";
    }

    private String getPaymentNarration() {
        return this.voucher == null || this.voucher.getDescription() == null ? "" : this.voucher.getDescription();
    }

    @Action(value="/report/billPaymentVoucherPrint-exportPdf")
    public String exportPdf() throws JRException, IOException {
        this.populateVoucher();
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, JASPERPATH, this.getParamMap(), this.voucherReportList);
        return "PDF";
    }

    public String exportHtml() {
        this.populateVoucher();
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, JASPERPATH, this.getParamMap(), this.voucherReportList, "px");
        return "HTML";
    }

    @Action(value="/report/billPaymentVoucherPrint-exportXls")
    public String exportXls() throws JRException, IOException {
        this.populateVoucher();
        this.inputStream = this.reportHelper.exportXls(this.inputStream, JASPERPATH, this.getParamMap(), this.voucherReportList);
        return "XLS";
    }

    public Map<String, Object> getAccountDetails(Integer detailtypeid, Integer detailkeyid, Map<String, Object> tempMap) throws ApplicationException {
        Accountdetailtype detailtype = (Accountdetailtype)this.getPersistenceService().find(ACCDETAILTYPEQUERY, new Object[]{detailtypeid});
        tempMap.put("detailtype", detailtype.getName());
        tempMap.put("detailtypeid", detailtype.getId());
        tempMap.put("detailkeyid", detailkeyid);
        this.egovCommon.setPersistenceService(this.persistenceService);
        EntityType entityType = this.egovCommon.getEntityType(detailtype, (Serializable)detailkeyid);
        tempMap.put("detailkey", entityType.getName());
        tempMap.put("detailcode", entityType.getCode());
        return tempMap;
    }

    String getVoucherNumber() {
        return this.voucher == null || this.voucher.getVoucherNumber() == null ? "" : this.voucher.getVoucherNumber();
    }

    String getVoucherDate() {
        return this.voucher == null || this.voucher.getVoucherDate() == null ? "" : DateUtils.getDefaultFormattedDate((Date)this.voucher.getVoucherDate());
    }

    private void loadInboxHistoryData(List<StateHistory<Position>> stateHistory, Map<String, Object> paramMap) {
        ArrayList<String> history = new ArrayList<String>();
        ArrayList<String> workFlowDate = new ArrayList<String>();
        if (!stateHistory.isEmpty()) {
            for (StateHistory<Position> historyState : stateHistory) {
                if ("NEW".equalsIgnoreCase(historyState.getValue())) continue;
                history.add(historyState.getSenderName());
                workFlowDate.add(Constants.DDMMYYYYFORMAT2.format(historyState.getLastModifiedDate()));
                if (!historyState.getValue().equalsIgnoreCase("Rejected")) continue;
                history.clear();
                workFlowDate.clear();
            }
            history.add(this.paymentHeader.getState().getSenderName());
            workFlowDate.add(Constants.DDMMYYYYFORMAT2.format(this.paymentHeader.getState().getLastModifiedDate()));
        } else {
            history.add(this.paymentHeader.getState().getSenderName());
            workFlowDate.add(Constants.DDMMYYYYFORMAT2.format(this.paymentHeader.getState().getLastModifiedDate()));
        }
        for (int i = 0; i < history.size(); ++i) {
            paramMap.put("workFlow_" + i, history.get(i));
            paramMap.put("workFlowDate_" + i, workFlowDate.get(i));
        }
    }

    String getVoucherDescription() {
        return this.voucher == null || this.voucher.getDescription() == null ? "" : this.voucher.getDescription();
    }
}

