/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.model.BankBookEntry;
import org.egov.egf.model.BankBookViewEntry;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.payment.Paymentheader;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"results"}, location="bankBookReport-results.jsp"), @Result(name={"chequeDetails"}, location="bankBookReport-chequeDetails.jsp"), @Result(name={"PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BankBookReport.pdf"}), @Result(name={"XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BankBookReport.xls"})})
public class BankBookReportAction
extends BaseFormAction {
    private static final long serialVersionUID = -4641317233825371935L;
    private static final String EMPTY_STRING = "";
    private static final String PAYMENT = "Payment";
    private static final String RECEIPT = "Receipt";
    private static final String SURRENDERED = "Surrendered";
    private static final Logger LOGGER = Logger.getLogger(BankBookReportAction.class);
    String jasperpath = "/reports/templates/bankBookReport.jasper";
    List<Paymentheader> paymentHeaderList = new ArrayList();
    private List<BankBookEntry> bankBookEntries = new ArrayList();
    private List<BankBookViewEntry> bankBookViewEntries = new ArrayList();
    private Date startDate = new Date();
    private Date endDate = new Date();
    private BigDecimal bankBalance = BigDecimal.ZERO;
    private Bankaccount bankAccount;
    private InputStream inputStream;
    ReportHelper reportHelper;
    private EgovCommon egovCommon;
    protected List<String> headerFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    private Fund fundId = new Fund();
    private CFunction function = new CFunction();
    private Vouchermis vouchermis = new Vouchermis();
    private Long voucherId;
    private List<InstrumentHeader> chequeDetails = new ArrayList();
    private String chequeStatus = "";
    private String voucherStr = "";
    private StringBuffer header = new StringBuffer();
    private Date todayDate;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private final List<String> voucherNo = new ArrayList();
    private boolean isCreditOpeningBalance = false;
    private String queryFrom = "";
    private String getInstrumentsByVoucherIdsQuery = "";
    private Map<Long, List<Object[]>> voucherIdAndInstrumentMap = new HashMap();
    private Map<Long, List<Object[]>> InstrumentHeaderIdsAndInstrumentVouchersMap = new HashMap();
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public String execute() throws Exception {
        this.finYearDate();
        return "form";
    }

    public void finYearDate() {
        String financialYearId = this.financialYearDAO.getCurrYearFiscalId();
        this.startDate = financialYearId == null || financialYearId.equals(EMPTY_STRING) ? new Date() : (Date)this.persistenceService.find("select startingDate  from CFinancialYear where id=?", new Object[]{Long.parseLong(financialYearId)});
        this.endDate = null;
    }

    public BankBookReportAction() {
        this.addRelatedEntity("vouchermis.departmentid", Department.class);
        this.addRelatedEntity("vouchermis.fundId", Fund.class);
        this.addRelatedEntity("vouchermis.schemeid", Scheme.class);
        this.addRelatedEntity("vouchermis.subschemeid", SubScheme.class);
        this.addRelatedEntity("vouchermis.functionary", Functionary.class);
        this.addRelatedEntity("vouchermis.fundsource", Fundsource.class);
        this.addRelatedEntity("vouchermis.divisionid", Boundary.class);
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        if (!this.parameters.containsKey("skipPrepare")) {
            this.addDropdownData("bankList", this.egovCommon.getBankBranchForActiveBanks());
            this.addDropdownData("accNumList", Collections.EMPTY_LIST);
            this.getHeaderFields();
            if (this.headerFields.contains("department")) {
                this.addDropdownData("departmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
            }
            if (this.headerFields.contains("function")) {
                this.addDropdownData("functionList", this.persistenceService.findAllBy("from CFunction where isactive=true and isnotleaf=false  order by name", new Object[0]));
            }
            if (this.headerFields.contains("functionary")) {
                this.addDropdownData("functionaryList", this.persistenceService.findAllBy(" from Functionary where isactive=true order by name", new Object[0]));
            }
            if (this.headerFields.contains("fund")) {
                this.addDropdownData("fundList", this.persistenceService.findAllBy(" from Fund where isactive=true and isnotleaf=false order by name", new Object[0]));
            }
            if (this.headerFields.contains("fundsource")) {
                this.addDropdownData("fundsourceList", this.persistenceService.findAllBy(" from Fundsource where isactive=true order by name", new Object[0]));
            }
            if (this.headerFields.contains("field")) {
                this.addDropdownData("fieldList", this.persistenceService.findAllBy(" from Boundary b where lower(b.boundaryType.name)='ward' ", new Object[0]));
            }
            if (this.headerFields.contains("scheme")) {
                this.addDropdownData("schemeList", Collections.EMPTY_LIST);
            }
            if (this.headerFields.contains("subscheme")) {
                this.addDropdownData("subschemeList", Collections.EMPTY_LIST);
            }
        }
    }

    protected void getHeaderFields() {
        List appConfigList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "REPORT_SEARCH_MISATTRRIBUTES");
        for (AppConfigValues appConfigVal : appConfigList) {
            String value = appConfigVal.getValue();
            String header = value.substring(0, value.indexOf(124));
            this.headerFields.add(header);
            String mandate = value.substring(value.indexOf(124) + 1);
            if (!mandate.equalsIgnoreCase("M")) continue;
            this.mandatoryFields.add(header);
        }
    }

    public boolean shouldShowHeaderField(String fieldName) {
        return this.headerFields.contains(fieldName);
    }

    @ReadOnly
    @Action(value="/report/bankBookReport-ajaxLoadBankBook")
    public String ajaxLoadBankBook() {
        if (this.parameters.containsKey("bankAccount.id") && ((String[])this.parameters.get("bankAccount.id"))[0] != null) {
            String endFormat1;
            this.startDate = this.parseDate("startDate");
            this.endDate = this.parseDate("endDate");
            CFinancialYear financialYear = this.financialYearDAO.getFinYearByDate(this.startDate);
            Date endingDate = financialYear.getEndingDate();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String endFormat = formatter.format(this.endDate);
            if (endFormat.compareTo(endFormat1 = formatter.format(endingDate)) > 0) {
                this.addActionError(this.getText("End date should be within a financial year"));
                return "results";
            }
            this.setTodayDate(new Date());
            this.bankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.valueOf(((String[])this.parameters.get("bankAccount.id"))[0])});
            List results = this.getResults(this.bankAccount.getChartofaccounts().getGlcode());
            HashMap<String, BankBookEntry> voucherNumberAndEntryMap = new HashMap<String, BankBookEntry>();
            ArrayList<String> multipleChequeVoucherNumber = new ArrayList<String>();
            ArrayList<BankBookEntry> rowsToBeRemoved = new ArrayList<BankBookEntry>();
            for (BankBookEntry row : results) {
                if (row.getType().equalsIgnoreCase(RECEIPT)) {
                    row.setType(RECEIPT);
                } else {
                    row.setType(PAYMENT);
                }
                boolean shouldAddRow = true;
                if (voucherNumberAndEntryMap.containsKey(row.getVoucherNumber())) {
                    if (SURRENDERED.equalsIgnoreCase(row.getInstrumentStatus()) || "Surrender_For_Reassign".equalsIgnoreCase(row.getInstrumentStatus())) {
                        shouldAddRow = false;
                    } else {
                        BankBookEntry entryInMap = (BankBookEntry)voucherNumberAndEntryMap.get(row.getVoucherNumber());
                        if (!(!SURRENDERED.equalsIgnoreCase(entryInMap.getInstrumentStatus()) && !"Surrender_For_Reassign".equalsIgnoreCase(entryInMap.getInstrumentStatus()) || SURRENDERED.equalsIgnoreCase(row.getInstrumentStatus()) && "Surrender_For_Reassign".equalsIgnoreCase(row.getInstrumentStatus()))) {
                            rowsToBeRemoved.add(entryInMap);
                            voucherNumberAndEntryMap.put(row.getVoucherNumber(), row);
                        } else if (row.getVoucherDate().compareTo(entryInMap.getVoucherDate()) == 0 && row.getParticulars().equalsIgnoreCase(entryInMap.getParticulars()) && row.getAmount().equals(entryInMap.getAmount()) && !SURRENDERED.equalsIgnoreCase(entryInMap.getInstrumentStatus())) {
                            multipleChequeVoucherNumber.add(row.getVoucherNumber());
                            shouldAddRow = false;
                        } else {
                            shouldAddRow = true;
                        }
                    }
                } else {
                    voucherNumberAndEntryMap.put(row.getVoucherNumber(), row);
                }
                if (!shouldAddRow) continue;
                this.bankBookEntries.add(row);
            }
            if (!this.bankBookEntries.isEmpty()) {
                this.computeTotals(this.bankAccount.getChartofaccounts().getGlcode(), this.bankAccount.getFund().getCode(), multipleChequeVoucherNumber, rowsToBeRemoved);
                this.prepareViewObject();
            }
        }
        return "results";
    }

    private void prepareViewObject() {
        for (BankBookEntry row : this.bankBookEntries) {
            BigDecimal amt;
            BankBookViewEntry bankBookViewEntry = new BankBookViewEntry();
            if ("Total".equalsIgnoreCase(row.getParticulars())) {
                bankBookViewEntry.setReceiptAmount(row.getReceiptAmount());
                bankBookViewEntry.setReceiptParticulars(row.getParticulars());
                bankBookViewEntry.setPaymentAmount(row.getReceiptAmount());
                bankBookViewEntry.setPaymentParticulars(row.getParticulars());
            } else if ("To Opening Balance".equalsIgnoreCase(row.getParticulars())) {
                amt = row.getAmount();
                if (amt.longValue() < 0L) {
                    bankBookViewEntry.setPaymentAmount(amt.abs());
                    bankBookViewEntry.setPaymentParticulars(row.getParticulars());
                } else {
                    bankBookViewEntry.setReceiptAmount(amt.abs());
                    bankBookViewEntry.setReceiptParticulars(row.getParticulars());
                }
            } else if ("Closing:By Balance c/d".equalsIgnoreCase(row.getParticulars())) {
                amt = row.getAmount();
                if (amt.longValue() < 0L) {
                    bankBookViewEntry.setReceiptAmount(amt.abs());
                    bankBookViewEntry.setReceiptParticulars(row.getParticulars());
                } else {
                    bankBookViewEntry.setPaymentAmount(amt.abs());
                    bankBookViewEntry.setPaymentParticulars(row.getParticulars());
                }
            } else {
                String voucherDate;
                String string = voucherDate = row.getVoucherDate() == null ? EMPTY_STRING : Constants.DDMMYYYYFORMAT2.format(row.getVoucherDate());
                if (row.getType().equalsIgnoreCase(RECEIPT)) {
                    bankBookViewEntry = new BankBookViewEntry(row.getVoucherNumber(), voucherDate, row.getParticulars(), row.getAmount(), row.getChequeDetail(), RECEIPT, row.getChequeNumber());
                    bankBookViewEntry.setVoucherId(Long.valueOf(row.getVoucherId().longValue()));
                } else {
                    bankBookViewEntry = new BankBookViewEntry(row.getVoucherNumber(), voucherDate, row.getParticulars(), row.getAmount(), row.getChequeDetail(), PAYMENT, row.getChequeNumber());
                    bankBookViewEntry.setVoucherId(Long.valueOf(row.getVoucherId().longValue()));
                }
            }
            this.bankBookViewEntries.add(bankBookViewEntry);
        }
    }

    private void computeTotals(String glCode, String fundCode, List<String> multipleChequeVoucherNumber, List<BankBookEntry> rowsToBeRemoved) {
        ArrayList<BankBookEntry> entries = new ArrayList<BankBookEntry>();
        this.getInstrumentsByVoucherIds();
        this.getInstrumentVouchersByInstrumentHeaderIds();
        Integer deptId = null;
        if (this.getVouchermis() != null && this.getVouchermis().getDepartmentid() != null && this.getVouchermis().getDepartmentid().getId() != null && this.getVouchermis().getDepartmentid().getId() != -1L) {
            deptId = this.getVouchermis().getDepartmentid().getId().intValue();
        }
        BankBookEntry initialOpeningBalance = this.getInitialAccountBalance(glCode, fundCode, deptId);
        entries.add(initialOpeningBalance);
        Date date = ((BankBookEntry)this.bankBookEntries.get(0)).getVoucherDate();
        String voucherNumber = EMPTY_STRING;
        String chequeNumber = EMPTY_STRING;
        BigDecimal receiptTotal = BigDecimal.ZERO;
        BigDecimal paymentTotal = BigDecimal.ZERO;
        BigDecimal initialBalance = initialOpeningBalance.getAmount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside computeTotals()");
        }
        for (BankBookEntry bankBookEntry : this.bankBookEntries) {
            if (initialBalance.longValue() < 0L) {
                this.isCreditOpeningBalance = true;
            }
            if (rowsToBeRemoved.contains(bankBookEntry)) continue;
            if (bankBookEntry.voucherDate.compareTo(date) != 0) {
                date = bankBookEntry.getVoucherDate();
                BigDecimal closingBalance = initialBalance.add(receiptTotal).subtract(paymentTotal);
                if (closingBalance.longValue() < 0L) {
                    entries.add(new BankBookEntry("Closing:By Balance c/d", closingBalance, PAYMENT, BigDecimal.ZERO, BigDecimal.ZERO));
                    if (this.isCreditOpeningBalance) {
                        entries.add(new BankBookEntry("Total", BigDecimal.ZERO, RECEIPT, closingBalance.abs().add(receiptTotal), initialBalance.abs().add(paymentTotal)));
                    } else {
                        entries.add(new BankBookEntry("Total", BigDecimal.ZERO, RECEIPT, initialBalance.abs().add(receiptTotal).add(closingBalance.abs()), paymentTotal));
                    }
                    entries.add(new BankBookEntry("To Opening Balance", closingBalance, RECEIPT, BigDecimal.ZERO, BigDecimal.ZERO));
                } else {
                    entries.add(new BankBookEntry("Closing:By Balance c/d", closingBalance, RECEIPT, BigDecimal.ZERO, BigDecimal.ZERO));
                    if (this.isCreditOpeningBalance) {
                        entries.add(new BankBookEntry("Total", BigDecimal.ZERO, RECEIPT, receiptTotal, closingBalance.abs().add(paymentTotal).add(initialBalance.abs())));
                    } else {
                        entries.add(new BankBookEntry("Total", BigDecimal.ZERO, RECEIPT, initialBalance.abs().add(receiptTotal), closingBalance.abs().add(paymentTotal)));
                    }
                    entries.add(new BankBookEntry("To Opening Balance", closingBalance, PAYMENT, BigDecimal.ZERO, BigDecimal.ZERO));
                }
                receiptTotal = BigDecimal.ZERO;
                paymentTotal = BigDecimal.ZERO;
                initialBalance = closingBalance;
                this.isCreditOpeningBalance = false;
            }
            if (RECEIPT.equalsIgnoreCase(bankBookEntry.getType()) && !voucherNumber.equalsIgnoreCase(bankBookEntry.getVoucherNumber())) {
                receiptTotal = receiptTotal.add(bankBookEntry.getAmount());
            } else if (!voucherNumber.equalsIgnoreCase(bankBookEntry.getVoucherNumber())) {
                paymentTotal = paymentTotal.add(bankBookEntry.getAmount());
            }
            if (SURRENDERED.equalsIgnoreCase(bankBookEntry.getInstrumentStatus())) {
                bankBookEntry.setChequeDetail(EMPTY_STRING);
            }
            if (multipleChequeVoucherNumber.contains(bankBookEntry.getVoucherNumber())) {
                bankBookEntry.setChequeDetail("MULTIPLE");
                List chequeDetails = (List)this.voucherIdAndInstrumentMap.get(bankBookEntry.getVoucherId().longValue());
                StringBuffer listofcheque = new StringBuffer(100);
                String chequeNos = " ";
                String chequeComp = " ";
                if (!this.voucherNo.contains(bankBookEntry.getVoucherNumber())) {
                    for (Object[] iv : chequeDetails) {
                        chequeNumber = this.getStringValue(iv[1]);
                        this.chequeStatus = " ";
                        this.chequeStatus = this.getStringValue(iv[2]);
                        if (SURRENDERED.equalsIgnoreCase(this.chequeStatus) || "Surrender_For_Reassign".equalsIgnoreCase(this.chequeStatus)) continue;
                        if (this.isInstrumentMultiVoucherMapped(this.getLongValue(iv[3]))) {
                            String chqDate = this.sdf.format(this.getDateValue(iv[4]));
                            chequeComp = chequeNumber + " " + chqDate + "-MULTIPLE";
                        }
                        listofcheque.append(this.getStringValue(iv[1])).append(" ").append(this.getDateValue(iv[4]) != null ? this.sdf.format(this.getDateValue(iv[4])) : EMPTY_STRING);
                        if (chequeComp.contains("-MULTIPLE")) {
                            listofcheque.append(" ").append("-MULTIPLE,");
                            chequeComp = " ";
                            continue;
                        }
                        listofcheque.append(" ").append(",");
                    }
                    chequeNos = listofcheque.toString();
                    if (chequeNos.length() > 1) {
                        chequeNos = chequeNos.substring(0, chequeNos.length() - 1);
                    }
                    bankBookEntry.setChequeNumber(chequeNos);
                    voucherNumber = bankBookEntry.getVoucherNumber();
                    entries.add(bankBookEntry);
                    this.voucherNo.add(bankBookEntry.getVoucherNumber());
                }
            } else {
                this.voucherStr = " ";
                List instrumentVoucherList = new ArrayList();
                instrumentVoucherList = (List)this.voucherIdAndInstrumentMap.get(bankBookEntry.getVoucherId().longValue());
                if (instrumentVoucherList != null) {
                    for (Object[] instrumentVoucher : instrumentVoucherList) {
                        try {
                            String chqDate;
                            chequeNumber = this.getStringValue(instrumentVoucher[1]);
                            this.chequeStatus = " ";
                            this.chequeStatus = this.getStringValue(instrumentVoucher[2]);
                            if (SURRENDERED.equalsIgnoreCase(this.chequeStatus) || "Surrender_For_Reassign".equalsIgnoreCase(this.chequeStatus)) continue;
                            if (this.isInstrumentMultiVoucherMapped(this.getLongValue(instrumentVoucher[3]))) {
                                if (chequeNumber != null && !chequeNumber.equalsIgnoreCase(EMPTY_STRING)) {
                                    chqDate = this.getDateValue(instrumentVoucher[4]) != null ? this.sdf.format(this.getDateValue(instrumentVoucher[4])) : EMPTY_STRING;
                                    this.voucherStr = chequeNumber + " " + chqDate + "-MULTIPLE";
                                    continue;
                                }
                                chequeNumber = this.getStringValue(instrumentVoucher[5]);
                                chqDate = this.getDateValue(instrumentVoucher[6]) != null ? this.sdf.format(this.getDateValue(instrumentVoucher[6])) : EMPTY_STRING;
                                this.voucherStr = chequeNumber + " " + chqDate + "-MULTIPLE";
                                continue;
                            }
                            if (chequeNumber != null && !chequeNumber.equalsIgnoreCase(EMPTY_STRING)) {
                                chqDate = this.getDateValue(instrumentVoucher[4]) != null ? this.sdf.format(this.getDateValue(instrumentVoucher[4])) : EMPTY_STRING;
                                this.voucherStr = chequeNumber + " " + chqDate;
                                continue;
                            }
                            chequeNumber = this.getStringValue(instrumentVoucher[5]);
                            chqDate = this.sdf.format(this.getDateValue(instrumentVoucher[6]));
                            this.voucherStr = chequeNumber + " " + chqDate;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                bankBookEntry.setChequeDetail(this.voucherStr);
                entries.add(bankBookEntry);
                this.voucherNo.add(bankBookEntry.getVoucherNumber());
            }
            voucherNumber = bankBookEntry.getVoucherNumber();
        }
        String vhNum = EMPTY_STRING;
        for (BankBookEntry bankBookEntry : this.bankBookEntries) {
            if (bankBookEntry.voucherNumber.equalsIgnoreCase(vhNum)) {
                bankBookEntry.setVoucherDate(null);
                bankBookEntry.setAmount(null);
                bankBookEntry.setVoucherNumber(EMPTY_STRING);
                continue;
            }
            vhNum = bankBookEntry.getVoucherNumber();
        }
        this.addTotalsSection(initialBalance, paymentTotal, receiptTotal, entries);
        this.bankBookEntries = entries;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End of computeTotals()");
        }
    }

    private void getInstrumentsByVoucherIds() {
        String mainQuery = EMPTY_STRING;
        mainQuery = "SELECT vh2.id,ih2.instrumentnumber,es2.code,ih2.id as instrumentHeaderId ,ih2.instrumentdate, ih2.transactionnumber, ih2.transactiondate";
        this.getInstrumentsByVoucherIdsQuery = " FROM VOUCHERHEADER vh2,egf_instrumentvoucher iv2 ,egf_instrumentheader ih2 ,egw_status es2 WHERE vh2.id = iv2.voucherheaderid AND iv2.instrumentheaderid=ih2.id AND ih2.id_status = es2.id AND vh2.id in (select vh.id as vhId" + this.queryFrom + ")";
        mainQuery = mainQuery + this.getInstrumentsByVoucherIdsQuery;
        List objs = this.persistenceService.getSession().createSQLQuery(mainQuery).list();
        for (Object[] obj : objs) {
            if (this.voucherIdAndInstrumentMap.containsKey(this.getLongValue(obj[0]))) {
                ((List)this.voucherIdAndInstrumentMap.get(this.getLongValue(obj[0]))).add(obj);
                continue;
            }
            ArrayList<Object[]> instrumentVouchers = new ArrayList<Object[]>();
            instrumentVouchers.add(obj);
            this.voucherIdAndInstrumentMap.put(this.getLongValue(obj[0]), instrumentVouchers);
        }
    }

    private void getInstrumentVouchersByInstrumentHeaderIds() {
        List objs = this.persistenceService.getSession().createSQLQuery("SELECT ih.id,vh1.id as voucherHeaderId FROM VOUCHERHEADER vh1,egf_instrumentvoucher iv ,egf_instrumentheader ih,egw_status es1 WHERE vh1.id = iv.voucherheaderid AND iv.instrumentheaderid=ih.id AND ih.id_status = es1.id AND ih.id in (select ih2.id as instrHeaderId " + this.getInstrumentsByVoucherIdsQuery + ")").list();
        for (Object[] obj : objs) {
            if (this.InstrumentHeaderIdsAndInstrumentVouchersMap.containsKey(this.getLongValue(obj[0]))) {
                ((List)this.InstrumentHeaderIdsAndInstrumentVouchersMap.get(this.getLongValue(obj[0]))).add(obj);
                continue;
            }
            ArrayList<Object[]> instrumentVouchers = new ArrayList<Object[]>();
            instrumentVouchers.add(obj);
            this.InstrumentHeaderIdsAndInstrumentVouchersMap.put(this.getLongValue(obj[0]), instrumentVouchers);
        }
    }

    private boolean isInstrumentMultiVoucherMapped(Long instrumentHeaderId) {
        List instrumentVoucherList = (List)this.InstrumentHeaderIdsAndInstrumentVouchersMap.get(instrumentHeaderId);
        boolean rep = false;
        if (instrumentVoucherList != null && instrumentVoucherList.size() != 0) {
            Object[] obj = (Object[])instrumentVoucherList.get(0);
            Long voucherId = this.getLongValue(obj[1]);
            for (Object[] instrumentVoucher : instrumentVoucherList) {
                if (voucherId == this.getLongValue(instrumentVoucher[1])) continue;
                rep = true;
                break;
            }
        }
        return rep;
    }

    private BankBookEntry getInitialAccountBalance(String glCode, String fundCode, Integer deptId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.startDate);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5));
        BankBookEntry initialOpeningBalance = new BankBookEntry("To Opening Balance", this.egovCommon.getAccountBalanceforDate(calendar.getTime(), glCode, fundCode, null, null, deptId), RECEIPT, BigDecimal.ZERO, BigDecimal.ZERO);
        return initialOpeningBalance;
    }

    private void addTotalsSection(BigDecimal initialBalance, BigDecimal paymentTotal, BigDecimal receiptTotal, List<BankBookEntry> entries) {
        BigDecimal closingBalance = initialBalance.add(receiptTotal).subtract(paymentTotal);
        entries.add(new BankBookEntry("Closing:By Balance c/d", closingBalance, PAYMENT, BigDecimal.ZERO, BigDecimal.ZERO));
        if (initialBalance.longValue() < 0L) {
            this.isCreditOpeningBalance = true;
        }
        if (closingBalance.longValue() < 0L) {
            if (this.isCreditOpeningBalance) {
                entries.add(new BankBookEntry("Total", BigDecimal.ZERO, RECEIPT, closingBalance.abs().add(receiptTotal), initialBalance.abs().add(paymentTotal)));
            } else {
                entries.add(new BankBookEntry("Total", BigDecimal.ZERO, RECEIPT, initialBalance.abs().add(receiptTotal).add(closingBalance.abs()), paymentTotal));
            }
        } else if (this.isCreditOpeningBalance) {
            entries.add(new BankBookEntry("Total", BigDecimal.ZERO, RECEIPT, receiptTotal, closingBalance.abs().add(paymentTotal).add(initialBalance.abs())));
        } else {
            entries.add(new BankBookEntry("Total", BigDecimal.ZERO, RECEIPT, initialBalance.abs().add(receiptTotal), closingBalance.abs().add(paymentTotal)));
        }
        this.isCreditOpeningBalance = false;
        receiptTotal = BigDecimal.ZERO;
        paymentTotal = BigDecimal.ZERO;
        initialBalance = closingBalance;
    }

    private String getAppConfigValueFor(String module, String key) {
        try {
            return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey(module, key).get(0)).getValue();
        }
        catch (Exception e) {
            throw new ValidationException(EMPTY_STRING, "The key '" + key + "' is not defined in appconfig", new String[0]);
        }
    }

    private List<BankBookEntry> getResults(String glCode1) {
        String miscQuery = this.getMiscQuery();
        String OrderBy = EMPTY_STRING;
        String voucherStatusToExclude = this.getAppConfigValueFor("EGF", "statusexcludeReport");
        String query1 = "SELECT distinct vh.id as voucherId,vh.voucherDate AS voucherDate, vh.voucherNumber AS voucherNumber, gl.glcode||' - '||case when gl.debitAmount  = 0 then (case (gl.creditamount) when 0 then gl.creditAmount||'.00cr' when floor(gl.creditamount) then gl.creditAmount||'.00cr' else  gl.creditAmount||'cr'  end ) else (case (gl.debitamount) when 0 then gl.debitamount||'.00dr' when floor(gl.debitamount)  then gl.debitamount||'.00dr' else  gl.debitamount||'dr' \t end ) end AS particulars,case when gl1.debitAmount = 0 then gl1.creditamount else gl1.debitAmount end AS amount, case when gl1.debitAmount = 0 then 'Payment' else 'Receipt' end AS type, case when (case when ch.instrumentnumber is NULL then ch.transactionnumber else ch.instrumentnumber  ||' , ' ||TO_CHAR(case when ch.instrumentdate is NULL THEN ch.transactiondate else ch.instrumentdate end,'dd/mm/yyyy') end )  is NULL then case when ch.instrumentnumber is NULL then ch.transactionnumber else ch.instrumentnumber end ||' , ' ||TO_CHAR(case when ch.instrumentdate is NULL then ch.transactiondate else ch.instrumentdate end,'dd/mm/yyyy') end AS chequeDetail,gl.glcode as glCode,ch.description as instrumentStatus  ";
        this.queryFrom = " FROM generalLedger gl,generalLedger gl1,vouchermis vmis, VOUCHERHEADER vh left outer join (select iv.voucherheaderid,ih.instrumentnumber,ih.instrumentdate,es.description,ih.transactionnumber,ih.transactiondate from egf_instrumentheader ih,egw_status es,egf_instrumentvoucher iv where iv.instrumentheaderid=ih.id and ih.id_status=es.id) ch on ch.voucherheaderid=vh.id  WHERE  gl.voucherHeaderId = vh.id  AND vmis.VOUCHERHEADERID=vh.id  and gl.voucherheaderid  IN (SELECT voucherheaderid FROM generalledger gl WHERE glcode='" + glCode1 + "') AND gl.voucherheaderid = gl1.voucherheaderid AND gl.glcode <> '" + glCode1 + "' AND gl1.glcode = '" + glCode1 + "' and vh.voucherDate>='" + Constants.DDMMYYYYFORMAT1.format(this.startDate) + "' " + "and vh.voucherDate<='" + Constants.DDMMYYYYFORMAT1.format(this.endDate) + "' and vh.status not in(" + voucherStatusToExclude + ") " + miscQuery + " ";
        OrderBy = "order by voucherdate,vouchernumber";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Main query :SELECT distinct vh.id as voucherId,vh.voucherDate AS voucherDate, vh.voucherNumber AS voucherNumber, gl.glcode||' - '||case when gl.debitAmount  = 0 then (case (gl.creditamount) when 0 then gl.creditAmount||'.00cr' when floor(gl.creditamount) then gl.creditAmount||'.00cr' else  gl.creditAmount||'cr'  end ) else (case (gl.debitamount) when 0 then gl.debitamount||'.00dr' when floor(gl.debitamount)  then gl.debitamount||'.00dr' else  gl.debitamount||'dr' \t end ) end AS particulars,case when gl1.debitAmount = 0 then gl1.creditamount else gl1.debitAmount end AS amount, case when gl1.debitAmount = 0 then 'Payment' else 'Receipt' end AS type, case when (case when ch.instrumentnumber is NULL then ch.transactionnumber else ch.instrumentnumber  ||' , ' ||TO_CHAR(case when ch.instrumentdate is NULL THEN ch.transactiondate else ch.instrumentdate end,'dd/mm/yyyy') end )  is NULL then case when ch.instrumentnumber is NULL then ch.transactionnumber else ch.instrumentnumber end ||' , ' ||TO_CHAR(case when ch.instrumentdate is NULL then ch.transactiondate else ch.instrumentdate end,'dd/mm/yyyy') end AS chequeDetail,gl.glcode as glCode,ch.description as instrumentStatus  " + this.queryFrom + OrderBy));
        }
        Query query = this.persistenceService.getSession().createSQLQuery("SELECT distinct vh.id as voucherId,vh.voucherDate AS voucherDate, vh.voucherNumber AS voucherNumber, gl.glcode||' - '||case when gl.debitAmount  = 0 then (case (gl.creditamount) when 0 then gl.creditAmount||'.00cr' when floor(gl.creditamount) then gl.creditAmount||'.00cr' else  gl.creditAmount||'cr'  end ) else (case (gl.debitamount) when 0 then gl.debitamount||'.00dr' when floor(gl.debitamount)  then gl.debitamount||'.00dr' else  gl.debitamount||'dr' \t end ) end AS particulars,case when gl1.debitAmount = 0 then gl1.creditamount else gl1.debitAmount end AS amount, case when gl1.debitAmount = 0 then 'Payment' else 'Receipt' end AS type, case when (case when ch.instrumentnumber is NULL then ch.transactionnumber else ch.instrumentnumber  ||' , ' ||TO_CHAR(case when ch.instrumentdate is NULL THEN ch.transactiondate else ch.instrumentdate end,'dd/mm/yyyy') end )  is NULL then case when ch.instrumentnumber is NULL then ch.transactionnumber else ch.instrumentnumber end ||' , ' ||TO_CHAR(case when ch.instrumentdate is NULL then ch.transactiondate else ch.instrumentdate end,'dd/mm/yyyy') end AS chequeDetail,gl.glcode as glCode,ch.description as instrumentStatus  " + this.queryFrom + OrderBy).addScalar("voucherId", (Type)new BigDecimalType()).addScalar("voucherDate").addScalar("voucherNumber").addScalar("particulars").addScalar("amount", (Type)new BigDecimalType()).addScalar("type").addScalar("chequeDetail").addScalar("glCode").addScalar("instrumentStatus").setResultTransformer(Transformers.aliasToBean(BankBookEntry.class));
        List results = query.list();
        return results;
    }

    String getMiscQuery() {
        StringBuffer query = new StringBuffer();
        if (this.fundId != null && this.fundId.getId() != null && this.fundId.getId() != -1) {
            query.append(" and vh.fundId=").append(this.fundId.getId().toString());
            Fund fnd = (Fund)this.persistenceService.find("from Fund where id=?", new Object[]{this.fundId.getId()});
            this.header.append(" for " + fnd.getName());
        }
        if (this.getVouchermis() != null && this.getVouchermis().getDepartmentid() != null && this.getVouchermis().getDepartmentid().getId() != null && this.getVouchermis().getDepartmentid().getId() != -1L) {
            query.append(" and vmis.DEPARTMENTID=").append(this.getVouchermis().getDepartmentid().getId().toString());
            Department dept = (Department)this.persistenceService.find("from Department where id=?", new Object[]{this.getVouchermis().getDepartmentid().getId()});
            this.header.append(" in " + dept.getName() + " ");
        }
        if (this.getVouchermis() != null && this.getVouchermis().getFunctionary() != null && this.getVouchermis().getFunctionary().getId() != null && this.getVouchermis().getFunctionary().getId() != -1) {
            query.append(" and vmis.FUNCTIONARYID=").append(this.getVouchermis().getFunctionary().getId().toString());
        }
        if (this.getVouchermis() != null && this.getVouchermis().getFundsource() != null && this.getVouchermis().getFundsource().getId() != null && this.getVouchermis().getFundsource().getId() != -1L) {
            query.append(" and vmis.FUNDSOURCEID =").append(this.getVouchermis().getFundsource().getId().toString());
        }
        if (this.getVouchermis() != null && this.getVouchermis().getSchemeid() != null && this.getVouchermis().getSchemeid().getId() != null && this.getVouchermis().getSchemeid().getId() != -1) {
            query.append(" and vmis.SCHEMEID =").append(this.getVouchermis().getSchemeid().getId().toString());
        }
        if (this.getVouchermis() != null && this.getVouchermis().getSubschemeid() != null && this.getVouchermis().getSubschemeid().getId() != null && this.getVouchermis().getSubschemeid().getId() != -1) {
            query.append(" and vmis.SUBSCHEMEID =").append(this.getVouchermis().getSubschemeid().getId().toString());
        }
        if (this.getVouchermis() != null && this.getVouchermis().getDivisionid() != null && this.getVouchermis().getDivisionid().getId() != null && this.getVouchermis().getDivisionid().getId() != -1L) {
            query.append(" and vmis.DIVISIONID =").append(this.getVouchermis().getDivisionid().getId().toString());
        }
        if (this.getVouchermis() != null && this.getVouchermis().getFunction() != null && this.getVouchermis().getFunction().getId() != null && this.getVouchermis().getFunction().getId() != -1L) {
            query.append(" and vmis.functionid=").append(this.getVouchermis().getFunction().getId());
            CFunction func = (CFunction)this.persistenceService.find("from CFunction where id=?", new Object[]{this.getVouchermis().getFunction().getId()});
            this.header.append(" in " + func.getName() + " ");
        }
        return query.toString();
    }

    Date parseDate(String stringDate) {
        if (this.parameters.containsKey(stringDate) && ((String[])this.parameters.get(stringDate))[0] != null) {
            try {
                return Constants.DDMMYYYYFORMAT2.parse(((String[])this.parameters.get(stringDate))[0]);
            }
            catch (ParseException e) {
                throw new ValidationException("Invalid date", "Invalid date", new String[0]);
            }
        }
        return new Date();
    }

    public List<Paymentheader> getPaymentHeaderList() {
        return this.paymentHeaderList;
    }

    private String getStringValue(Object object) {
        return object != null ? object.toString() : EMPTY_STRING;
    }

    private Date getDateValue(Object object) {
        return object != null ? (Date)object : null;
    }

    private Long getLongValue(Object object) {
        return object != null ? new Long(object.toString()) : 0L;
    }

    public BigDecimal getBankBalance() {
        return this.bankBalance;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getFormattedDate(Date date) {
        return Constants.DDMMYYYYFORMAT2.format(date);
    }

    public void setBankBalance(BigDecimal bankBalance) {
        this.bankBalance = bankBalance;
    }

    public void setBankAccount(Bankaccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public Bankaccount getBankAccount() {
        return this.bankAccount;
    }

    @Action(value="/report/bankBookReport-exportPdf")
    public String exportPdf() throws JRException, IOException {
        this.ajaxLoadBankBook();
        ArrayList<BankBookViewEntry> dataSource = new ArrayList<BankBookViewEntry>();
        for (BankBookViewEntry row : this.bankBookViewEntries) {
            dataSource.add(row);
        }
        this.setInputStream(this.reportHelper.exportPdf(this.getInputStream(), this.jasperpath, this.getParamMap(), dataSource));
        return "PDF";
    }

    @Action(value="/report/bankBookReport-exportXls")
    public String exportXls() throws JRException, IOException {
        this.ajaxLoadBankBook();
        ArrayList<BankBookViewEntry> dataSource = new ArrayList<BankBookViewEntry>();
        for (BankBookViewEntry row : this.bankBookViewEntries) {
            dataSource.add(row);
        }
        this.setInputStream(this.reportHelper.exportXls(this.getInputStream(), this.jasperpath, this.getParamMap(), dataSource));
        return "XLS";
    }

    Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ulbName", ReportUtil.getCityName());
        String name = this.bankAccount.getBankbranch().getBank().getName().concat("-").concat(this.bankAccount.getBankbranch().getBranchname()).concat("-").concat(this.bankAccount.getAccountnumber());
        paramMap.put("heading", this.getText("bank.book.heading", new String[]{name, this.header.toString(), Constants.DDMMYYYYFORMAT2.format(this.startDate), Constants.DDMMYYYYFORMAT2.format(this.endDate)}));
        return paramMap;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public void setBankBookViewEntries(List<BankBookViewEntry> bankBookViewEntries) {
        this.bankBookViewEntries = bankBookViewEntries;
    }

    public List<BankBookViewEntry> getBankBookViewEntries() {
        return this.bankBookViewEntries;
    }

    public void setFundId(Fund fundId) {
        this.fundId = fundId;
    }

    public Fund getFundId() {
        return this.fundId;
    }

    public Vouchermis getVouchermis() {
        return this.vouchermis;
    }

    public Object getModel() {
        return null;
    }

    public void setVoucherId(Long voucherId) {
        this.voucherId = voucherId;
    }

    public Long getVoucherId() {
        return this.voucherId;
    }

    @Action(value="/report/bankBookReport-showChequeDetails")
    public String showChequeDetails() {
        if (this.voucherId != null) {
            this.chequeDetails = this.persistenceService.findAllBy("select iv.instrumentHeaderId from InstrumentVoucher iv where iv.voucherHeaderId.id=?", new Object[]{this.voucherId});
        }
        return "chequeDetails";
    }

    public void setChequeDetails(List<InstrumentHeader> chequeDetails) {
        this.chequeDetails = chequeDetails;
    }

    public List<InstrumentHeader> getChequeDetails() {
        return this.chequeDetails;
    }

    public void setVouchermis(Vouchermis vouchermis) {
        this.vouchermis = vouchermis;
    }

    public StringBuffer getHeader() {
        return this.header;
    }

    public void setHeader(StringBuffer header) {
        this.header = header;
    }

    public Date getTodayDate() {
        return this.todayDate;
    }

    private void setTodayDate(Date todayDate) {
        this.todayDate = todayDate;
    }

    public String getQueryFrom() {
        return this.queryFrom;
    }

    public void setQueryFrom(String queryFrom) {
        this.queryFrom = queryFrom;
    }

    public String getGetInstrumentsByVoucherIdsQuery() {
        return this.getInstrumentsByVoucherIdsQuery;
    }

    public void setGetInstrumentsByVoucherIdsQuery(String getInstrumentsByVoucherIdsQuery) {
        this.getInstrumentsByVoucherIdsQuery = getInstrumentsByVoucherIdsQuery;
    }

    public Map<Long, List<Object[]>> getVoucherIdAndInstrumentMap() {
        return this.voucherIdAndInstrumentMap;
    }

    public void setVoucherIdAndInstrumentMap(Map<Long, List<Object[]>> voucherIdAndInstrumentMap) {
        this.voucherIdAndInstrumentMap = voucherIdAndInstrumentMap;
    }

    public Map<Long, List<Object[]>> getInstrumentHeaderIdsAndInstrumentVouchersMap() {
        return this.InstrumentHeaderIdsAndInstrumentVouchersMap;
    }

    public void setInstrumentHeaderIdsAndInstrumentVouchersMap(Map<Long, List<Object[]>> instrumentHeaderIdsAndInstrumentVouchersMap) {
        this.InstrumentHeaderIdsAndInstrumentVouchersMap = instrumentHeaderIdsAndInstrumentVouchersMap;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public FinancialYearDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }
}

