/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.report;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.egf.model.Statement;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.services.report.BalanceSheetScheduleService;
import org.egov.services.report.BalanceSheetService;
import org.egov.utils.ReportHelper;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"allScheduleDetailedResults"}, location="balanceSheetReport-allScheduleDetailedResults.jsp"), @Result(name={"report"}, location="balanceSheetReport-report.jsp"), @Result(name={"scheduleResults"}, location="balanceSheetReport-scheduleResults.jsp"), @Result(name={"allScheduleResults"}, location="balanceSheetReport-allScheduleResults.jsp"), @Result(name={"balanceSheet-PDF"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=BalanceSheet.pdf"}), @Result(name={"balanceSheet-XLS"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "application/xls", "contentDisposition", "no-cache;filename=BalanceSheet.xls"}), @Result(name={"balanceSheet-HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
public class BalanceSheetReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 7914013458428148999L;
    private static final String BALANCE_SHEET_PDF = "balanceSheet-PDF";
    private static final String BALANCE_SHEET_XLS = "balanceSheet-XLS";
    InputStream inputStream;
    ReportHelper reportHelper;
    Statement balanceSheet = new Statement();
    private Date todayDate;
    FinancialYearDAO financialYearDAO;
    CFinancialYear financialYear = new CFinancialYear();
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    private Date asOnDate;
    private StringBuffer header = new StringBuffer();
    BalanceSheetService balanceSheetService;
    BalanceSheetScheduleService balanceSheetScheduleService;
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);

    public FinancialYearDAO getFinancialYearDAO() {
        return this.financialYearDAO;
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public Date getFromDate() {
        return this.balanceSheetService.getFromDate(this.balanceSheet);
    }

    public Date getToDate() {
        return this.balanceSheetService.getToDate(this.balanceSheet);
    }

    public void setFromDate(Date fromDate) {
    }

    public Date getCurrentYearfromDate() {
        return this.getFromDate();
    }

    public void setCurrentYearfromDate(Date currentYearfromDate) {
    }

    public Date getCurrentYeartoDate() {
        return this.getToDate();
    }

    public void setCurrentYeartoDate(Date currentYeartoDate) {
    }

    public void setToDate(Date toDate) {
    }

    public Date getPreviousYearfromDate() {
        return this.balanceSheetService.getPreviousYearFor(this.getFromDate());
    }

    public Date getPreviousYeartoDate() {
        return this.balanceSheetService.getPreviousYearFor(this.getToDate());
    }

    public void setPreviousYearfromDate(Date previousYearfromDate) {
    }

    public void setPreviousYeartoDate(Date previousYeartoDate) {
    }

    public void setBalanceSheetService(BalanceSheetService balanceSheetService) {
        this.balanceSheetService = balanceSheetService;
    }

    public void setBalanceSheetScheduleService(BalanceSheetScheduleService balanceSheetScheduleService) {
        this.balanceSheetScheduleService = balanceSheetScheduleService;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Statement getBalanceSheet() {
        return this.balanceSheet;
    }

    public BalanceSheetReportAction() {
        this.addRelatedEntity("department", Department.class);
        this.addRelatedEntity("function", CFunction.class);
        this.addRelatedEntity("fund", Fund.class);
        this.addRelatedEntity("functionary", Functionary.class);
        this.addRelatedEntity("financialYear", CFinancialYear.class);
        this.addRelatedEntity("field", Boundary.class);
    }

    public void prepare() {
        this.persistenceService.getSession().setDefaultReadOnly(true);
        this.persistenceService.getSession().setFlushMode(FlushMode.MANUAL);
        super.prepare();
        if (!this.parameters.containsKey("showDropDown")) {
            this.addDropdownData("departmentList", this.masterDataCache.get("egi-department"));
            this.addDropdownData("fundList", this.masterDataCache.get("egi-fund"));
            this.addDropdownData("functionList", this.masterDataCache.get("egi-function"));
            this.addDropdownData("financialYearList", this.persistenceService.findAllBy("from CFinancialYear order by finYearRange desc ", new Object[0]));
        }
    }

    protected void setRelatedEntitesOn() {
        this.setTodayDate(new Date());
        if (this.balanceSheet.getFinancialYear() != null && this.balanceSheet.getFinancialYear().getId() != null) {
            this.balanceSheet.setFinancialYear((CFinancialYear)this.getPersistenceService().find("from CFinancialYear where id=?", new Object[]{this.balanceSheet.getFinancialYear().getId()}));
        }
        if (this.balanceSheet.getDepartment() != null && this.balanceSheet.getDepartment().getId() != null && this.balanceSheet.getDepartment().getId() != 0L) {
            this.balanceSheet.setDepartment((Department)this.getPersistenceService().find("from Department where id=?", new Object[]{this.balanceSheet.getDepartment().getId()}));
            this.persistenceService.find("from Department where id=?", new Object[]{this.balanceSheet.getDepartment().getId()});
            this.header.append(" in " + this.balanceSheet.getDepartment().getName());
        } else {
            this.balanceSheet.setDepartment(null);
        }
        if (this.balanceSheet.getFund() != null && this.balanceSheet.getFund().getId() != null && this.balanceSheet.getFund().getId() != 0) {
            this.balanceSheet.setFund((Fund)this.getPersistenceService().find("from Fund where id=?", new Object[]{this.balanceSheet.getFund().getId()}));
            this.header.append(" for " + this.balanceSheet.getFund().getName());
        }
        if (this.balanceSheet.getFunction() != null && this.balanceSheet.getFunction().getId() != null && this.balanceSheet.getFunction().getId() != 0L) {
            this.balanceSheet.setFunction((CFunction)this.getPersistenceService().find("from CFunction where id=?", new Object[]{this.balanceSheet.getFunction().getId()}));
            this.header.append(" for " + this.balanceSheet.getFunction().getName());
        }
        if (this.balanceSheet.getAsOndate() != null) {
            this.header.append(" as on " + DDMMYYYYFORMATS.format(this.balanceSheet.getAsOndate()));
        }
        this.header.toString();
    }

    public Object getModel() {
        return this.balanceSheet;
    }

    @SkipValidation
    @Action(value="/report/balanceSheetReport-generateBalanceSheetReport")
    public String generateBalanceSheetReport() {
        return "report";
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateBalanceSheetSubReport")
    public String generateBalanceSheetSubReport() {
        this.populateDataSourceForSchedule();
        this.asOnDate = this.balanceSheet.getAsOndate();
        return "scheduleResults";
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateScheduleReport")
    public String generateScheduleReport() {
        this.populateDataSourceForAllSchedules();
        return "allScheduleResults";
    }

    @ReadOnly
    @SkipValidation
    @Action(value="/report/balanceSheetReport-generateScheduleReportDetailed")
    public String generateScheduleReportDetailed() {
        this.populateDataSourceForAllSchedulesDetailed();
        return "allScheduleDetailedResults";
    }

    private void populateDataSourceForSchedule() {
        this.setRelatedEntitesOn();
        if (this.balanceSheet.getFund() != null && this.balanceSheet.getFund().getId() != null) {
            ArrayList<Fund> selFund = new ArrayList<Fund>();
            selFund.add(this.balanceSheet.getFund());
            this.balanceSheet.setFunds(selFund);
        } else {
            this.balanceSheet.setFunds(this.balanceSheetService.getFunds());
        }
        this.balanceSheetScheduleService.populateDataForSchedule(this.balanceSheet, ((String[])this.parameters.get("majorCode"))[0]);
    }

    private void populateDataSourceForAllSchedules() {
        this.setRelatedEntitesOn();
        if (this.balanceSheet.getFund() != null && this.balanceSheet.getFund().getId() != null && this.balanceSheet.getFund().getId() != 0) {
            ArrayList<Fund> selFund = new ArrayList<Fund>();
            selFund.add(this.balanceSheet.getFund());
            this.balanceSheet.setFunds(selFund);
        } else {
            this.balanceSheet.setFunds(this.balanceSheetService.getFunds());
        }
        this.balanceSheetScheduleService.populateDataForAllSchedules(this.balanceSheet);
    }

    private void populateDataSourceForAllSchedulesDetailed() {
        this.setRelatedEntitesOn();
        if (this.balanceSheet.getFund() != null && this.balanceSheet.getFund().getId() != null && this.balanceSheet.getFund().getId() != 0) {
            ArrayList<Fund> selFund = new ArrayList<Fund>();
            selFund.add(this.balanceSheet.getFund());
            this.balanceSheet.setFunds(selFund);
        } else {
            this.balanceSheet.setFunds(this.balanceSheetService.getFunds());
        }
        this.balanceSheetScheduleService.populateDataForAllSchedulesDetailed(this.balanceSheet);
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-printBalanceSheetReport")
    public String printBalanceSheetReport() {
        this.populateDataSource();
        return "report";
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateBalanceSheetPdf")
    public String generateBalanceSheetPdf() throws Exception {
        this.populateDataSource();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), true);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return BALANCE_SHEET_PDF;
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateBalanceSheetXls")
    public String generateBalanceSheetXls() throws Exception {
        this.populateDataSource();
        JasperPrint jasper = null;
        jasper = !this.balanceSheet.getPeriod().equalsIgnoreCase("Yearly") ? this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), true) : this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), true);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return BALANCE_SHEET_XLS;
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateSchedulePdf")
    public String generateSchedulePdf() throws Exception {
        this.populateDataSourceForAllSchedules();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), false);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return BALANCE_SHEET_PDF;
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateScheduleXls")
    public String generateScheduleXls() throws Exception {
        this.populateDataSourceForAllSchedules();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), false);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return BALANCE_SHEET_XLS;
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateDetailedSchedulePdf")
    public String generateDetailedSchedulePdf() throws Exception {
        this.populateDataSourceForAllSchedulesDetailed();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), false);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return BALANCE_SHEET_PDF;
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateDetailedScheduleXls")
    public String generateDetailedScheduleXls() throws Exception {
        this.populateDataSourceForAllSchedulesDetailed();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), false);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return BALANCE_SHEET_XLS;
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateBalanceSheetSchedulePdf")
    public String generateBalanceSheetSchedulePdf() throws Exception {
        this.populateDataSourceForSchedule();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.sub.schedule.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), false);
        this.inputStream = this.reportHelper.exportPdf(this.inputStream, jasper);
        return BALANCE_SHEET_PDF;
    }

    @ReadOnly
    @Action(value="/report/balanceSheetReport-generateBalanceSheetScheduleXls")
    public String generateBalanceSheetScheduleXls() throws Exception {
        this.populateDataSourceForSchedule();
        JasperPrint jasper = this.reportHelper.generateFinancialStatementReportJasperPrint(this.balanceSheet, this.getText("report.sub.schedule.heading"), this.header.toString(), this.getCurrentYearToDate(), this.getPreviousYearToDate(), false);
        this.inputStream = this.reportHelper.exportXls(this.inputStream, jasper);
        return BALANCE_SHEET_XLS;
    }

    protected void populateDataSource() {
        this.setRelatedEntitesOn();
        if (this.balanceSheet.getFund() != null && this.balanceSheet.getFund().getId() != null) {
            ArrayList<Fund> selFund = new ArrayList<Fund>();
            selFund.add(this.balanceSheet.getFund());
            this.balanceSheet.setFunds(selFund);
        } else {
            this.balanceSheet.setFunds(this.balanceSheetService.getFunds());
        }
        this.balanceSheetService.populateBalanceSheet(this.balanceSheet);
    }

    public String getCurrentYearToDate() {
        return this.balanceSheetService.getFormattedDate(this.balanceSheetService.getToDate(this.balanceSheet));
    }

    public String getPreviousYearToDate() {
        return this.balanceSheetService.getFormattedDate(this.balanceSheetService.getPreviousYearFor(this.balanceSheetService.getToDate(this.balanceSheet)));
    }

    public Date getTodayDate() {
        return this.todayDate;
    }

    public void setTodayDate(Date todayDate) {
        this.todayDate = todayDate;
    }

    public StringBuffer getHeader() {
        return this.header;
    }

    public void setHeader(StringBuffer header) {
        this.header = header;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }
}

