/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.payment;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.ChequeFormat;
import org.egov.infra.utils.NumberToWord;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.instrument.InstrumentService;
import org.egov.utils.Constants;
import org.egov.utils.ReportHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"chequeFormat-HTML"}, type="stream", location="inputStream", params={"inputName", "inputStream", "contentType", "text/html"})})
public class ChequeAssignmentPrintAction
extends BaseFormAction {
    String jasperpath = "/reports/templates/ChequeFormat.jasper";
    ChequeFormat chequeFormat = new ChequeFormat();
    @Autowired
    @Qualifier(value="instrumentService")
    private InstrumentService instrumentService;
    private InputStream inputStream;
    private ReportHelper reportHelper;
    private List chequeFormatList = new ArrayList();
    private final SimpleDateFormat DDMMYYYFORMAT = new SimpleDateFormat("ddMMYYYY");
    private final SimpleDateFormat DD_MON_YYYYFORMAT = Constants.DD_MON_YYYYFORMAT;
    private String instrumentHeader;

    public Object getModel() {
        return this.chequeFormat;
    }

    @SkipValidation
    @Action(value="/payment/chequeAssignmentPrint-generateChequeFormat")
    public String generateChequeFormat() throws IOException {
        Map paramMap = this.getParamMap();
        this.inputStream = this.reportHelper.exportHtml(this.inputStream, this.jasperpath, paramMap, this.getDataForChequeFormat(), "pt");
        return "chequeFormat-HTML";
    }

    public boolean chequeFormatExists() {
        return true;
    }

    protected List<Object> getDataForChequeFormat() {
        return this.chequeFormatList;
    }

    protected String numberFormate(String amountToFormat) {
        DecimalFormat df = new DecimalFormat();
        String formatedAmount = df.format(Double.parseDouble(amountToFormat));
        return formatedAmount;
    }

    protected Map<String, Object> getParamMap() {
        InstrumentHeader instrumentDetails = new InstrumentHeader();
        if (this.instrumentHeader != null) {
            instrumentDetails = this.instrumentService.getInstrumentHeaderById(Long.valueOf(this.instrumentHeader));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (instrumentDetails != null) {
            paramMap.put("payee", instrumentDetails.getPayTo());
            String totalAmount = this.numberFormate(instrumentDetails.getInstrumentAmount().toString());
            String amountInWords = NumberToWord.convertToWord((String)instrumentDetails.getInstrumentAmount().toString());
            String chqDate = this.DDMMYYYFORMAT.format(instrumentDetails.getInstrumentDate());
            paramMap.put("totalAmount", totalAmount);
            paramMap.put("amountInWords", amountInWords);
            paramMap.put("chqDate", chqDate);
        }
        return paramMap;
    }

    public ChequeFormat getChequeFormat() {
        return this.chequeFormat;
    }

    public void setChequeFormat(ChequeFormat chequeFormat) {
        this.chequeFormat = chequeFormat;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ReportHelper getReportHelper() {
        return this.reportHelper;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setReportHelper(ReportHelper reportHelper) {
        this.reportHelper = reportHelper;
    }

    public String getInstrumentHeader() {
        return this.instrumentHeader;
    }

    public void setInstrumentHeader(String instrumentHeader) {
        this.instrumentHeader = instrumentHeader;
    }
}

