/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.web.actions.deduction;

import com.exilant.GLEngine.ChartOfAccounts;
import com.exilant.GLEngine.Transaxtion;
import com.opensymphony.xwork2.validator.annotations.Validation;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.Vouchermis;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.service.BankAccountService;
import org.egov.commons.service.FunctionService;
import org.egov.commons.utils.EntityType;
import org.egov.dao.voucher.VoucherHibernateDAO;
import org.egov.deduction.model.EgRemittance;
import org.egov.deduction.model.EgRemittanceDetail;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.web.actions.payment.BasePaymentAction;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.deduction.RemittanceBean;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.payment.Paymentheader;
import org.egov.model.recoveries.Recovery;
import org.egov.model.service.RecoveryService;
import org.egov.model.voucher.CommonBean;
import org.egov.model.voucher.WorkflowBean;
import org.egov.payment.services.PaymentActionHelper;
import org.egov.pims.commons.Position;
import org.egov.services.deduction.RemitRecoveryService;
import org.egov.services.masters.BankService;
import org.egov.services.payment.PaymentService;
import org.egov.services.voucher.VoucherService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Validation
@Results(value={@Result(name={"new"}, location="remitRecovery-new.jsp"), @Result(name={"messages"}, location="remitRecovery-messages.jsp"), @Result(name={"view"}, location="remitRecovery-view.jsp"), @Result(name={"remitDetail"}, location="remitRecovery-remitDetail.jsp")})
public class RemitRecoveryAction
extends BasePaymentAction {
    private static final String DESIGNATION_ID = "designationId";
    private static final String DESIGNATION_NAME = "designationName";
    private static final String DESIGNATION_LIST = "designationList";
    private static final String UNCHECKED = "unchecked";
    private static final String MESSAGES = "messages";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(RemitRecoveryAction.class);
    protected List<String> headerFields = new ArrayList();
    protected List<String> mandatoryFields = new ArrayList();
    private RemittanceBean remittanceBean = new RemittanceBean();
    private RemitRecoveryService remitRecoveryService;
    private VoucherService voucherService;
    private List<RemittanceBean> listRemitBean;
    private String selectedRows;
    private Long functionId;
    @Autowired
    @Qualifier(value="remittanceRecoveryService")
    private RecoveryService recoveryService;
    private Map<String, String> modeOfCollectionMap = new HashMap();
    private PaymentService paymentService;
    private Paymentheader paymentheader = new Paymentheader();
    private static final String PAYMENTID = "paymentid";
    private static final String VIEW = "view";
    public boolean showApprove = false;
    private CommonBean commonBean;
    private String modeOfPayment;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    CreateVoucher createVoucher;
    private Integer departmentId;
    private String wfitemstate;
    private String comments;
    private static final String DD_MMM_YYYY = "dd-MMM-yyyy";
    private static final String FAILED = "Transaction failed";
    private static final String SAVE_EXCEPTION = "Exception while saving data";
    private Recovery recovery;
    private VoucherHibernateDAO voucherHibDAO;
    private EgovCommon egovCommon;
    private boolean showCancel = false;
    private boolean showButtons = true;
    private BigDecimal balance;
    private String remittedTo = "";
    private final boolean remit = false;
    private List<InstrumentHeader> instrumentHeaderList = new ArrayList();
    private String cutOffDate;
    private final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    DateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
    DateFormat sdf1 = new SimpleDateFormat("dd/MM/yyyy");
    private final SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
    Date date;
    private ScriptService scriptService;
    @Autowired
    private PaymentActionHelper paymentActionHelper;
    private ChartOfAccounts chartOfAccounts;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    @Qualifier(value="bankService")
    private BankService bankService;
    @Autowired
    @Qualifier(value="bankAccountService")
    private BankAccountService bankAccountService;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public StateAware getModel() {
        this.voucherHeader = (CVoucherHeader)super.getModel();
        this.voucherHeader.setType("Payment");
        return this.voucherHeader;
    }

    public RemitRecoveryAction() {
        this.voucherHeader.setVouchermis(new Vouchermis());
        this.addRelatedEntity("vouchermis.departmentid", Department.class);
        this.addRelatedEntity("fundId", Fund.class);
        this.addRelatedEntity("vouchermis.schemeid", Scheme.class);
        this.addRelatedEntity("vouchermis.subschemeid", SubScheme.class);
        this.addRelatedEntity("vouchermis.functionary", Functionary.class);
        this.addRelatedEntity("fundsourceId", Fundsource.class);
        this.addRelatedEntity("vouchermis.divisionid", Boundary.class);
    }

    public void prepare() {
        super.prepare();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Inside Prepare method");
        }
        List listRecovery = this.recoveryService.getAllActiveRecoverys();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("RemitRecoveryAction | Tds list size : " + listRecovery.size()));
        }
        List activeBanks = this.bankHibernateDAO.getAllBankHavingBranchAndAccounts();
        this.addDropdownData("bankList", activeBanks);
        this.addDropdownData("branchList", Collections.EMPTY_LIST);
        this.addDropdownData("recoveryList", listRecovery);
        this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        this.modeOfCollectionMap.put("cash", this.getText("cash.consolidated.cheque"));
    }

    @Action(value="/deduction/remitRecovery-newform")
    public String newform() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"RemitRecoveryAction | newform | start");
        }
        this.reset();
        this.loadDefalutDates();
        return "new";
    }

    private void reset() {
        this.commonBean.reset();
        this.voucherHeader.reset();
        this.remittanceBean = new RemittanceBean();
    }

    @ValidationErrorPage(value="new")
    @Action(value="/deduction/remitRecovery-search")
    public String search() {
        this.listRemitBean = new ArrayList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"RemitRecoveryAction | Search | Start");
        }
        this.listRemitBean = this.remitRecoveryService.getRecoveryDetails(this.remittanceBean, this.voucherHeader);
        if (this.listRemitBean == null || this.listRemitBean.isEmpty()) {
            this.listRemitBean = new ArrayList();
        } else {
            this.departmentId = ((RemittanceBean)this.listRemitBean.get(0)).getDepartmentId().intValue();
            this.functionId = ((RemittanceBean)this.listRemitBean.get(0)).getFunctionId();
        }
        return "new";
    }

    public void prepareRemit() {
        this.addDropdownData("userList", Collections.EMPTY_LIST);
        this.loadDefalutDates();
    }

    @ValidationErrorPage(value="new")
    @Action(value="/deduction/remitRecovery-remit")
    public String remit() {
        Recovery recov;
        this.prepareListRemitBean(this.selectedRows);
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
            try {
                this.date = this.df.parse(((AppConfigValues)cutOffDateconfigValue.get(0)).getValue());
                this.setCutOffDate(this.formatter.format(this.date));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.voucherHeader.setType("Payment");
        if (this.voucherHeader.getVouchermis().getDepartmentid() == null) {
            Department department = this.departmentService.getDepartmentById(Long.valueOf(this.departmentId.longValue()));
            this.voucherHeader.getVouchermis().setDepartmentid(department);
        }
        if (this.voucherHeader.getVouchermis().getFunction() == null) {
            CFunction function = this.functionService.findOne(this.functionId);
            this.voucherHeader.getVouchermis().setFunction(function);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"RemitRecoveryAction | remit | start");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("RemitRecoveryAction | remit | size before filter" + this.listRemitBean.size()));
        }
        if ((recov = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{this.remittanceBean.getRecoveryId()})) != null) {
            this.remittedTo = recov.getRemitted();
        }
        for (RemittanceBean rbean : this.listRemitBean) {
            rbean.setPartialAmount(rbean.getAmount());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("RemitRecoveryAction | remit | size after filter" + this.listRemitBean.size()));
        }
        this.setModeOfPayment("cash");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"RemitRecoveryAction | remit | end");
        }
        if (this.getBankBalanceCheck() == null || "".equals(this.getBankBalanceCheck())) {
            this.addActionMessage(this.getText("payment.bankbalance.controltype"));
        }
        return "remitDetail";
    }

    private void prepareListRemitBean(String selectedRows) {
        this.listRemitBean = this.remitRecoveryService.getRecoveryDetails(selectedRows);
        if (this.listRemitBean == null) {
            this.listRemitBean = new ArrayList();
        }
    }

    @ValidationErrorPage(value="remitDetail")
    @Action(value="/deduction/remitRecovery-create")
    public String create() {
        try {
            String vdate = ((String[])this.parameters.get("voucherDate"))[0];
            Date date1 = this.sdf1.parse(vdate);
            String voucherDate = this.formatter1.format(date1);
            String cutOffDate1 = null;
            this.prepareListRemitBean(this.selectedRows);
            this.validateFields();
            this.voucherHeader.setType("Payment");
            this.voucherHeader.setName("Remittance Payment");
            HashMap headerDetails = this.createHeaderAndMisDetails();
            this.recovery = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{this.remittanceBean.getRecoveryId()});
            this.populateWorkflowBean();
            this.paymentheader = this.paymentActionHelper.createRemittancePayment(this.paymentheader, this.voucherHeader, Integer.valueOf(this.commonBean.getAccountNumberId()), this.getModeOfPayment(), this.remittanceBean.getTotalAmount(), this.listRemitBean, this.recovery, this.remittanceBean, this.remittedTo, this.workflowBean, headerDetails, this.commonBean);
            if (!this.cutOffDate.isEmpty() && this.cutOffDate != null) {
                try {
                    this.date = this.sdf1.parse(this.cutOffDate);
                    cutOffDate1 = this.formatter1.format(this.date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (cutOffDate1 != null && voucherDate.compareTo(cutOffDate1) <= 0 && "Create And Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
                this.addActionMessage(this.getText("remittancepayment.transaction.success") + this.paymentheader.getVoucherheader().getVoucherNumber());
            } else {
                this.addActionMessage(this.getText("remittancepayment.transaction.success") + this.paymentheader.getVoucherheader().getVoucherNumber());
                this.addActionMessage(this.getText("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId((Position)this.paymentheader.getState().getOwnerPosition())}));
            }
        }
        catch (ValidationException e) {
            this.loadAjaxedDropDowns();
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            this.loadAjaxedDropDowns();
            LOGGER.error((Object)e.getMessage());
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        return MESSAGES;
    }

    private List<HashMap<String, Object>> addSubledgerGroupBy(List<HashMap<String, Object>> subledgerDetails, String glcode) {
        HashMap detailTypesMap = new HashMap();
        Integer detailTypeId = null;
        ArrayList<Integer> detailTypeList = new ArrayList<Integer>();
        HashMap<String, Object> subledgertDetailMap = null;
        for (RemittanceBean rbean : this.listRemitBean) {
            detailTypeId = rbean.getDetailTypeId();
            if (detailTypeList.contains(detailTypeId)) {
                if (((List)detailTypesMap.get(detailTypeId)).contains(rbean.getDetailKeyid())) continue;
                ((List)detailTypesMap.get(detailTypeId)).add(rbean.getDetailKeyid());
                continue;
            }
            detailTypeList.add(detailTypeId);
            detailTypesMap.put(detailTypeId, new ArrayList());
            ((List)detailTypesMap.get(detailTypeId)).add(rbean.getDetailKeyid());
        }
        Set entrySet = detailTypesMap.entrySet();
        List tempRemitBean = this.listRemitBean;
        for (Map.Entry o : entrySet) {
            List value = (List)o.getValue();
            for (Integer detailKey : value) {
                BigDecimal sumPerDetailKey = BigDecimal.ZERO;
                for (RemittanceBean remittanceBean2 : tempRemitBean) {
                    if (remittanceBean2.getDetailKeyid() == null || !remittanceBean2.getDetailKeyid().equals(detailKey)) continue;
                    sumPerDetailKey = sumPerDetailKey.add(remittanceBean2.getPartialAmount());
                }
                subledgertDetailMap = new HashMap<String, Object>();
                subledgertDetailMap.put("debitamount", sumPerDetailKey);
                subledgertDetailMap.put("creditamount", BigDecimal.ZERO);
                subledgertDetailMap.put("detailtypeid", ((Integer)o.getKey()).toString());
                subledgertDetailMap.put("detailkeyid", detailKey);
                subledgertDetailMap.put("glcode", glcode);
                subledgerDetails.add(subledgertDetailMap);
            }
        }
        return subledgerDetails;
    }

    public Paymentheader getPayment() {
        String paymentid = null;
        if (this.parameters.get(PAYMENTID) == null) {
            Object obj = this.getSession().get(PAYMENTID);
            if (obj != null) {
                paymentid = (String)obj;
            }
        } else {
            paymentid = ((String[])this.parameters.get(PAYMENTID))[0];
        }
        if (this.paymentheader == null && paymentid != null) {
            this.paymentheader = (Paymentheader)this.paymentService.find("from Paymentheader where id=?", new Object[]{Long.valueOf(paymentid)});
        }
        if (this.paymentheader == null) {
            this.paymentheader = new Paymentheader();
        }
        return this.paymentheader;
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    @Action(value="/deduction/remitRecovery-sendForApproval")
    public String sendForApproval() {
        this.paymentheader = (Paymentheader)this.paymentService.find("from Paymentheader where id=?", new Object[]{Long.valueOf(this.paymentid)});
        this.populateWorkflowBean();
        this.paymentheader = this.paymentActionHelper.sendForApproval(this.paymentheader, this.workflowBean);
        if ("Reject".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.rejected", new String[]{this.paymentService.getEmployeeNameForPositionId((Position)this.paymentheader.getState().getOwnerPosition())}));
        }
        if ("Forward".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.approved", new String[]{this.paymentService.getEmployeeNameForPositionId((Position)this.paymentheader.getState().getOwnerPosition())}));
        }
        if ("Cancel".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.cancelled"));
        } else if ("Approve".equalsIgnoreCase(this.workflowBean.getWorkFlowAction())) {
            this.addActionMessage(this.getText("payment.voucher.final.approval"));
            this.setAction(this.workflowBean.getWorkFlowAction());
        }
        return MESSAGES;
    }

    @ValidationErrorPage(value="view")
    @SkipValidation
    @Action(value="/deduction/remitRecovery-viewInboxItem")
    public String viewInboxItem() {
        this.paymentheader = (Paymentheader)this.paymentService.find("from Paymentheader where id=?", new Object[]{Long.valueOf(this.paymentid)});
        this.showApprove = true;
        this.voucherHeader.setId(this.paymentheader.getVoucherheader().getId());
        this.prepareForViewModifyReverse();
        return VIEW;
    }

    public String beforeEdit() {
        this.showApprove = true;
        this.prepareForViewModifyReverse();
        return "edit";
    }

    @ValidationErrorPage(value="edit")
    @Action(value="/deduction/remitRecovery-edit")
    public String edit() {
        try {
            this.validateFields();
            this.voucherHeader = this.voucherService.updateVoucherHeader(this.voucherHeader);
            this.reCreateLedger();
            this.updateRemittanceDetail();
            this.paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where voucherheader=?", new Object[]{this.voucherHeader});
            this.paymentService.updatePaymentHeader(this.paymentheader, this.voucherHeader, Integer.valueOf(this.commonBean.getAccountNumberId()), this.getModeOfPayment(), this.remittanceBean.getTotalAmount());
            Miscbilldetail miscbillDetail = (Miscbilldetail)this.persistenceService.find(" from Miscbilldetail where payVoucherHeader=?", new Object[]{this.voucherHeader});
            miscbillDetail.setPaidto(this.remittedTo);
            this.persistenceService.persist((Object)miscbillDetail);
            this.sendForApproval();
            this.addActionMessage(this.getText("remittancepayment.transaction.success") + this.voucherHeader.getVoucherNumber());
        }
        catch (ValidationException e) {
            this.loadAjaxedDropDowns();
            throw e;
        }
        return MESSAGES;
    }

    private void updateRemittanceDetail() {
        for (RemittanceBean rbean : this.listRemitBean) {
            EgRemittanceDetail egrDetail = (EgRemittanceDetail)this.persistenceService.find("from EgRemittanceDetail where id=?", new Object[]{rbean.getRemittanceId()});
            egrDetail.setRemittedamt(rbean.getPartialAmount());
            this.persistenceService.persist((Object)egrDetail);
        }
    }

    private void reCreateLedger() {
        try {
            this.createVoucher.deleteVoucherdetailAndGL(this.voucherHeader);
            this.persistenceService.getSession().flush();
            HashMap<String, String> detailMap = null;
            ArrayList accountdetails = new ArrayList();
            List subledgerDetails = new ArrayList();
            detailMap = new HashMap<String, String>();
            detailMap.put("creditamount", this.remittanceBean.getTotalAmount().toString());
            detailMap.put("debitamount", "0");
            Bankaccount account = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Integer.valueOf(this.commonBean.getAccountNumberId())});
            detailMap.put("glcode", account.getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("creditamount", "0");
            detailMap.put("debitamount", this.remittanceBean.getTotalAmount().toString());
            this.recovery = (Recovery)this.persistenceService.find("from Recovery where id=?", new Object[]{this.remittanceBean.getRecoveryId()});
            detailMap.put("glcode", this.recovery.getChartofaccounts().getGlcode());
            accountdetails.add(detailMap);
            subledgerDetails = this.addSubledgerGroupBy(subledgerDetails, this.recovery.getChartofaccounts().getGlcode());
            List transactions = this.createVoucher.createTransaction(null, accountdetails, subledgerDetails, this.voucherHeader);
            this.persistenceService.getSession().flush();
            Transaxtion[] txnList = new Transaxtion[transactions.size()];
            txnList = transactions.toArray(txnList);
            SimpleDateFormat formatter = new SimpleDateFormat(DD_MMM_YYYY);
            if (!this.chartOfAccounts.postTransaxtions(txnList, formatter.format(this.voucherHeader.getVoucherDate()))) {
                throw new ValidationException(Arrays.asList(new ValidationError("Exception While Saving Data", "Transaction Failed")));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(SAVE_EXCEPTION, FAILED)));
        }
    }

    @Action(value="/deduction/remitRecovery-beforeView")
    public String beforeView() {
        this.prepareForViewModifyReverse();
        this.wfitemstate = "END";
        this.showApprove = true;
        this.showButtons = false;
        return VIEW;
    }

    private void prepareForViewModifyReverse() {
        StringBuffer instrumentQuery = new StringBuffer(100);
        instrumentQuery.append("select  distinct ih from InstrumentHeader ih join ih.instrumentVouchers iv where iv.voucherHeaderId.id=?").append(" order by ih.id");
        this.remittanceBean = new RemittanceBean();
        this.voucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{this.voucherHeader.getId()});
        this.paymentheader = (Paymentheader)this.persistenceService.find("from Paymentheader where voucherheader=?", new Object[]{this.voucherHeader});
        Miscbilldetail miscBill = (Miscbilldetail)this.persistenceService.find("from Miscbilldetail where payVoucherHeader=?", new Object[]{this.voucherHeader});
        this.remittedTo = miscBill.getPaidto();
        this.commonBean.setAmount(this.paymentheader.getPaymentAmount());
        this.commonBean.setAccountNumberId(this.paymentheader.getBankaccount().getId().toString());
        this.commonBean.setAccnumnar(this.paymentheader.getBankaccount().getNarration());
        String bankBranchId = this.paymentheader.getBankaccount().getBankbranch().getBank().getId() + "-" + this.paymentheader.getBankaccount().getBankbranch().getId();
        this.commonBean.setBankId(bankBranchId);
        this.setModeOfPayment(this.paymentheader.getType());
        this.remittanceBean.setTotalAmount(this.paymentheader.getPaymentAmount());
        this.setComments(this.getText("payment.comments", new String[]{this.paymentheader.getPaymentAmount().toPlainString()}));
        this.getRemittanceFromVoucher();
        this.loadAjaxedDropDowns();
        if (VIEW.equalsIgnoreCase(this.showMode)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"fetching cheque detail ------------------------");
            }
            this.instrumentHeaderList = this.getPersistenceService().findAllBy(instrumentQuery.toString(), new Object[]{this.paymentheader.getVoucherheader().getId()});
        }
    }

    private void getRemittanceFromVoucher() {
        this.listRemitBean = new ArrayList();
        List remitList = this.persistenceService.findAllBy("from EgRemittance where voucherheader=?", new Object[]{this.voucherHeader});
        for (EgRemittance remit : remitList) {
            RemittanceBean rbean = null;
            Set egRemittanceDetail = remit.getEgRemittanceDetail();
            for (EgRemittanceDetail remitDtl : egRemittanceDetail) {
                rbean = new RemittanceBean();
                rbean.setPartialAmount(remitDtl.getRemittedamt());
                rbean.setAmount(remitDtl.getRemittedamt());
                if (remitDtl.getEgRemittanceGldtl() != null) {
                    rbean.setDetailTypeId(remitDtl.getEgRemittanceGldtl().getGeneralledgerdetail().getDetailTypeId().getId());
                    rbean.setDetailKeyid(Integer.valueOf(remitDtl.getEgRemittanceGldtl().getGeneralledgerdetail().getDetailKeyId()));
                    rbean.setRemittance_gl_dtlId(remitDtl.getEgRemittanceGldtl().getId());
                    rbean.setDeductionAmount(remitDtl.getEgRemittanceGldtl().getGldtlamt());
                } else {
                    rbean.setDeductionAmount(remitDtl.getRemittedamt());
                }
                rbean.setRemittanceId(remitDtl.getId());
                BigDecimal calculatedEarlierPayment = BigDecimal.ZERO;
                if (remitDtl.getEgRemittanceGldtl() != null) {
                    calculatedEarlierPayment = this.calculateEarlierPayment(remitDtl);
                }
                if (calculatedEarlierPayment.compareTo(BigDecimal.ZERO) == 0) {
                    rbean.setEarlierPayment(BigDecimal.ZERO);
                } else if (remit.getVoucherheader().getStatus().intValue() == FinancialConstants.CANCELLEDVOUCHERSTATUS.intValue() || remit.getVoucherheader().getStatus().intValue() == FinancialConstants.REVERSALVOUCHERSTATUS.intValue()) {
                    rbean.setEarlierPayment(calculatedEarlierPayment);
                } else {
                    rbean.setEarlierPayment(calculatedEarlierPayment.subtract(remitDtl.getRemittedamt()));
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                if (remitDtl.getEgRemittanceGldtl() != null) {
                    EntityType entity = this.voucherHibDAO.getEntityInfo(Integer.valueOf(remitDtl.getEgRemittanceGldtl().getGeneralledgerdetail().getDetailKeyId()), remitDtl.getEgRemittanceGldtl().getGeneralledgerdetail().getDetailTypeId().getId());
                    rbean.setPartyCode(entity.getCode());
                    rbean.setPartyName(entity.getName());
                    rbean.setPanNo(entity.getPanno());
                    rbean.setVoucherDate(sdf.format(remitDtl.getEgRemittanceGldtl().getGeneralledgerdetail().getGeneralLedgerId().getVoucherHeaderId().getVoucherDate()));
                    rbean.setVoucherNumber(remitDtl.getEgRemittanceGldtl().getGeneralledgerdetail().getGeneralLedgerId().getVoucherHeaderId().getVoucherNumber());
                    rbean.setVoucherName(remitDtl.getEgRemittanceGldtl().getGeneralledgerdetail().getGeneralLedgerId().getVoucherHeaderId().getName());
                } else if (remitDtl.getGeneralLedger().getVoucherHeaderId() != null) {
                    rbean.setVoucherDate(sdf.format(remitDtl.getGeneralLedger().getVoucherHeaderId().getVoucherDate()));
                    rbean.setVoucherNumber(remitDtl.getGeneralLedger().getVoucherHeaderId().getVoucherNumber());
                    rbean.setVoucherName(remitDtl.getGeneralLedger().getVoucherHeaderId().getName());
                }
                this.listRemitBean.add(rbean);
            }
            if (this.remittanceBean.getRecoveryId() != null) continue;
            this.remittanceBean.setRecoveryId(remit.getRecovery().getId());
        }
    }

    private BigDecimal calculateEarlierPayment(EgRemittanceDetail remitDtl) {
        BigDecimal sum = (BigDecimal)this.persistenceService.find("select sum(egr.remittedamt) from EgRemittanceDetail egr where  egr.egRemittanceGldtl=?  and egr.egRemittance.voucherheader.status  NOT in (?,?)", new Object[]{remitDtl.getEgRemittanceGldtl(), FinancialConstants.CANCELLEDVOUCHERSTATUS, FinancialConstants.REVERSEDVOUCHERSTATUS});
        if (sum == null) {
            return BigDecimal.ZERO;
        }
        return sum;
    }

    @SkipValidation
    public boolean validateUser(String purpose) {
        Script validScript = (Script)this.getPersistenceService().findAllByNamedQuery("Script.findByName", new Object[]{"Paymentheader.show.bankbalance"}).get(0);
        List list = (List)this.scriptService.executeScript(validScript, ScriptService.createContext((Object[])new Object[]{"persistenceService", this.paymentService, "purpose", purpose}));
        if (((String)list.get(0)).equals("true")) {
            try {
                this.canCheckBalance = true;
                this.commonBean.setAvailableBalance(this.egovCommon.getAccountBalance(new Date(), this.paymentheader.getBankaccount().getId(), this.paymentheader.getPaymentAmount(), this.paymentheader.getId(), this.paymentheader.getBankaccount().getChartofaccounts().getId()));
                this.balance = this.commonBean.getAvailableBalance();
                return true;
            }
            catch (Exception e) {
                this.balance = BigDecimal.valueOf(-1L);
                return true;
            }
        }
        return false;
    }

    private void loadAjaxedDropDowns() {
        this.loadSchemeSubscheme();
        this.loadBankBranchForFundAndType();
        this.loadBankAccountNumberForFundAndType();
    }

    private void loadBankBranchForFundAndType() {
        this.addDropdownData("bankList", this.bankService.getBankByFundAndType(this.voucherHeader.getFundId().getId(), "RECEIPTS_PAYMENTS,PAYMENTS"));
    }

    private void loadBankAccountNumberForFundAndType() {
        Bankaccount bankaccount = null;
        if (this.paymentheader != null && this.paymentheader.getBankaccount() != null) {
            bankaccount = this.paymentheader.getBankaccount();
        } else if (this.commonBean.getAccountNumberId() != null && !this.commonBean.getAccountNumberId().equals("-1") && !this.commonBean.getAccountNumberId().equals("")) {
            bankaccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.valueOf(this.commonBean.getAccountNumberId())});
        }
        if (bankaccount.getBankbranch().getId() != null) {
            this.addDropdownData("accNumList", this.bankAccountService.getBankAccounts(this.voucherHeader.getFundId().getId(), bankaccount.getBankbranch().getId(), bankaccount.getBankbranch().getBank().getId(), "RECEIPTS_PAYMENTS,PAYMENTS"));
        } else {
            this.addDropdownData("accNumList", Collections.EMPTY_LIST);
        }
    }

    protected void loadDefalutDates() {
        Date currDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            this.voucherHeader.setVoucherDate(sdf.parse(sdf.format(currDate)));
        }
        catch (ParseException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting voucher date", FAILED)));
        }
    }

    public List<String> getValidActions() {
        List<String> validActions = Collections.emptyList();
        List cutOffDateconfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "DataEntryCutOffDate");
        if (cutOffDateconfigValue != null && !cutOffDateconfigValue.isEmpty()) {
            if (null == this.paymentheader || null == this.paymentheader.getId() || this.paymentheader.getCurrentState().getValue().endsWith("NEW")) {
                validActions = Arrays.asList("Forward", "Create And Approve");
            } else if (this.paymentheader.getCurrentState() != null) {
                validActions = this.customizedWorkFlowService.getNextValidActions(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate());
            }
        } else if (null == this.paymentheader || null == this.paymentheader.getId() || this.paymentheader.getCurrentState().getValue().endsWith("NEW")) {
            validActions = Arrays.asList("Forward");
        } else if (this.paymentheader.getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate());
        }
        return validActions;
    }

    public String getNextAction() {
        WorkFlowMatrix wfMatrix = null;
        if (this.paymentheader.getId() != null) {
            wfMatrix = this.paymentheader.getCurrentState() != null ? this.customizedWorkFlowService.getWfMatrix(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.paymentheader.getCurrentState().getValue(), this.getPendingActions(), this.paymentheader.getCreatedDate()) : this.customizedWorkFlowService.getWfMatrix(this.paymentheader.getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), "Created", this.getPendingActions(), this.paymentheader.getCreatedDate());
        }
        return wfMatrix == null ? "" : wfMatrix.getNextAction();
    }

    public CVoucherHeader getVoucherHeader() {
        return this.voucherHeader;
    }

    public void setVoucherHeader(CVoucherHeader voucherHeader) {
        this.voucherHeader = voucherHeader;
    }

    public RemittanceBean getRemittanceBean() {
        return this.remittanceBean;
    }

    public void setRemittanceBean(RemittanceBean remittanceBean) {
        this.remittanceBean = remittanceBean;
    }

    public void setRemitRecoveryService(RemitRecoveryService remitRecoveryService) {
        this.remitRecoveryService = remitRecoveryService;
    }

    public List<RemittanceBean> getListRemitBean() {
        return this.listRemitBean;
    }

    public void setListRemitBean(List<RemittanceBean> listRemitBean) {
        this.listRemitBean = listRemitBean;
    }

    public Paymentheader getPaymentheader() {
        return this.paymentheader;
    }

    public void setPaymentheader(Paymentheader paymentheader) {
        this.paymentheader = paymentheader;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setPaymentWorkflowService(SimpleWorkflowService<Paymentheader> paymentWorkflowService) {
    }

    public void setVoucherService(VoucherService voucherService) {
        this.voucherService = voucherService;
    }

    public void setCommonBean(CommonBean commonBean) {
        this.commonBean = commonBean;
    }

    public CommonBean getCommonBean() {
        return this.commonBean;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
    }

    public Map<String, String> getModeOfCollectionMap() {
        return this.modeOfCollectionMap;
    }

    public void setModeOfCollectionMap(Map<String, String> modeOfCollectionMap) {
        this.modeOfCollectionMap = modeOfCollectionMap;
    }

    public String getModeOfPayment() {
        return this.modeOfPayment;
    }

    public void setModeOfPayment(String modeOfPayment) {
        this.modeOfPayment = modeOfPayment;
    }

    public void setVoucherHibDAO(VoucherHibernateDAO voucherHibDAO) {
        this.voucherHibDAO = voucherHibDAO;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getWfitemstate() {
        return this.wfitemstate;
    }

    public void setWfitemstate(String wfitemstate) {
        this.wfitemstate = wfitemstate;
    }

    public boolean isShowButtons() {
        return this.showButtons;
    }

    public void setShowButtons(boolean showButtons) {
        this.showButtons = showButtons;
    }

    public boolean isShowCancel() {
        return this.showCancel;
    }

    public void setShowCancel(boolean showCancel) {
        this.showCancel = showCancel;
    }

    public void setRemittedTo(String remittedTo) {
        this.remittedTo = remittedTo;
    }

    public String getRemittedTo() {
        return this.remittedTo;
    }

    public List<InstrumentHeader> getInstrumentHeaderList() {
        return this.instrumentHeaderList;
    }

    public void setInstrumentHeaderList(List<InstrumentHeader> instrumentHeaderList) {
        this.instrumentHeaderList = instrumentHeaderList;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public ChartOfAccounts getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(ChartOfAccounts chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public String getCurrentState() {
        return this.paymentheader.getState().getValue();
    }

    public String getCutOffDate() {
        return this.cutOffDate;
    }

    public void setCutOffDate(String cutOffDate) {
        this.cutOffDate = cutOffDate;
    }

    public String getSelectedRows() {
        return this.selectedRows;
    }

    public Long getFunctionId() {
        return this.functionId;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setSelectedRows(String selectedRows) {
        this.selectedRows = selectedRows;
    }

    public void setFunctionId(Long functionId) {
        this.functionId = functionId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }
}

